/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.store.jdbc;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeName;
import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import org.apache.drill.common.PlanStringBuilder;
import org.apache.drill.common.logical.AbstractSecuredStoragePluginConfig;
import org.apache.drill.common.logical.security.CredentialsProvider;
import org.apache.drill.exec.store.security.CredentialProviderUtils;
import org.apache.drill.exec.store.security.UsernamePasswordCredentials;

@JsonTypeName(value="jdbc")
@JsonFilter(value="passwordFilter")
public class JdbcStorageConfig
extends AbstractSecuredStoragePluginConfig {
    public static final String NAME = "jdbc";
    public static final int DEFAULT_MAX_WRITER_BATCH_SIZE = 10000;
    private final String driver;
    private final String url;
    private final boolean caseInsensitiveTableNames;
    private final boolean writable;
    private final Map<String, Object> sourceParameters;
    private final int writerBatchSize;

    @JsonCreator
    public JdbcStorageConfig(@JsonProperty(value="driver") String driver, @JsonProperty(value="url") String url, @JsonProperty(value="username") String username, @JsonProperty(value="password") String password, @JsonProperty(value="caseInsensitiveTableNames") boolean caseInsensitiveTableNames, @JsonProperty(value="writable") boolean writable, @JsonProperty(value="sourceParameters") Map<String, Object> sourceParameters, @JsonProperty(value="credentialsProvider") CredentialsProvider credentialsProvider, @JsonProperty(value="writerBatchSize") int writerBatchSize) {
        super(CredentialProviderUtils.getCredentialsProvider((String)username, (String)password, (CredentialsProvider)credentialsProvider), credentialsProvider == null);
        this.driver = driver;
        this.url = url;
        this.writable = writable;
        this.caseInsensitiveTableNames = caseInsensitiveTableNames;
        this.sourceParameters = sourceParameters == null ? Collections.emptyMap() : sourceParameters;
        this.writerBatchSize = writerBatchSize == 0 ? (writerBatchSize = 10000) : writerBatchSize;
    }

    public String getDriver() {
        return this.driver;
    }

    public String getUrl() {
        return this.url;
    }

    public boolean isWritable() {
        return this.writable;
    }

    public int getWriterBatchSize() {
        return this.writerBatchSize;
    }

    public String getUsername() {
        if (this.directCredentials) {
            return this.getUsernamePasswordCredentials().getUsername();
        }
        return null;
    }

    public String getPassword() {
        if (this.directCredentials) {
            return this.getUsernamePasswordCredentials().getPassword();
        }
        return null;
    }

    @JsonProperty(value="caseInsensitiveTableNames")
    public boolean areTableNamesCaseInsensitive() {
        return this.caseInsensitiveTableNames;
    }

    public Map<String, Object> getSourceParameters() {
        return this.sourceParameters;
    }

    @JsonIgnore
    public UsernamePasswordCredentials getUsernamePasswordCredentials() {
        return new UsernamePasswordCredentials(this.credentialsProvider);
    }

    public int hashCode() {
        return Objects.hash(this.driver, this.url, this.caseInsensitiveTableNames, this.sourceParameters, this.credentialsProvider, this.writable, this.writerBatchSize);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        JdbcStorageConfig that = (JdbcStorageConfig)((Object)o);
        return this.caseInsensitiveTableNames == that.caseInsensitiveTableNames && Objects.equals(this.driver, that.driver) && Objects.equals(this.url, that.url) && Objects.equals(this.writable, that.writable) && Objects.equals(this.sourceParameters, that.sourceParameters) && Objects.equals(this.credentialsProvider, that.credentialsProvider) && Objects.equals(this.writerBatchSize, that.writerBatchSize);
    }

    public String toString() {
        return new PlanStringBuilder((Object)this).field("driver", this.driver).field("url", this.url).field("writable", (Object)this.writable).field("writerBatchSize", this.writerBatchSize).field("caseInsensitiveTableNames", (Object)this.caseInsensitiveTableNames).toString();
    }
}

