/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.store.jdbc;

import java.io.IOException;
import java.nio.file.Paths;
import java.time.LocalDate;
import java.time.LocalTime;
import java.util.TimeZone;
import org.apache.drill.categories.JdbcStorageTest;
import org.apache.drill.common.exceptions.UserRemoteException;
import org.apache.drill.common.logical.StoragePluginConfig;
import org.apache.drill.common.types.TypeProtos;
import org.apache.drill.exec.physical.rowSet.DirectRowSet;
import org.apache.drill.exec.physical.rowSet.RowSet;
import org.apache.drill.exec.physical.rowSet.RowSetBuilder;
import org.apache.drill.exec.record.metadata.SchemaBuilder;
import org.apache.drill.exec.record.metadata.TupleMetadata;
import org.apache.drill.exec.store.jdbc.JdbcStorageConfig;
import org.apache.drill.exec.store.jdbc.JdbcTestUtils;
import org.apache.drill.test.BaseDirTestWatcher;
import org.apache.drill.test.ClusterFixture;
import org.apache.drill.test.ClusterFixtureBuilder;
import org.apache.drill.test.ClusterTest;
import org.apache.drill.test.QueryBuilder;
import org.apache.drill.test.rowSet.RowSetUtilities;
import org.apache.hadoop.fs.Path;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Ignore;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.testcontainers.containers.JdbcDatabaseContainer;
import org.testcontainers.containers.MySQLContainer;
import org.testcontainers.delegate.DatabaseDelegate;
import org.testcontainers.ext.ScriptUtils;
import org.testcontainers.jdbc.JdbcDatabaseDelegate;
import org.testcontainers.utility.DockerImageName;

@Category(value={JdbcStorageTest.class})
public class TestJdbcWriterWithMySQL
extends ClusterTest {
    private static final String DOCKER_IMAGE_MYSQL = "mysql:5.7.27";
    private static final String DOCKER_IMAGE_MARIADB = "mariadb:10.6.0";
    private static final Logger logger = LoggerFactory.getLogger(TestJdbcWriterWithMySQL.class);
    private static JdbcDatabaseContainer<?> jdbcContainer;

    @BeforeClass
    public static void initMysql() throws Exception {
        TestJdbcWriterWithMySQL.startCluster((ClusterFixtureBuilder)ClusterFixture.builder((BaseDirTestWatcher)dirTestWatcher));
        dirTestWatcher.copyResourceToRoot(Paths.get("", new String[0]));
        TimeZone.setDefault(TimeZone.getTimeZone("UTC"));
        String osName = System.getProperty("os.name").toLowerCase();
        String mysqlDBName = "drill_mysql_test";
        DockerImageName imageName = osName.startsWith("linux") && "aarch64".equals(System.getProperty("os.arch")) ? DockerImageName.parse((String)DOCKER_IMAGE_MARIADB).asCompatibleSubstituteFor("mysql") : DockerImageName.parse((String)DOCKER_IMAGE_MYSQL);
        jdbcContainer = ((MySQLContainer)((MySQLContainer)((MySQLContainer)new MySQLContainer(imageName).withExposedPorts(new Integer[]{3306})).withConfigurationOverride("mysql_config_override").withUsername("mysqlUser").withPassword("mysqlPass").withDatabaseName(mysqlDBName).withUrlParam("serverTimezone", "UTC")).withUrlParam("useJDBCCompliantTimezoneShift", "true")).withInitScript("mysql-test-data.sql");
        jdbcContainer.start();
        if (osName.startsWith("linux")) {
            JdbcDatabaseDelegate databaseDelegate = new JdbcDatabaseDelegate(jdbcContainer, "");
            ScriptUtils.runInitScript((DatabaseDelegate)databaseDelegate, (String)"mysql-test-data-linux.sql");
        }
        String jdbcUrl = jdbcContainer.getJdbcUrl();
        logger.debug("JDBC URL: {}", (Object)jdbcUrl);
        JdbcStorageConfig jdbcStorageConfig = new JdbcStorageConfig("com.mysql.cj.jdbc.Driver", jdbcUrl, jdbcContainer.getUsername(), jdbcContainer.getPassword(), false, true, null, null, 10000);
        jdbcStorageConfig.setEnabled(Boolean.valueOf(true));
        cluster.defineStoragePlugin("mysql", (StoragePluginConfig)jdbcStorageConfig);
        JdbcStorageConfig jdbcStorageConfigNoWrite = new JdbcStorageConfig("com.mysql.cj.jdbc.Driver", jdbcUrl, jdbcContainer.getUsername(), jdbcContainer.getPassword(), false, false, null, null, 10000);
        jdbcStorageConfigNoWrite.setEnabled(Boolean.valueOf(true));
        cluster.defineStoragePlugin("mysql_no_write", (StoragePluginConfig)jdbcStorageConfigNoWrite);
        if (osName.startsWith("linux")) {
            JdbcStorageConfig jdbcCaseSensitiveStorageConfig = new JdbcStorageConfig("com.mysql.cj.jdbc.Driver", jdbcUrl, jdbcContainer.getUsername(), jdbcContainer.getPassword(), true, true, null, null, 10000);
            jdbcCaseSensitiveStorageConfig.setEnabled(Boolean.valueOf(true));
            cluster.defineStoragePlugin("mysqlCaseInsensitive", (StoragePluginConfig)jdbcCaseSensitiveStorageConfig);
        }
    }

    @Test
    public void testBasicCTAS() throws Exception {
        String query = "CREATE TABLE mysql.`drill_mysql_test`.`test_table` (ID, NAME) AS SELECT * FROM (VALUES(1,2), (3,4))";
        QueryBuilder.QuerySummary insertResults = this.queryBuilder().sql(query).run();
        Assert.assertTrue((boolean)insertResults.succeeded());
        String testQuery = "SELECT * FROM  mysql.`drill_mysql_test`.`test_table`";
        DirectRowSet results = this.queryBuilder().sql(testQuery).rowSet();
        TupleMetadata expectedSchema = new SchemaBuilder().add("ID", TypeProtos.MinorType.BIGINT, TypeProtos.DataMode.OPTIONAL).add("NAME", TypeProtos.MinorType.BIGINT, TypeProtos.DataMode.OPTIONAL).buildSchema();
        RowSet.SingleRowSet expected = new RowSetBuilder(client.allocator(), expectedSchema).addRow(new Object[]{1L, 2L}).addRow(new Object[]{3L, 4L}).build();
        RowSetUtilities.verify((RowSet)expected, (RowSet)results);
        String dropQuery = "DROP TABLE mysql.`drill_mysql_test`.`test_table`";
        QueryBuilder.QuerySummary dropResults = this.queryBuilder().sql(dropQuery).run();
        Assert.assertTrue((boolean)dropResults.succeeded());
    }

    @Test
    public void testBasicCTASWithSpacesInTableName() throws Exception {
        String query = "CREATE TABLE mysql.`drill_mysql_test`.`test table` (ID, NAME) AS SELECT * FROM (VALUES(1,2), (3,4))";
        QueryBuilder.QuerySummary insertResults = this.queryBuilder().sql(query).run();
        Assert.assertTrue((boolean)insertResults.succeeded());
        String testQuery = "SELECT * FROM  mysql.`drill_mysql_test`.`test table`";
        DirectRowSet results = this.queryBuilder().sql(testQuery).rowSet();
        TupleMetadata expectedSchema = new SchemaBuilder().add("ID", TypeProtos.MinorType.BIGINT, TypeProtos.DataMode.OPTIONAL).add("NAME", TypeProtos.MinorType.BIGINT, TypeProtos.DataMode.OPTIONAL).buildSchema();
        RowSet.SingleRowSet expected = new RowSetBuilder(client.allocator(), expectedSchema).addRow(new Object[]{1L, 2L}).addRow(new Object[]{3L, 4L}).build();
        RowSetUtilities.verify((RowSet)expected, (RowSet)results);
        String dropQuery = "DROP TABLE mysql.`drill_mysql_test`.`test table`";
        QueryBuilder.QuerySummary dropResults = this.queryBuilder().sql(dropQuery).run();
        Assert.assertTrue((boolean)dropResults.succeeded());
    }

    @Test
    public void testBasicCTASWithSpacesInFieldNames() throws Exception {
        String query = "CREATE TABLE mysql.`drill_mysql_test`.`test table` (`My id`, `My name`) AS SELECT * FROM (VALUES(1,2), (3,4))";
        QueryBuilder.QuerySummary insertResults = this.queryBuilder().sql(query).run();
        Assert.assertTrue((boolean)insertResults.succeeded());
        String testQuery = "SELECT * FROM  mysql.`drill_mysql_test`.`test table`";
        DirectRowSet results = this.queryBuilder().sql(testQuery).rowSet();
        TupleMetadata expectedSchema = new SchemaBuilder().add("My id", TypeProtos.MinorType.BIGINT, TypeProtos.DataMode.OPTIONAL).add("My name", TypeProtos.MinorType.BIGINT, TypeProtos.DataMode.OPTIONAL).buildSchema();
        RowSet.SingleRowSet expected = new RowSetBuilder(client.allocator(), expectedSchema).addRow(new Object[]{1L, 2L}).addRow(new Object[]{3L, 4L}).build();
        RowSetUtilities.verify((RowSet)expected, (RowSet)results);
        String dropQuery = "DROP TABLE mysql.`drill_mysql_test`.`test table`";
        QueryBuilder.QuerySummary dropResults = this.queryBuilder().sql(dropQuery).run();
        Assert.assertTrue((boolean)dropResults.succeeded());
    }

    @Test
    @Ignore(value="Requires local installation of MySQL")
    public void testBasicCTASWithLocalDatabase() throws Exception {
        String localMySql = "jdbc:mysql://localhost:3306/?useJDBCCompliantTimezoneShift=true&serverTimezone=EST5EDT";
        JdbcStorageConfig localJdbcStorageConfig = new JdbcStorageConfig("com.mysql.cj.jdbc.Driver", localMySql, "root", "password", false, true, null, null, 10000);
        localJdbcStorageConfig.setEnabled(Boolean.valueOf(true));
        cluster.defineStoragePlugin("localMysql", (StoragePluginConfig)localJdbcStorageConfig);
        String query = "CREATE TABLE localMysql.`drill_mysql_test`.`test_table` (ID, NAME) AS SELECT * FROM (VALUES(1,2), (3,4))";
        QueryBuilder.QuerySummary insertResults = this.queryBuilder().sql(query).run();
        Assert.assertTrue((boolean)insertResults.succeeded());
        String testQuery = "SELECT * FROM  localMysql.`drill_mysql_test`.`test_table`";
        DirectRowSet results = this.queryBuilder().sql(testQuery).rowSet();
        TupleMetadata expectedSchema = new SchemaBuilder().add("ID", TypeProtos.MinorType.BIGINT, TypeProtos.DataMode.OPTIONAL).add("NAME", TypeProtos.MinorType.BIGINT, TypeProtos.DataMode.OPTIONAL).buildSchema();
        RowSet.SingleRowSet expected = new RowSetBuilder(client.allocator(), expectedSchema).addRow(new Object[]{1L, 2L}).addRow(new Object[]{3L, 4L}).build();
        RowSetUtilities.verify((RowSet)expected, (RowSet)results);
        String dropQuery = "DROP TABLE localMysql.`drill_mysql_test`.`test_table`";
        QueryBuilder.QuerySummary dropResults = this.queryBuilder().sql(dropQuery).run();
        Assert.assertTrue((boolean)dropResults.succeeded());
    }

    @Test
    public void testBasicCTASWithDataTypes() throws Exception {
        String query = "CREATE TABLE mysql.drill_mysql_test.`data_types` AS SELECT CAST(1 AS INTEGER) AS int_field,CAST(2 AS BIGINT) AS bigint_field,CAST(3.0 AS FLOAT) AS float4_field,CAST(4.0 AS DOUBLE) AS float8_field,'5.0' AS varchar_field,CAST('2021-01-01' AS DATE) as date_field,CAST('12:00:00' AS TIME) as time_field, CAST('2015-12-30 22:55:55.23' AS TIMESTAMP) as timestamp_field, true AS boolean_field FROM (VALUES(1))";
        QueryBuilder.QuerySummary insertResults = this.queryBuilder().sql(query).run();
        Assert.assertTrue((boolean)insertResults.succeeded());
        String testQuery = "SELECT * FROM  mysql.`drill_mysql_test`.`data_types`";
        DirectRowSet results = this.queryBuilder().sql(testQuery).rowSet();
        TupleMetadata expectedSchema = new SchemaBuilder().addNullable("int_field", TypeProtos.MinorType.INT, 10).addNullable("bigint_field", TypeProtos.MinorType.BIGINT, 19).addNullable("float4_field", TypeProtos.MinorType.FLOAT8, 12).addNullable("float8_field", TypeProtos.MinorType.FLOAT8, 22).addNullable("varchar_field", TypeProtos.MinorType.VARCHAR, 38).addNullable("date_field", TypeProtos.MinorType.DATE, 10).addNullable("time_field", TypeProtos.MinorType.TIME, 10).addNullable("timestamp_field", TypeProtos.MinorType.TIMESTAMP, 19).addNullable("boolean_field", TypeProtos.MinorType.BIT).buildSchema();
        RowSet.SingleRowSet expected = new RowSetBuilder(client.allocator(), expectedSchema).addRow(new Object[]{1, 2L, 3.0, 4.0, "5.0", LocalDate.parse("2021-01-01"), LocalTime.parse("12:00"), 1451516155000L, true}).build();
        RowSetUtilities.verify((RowSet)expected, (RowSet)results);
        String dropQuery = "DROP TABLE mysql.`drill_mysql_test`.`data_types`";
        QueryBuilder.QuerySummary dropResults = this.queryBuilder().sql(dropQuery).run();
        Assert.assertTrue((boolean)dropResults.succeeded());
    }

    @Test
    public void testCTASFromFileWithNulls() throws Exception {
        String sql = "CREATE TABLE mysql.drill_mysql_test.`t1` AS SELECT int_field, float_field, varchar_field, boolean_field FROM cp.`json/dataTypes.json`";
        QueryBuilder.QuerySummary insertResults = this.queryBuilder().sql(sql).run();
        Assert.assertTrue((boolean)insertResults.succeeded());
        sql = "SELECT * FROM mysql.drill_mysql_test.`t1`";
        DirectRowSet results = this.queryBuilder().sql(sql).rowSet();
        TupleMetadata expectedSchema = new SchemaBuilder().addNullable("int_field", TypeProtos.MinorType.BIGINT, 19).addNullable("float_field", TypeProtos.MinorType.FLOAT8, 22).addNullable("varchar_field", TypeProtos.MinorType.VARCHAR, 38, 0).addNullable("boolean_field", TypeProtos.MinorType.BIT, 1).build();
        RowSet.SingleRowSet expected = new RowSetBuilder(client.allocator(), expectedSchema).addRow(new Object[]{1L, 1.0, "foo1", true}).addRow(new Object[]{null, null, null, null}).addRow(new Object[]{2L, 2.0, "foo2", false}).build();
        RowSetUtilities.verify((RowSet)expected, (RowSet)results);
        String dropQuery = "DROP TABLE mysql.`drill_mysql_test`.`t1`";
        QueryBuilder.QuerySummary dropResults = this.queryBuilder().sql(dropQuery).run();
        Assert.assertTrue((boolean)dropResults.succeeded());
    }

    @Test
    public void testCTASFromFileWithUglyData() throws Exception {
        String sql = "CREATE TABLE mysql.drill_mysql_test.`t2` AS SELECT ugly1, ugly2 FROM cp.`json/uglyData.json`";
        QueryBuilder.QuerySummary insertResults = this.queryBuilder().sql(sql).run();
        Assert.assertTrue((boolean)insertResults.succeeded());
        sql = "SELECT * FROM mysql.drill_mysql_test.`t2`";
        DirectRowSet results = this.queryBuilder().sql(sql).rowSet();
        TupleMetadata expectedSchema = new SchemaBuilder().addNullable("ugly1", TypeProtos.MinorType.VARCHAR, 38).addNullable("ugly2", TypeProtos.MinorType.VARCHAR, 38).build();
        RowSet.SingleRowSet expected = new RowSetBuilder(client.allocator(), expectedSchema).addRow(new Object[]{"O'Malley", "Abraham Lincoln's best speech started with: \"Four score and seven years ago..."}).build();
        RowSetUtilities.verify((RowSet)expected, (RowSet)results);
        String dropQuery = "DROP TABLE mysql.`drill_mysql_test`.`t2`";
        QueryBuilder.QuerySummary dropResults = this.queryBuilder().sql(dropQuery).run();
        Assert.assertTrue((boolean)dropResults.succeeded());
    }

    @Test
    public void testDropNonExistentTable() throws Exception {
        String dropQuery = "DROP TABLE mysql.`drill_mysql_test`.`none_shall_pass`";
        try {
            this.queryBuilder().sql(dropQuery).run();
            Assert.fail();
        }
        catch (UserRemoteException e) {
            Assert.assertTrue((boolean)e.getMessage().contains("VALIDATION ERROR: Table [none_shall_pass] not found"));
        }
    }

    @Test
    public void testBasicCTASIfNotExists() throws Exception {
        String query = "CREATE TABLE IF NOT EXISTS mysql.`drill_mysql_test`.`test_table` (ID, NAME) AS SELECT * FROM (VALUES(1,2), (3,4))";
        QueryBuilder.QuerySummary insertResults = this.queryBuilder().sql(query).run();
        Assert.assertTrue((boolean)insertResults.succeeded());
        String testQuery = "SELECT * FROM  mysql.`drill_mysql_test`.`test_table`";
        DirectRowSet results = this.queryBuilder().sql(testQuery).rowSet();
        TupleMetadata expectedSchema = new SchemaBuilder().add("ID", TypeProtos.MinorType.BIGINT, TypeProtos.DataMode.OPTIONAL).add("NAME", TypeProtos.MinorType.BIGINT, TypeProtos.DataMode.OPTIONAL).buildSchema();
        RowSet.SingleRowSet expected = new RowSetBuilder(client.allocator(), expectedSchema).addRow(new Object[]{1L, 2L}).addRow(new Object[]{3L, 4L}).build();
        RowSetUtilities.verify((RowSet)expected, (RowSet)results);
        String dropQuery = "DROP TABLE mysql.`drill_mysql_test`.`test_table`";
        QueryBuilder.QuerySummary dropResults = this.queryBuilder().sql(dropQuery).run();
        Assert.assertTrue((boolean)dropResults.succeeded());
    }

    @Test
    public void testCTASWithDuplicateTable() throws Exception {
        String query = "CREATE TABLE mysql.`drill_mysql_test`.`test_table` (ID, NAME) AS SELECT * FROM (VALUES(1,2), (3,4))";
        QueryBuilder.QuerySummary insertResults = this.queryBuilder().sql(query).run();
        Assert.assertTrue((boolean)insertResults.succeeded());
        try {
            this.queryBuilder().sql(query).run();
            Assert.fail();
        }
        catch (UserRemoteException e) {
            Assert.assertTrue((boolean)e.getMessage().contains("VALIDATION ERROR"));
        }
        query = "CREATE TABLE IF NOT EXISTS mysql.`drill_mysql_test`.`test_table` (ID, NAME) AS SELECT * FROM (VALUES(1,2), (3,4))";
        DirectRowSet results = this.queryBuilder().sql(query).rowSet();
        TupleMetadata expectedSchema = new SchemaBuilder().add("ok", TypeProtos.MinorType.BIT).add("summary", TypeProtos.MinorType.VARCHAR, TypeProtos.DataMode.OPTIONAL).buildSchema();
        RowSet.SingleRowSet expected = new RowSetBuilder(client.allocator(), expectedSchema).addRow(new Object[]{false, "A table or view with given name [test_table] already exists in schema [mysql.drill_mysql_test]"}).build();
        RowSetUtilities.verify((RowSet)expected, (RowSet)results);
    }

    @Test
    public void testWithComplexData() throws Exception {
        try {
            String sql = "CREATE TABLE mysql.`drill_mysql_test`.`complex` AS SELECT * FROM cp.`json/complexData.json`";
            this.queryBuilder().sql(sql).run();
            Assert.fail();
        }
        catch (UserRemoteException e) {
            Assert.assertTrue((boolean)e.getMessage().contains("DATA_WRITE ERROR: Drill does not support writing complex fields to JDBC data sources."));
        }
    }

    @Test
    public void testWithArrayField() throws Exception {
        try {
            String sql = "CREATE TABLE mysql.`drill_mysql_test`.`complex` AS SELECT * FROM cp.`json/repeatedData.json`";
            this.queryBuilder().sql(sql).run();
            Assert.fail();
        }
        catch (UserRemoteException e) {
            Assert.assertTrue((boolean)e.getMessage().contains("DATA_WRITE ERROR: Drill does not yet support writing arrays to JDBC. `repeated_field` is an array."));
        }
    }

    @Test
    public void testUnwritableConnection() throws Exception {
        String query;
        try {
            query = "CREATE TABLE IF NOT EXISTS mysql_no_write.`drill_mysql_test`.`test_table` (ID, NAME) AS SELECT * FROM (VALUES(1,2), (3,4))";
            this.queryBuilder().sql(query).run();
            Assert.fail();
        }
        catch (UserRemoteException e) {
            Assert.assertTrue((boolean)e.getMessage().contains("VALIDATION ERROR: Unable to create or drop objects. Schema [mysql_no_write.drill_mysql_test] is immutable."));
        }
        try {
            query = "CREATE TABLE mysql_no_write.`drill_mysql_test`.`test_table` (ID, NAME) AS SELECT * FROM (VALUES(1,2), (3,4))";
            this.queryBuilder().sql(query).run();
            Assert.fail();
        }
        catch (UserRemoteException e) {
            Assert.assertTrue((boolean)e.getMessage().contains("VALIDATION ERROR: Unable to create or drop objects. Schema [mysql_no_write.drill_mysql_test] is immutable."));
        }
    }

    @Test
    public void testWithLargeFile() throws Exception {
        String query = "CREATE TABLE mysql.`drill_mysql_test`.test (id,first_name,last_name,email,gender,ip_address) AS SELECT id,first_name,last_name,email,gender,ip_address FROM cp.`csv/large_csv.csvh`";
        QueryBuilder.QuerySummary insertResults = this.queryBuilder().sql(query).run();
        Assert.assertTrue((boolean)insertResults.succeeded());
        query = "SELECT COUNT(*) FROM mysql.`drill_mysql_test`.test";
        long rowCount = this.queryBuilder().sql(query).singletonLong();
        Assert.assertEquals((long)6000L, (long)rowCount);
        String dropQuery = "DROP TABLE mysql.`drill_mysql_test`.`test`";
        QueryBuilder.QuerySummary dropResults = this.queryBuilder().sql(dropQuery).run();
        Assert.assertTrue((boolean)dropResults.succeeded());
    }

    @Test
    @Ignore(value="This is a slow test.  Please run manually.")
    public void testWithReallyLongFile() throws Exception {
        Path generatedFile = null;
        try {
            generatedFile = JdbcTestUtils.generateCsvFile("csv/very_large_file.csvh", 10, 100000);
        }
        catch (IOException e) {
            logger.error(e.getMessage());
            Assert.fail();
        }
        String testQuery = "SELECT COUNT(*) FROM dfs.`csv/very_large_file.csvh`";
        long resultsCount = this.queryBuilder().sql(testQuery).singletonLong();
        Assert.assertEquals((long)100000L, (long)resultsCount);
        String ctasQuery = "CREATE TABLE mysql.`drill_mysql_test`.`test_big_table` AS SELECT * FROM dfs.`csv/very_large_file.csvh`";
        QueryBuilder.QuerySummary insertResults = this.queryBuilder().sql(ctasQuery).run();
        Assert.assertTrue((boolean)insertResults.succeeded());
        testQuery = "SELECT COUNT(*) FROM mysql.`drill_mysql_test`.`test_big_table`";
        resultsCount = this.queryBuilder().sql(testQuery).singletonLong();
        Assert.assertEquals((long)100000L, (long)resultsCount);
        String dropQuery = "DROP TABLE mysql.`drill_mysql_test`.`test_big_table`";
        QueryBuilder.QuerySummary dropResults = this.queryBuilder().sql(dropQuery).run();
        Assert.assertTrue((boolean)dropResults.succeeded());
        boolean deletedFile = JdbcTestUtils.deleteCsvFile(String.valueOf(generatedFile));
        if (!deletedFile) {
            Assert.fail();
        }
    }

    @AfterClass
    public static void stopMysql() {
        if (jdbcContainer != null) {
            jdbcContainer.stop();
        }
    }
}

