/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.store.jdbc;

import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.net.URL;
import java.nio.file.Paths;
import java.sql.Connection;
import java.sql.DriverManager;
import java.time.LocalDate;
import java.time.LocalTime;
import java.util.HashMap;
import java.util.TimeZone;
import org.apache.drill.common.exceptions.UserRemoteException;
import org.apache.drill.common.logical.StoragePluginConfig;
import org.apache.drill.common.types.TypeProtos;
import org.apache.drill.exec.physical.rowSet.DirectRowSet;
import org.apache.drill.exec.physical.rowSet.RowSet;
import org.apache.drill.exec.physical.rowSet.RowSetBuilder;
import org.apache.drill.exec.record.metadata.SchemaBuilder;
import org.apache.drill.exec.record.metadata.TupleMetadata;
import org.apache.drill.exec.store.enumerable.plan.EnumMockPlugin;
import org.apache.drill.exec.store.jdbc.JdbcStorageConfig;
import org.apache.drill.exec.store.jdbc.JdbcTestUtils;
import org.apache.drill.exec.store.jdbc.TestJdbcPluginWithH2IT;
import org.apache.drill.test.BaseDirTestWatcher;
import org.apache.drill.test.ClusterFixture;
import org.apache.drill.test.ClusterFixtureBuilder;
import org.apache.drill.test.ClusterTest;
import org.apache.drill.test.QueryBuilder;
import org.apache.drill.test.rowSet.RowSetUtilities;
import org.apache.hadoop.fs.Path;
import org.h2.tools.RunScript;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Ignore;
import org.junit.Test;

public class TestJdbcWriterWithH2
extends ClusterTest {
    public static final String TEST_TABLE = "h2.tmp.drill_h2_test.test_table";
    public static final String DROP_TEST_TABLE = String.format("DROP TABLE %s", "h2.tmp.drill_h2_test.test_table");

    @BeforeClass
    public static void init() throws Exception {
        TestJdbcWriterWithH2.startCluster((ClusterFixtureBuilder)ClusterFixture.builder((BaseDirTestWatcher)dirTestWatcher));
        TimeZone.setDefault(TimeZone.getTimeZone("UTC"));
        dirTestWatcher.copyResourceToRoot(Paths.get("", new String[0]));
        Class.forName("org.h2.Driver");
        String connString = "jdbc:h2:" + dirTestWatcher.getTmpDir().getCanonicalPath();
        URL scriptFile = TestJdbcPluginWithH2IT.class.getClassLoader().getResource("h2-test-data.sql");
        Assert.assertNotNull((String)"Script for test tables generation 'h2-test-data.sql' cannot be found in test resources", (Object)scriptFile);
        try (Connection connection = DriverManager.getConnection(connString, "root", "root");
             FileReader fileReader = new FileReader(scriptFile.getFile());){
            RunScript.execute((Connection)connection, (Reader)fileReader);
        }
        HashMap<String, Integer> sourceParameters = new HashMap<String, Integer>();
        sourceParameters.put("minimumIdle", 1);
        JdbcStorageConfig jdbcStorageConfig = new JdbcStorageConfig("org.h2.Driver", connString, "root", "root", true, true, sourceParameters, null, 10000);
        jdbcStorageConfig.setEnabled(Boolean.valueOf(true));
        JdbcStorageConfig jdbcStorageConfigNoWrite = new JdbcStorageConfig("org.h2.Driver", connString, "root", "root", true, false, sourceParameters, null, 10000);
        jdbcStorageConfig.setEnabled(Boolean.valueOf(true));
        jdbcStorageConfigNoWrite.setEnabled(Boolean.valueOf(true));
        cluster.defineStoragePlugin("h2", (StoragePluginConfig)jdbcStorageConfig);
        cluster.defineStoragePlugin("h2_unwritable", (StoragePluginConfig)jdbcStorageConfigNoWrite);
        EnumMockPlugin.EnumMockStoragePluginConfig config = new EnumMockPlugin.EnumMockStoragePluginConfig();
        config.setEnabled(Boolean.valueOf(true));
        cluster.defineStoragePlugin("mocked_enum", (StoragePluginConfig)config);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testBasicCTAS() throws Exception {
        String query = String.format("CREATE TABLE %s (ID, NAME) AS SELECT * FROM (VALUES(1,2), (3,4))", TEST_TABLE);
        QueryBuilder.QuerySummary insertResults = this.queryBuilder().sql(query).run();
        try {
            Assert.assertTrue((boolean)insertResults.succeeded());
            String testQuery = String.format("SELECT * FROM %s", TEST_TABLE);
            DirectRowSet results = this.queryBuilder().sql(testQuery).rowSet();
            TupleMetadata expectedSchema = new SchemaBuilder().add("ID", TypeProtos.MinorType.BIGINT, TypeProtos.DataMode.OPTIONAL).add("NAME", TypeProtos.MinorType.BIGINT, TypeProtos.DataMode.OPTIONAL).buildSchema();
            RowSet.SingleRowSet expected = new RowSetBuilder(client.allocator(), expectedSchema).addRow(new Object[]{1L, 2L}).addRow(new Object[]{3L, 4L}).build();
            RowSetUtilities.verify((RowSet)expected, (RowSet)results);
        }
        finally {
            QueryBuilder.QuerySummary dropResults = this.queryBuilder().sql(DROP_TEST_TABLE).run();
            Assert.assertTrue((boolean)dropResults.succeeded());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testBasicCTASWithDataTypes() throws Exception {
        String query = String.format("CREATE TABLE %s AS ", TEST_TABLE) + "SELECT CAST(1 AS INTEGER) AS int_field,CAST(2 AS BIGINT) AS bigint_field,CAST(3.0 AS FLOAT) AS float4_field,CAST(4.0 AS DOUBLE) AS float8_field,'5.0' AS varchar_field,CAST('2021-01-01' AS DATE) as date_field,CAST('12:00:00' AS TIME) as time_field, CAST('2015-12-30 22:55:55.23' AS TIMESTAMP) as timestamp_field, true AS boolean_field FROM (VALUES(1))";
        QueryBuilder.QuerySummary insertResults = this.queryBuilder().sql(query).run();
        Assert.assertTrue((boolean)insertResults.succeeded());
        try {
            String testQuery = String.format("SELECT * FROM  %s", TEST_TABLE);
            DirectRowSet results = this.queryBuilder().sql(testQuery).rowSet();
            TupleMetadata expectedSchema = new SchemaBuilder().addNullable("int_field", TypeProtos.MinorType.INT, 32).addNullable("bigint_field", TypeProtos.MinorType.BIGINT, 38).addNullable("float4_field", TypeProtos.MinorType.FLOAT4, 38).addNullable("float8_field", TypeProtos.MinorType.FLOAT8, 38).addNullable("varchar_field", TypeProtos.MinorType.VARCHAR, 38).addNullable("date_field", TypeProtos.MinorType.DATE, 10).addNullable("time_field", TypeProtos.MinorType.TIME, 8).addNullable("timestamp_field", TypeProtos.MinorType.TIMESTAMP, 26, 6).addNullable("boolean_field", TypeProtos.MinorType.BIT, 1).buildSchema();
            RowSet.SingleRowSet expected = new RowSetBuilder(client.allocator(), expectedSchema).addRow(new Object[]{1, 2L, 3.0, 4.0, "5.0", LocalDate.parse("2021-01-01"), LocalTime.parse("12:00"), 1451516155000L, true}).build();
            RowSetUtilities.verify((RowSet)expected, (RowSet)results);
        }
        finally {
            QueryBuilder.QuerySummary dropResults = this.queryBuilder().sql(DROP_TEST_TABLE).run();
            Assert.assertTrue((boolean)dropResults.succeeded());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testBasicCTASWithSpacesInFieldNames() throws Exception {
        String query = String.format("CREATE TABLE %s (`My id`, `My name`) AS SELECT * FROM (VALUES(1,2), (3,4))", TEST_TABLE);
        QueryBuilder.QuerySummary insertResults = this.queryBuilder().sql(query).run();
        Assert.assertTrue((boolean)insertResults.succeeded());
        try {
            String testQuery = String.format("SELECT * FROM %s", TEST_TABLE);
            DirectRowSet results = this.queryBuilder().sql(testQuery).rowSet();
            TupleMetadata expectedSchema = new SchemaBuilder().add("My id", TypeProtos.MinorType.BIGINT, TypeProtos.DataMode.OPTIONAL).add("My name", TypeProtos.MinorType.BIGINT, TypeProtos.DataMode.OPTIONAL).buildSchema();
            RowSet.SingleRowSet expected = new RowSetBuilder(client.allocator(), expectedSchema).addRow(new Object[]{1L, 2L}).addRow(new Object[]{3L, 4L}).build();
            RowSetUtilities.verify((RowSet)expected, (RowSet)results);
        }
        finally {
            QueryBuilder.QuerySummary dropResults = this.queryBuilder().sql(DROP_TEST_TABLE).run();
            Assert.assertTrue((boolean)dropResults.succeeded());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testCTASFromFileWithNulls() throws Exception {
        String sql = String.format("CREATE TABLE %s AS SELECT int_field, float_field, varchar_field, boolean_field FROM cp.`json/dataTypes.json`", TEST_TABLE);
        QueryBuilder.QuerySummary insertResults = this.queryBuilder().sql(sql).run();
        Assert.assertTrue((boolean)insertResults.succeeded());
        try {
            sql = String.format("SELECT * FROM %s", TEST_TABLE);
            DirectRowSet results = this.queryBuilder().sql(sql).rowSet();
            TupleMetadata expectedSchema = new SchemaBuilder().addNullable("int_field", TypeProtos.MinorType.BIGINT, 38).addNullable("float_field", TypeProtos.MinorType.FLOAT8, 38).addNullable("varchar_field", TypeProtos.MinorType.VARCHAR, 38).addNullable("boolean_field", TypeProtos.MinorType.BIT, 1).build();
            RowSet.SingleRowSet expected = new RowSetBuilder(client.allocator(), expectedSchema).addRow(new Object[]{1L, 1.0, "foo1", true}).addRow(new Object[]{null, null, null, null}).addRow(new Object[]{2L, 2.0, "foo2", false}).build();
            RowSetUtilities.verify((RowSet)expected, (RowSet)results);
        }
        finally {
            QueryBuilder.QuerySummary dropResults = this.queryBuilder().sql(DROP_TEST_TABLE).run();
            Assert.assertTrue((boolean)dropResults.succeeded());
        }
    }

    @Test
    public void testDropNonExistentTable() throws Exception {
        String dropQuery = "DROP TABLE h2.tmp.`drill_h2_test`.`none_shall_pass`";
        try {
            this.queryBuilder().sql(dropQuery).run();
            Assert.fail();
        }
        catch (UserRemoteException e) {
            Assert.assertTrue((boolean)e.getMessage().contains("VALIDATION ERROR: Table [none_shall_pass] not found"));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testBasicCTASWithSpacesInTableName() throws Exception {
        String query = "CREATE TABLE h2.tmp.`drill_h2_test`.`test table` (ID, NAME) AS SELECT * FROM (VALUES(1,2), (3,4))";
        QueryBuilder.QuerySummary insertResults = this.queryBuilder().sql(query).run();
        Assert.assertTrue((boolean)insertResults.succeeded());
        try {
            String testQuery = "SELECT * FROM h2.tmp.`drill_h2_test`.`test table`";
            DirectRowSet results = this.queryBuilder().sql(testQuery).rowSet();
            TupleMetadata expectedSchema = new SchemaBuilder().add("ID", TypeProtos.MinorType.BIGINT, TypeProtos.DataMode.OPTIONAL).add("NAME", TypeProtos.MinorType.BIGINT, TypeProtos.DataMode.OPTIONAL).buildSchema();
            RowSet.SingleRowSet expected = new RowSetBuilder(client.allocator(), expectedSchema).addRow(new Object[]{1L, 2L}).addRow(new Object[]{3L, 4L}).build();
            RowSetUtilities.verify((RowSet)expected, (RowSet)results);
        }
        finally {
            String dropQuery = "DROP TABLE  h2.tmp.`drill_h2_test`.`test table`";
            QueryBuilder.QuerySummary dropResults = this.queryBuilder().sql(dropQuery).run();
            Assert.assertTrue((boolean)dropResults.succeeded());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testBasicCTASIfNotExists() throws Exception {
        String query = String.format("CREATE TABLE IF NOT EXISTS %s (ID, NAME) AS SELECT * FROM (VALUES(1,2), (3,4))", TEST_TABLE);
        QueryBuilder.QuerySummary insertResults = this.queryBuilder().sql(query).run();
        Assert.assertTrue((boolean)insertResults.succeeded());
        try {
            String testQuery = String.format("SELECT * FROM %s", TEST_TABLE);
            DirectRowSet results = this.queryBuilder().sql(testQuery).rowSet();
            TupleMetadata expectedSchema = new SchemaBuilder().add("ID", TypeProtos.MinorType.BIGINT, TypeProtos.DataMode.OPTIONAL).add("NAME", TypeProtos.MinorType.BIGINT, TypeProtos.DataMode.OPTIONAL).buildSchema();
            RowSet.SingleRowSet expected = new RowSetBuilder(client.allocator(), expectedSchema).addRow(new Object[]{1L, 2L}).addRow(new Object[]{3L, 4L}).build();
            RowSetUtilities.verify((RowSet)expected, (RowSet)results);
        }
        finally {
            QueryBuilder.QuerySummary dropResults = this.queryBuilder().sql(DROP_TEST_TABLE).run();
            Assert.assertTrue((boolean)dropResults.succeeded());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testCTASWithDuplicateTable() throws Exception {
        String query = String.format("CREATE TABLE %s (ID, NAME) AS SELECT * FROM (VALUES(1,2), (3,4))", TEST_TABLE);
        QueryBuilder.QuerySummary insertResults = this.queryBuilder().sql(query).run();
        Assert.assertTrue((boolean)insertResults.succeeded());
        try {
            try {
                this.queryBuilder().sql(query).run();
                Assert.fail();
            }
            catch (UserRemoteException e) {
                Assert.assertTrue((boolean)e.getMessage().contains("VALIDATION ERROR"));
            }
            query = String.format("CREATE TABLE IF NOT EXISTS %s (ID, NAME) AS SELECT * FROM (VALUES(1,2), (3,4))", TEST_TABLE);
            DirectRowSet results = this.queryBuilder().sql(query).rowSet();
            TupleMetadata expectedSchema = new SchemaBuilder().add("ok", TypeProtos.MinorType.BIT).add("summary", TypeProtos.MinorType.VARCHAR, TypeProtos.DataMode.OPTIONAL).buildSchema();
            RowSet.SingleRowSet expected = new RowSetBuilder(client.allocator(), expectedSchema).addRow(new Object[]{false, "A table or view with given name [test_table] already exists in schema [h2.tmp.drill_h2_test]"}).build();
            RowSetUtilities.verify((RowSet)expected, (RowSet)results);
        }
        finally {
            QueryBuilder.QuerySummary dropResults = this.queryBuilder().sql(DROP_TEST_TABLE).run();
            Assert.assertTrue((boolean)dropResults.succeeded());
        }
    }

    @Test
    public void testWithComplexData() throws Exception {
        try {
            String sql = String.format("CREATE TABLE %s AS SELECT * FROM cp.`json/complexData.json`", TEST_TABLE);
            this.queryBuilder().sql(sql).run();
            Assert.fail();
        }
        catch (UserRemoteException e) {
            Assert.assertTrue((boolean)e.getMessage().contains("DATA_WRITE ERROR: Drill does not support writing complex fields to JDBC data sources."));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testCTASFromFileWithUglyData() throws Exception {
        String sql = String.format("CREATE TABLE %s AS SELECT ugly1, ugly2 FROM cp.`json/uglyData.json`", TEST_TABLE);
        QueryBuilder.QuerySummary insertResults = this.queryBuilder().sql(sql).run();
        Assert.assertTrue((boolean)insertResults.succeeded());
        try {
            sql = String.format("SELECT * FROM %s", TEST_TABLE);
            DirectRowSet results = this.queryBuilder().sql(sql).rowSet();
            TupleMetadata expectedSchema = new SchemaBuilder().addNullable("ugly1", TypeProtos.MinorType.VARCHAR, 38).addNullable("ugly2", TypeProtos.MinorType.VARCHAR, 38).build();
            RowSet.SingleRowSet expected = new RowSetBuilder(client.allocator(), expectedSchema).addRow(new Object[]{"O'Malley", "Abraham Lincoln's best speech started with: \"Four score and seven years ago..."}).build();
            RowSetUtilities.verify((RowSet)expected, (RowSet)results);
        }
        finally {
            QueryBuilder.QuerySummary dropResults = this.queryBuilder().sql(DROP_TEST_TABLE).run();
            Assert.assertTrue((boolean)dropResults.succeeded());
        }
    }

    @Test
    public void testWithArrayField() throws Exception {
        try {
            String sql = String.format("CREATE TABLE %s AS SELECT * FROM cp.`json/repeatedData.json`", TEST_TABLE);
            this.queryBuilder().sql(sql).run();
            Assert.fail();
        }
        catch (UserRemoteException e) {
            Assert.assertTrue((boolean)e.getMessage().contains("DATA_WRITE ERROR: Drill does not yet support writing arrays to JDBC. `repeated_field` is an array."));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testWithLargeFile() throws Exception {
        String query = String.format("CREATE TABLE %s (id,first_name,last_name,email,gender,ip_address) AS SELECT id,first_name,last_name,email,gender,ip_address FROM cp.`csv/large_csv.csvh`", TEST_TABLE);
        QueryBuilder.QuerySummary insertResults = this.queryBuilder().sql(query).run();
        Assert.assertTrue((boolean)insertResults.succeeded());
        try {
            query = String.format("SELECT COUNT(*) FROM %s", TEST_TABLE);
            long rowCount = this.queryBuilder().sql(query).singletonLong();
            Assert.assertEquals((long)6000L, (long)rowCount);
        }
        finally {
            QueryBuilder.QuerySummary dropResults = this.queryBuilder().sql(DROP_TEST_TABLE).run();
            Assert.assertTrue((boolean)dropResults.succeeded());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    @Ignore(value="This is a slow test.  Please run manually.")
    public void testWithReallyLongFile() throws Exception {
        Path generatedFile = null;
        try {
            generatedFile = JdbcTestUtils.generateCsvFile("csv/very_large_file.csvh", 10, 100000);
        }
        catch (IOException e) {
            Assert.fail();
        }
        String testQuery = "SELECT COUNT(*) FROM dfs.`csv/very_large_file.csvh`";
        long resultsCount = this.queryBuilder().sql(testQuery).singletonLong();
        Assert.assertEquals((long)100000L, (long)resultsCount);
        String ctasQuery = String.format("CREATE TABLE %s AS ", TEST_TABLE) + "SELECT * FROM dfs.`csv/very_large_file.csvh`";
        QueryBuilder.QuerySummary insertResults = this.queryBuilder().sql(ctasQuery).run();
        Assert.assertTrue((boolean)insertResults.succeeded());
        try {
            testQuery = String.format("SELECT COUNT(*) FROM %s", TEST_TABLE);
            resultsCount = this.queryBuilder().sql(testQuery).singletonLong();
            Assert.assertEquals((long)100000L, (long)resultsCount);
        }
        finally {
            QueryBuilder.QuerySummary dropResults = this.queryBuilder().sql(DROP_TEST_TABLE).run();
            Assert.assertTrue((boolean)dropResults.succeeded());
            boolean deletedFile = JdbcTestUtils.deleteCsvFile(String.valueOf(generatedFile));
            if (!deletedFile) {
                Assert.fail();
            }
        }
    }

    @Test
    public void testUnwritableConnection() throws Exception {
        String query;
        try {
            query = "CREATE TABLE IF NOT EXISTS h2_unwritable.tmp.`test_table` (ID, NAME) AS SELECT * FROM (VALUES(1,2), (3,4))";
            this.queryBuilder().sql(query).run();
            Assert.fail();
        }
        catch (UserRemoteException e) {
            Assert.assertTrue((boolean)e.getMessage().contains("VALIDATION ERROR: Unable to create or drop objects. Schema [h2_unwritable.tmp] is immutable."));
        }
        try {
            query = "CREATE TABLE h2_unwritable.tmp.`test_table` (ID, NAME) AS SELECT * FROM (VALUES(1,2), (3,4))";
            this.queryBuilder().sql(query).run();
            Assert.fail();
        }
        catch (UserRemoteException e) {
            Assert.assertTrue((boolean)e.getMessage().contains("VALIDATION ERROR: Unable to create or drop objects. Schema [h2_unwritable.tmp] is immutable."));
        }
    }
}

