/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.store.jdbc;

import java.math.BigDecimal;
import org.apache.drill.categories.JdbcStorageTest;
import org.apache.drill.common.logical.StoragePluginConfig;
import org.apache.drill.common.types.TypeProtos;
import org.apache.drill.exec.expr.fn.impl.DateUtility;
import org.apache.drill.exec.physical.rowSet.DirectRowSet;
import org.apache.drill.exec.physical.rowSet.RowSet;
import org.apache.drill.exec.record.metadata.SchemaBuilder;
import org.apache.drill.exec.record.metadata.TupleMetadata;
import org.apache.drill.exec.store.jdbc.JdbcStorageConfig;
import org.apache.drill.test.BaseDirTestWatcher;
import org.apache.drill.test.ClusterFixture;
import org.apache.drill.test.ClusterFixtureBuilder;
import org.apache.drill.test.ClusterTest;
import org.apache.drill.test.rowSet.RowSetUtilities;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.testcontainers.containers.ClickHouseContainer;
import org.testcontainers.containers.JdbcDatabaseContainer;
import org.testcontainers.utility.DockerImageName;

@Category(value={JdbcStorageTest.class})
public class TestJdbcPluginWithClickhouse
extends ClusterTest {
    private static final String DOCKER_IMAGE_CLICKHOUSE_X86 = "yandex/clickhouse-server:21.8.4.51";
    private static final String DOCKER_IMAGE_CLICKHOUSE_ARM = "lunalabsltd/clickhouse-server:21.7.2.7-arm";
    private static JdbcDatabaseContainer<?> jdbcContainer;

    @BeforeClass
    public static void initClickhouse() throws Exception {
        TestJdbcPluginWithClickhouse.startCluster((ClusterFixtureBuilder)ClusterFixture.builder((BaseDirTestWatcher)dirTestWatcher));
        String osName = System.getProperty("os.name").toLowerCase();
        DockerImageName imageName = osName.startsWith("linux") && "aarch64".equals(System.getProperty("os.arch")) ? DockerImageName.parse((String)DOCKER_IMAGE_CLICKHOUSE_ARM).asCompatibleSubstituteFor("yandex/clickhouse-server") : DockerImageName.parse((String)DOCKER_IMAGE_CLICKHOUSE_X86);
        jdbcContainer = new ClickHouseContainer(imageName).withInitScript("clickhouse-test-data.sql");
        jdbcContainer.start();
        JdbcStorageConfig jdbcStorageConfig = new JdbcStorageConfig("ru.yandex.clickhouse.ClickHouseDriver", jdbcContainer.getJdbcUrl(), jdbcContainer.getUsername(), null, true, false, null, null, 0);
        jdbcStorageConfig.setEnabled(Boolean.valueOf(true));
        cluster.defineStoragePlugin("clickhouse", (StoragePluginConfig)jdbcStorageConfig);
    }

    @AfterClass
    public static void stopClickhouse() {
        if (jdbcContainer != null) {
            jdbcContainer.stop();
        }
    }

    @Test
    public void validateResult() throws Exception {
        this.testBuilder().sqlQuery("select person_id, first_name, last_name, address, city, state, zip, json, bigint_field, smallint_field, decimal_field, boolean_field, double_field, float_field, date_field, datetime_field, enum_field from clickhouse.`default`.person order by person_id").ordered().baselineColumns(new String[]{"person_id", "first_name", "last_name", "address", "city", "state", "zip", "json", "bigint_field", "smallint_field", "decimal_field", "boolean_field", "double_field", "float_field", "date_field", "datetime_field", "enum_field"}).baselineValues(new Object[]{1, "first_name_1", "last_name_1", "1401 John F Kennedy Blvd", "Philadelphia", "PA", 19107, "{ a : 5, b : 6 }", 123456789L, 1, new BigDecimal("123.32"), 0, 1.0, 1.1, DateUtility.parseLocalDate((String)"2012-02-29"), DateUtility.parseLocalDateTime((String)"2012-02-29 13:00:01.0"), "XXX"}).baselineValues(new Object[]{2, "first_name_2", "last_name_2", "One Ferry Building", "San Francisco", "CA", 94111, "{ z : [ 1, 2, 3 ] }", 45456767L, 3, null, 1, 3.0, 3.1, DateUtility.parseLocalDate((String)"2011-10-30"), DateUtility.parseLocalDateTime((String)"2011-10-30 11:34:21.0"), "YYY"}).baselineValues(new Object[]{3, "first_name_3", "last_name_3", "176 Bowery", "New York", "NY", 10012, "{ [ a, b, c ] }", 123090L, -3, null, 0, 5.0, 5.1, DateUtility.parseLocalDate((String)"2015-06-01"), DateUtility.parseLocalDateTime((String)"2015-09-22 15:46:10.0"), "ZZZ"}).baselineValues(new Object[]{4, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, "XXX"}).go();
    }

    @Test
    public void pushDownJoin() throws Exception {
        String query = "select x.person_id from (select person_id from clickhouse.`default`.person) x join (select person_id from clickhouse.`default`.person) y on x.person_id = y.person_id";
        this.queryBuilder().sql(query).planMatcher().exclude(new String[]{"Join"}).match();
    }

    @Test
    public void pushDownJoinAndFilterPushDown() throws Exception {
        String query = "select * from clickhouse.`default`.person e INNER JOIN clickhouse.`default`.person s ON e.first_name = s.first_name WHERE e.last_name > 'hello'";
        this.queryBuilder().sql(query).planMatcher().exclude(new String[]{"Join", "Filter"}).match();
    }

    @Test
    public void pushDownAggWithDecimal() throws Exception {
        String query = "SELECT sum(decimal_field * smallint_field) AS `order_total`\nFROM clickhouse.`default`.person e";
        DirectRowSet results = this.queryBuilder().sql(query).rowSet();
        TupleMetadata expectedSchema = new SchemaBuilder().addNullable("order_total", TypeProtos.MinorType.VARDECIMAL, 38, 2).buildSchema();
        RowSet.SingleRowSet expected = client.rowSetBuilder(expectedSchema).addRow(new Object[]{123.32}).build();
        RowSetUtilities.verify((RowSet)expected, (RowSet)results);
    }

    @Test
    public void testPhysicalPlanSubmission() throws Exception {
        String query = "select * from clickhouse.`default`.person";
        String plan = this.queryBuilder().sql(query).explainJson();
        Assert.assertEquals((long)4L, (long)this.queryBuilder().physical(plan).run().recordCount());
    }

    @Test
    public void emptyOutput() {
        String query = "select * from clickhouse.`default`.person e limit 0";
        this.testBuilder().sqlQuery(query).expectsEmptyResultSet();
    }

    @Test
    public void testExpressionsWithoutAlias() throws Exception {
        String query = "select count(*), 1+1+2+3+5+8+13+21+34, (1+sqrt(5))/2\nfrom clickhouse.`default`.person";
        this.testBuilder().sqlQuery(query).unOrdered().baselineColumns(new String[]{"EXPR$0", "EXPR$1", "EXPR$2"}).baselineValues(new Object[]{4L, 88L, 1.618033988749895}).go();
    }

    @Test
    public void testExpressionsWithoutAliasesPermutations() throws Exception {
        String query = "select EXPR$1, EXPR$0, EXPR$2\nfrom (select 1+1+2+3+5+8+13+21+34, (1+sqrt(5))/2, count(*) from clickhouse.`default`.person)";
        this.testBuilder().sqlQuery(query).unOrdered().baselineColumns(new String[]{"EXPR$1", "EXPR$0", "EXPR$2"}).baselineValues(new Object[]{1.618033988749895, 88L, 4L}).go();
    }

    @Test
    public void testExpressionsWithAliases() throws Exception {
        String query = "select person_id as ID, 1+1+2+3+5+8+13+21+34 as FIBONACCI_SUM, (1+sqrt(5))/2 as golden_ratio\nfrom clickhouse.`default`.person limit 2";
        this.testBuilder().sqlQuery(query).unOrdered().baselineColumns(new String[]{"ID", "FIBONACCI_SUM", "golden_ratio"}).baselineValues(new Object[]{1, 88L, 1.618033988749895}).baselineValues(new Object[]{2, 88L, 1.618033988749895}).go();
    }

    @Test
    public void testJoinStar() throws Exception {
        String query = "select * from (select person_id from clickhouse.`default`.person) t1 join (select person_id from clickhouse.`default`.person) t2 on t1.person_id = t2.person_id";
        this.testBuilder().sqlQuery(query).unOrdered().baselineColumns(new String[]{"person_id", "person_id0"}).baselineValues(new Object[]{1, 1}).baselineValues(new Object[]{2, 2}).baselineValues(new Object[]{3, 3}).baselineValues(new Object[]{4, 4}).go();
    }

    @Test
    public void testSemiJoin() throws Exception {
        String query = "select person_id from clickhouse.`default`.person t1\nwhere exists (select person_id from clickhouse.`default`.person\nwhere t1.person_id = person_id)";
        this.testBuilder().sqlQuery(query).unOrdered().baselineColumns(new String[]{"person_id"}).baselineValuesForSingleColumn(new Object[]{1, 2, 3, 4}).go();
    }

    @Test
    public void testInformationSchemaViews() throws Exception {
        String query = "select * from information_schema.`views`";
        TestJdbcPluginWithClickhouse.run((String)query, (Object[])new Object[0]);
    }

    @Test
    public void testJdbcTableTypes() throws Exception {
        String query = "select distinct table_type from information_schema.`tables` where table_schema like 'clickhouse%'";
        this.testBuilder().sqlQuery(query).unOrdered().baselineColumns(new String[]{"table_type"}).baselineValuesForSingleColumn(new Object[]{"TABLE", "VIEW"}).go();
    }

    @Test
    public void testLimitPushDown() throws Exception {
        String query = "select person_id, first_name, last_name from clickhouse.`default`.person limit 100";
        this.queryBuilder().sql(query).planMatcher().include(new String[]{"Jdbc\\(.*LIMIT 100"}).exclude(new String[]{"Limit\\("}).match();
    }

    @Test
    public void testLimitPushDownWithOrderBy() throws Exception {
        String query = "select person_id from clickhouse.`default`.person order by first_name limit 100";
        this.queryBuilder().sql(query).planMatcher().include(new String[]{"Jdbc\\(.*ORDER BY `first_name`.*LIMIT 100"}).exclude(new String[]{"Limit\\("}).match();
    }

    @Test
    public void testLimitPushDownWithOffset() throws Exception {
        String query = "select person_id, first_name from clickhouse.`default`.person limit 100 offset 10";
        this.queryBuilder().sql(query).planMatcher().include(new String[]{"Jdbc\\(.*LIMIT 10, 100"}).exclude(new String[]{"Limit\\("}).match();
    }

    @Test
    public void testLimitPushDownWithConvertFromJson() throws Exception {
        String query = "select convert_fromJSON(first_name)['ppid'] from clickhouse.`default`.person LIMIT 100";
        this.queryBuilder().sql(query).planMatcher().include(new String[]{"Jdbc\\(.*LIMIT 100"}).exclude(new String[]{"Limit\\("}).match();
    }
}

