/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.store.jdbc;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Random;
import org.apache.commons.lang3.RandomStringUtils;
import org.apache.drill.exec.ExecTest;
import org.apache.drill.test.ClusterTest;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JdbcTestUtils {
    private static final Logger logger = LoggerFactory.getLogger(JdbcTestUtils.class);

    public static String generateRandomString(int length) {
        return RandomStringUtils.random((int)length, (boolean)true, (boolean)false);
    }

    public static Path generateCsvFile(String fileName, int columnCount, int rowCount) throws IOException {
        String COLUMN_NAME_TEMPLATE = "col_";
        StringBuilder row = new StringBuilder();
        Random random = new Random();
        FileSystem fs = ExecTest.getLocalFileSystem();
        Path outFile = new Path(ClusterTest.dirTestWatcher.getRootDir().getAbsolutePath(), fileName);
        FileWriter fileWriter = new FileWriter(String.valueOf(outFile));
        PrintWriter printWriter = new PrintWriter(fileWriter);
        for (int i = 0; i <= rowCount; ++i) {
            for (int j = 0; j < columnCount; ++j) {
                if (i == 0) {
                    row.append("col_").append(j);
                } else if (j % 2 == 0) {
                    row.append(JdbcTestUtils.generateRandomString(8));
                } else {
                    row.append(random.nextInt(1000000));
                }
                if (j >= columnCount - 1) continue;
                row.append(",");
            }
            printWriter.println(row);
            row = new StringBuilder();
        }
        printWriter.close();
        return outFile;
    }

    public static boolean deleteCsvFile(String filepath) {
        File tempFile = new File(filepath);
        return tempFile.delete();
    }
}

