/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.store.jdbc;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeName;
import java.util.List;
import org.apache.drill.common.PlanStringBuilder;
import org.apache.drill.common.exceptions.ExecutionSetupException;
import org.apache.drill.common.expression.SchemaPath;
import org.apache.drill.common.logical.StoragePluginConfig;
import org.apache.drill.exec.physical.base.AbstractSubScan;
import org.apache.drill.exec.store.StoragePluginRegistry;
import org.apache.drill.exec.store.jdbc.JdbcStorageConfig;
import org.apache.drill.exec.store.jdbc.JdbcStoragePlugin;

@JsonTypeName(value="jdbc-sub-scan")
public class JdbcSubScan
extends AbstractSubScan {
    public static final String OPERATOR_TYPE = "JDBC_SCAN";
    private final String sql;
    private final JdbcStoragePlugin plugin;
    private final List<SchemaPath> columns;

    @JsonCreator
    public JdbcSubScan(@JsonProperty(value="sql") String sql, @JsonProperty(value="columns") List<SchemaPath> columns, @JsonProperty(value="config") StoragePluginConfig config, @JacksonInject StoragePluginRegistry plugins) throws ExecutionSetupException {
        super("");
        this.sql = sql;
        this.columns = columns;
        this.plugin = (JdbcStoragePlugin)plugins.resolve(config, JdbcStoragePlugin.class);
    }

    JdbcSubScan(String sql, List<SchemaPath> columns, JdbcStoragePlugin plugin) {
        super("");
        this.sql = sql;
        this.columns = columns;
        this.plugin = plugin;
    }

    public String getOperatorType() {
        return OPERATOR_TYPE;
    }

    public String getSql() {
        return this.sql;
    }

    public List<SchemaPath> getColumns() {
        return this.columns;
    }

    public JdbcStorageConfig getConfig() {
        return this.plugin.getConfig();
    }

    @JsonIgnore
    public JdbcStoragePlugin getPlugin() {
        return this.plugin;
    }

    public String toString() {
        return new PlanStringBuilder((Object)this).field("sql", this.sql).field("columns", this.columns).toString();
    }
}

