/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.store.jdbc.rules;

import java.math.BigDecimal;
import java.util.Collections;
import org.apache.calcite.adapter.jdbc.JdbcConvention;
import org.apache.calcite.plan.RelTrait;
import org.apache.calcite.plan.RelTraitSet;
import org.apache.calcite.rel.RelCollations;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rex.RexLiteral;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.sql.dialect.MssqlSqlDialect;
import org.apache.drill.exec.planner.common.DrillLimitRelBase;
import org.apache.drill.exec.store.enumerable.plan.DrillJdbcRuleBase;
import org.apache.drill.exec.store.enumerable.plan.DrillJdbcSort;
import org.apache.drill.exec.store.jdbc.DrillJdbcConvention;

public class JdbcLimitRule
extends DrillJdbcRuleBase.DrillJdbcLimitRule {
    private final DrillJdbcConvention convention;

    public JdbcLimitRule(RelTrait in, DrillJdbcConvention out) {
        super(in, (JdbcConvention)out);
        this.convention = out;
    }

    public RelNode convert(RelNode rel) {
        DrillLimitRelBase limit = (DrillLimitRelBase)rel;
        if (limit.getOffset() == null || !limit.getTraitSet().contains((RelTrait)RelCollations.EMPTY) || !(this.convention.getPlugin().getDialect() instanceof MssqlSqlDialect)) {
            return super.convert((RelNode)limit);
        }
        int offset = Math.max(0, RexLiteral.intValue((RexNode)limit.getOffset()));
        int fetch = Math.max(0, RexLiteral.intValue((RexNode)limit.getFetch()));
        RexLiteral childFetch = limit.getCluster().getRexBuilder().makeExactLiteral(BigDecimal.valueOf(offset + fetch));
        DrillJdbcSort jdbcSort = new DrillJdbcSort(limit.getCluster(), limit.getTraitSet().plus((RelTrait)RelCollations.EMPTY).replace((RelTrait)this.out).simplify(), JdbcLimitRule.convert((RelNode)limit.getInput(), (RelTraitSet)limit.getInput().getTraitSet().replace((RelTrait)this.out).simplify()), RelCollations.EMPTY, null, (RexNode)childFetch);
        return limit.copy(limit.getTraitSet(), Collections.singletonList(jdbcSort), true);
    }
}

