/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.store.jdbc;

import org.apache.calcite.adapter.java.JavaTypeFactory;
import org.apache.calcite.adapter.jdbc.JdbcImplementor;
import org.apache.calcite.plan.RelOptCluster;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.rel2sql.SqlImplementor;
import org.apache.calcite.schema.Schema;
import org.apache.calcite.schema.SchemaPlus;
import org.apache.calcite.sql.SqlDialect;
import org.apache.drill.exec.store.SchemaConfig;
import org.apache.drill.exec.store.SubsetRemover;
import org.apache.drill.exec.store.jdbc.JdbcCatalogSchema;
import org.apache.drill.exec.store.jdbc.JdbcDialect;
import org.apache.drill.exec.store.jdbc.JdbcStoragePlugin;

public class DefaultJdbcDialect
implements JdbcDialect {
    private final JdbcStoragePlugin plugin;

    public DefaultJdbcDialect(JdbcStoragePlugin plugin) {
        this.plugin = plugin;
    }

    @Override
    public void registerSchemas(SchemaConfig config, SchemaPlus parent) {
        JdbcCatalogSchema schema = new JdbcCatalogSchema(this.plugin.getName(), this.plugin.getDataSource(), this.plugin.getDialect(), this.plugin.getConvention(), !this.plugin.getConfig().areTableNamesCaseInsensitive());
        SchemaPlus holder = parent.add(this.plugin.getName(), (Schema)schema);
        schema.setHolder(holder);
    }

    @Override
    public String generateSql(RelOptCluster cluster, RelNode input) {
        SqlDialect dialect = this.plugin.getDialect();
        JdbcImplementor jdbcImplementor = new JdbcImplementor(dialect, (JavaTypeFactory)cluster.getTypeFactory());
        SqlImplementor.Result result = jdbcImplementor.visitChild(0, input.accept(SubsetRemover.INSTANCE));
        return result.asStatement().toSqlString(dialect).getSql();
    }
}

