/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.store.jdbc.utils;

import java.sql.JDBCType;
import org.apache.calcite.sql.SqlDialect;
import org.apache.calcite.sql.dialect.PostgresqlSqlDialect;
import org.apache.drill.common.exceptions.UserException;
import org.apache.drill.common.types.TypeProtos;
import org.apache.drill.exec.store.jdbc.JdbcRecordWriter;
import org.apache.drill.exec.store.jdbc.utils.JdbcDDLQueryUtils;
import org.apache.parquet.Strings;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CreateTableStmtBuilder {
    private static final Logger logger = LoggerFactory.getLogger(CreateTableStmtBuilder.class);
    public static final int DEFAULT_VARCHAR_PRECISION = 100;
    private static final String CREATE_TABLE_QUERY = "CREATE TABLE %s (";
    private StringBuilder createTableQuery;
    private final String tableName;
    private final SqlDialect dialect;
    private StringBuilder columns;

    public CreateTableStmtBuilder(String tableName, SqlDialect dialect) {
        if (Strings.isNullOrEmpty((String)tableName)) {
            throw new UnsupportedOperationException("Table name cannot be empty");
        }
        this.tableName = tableName;
        this.dialect = dialect;
        this.columns = new StringBuilder();
    }

    public void addColumn(String colName, TypeProtos.MinorType type, boolean nullable, int precision, int scale) {
        StringBuilder queryText = new StringBuilder();
        String jdbcColTypeName = "";
        try {
            Integer jdbcColType = (Integer)JdbcRecordWriter.JDBC_TYPE_MAPPINGS.get((Object)type);
            jdbcColTypeName = JDBCType.valueOf(jdbcColType).getName();
            if (this.dialect instanceof PostgresqlSqlDialect && jdbcColType.equals(8)) {
                jdbcColTypeName = "FLOAT";
            }
        }
        catch (NullPointerException e) {
            throw UserException.dataWriteError().message("Drill does not support writing complex fields to JDBC data sources.", new Object[0]).addContext(colName + " is a complex type.").build(logger);
        }
        queryText.append(colName).append(" ").append(jdbcColTypeName);
        if (jdbcColTypeName.equals("VARCHAR")) {
            int max_precision = Math.max(precision, 100);
            queryText.append("(").append(max_precision).append(")");
        }
        if (!nullable) {
            queryText.append(" NOT NULL");
        }
        if (!Strings.isNullOrEmpty((String)this.columns.toString())) {
            this.columns.append(",\n");
        }
        this.columns.append((CharSequence)queryText);
    }

    public CreateTableStmtBuilder build() {
        this.createTableQuery = new StringBuilder();
        this.createTableQuery.append(String.format(CREATE_TABLE_QUERY, this.tableName));
        this.createTableQuery.append((CharSequence)this.columns);
        this.createTableQuery.append("\n)");
        return this;
    }

    public String getCreateTableQuery() {
        return this.createTableQuery != null ? this.createTableQuery.toString() : null;
    }

    public String toString() {
        return this.getCreateTableQuery();
    }

    public static String buildCompleteTableName(String table, String catalog, String schema) {
        logger.debug("Building complete table.");
        StringBuilder completeTable = new StringBuilder();
        if (!Strings.isNullOrEmpty((String)catalog)) {
            completeTable.append(catalog);
            completeTable.append(".");
        }
        if (!Strings.isNullOrEmpty((String)schema)) {
            completeTable.append(schema);
            completeTable.append(".");
        }
        completeTable.append(table);
        return JdbcDDLQueryUtils.addBackTicksToTable(completeTable.toString());
    }
}

