/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.store.jdbc.clickhouse;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import javax.sql.DataSource;
import org.apache.calcite.schema.Schema;
import org.apache.calcite.schema.SchemaPlus;
import org.apache.calcite.schema.Table;
import org.apache.calcite.sql.SqlDialect;
import org.apache.drill.exec.store.AbstractSchema;
import org.apache.drill.exec.store.jdbc.CapitalizingJdbcSchema;
import org.apache.drill.exec.store.jdbc.DrillJdbcConvention;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ClickhouseCatalogSchema
extends AbstractSchema {
    private static final Logger logger = LoggerFactory.getLogger(ClickhouseCatalogSchema.class);
    private final Map<String, CapitalizingJdbcSchema> schemaMap = new HashMap<String, CapitalizingJdbcSchema>();
    private final CapitalizingJdbcSchema defaultSchema;

    public ClickhouseCatalogSchema(String name, DataSource source, SqlDialect dialect, DrillJdbcConvention convention) {
        super(Collections.emptyList(), name);
        String connectionSchemaName = null;
        try (Connection con = source.getConnection();
             ResultSet set = con.getMetaData().getSchemas();){
            connectionSchemaName = con.getSchema();
            while (set.next()) {
                String schemaName = set.getString(1);
                String catalogName = set.getString(2);
                this.schemaMap.put(schemaName, new CapitalizingJdbcSchema(this.getSchemaPath(), schemaName, source, dialect, convention, catalogName, schemaName, false));
            }
        }
        catch (SQLException e) {
            logger.error("Failure while attempting to load clickhouse schema.", (Throwable)e);
        }
        this.defaultSchema = this.determineDefaultSchema(connectionSchemaName);
    }

    private CapitalizingJdbcSchema determineDefaultSchema(String connectionSchemaName) {
        CapitalizingJdbcSchema schema = this.schemaMap.get(connectionSchemaName);
        if (schema == null) {
            return this.schemaMap.values().iterator().next();
        }
        return schema;
    }

    public void setHolder(SchemaPlus plusOfThis) {
        for (Map.Entry<String, CapitalizingJdbcSchema> entry : this.schemaMap.entrySet()) {
            plusOfThis.add(entry.getKey(), (Schema)entry.getValue());
        }
    }

    public String getTypeName() {
        return "jdbc";
    }

    public Schema getDefaultSchema() {
        return this.defaultSchema;
    }

    public Table getTable(String name) {
        if (this.defaultSchema != null) {
            try {
                return this.defaultSchema.getTable(name);
            }
            catch (RuntimeException e) {
                logger.warn("Failure while attempting to read table '{}' from {}.", new Object[]{name, ((Object)((Object)this)).getClass().getSimpleName(), e});
            }
        }
        return null;
    }

    public Set<String> getTableNames() {
        return this.defaultSchema.getTableNames();
    }
}

