/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.store.jdbc;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.io.IOException;
import org.apache.calcite.adapter.jdbc.JdbcSchema;
import org.apache.drill.common.PlanStringBuilder;
import org.apache.drill.common.exceptions.ExecutionSetupException;
import org.apache.drill.common.logical.StoragePluginConfig;
import org.apache.drill.exec.physical.base.AbstractWriter;
import org.apache.drill.exec.physical.base.PhysicalOperator;
import org.apache.drill.exec.store.StoragePluginRegistry;
import org.apache.drill.exec.store.jdbc.JdbcStoragePlugin;

public class JdbcWriter
extends AbstractWriter {
    public static final String OPERATOR_TYPE = "JDBC_WRITER";
    private final JdbcStoragePlugin plugin;
    private final String tableName;
    private final JdbcSchema inner;

    @JsonCreator
    public JdbcWriter(@JsonProperty(value="child") PhysicalOperator child, @JsonProperty(value="name") String name, @JsonProperty(value="storage") StoragePluginConfig storageConfig, @JacksonInject JdbcSchema inner, @JacksonInject StoragePluginRegistry engineRegistry) throws IOException, ExecutionSetupException {
        super(child);
        this.plugin = (JdbcStoragePlugin)engineRegistry.resolve(storageConfig, JdbcStoragePlugin.class);
        this.tableName = name;
        this.inner = inner;
    }

    JdbcWriter(PhysicalOperator child, String name, JdbcSchema inner, JdbcStoragePlugin plugin) {
        super(child);
        this.tableName = name;
        this.plugin = plugin;
        this.inner = inner;
    }

    public String getOperatorType() {
        return OPERATOR_TYPE;
    }

    protected PhysicalOperator getNewWithChild(PhysicalOperator child) {
        return new JdbcWriter(child, this.tableName, this.inner, this.plugin);
    }

    public String getTableName() {
        return this.tableName;
    }

    public StoragePluginConfig getStorage() {
        return this.plugin.getConfig();
    }

    @JsonIgnore
    public JdbcSchema getInner() {
        return this.inner;
    }

    @JsonIgnore
    public JdbcStoragePlugin getPlugin() {
        return this.plugin;
    }

    public String toString() {
        return new PlanStringBuilder((Object)this).field("tableName", this.tableName).field("storageStrategy", (Object)this.getStorageStrategy()).toString();
    }
}

