/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.store.jdbc;

import com.google.common.collect.ImmutableMap;
import io.netty.buffer.DrillBuf;
import java.io.IOException;
import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import javax.sql.DataSource;
import org.apache.calcite.sql.SqlDialect;
import org.apache.calcite.sql.util.SqlBuilder;
import org.apache.drill.common.AutoCloseables;
import org.apache.drill.common.exceptions.UserException;
import org.apache.drill.common.types.TypeProtos;
import org.apache.drill.exec.expr.fn.impl.StringFunctionHelpers;
import org.apache.drill.exec.expr.holders.BigIntHolder;
import org.apache.drill.exec.expr.holders.BitHolder;
import org.apache.drill.exec.expr.holders.DateHolder;
import org.apache.drill.exec.expr.holders.Float4Holder;
import org.apache.drill.exec.expr.holders.Float8Holder;
import org.apache.drill.exec.expr.holders.IntHolder;
import org.apache.drill.exec.expr.holders.NullableBigIntHolder;
import org.apache.drill.exec.expr.holders.NullableBitHolder;
import org.apache.drill.exec.expr.holders.NullableDateHolder;
import org.apache.drill.exec.expr.holders.NullableFloat4Holder;
import org.apache.drill.exec.expr.holders.NullableFloat8Holder;
import org.apache.drill.exec.expr.holders.NullableIntHolder;
import org.apache.drill.exec.expr.holders.NullableSmallIntHolder;
import org.apache.drill.exec.expr.holders.NullableTimeHolder;
import org.apache.drill.exec.expr.holders.NullableTimeStampHolder;
import org.apache.drill.exec.expr.holders.NullableTinyIntHolder;
import org.apache.drill.exec.expr.holders.NullableVarCharHolder;
import org.apache.drill.exec.expr.holders.NullableVarDecimalHolder;
import org.apache.drill.exec.expr.holders.SmallIntHolder;
import org.apache.drill.exec.expr.holders.TimeHolder;
import org.apache.drill.exec.expr.holders.TimeStampHolder;
import org.apache.drill.exec.expr.holders.TinyIntHolder;
import org.apache.drill.exec.expr.holders.VarCharHolder;
import org.apache.drill.exec.expr.holders.VarDecimalHolder;
import org.apache.drill.exec.ops.OperatorContext;
import org.apache.drill.exec.record.BatchSchema;
import org.apache.drill.exec.record.MaterializedField;
import org.apache.drill.exec.record.VectorAccessible;
import org.apache.drill.exec.store.AbstractRecordWriter;
import org.apache.drill.exec.store.EventBasedRecordWriter;
import org.apache.drill.exec.store.jdbc.JdbcWriter;
import org.apache.drill.exec.store.jdbc.JdbcWriterField;
import org.apache.drill.exec.store.jdbc.utils.CreateTableStmtBuilder;
import org.apache.drill.exec.store.jdbc.utils.JdbcDDLQueryUtils;
import org.apache.drill.exec.util.DecimalUtility;
import org.apache.drill.exec.vector.complex.reader.FieldReader;
import org.apache.parquet.Strings;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JdbcRecordWriter
extends AbstractRecordWriter {
    private static final Logger logger = LoggerFactory.getLogger(JdbcRecordWriter.class);
    private final String tableName;
    private Connection connection;
    private final SqlDialect dialect;
    private final List<Object> rowList;
    private final List<JdbcWriterField> fields;
    private final String rawTableName;
    private final JdbcWriter config;
    private SqlBuilder insertQueryBuilder;
    private boolean firstRecord;
    private int recordCount;
    public static final ImmutableMap<TypeProtos.MinorType, Integer> JDBC_TYPE_MAPPINGS = ImmutableMap.builder().put((Object)TypeProtos.MinorType.FLOAT8, (Object)8).put((Object)TypeProtos.MinorType.FLOAT4, (Object)6).put((Object)TypeProtos.MinorType.TINYINT, (Object)-6).put((Object)TypeProtos.MinorType.SMALLINT, (Object)5).put((Object)TypeProtos.MinorType.INT, (Object)4).put((Object)TypeProtos.MinorType.BIGINT, (Object)-5).put((Object)TypeProtos.MinorType.VARCHAR, (Object)12).put((Object)TypeProtos.MinorType.VARBINARY, (Object)-3).put((Object)TypeProtos.MinorType.VARDECIMAL, (Object)3).put((Object)TypeProtos.MinorType.DATE, (Object)91).put((Object)TypeProtos.MinorType.TIME, (Object)92).put((Object)TypeProtos.MinorType.TIMESTAMP, (Object)93).put((Object)TypeProtos.MinorType.BIT, (Object)16).build();

    public JdbcRecordWriter(DataSource source, OperatorContext context, String name, JdbcWriter config) {
        this.tableName = JdbcDDLQueryUtils.addBackTicksToTable(name);
        this.rowList = new ArrayList<Object>();
        this.dialect = config.getPlugin().getDialect();
        this.config = config;
        this.rawTableName = name;
        this.fields = new ArrayList<JdbcWriterField>();
        this.firstRecord = true;
        this.recordCount = 0;
        this.insertQueryBuilder = this.initializeInsertQuery();
        try {
            this.connection = source.getConnection();
        }
        catch (SQLException e) {
            throw UserException.connectionError().message("Unable to open JDBC connection for writing.", new Object[0]).addContext(e.getSQLState()).build(logger);
        }
    }

    public void init(Map<String, String> writerOptions) {
    }

    public void updateSchema(VectorAccessible batch) {
        BatchSchema schema = batch.getSchema();
        boolean nullable = false;
        CreateTableStmtBuilder queryBuilder = new CreateTableStmtBuilder(this.tableName, this.dialect);
        for (MaterializedField field : schema) {
            String columnName = JdbcDDLQueryUtils.addBackTicksToField(field.getName());
            TypeProtos.MinorType type = field.getType().getMinorType();
            logger.debug("Adding column {} of type {}.", (Object)columnName, (Object)type);
            if (field.getType().getMode() == TypeProtos.DataMode.REPEATED) {
                throw UserException.dataWriteError().message("Drill does not yet support writing arrays to JDBC. " + columnName + " is an array.", new Object[0]).build(logger);
            }
            if (field.getType().getMode() == TypeProtos.DataMode.OPTIONAL) {
                nullable = true;
            }
            int precision = field.getPrecision();
            int scale = field.getScale();
            queryBuilder.addColumn(columnName, field.getType().getMinorType(), nullable, precision, scale);
        }
        String sql = queryBuilder.build().getCreateTableQuery();
        sql = JdbcDDLQueryUtils.cleanDDLQuery(sql, this.dialect);
        logger.debug("Final query: {}", (Object)sql);
        try (Statement statement = this.connection.createStatement();){
            logger.debug("Executing CREATE query: {}", (Object)sql);
            statement.execute(sql);
        }
        catch (SQLException e) {
            throw UserException.dataReadError((Throwable)e).message("The JDBC storage plugin failed while trying to create the schema. ", new Object[0]).addContext("Sql", sql).build(logger);
        }
    }

    public void startRecord() {
        this.rowList.clear();
        if (!this.firstRecord) {
            this.insertQueryBuilder.append(",");
        }
        this.insertQueryBuilder.append("(");
        logger.debug("Start record");
    }

    public void endRecord() throws IOException {
        logger.debug("Ending record");
        for (int i = 0; i < this.rowList.size(); ++i) {
            String timeString;
            if (i > 0) {
                this.insertQueryBuilder.append(",");
            }
            if (this.rowList.get(i) instanceof String && ((String)this.rowList.get(i)).equalsIgnoreCase("null")) {
                this.insertQueryBuilder.append("null");
                continue;
            }
            JdbcWriterField currentField = this.fields.get(i);
            if (currentField.getDataType() == TypeProtos.MinorType.VARCHAR) {
                String value = null;
                if (currentField.getMode() == TypeProtos.DataMode.REQUIRED) {
                    VarCharHolder varCharHolder = (VarCharHolder)this.rowList.get(i);
                    value = StringFunctionHelpers.getStringFromVarCharHolder((VarCharHolder)varCharHolder);
                } else {
                    try {
                        NullableVarCharHolder nullableVarCharHolder = (NullableVarCharHolder)this.rowList.get(i);
                        value = StringFunctionHelpers.getStringFromVarCharHolder((NullableVarCharHolder)nullableVarCharHolder);
                    }
                    catch (ClassCastException e) {
                        logger.error("Unable to read field: {}", this.rowList.get(i));
                    }
                }
                this.insertQueryBuilder.literal(value);
                continue;
            }
            if (currentField.getDataType() == TypeProtos.MinorType.DATE) {
                String dateString = this.formatDateForInsertQuery((Long)this.rowList.get(i));
                this.insertQueryBuilder.literal(dateString);
                continue;
            }
            if (currentField.getDataType() == TypeProtos.MinorType.TIME) {
                timeString = this.formatTimeForInsertQuery((Integer)this.rowList.get(i));
                this.insertQueryBuilder.literal(timeString);
                continue;
            }
            if (currentField.getDataType() == TypeProtos.MinorType.TIMESTAMP) {
                timeString = this.formatTimeStampForInsertQuery((Long)this.rowList.get(i));
                this.insertQueryBuilder.literal(timeString);
                continue;
            }
            if (Strings.isNullOrEmpty((String)this.rowList.get(i).toString())) {
                this.insertQueryBuilder.append("null");
                continue;
            }
            this.insertQueryBuilder.append(this.rowList.get(i).toString());
        }
        ++this.recordCount;
        this.firstRecord = false;
        this.insertQueryBuilder.append(")");
        if (this.recordCount >= this.config.getPlugin().getConfig().getWriterBatchSize()) {
            String insertQuery = this.insertQueryBuilder.toString();
            this.executeInsert(insertQuery);
            this.recordCount = 0;
            this.firstRecord = true;
            this.insertQueryBuilder = this.initializeInsertQuery();
        }
        this.rowList.clear();
    }

    public void abort() {
        logger.debug("Abort insert.");
    }

    public void cleanup() throws IOException {
        logger.debug("Cleanup record");
        String insertQuery = this.insertQueryBuilder.toString();
        if (this.recordCount != 0) {
            this.executeInsert(insertQuery);
        }
        AutoCloseables.closeSilently((AutoCloseable[])new AutoCloseable[]{this.connection});
    }

    private void executeInsert(String insertQuery) throws IOException {
        try (Statement stmt = this.connection.createStatement();){
            logger.debug("Executing insert query: {}", (Object)insertQuery);
            stmt.execute(insertQuery);
            logger.debug("Query complete");
            AutoCloseables.closeSilently((AutoCloseable[])new AutoCloseable[]{stmt});
        }
        catch (SQLException e) {
            logger.error("Error: {} {} {}", new Object[]{e.getMessage(), e.getSQLState(), e.getErrorCode()});
            AutoCloseables.closeSilently((AutoCloseable[])new AutoCloseable[]{this.connection});
            throw new IOException(e.getMessage() + " " + e.getSQLState() + "\n" + insertQuery);
        }
    }

    private SqlBuilder initializeInsertQuery() {
        SqlBuilder builder = new SqlBuilder(this.dialect);
        if (this.dialect == SqlDialect.DatabaseProduct.PHOENIX.getDialect()) {
            builder.append("UPSERT INTO ");
        } else {
            builder.append("INSERT INTO ");
        }
        JdbcDDLQueryUtils.addTableToInsertQuery(builder, this.rawTableName);
        builder.append(" VALUES ");
        return builder;
    }

    private String formatDateForInsertQuery(Long dateVal) {
        Date date = new Date(dateVal);
        SimpleDateFormat df2 = new SimpleDateFormat("yyyy-MM-dd");
        return df2.format(date);
    }

    private String formatTimeForInsertQuery(Integer millis) {
        return String.format("%02d:%02d:%02d", TimeUnit.MILLISECONDS.toHours(millis.intValue()), TimeUnit.MILLISECONDS.toMinutes(millis.intValue()) % TimeUnit.HOURS.toMinutes(1L), TimeUnit.MILLISECONDS.toSeconds(millis.intValue()) % TimeUnit.MINUTES.toSeconds(1L));
    }

    private String formatTimeStampForInsertQuery(Long time) {
        Date date = new Date(time);
        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        return format.format((Object)date);
    }

    public EventBasedRecordWriter.FieldConverter getNewNullableIntConverter(int fieldId, String fieldName, FieldReader reader) {
        return new NullableIntJDBCConverter(fieldId, fieldName, reader, this.fields);
    }

    public EventBasedRecordWriter.FieldConverter getNewIntConverter(int fieldId, String fieldName, FieldReader reader) {
        return new IntJDBCConverter(fieldId, fieldName, reader, this.fields);
    }

    public EventBasedRecordWriter.FieldConverter getNewNullableBigIntConverter(int fieldId, String fieldName, FieldReader reader) {
        return new NullableBigIntJDBCConverter(fieldId, fieldName, reader, this.fields);
    }

    public EventBasedRecordWriter.FieldConverter getNewBigIntConverter(int fieldId, String fieldName, FieldReader reader) {
        return new BigIntJDBCConverter(fieldId, fieldName, reader, this.fields);
    }

    public EventBasedRecordWriter.FieldConverter getNewNullableSmallIntConverter(int fieldId, String fieldName, FieldReader reader) {
        return new NullableSmallIntJDBCConverter(fieldId, fieldName, reader, this.fields);
    }

    public EventBasedRecordWriter.FieldConverter getNewSmallIntConverter(int fieldId, String fieldName, FieldReader reader) {
        return new SmallIntJDBCConverter(fieldId, fieldName, reader, this.fields);
    }

    public EventBasedRecordWriter.FieldConverter getNewNullableTinyIntConverter(int fieldId, String fieldName, FieldReader reader) {
        return new NullableTinyIntJDBCConverter(fieldId, fieldName, reader, this.fields);
    }

    public EventBasedRecordWriter.FieldConverter getNewTinyIntConverter(int fieldId, String fieldName, FieldReader reader) {
        return new TinyIntJDBCConverter(fieldId, fieldName, reader, this.fields);
    }

    public EventBasedRecordWriter.FieldConverter getNewNullableFloat4Converter(int fieldId, String fieldName, FieldReader reader) {
        return new NullableFloat4JDBCConverter(fieldId, fieldName, reader, this.fields);
    }

    public EventBasedRecordWriter.FieldConverter getNewFloat4Converter(int fieldId, String fieldName, FieldReader reader) {
        return new Float4JDBCConverter(fieldId, fieldName, reader, this.fields);
    }

    public EventBasedRecordWriter.FieldConverter getNewNullableFloat8Converter(int fieldId, String fieldName, FieldReader reader) {
        return new NullableFloat8JDBCConverter(fieldId, fieldName, reader, this.fields);
    }

    public EventBasedRecordWriter.FieldConverter getNewFloat8Converter(int fieldId, String fieldName, FieldReader reader) {
        return new Float8JDBCConverter(fieldId, fieldName, reader, this.fields);
    }

    public EventBasedRecordWriter.FieldConverter getNewNullableVarDecimalConverter(int fieldId, String fieldName, FieldReader reader) {
        return new NullableVardecimalJDBCConverter(fieldId, fieldName, reader, this.fields);
    }

    public EventBasedRecordWriter.FieldConverter getNewVarDecimalConverter(int fieldId, String fieldName, FieldReader reader) {
        return new VardecimalJDBCConverter(fieldId, fieldName, reader, this.fields);
    }

    public EventBasedRecordWriter.FieldConverter getNewNullableVarCharConverter(int fieldId, String fieldName, FieldReader reader) {
        return new NullableVarCharJDBCConverter(fieldId, fieldName, reader, this.fields);
    }

    public EventBasedRecordWriter.FieldConverter getNewVarCharConverter(int fieldId, String fieldName, FieldReader reader) {
        return new VarCharJDBCConverter(fieldId, fieldName, reader, this.fields);
    }

    public EventBasedRecordWriter.FieldConverter getNewNullableDateConverter(int fieldId, String fieldName, FieldReader reader) {
        return new NullableDateJDBCConverter(fieldId, fieldName, reader, this.fields);
    }

    public EventBasedRecordWriter.FieldConverter getNewDateConverter(int fieldId, String fieldName, FieldReader reader) {
        return new DateJDBCConverter(fieldId, fieldName, reader, this.fields);
    }

    public EventBasedRecordWriter.FieldConverter getNewNullableTimeConverter(int fieldId, String fieldName, FieldReader reader) {
        return new NullableTimeJDBCConverter(fieldId, fieldName, reader, this.fields);
    }

    public EventBasedRecordWriter.FieldConverter getNewTimeConverter(int fieldId, String fieldName, FieldReader reader) {
        return new TimeJDBCConverter(fieldId, fieldName, reader, this.fields);
    }

    public EventBasedRecordWriter.FieldConverter getNewNullableTimeStampConverter(int fieldId, String fieldName, FieldReader reader) {
        return new NullableTimeStampJDBCConverter(fieldId, fieldName, reader, this.fields);
    }

    public EventBasedRecordWriter.FieldConverter getNewTimeStampConverter(int fieldId, String fieldName, FieldReader reader) {
        return new TimeStampJDBCConverter(fieldId, fieldName, reader, this.fields);
    }

    public EventBasedRecordWriter.FieldConverter getNewNullableBitConverter(int fieldId, String fieldName, FieldReader reader) {
        return new NullableBitJDBCConverter(fieldId, fieldName, reader, this.fields);
    }

    public EventBasedRecordWriter.FieldConverter getNewBitConverter(int fieldId, String fieldName, FieldReader reader) {
        return new BitJDBCConverter(fieldId, fieldName, reader, this.fields);
    }

    public class BitJDBCConverter
    extends EventBasedRecordWriter.FieldConverter {
        private final BitHolder holder;

        public BitJDBCConverter(int fieldID, String fieldName, FieldReader reader, List<JdbcWriterField> fields) {
            super(fieldID, fieldName, reader);
            this.holder = new BitHolder();
            fields.add(new JdbcWriterField(fieldName, TypeProtos.MinorType.BIT, TypeProtos.DataMode.REQUIRED));
        }

        public void writeField() {
            this.reader.read(this.holder);
            String booleanValue = "false";
            if (this.holder.value == 1) {
                booleanValue = "true";
            }
            JdbcRecordWriter.this.rowList.add(booleanValue);
        }
    }

    public class NullableBitJDBCConverter
    extends EventBasedRecordWriter.FieldConverter {
        private final NullableBitHolder holder;

        public NullableBitJDBCConverter(int fieldID, String fieldName, FieldReader reader, List<JdbcWriterField> fields) {
            super(fieldID, fieldName, reader);
            this.holder = new NullableBitHolder();
            fields.add(new JdbcWriterField(fieldName, TypeProtos.MinorType.BIT, TypeProtos.DataMode.OPTIONAL));
        }

        public void writeField() {
            if (!this.reader.isSet()) {
                JdbcRecordWriter.this.rowList.add("null");
                return;
            }
            this.reader.read(this.holder);
            String booleanValue = "false";
            if (this.holder.value == 1) {
                booleanValue = "true";
            }
            JdbcRecordWriter.this.rowList.add(booleanValue);
        }
    }

    public class TimeStampJDBCConverter
    extends EventBasedRecordWriter.FieldConverter {
        private final TimeStampHolder holder;

        public TimeStampJDBCConverter(int fieldID, String fieldName, FieldReader reader, List<JdbcWriterField> fields) {
            super(fieldID, fieldName, reader);
            this.holder = new TimeStampHolder();
            fields.add(new JdbcWriterField(fieldName, TypeProtos.MinorType.TIMESTAMP, TypeProtos.DataMode.REQUIRED));
        }

        public void writeField() {
            this.reader.read(this.holder);
            JdbcRecordWriter.this.rowList.add(this.holder.value);
        }
    }

    public class NullableTimeStampJDBCConverter
    extends EventBasedRecordWriter.FieldConverter {
        private final NullableTimeStampHolder holder;

        public NullableTimeStampJDBCConverter(int fieldID, String fieldName, FieldReader reader, List<JdbcWriterField> fields) {
            super(fieldID, fieldName, reader);
            this.holder = new NullableTimeStampHolder();
            fields.add(new JdbcWriterField(fieldName, TypeProtos.MinorType.TIMESTAMP, TypeProtos.DataMode.OPTIONAL));
        }

        public void writeField() {
            if (!this.reader.isSet()) {
                JdbcRecordWriter.this.rowList.add("null");
                return;
            }
            this.reader.read(this.holder);
            JdbcRecordWriter.this.rowList.add(this.holder.value);
        }
    }

    public class TimeJDBCConverter
    extends EventBasedRecordWriter.FieldConverter {
        private final TimeHolder holder;

        public TimeJDBCConverter(int fieldID, String fieldName, FieldReader reader, List<JdbcWriterField> fields) {
            super(fieldID, fieldName, reader);
            this.holder = new TimeHolder();
            fields.add(new JdbcWriterField(fieldName, TypeProtos.MinorType.TIME, TypeProtos.DataMode.REQUIRED));
        }

        public void writeField() {
            this.reader.read(this.holder);
            JdbcRecordWriter.this.rowList.add(this.holder.value);
        }
    }

    public class NullableTimeJDBCConverter
    extends EventBasedRecordWriter.FieldConverter {
        private final NullableTimeHolder holder;

        public NullableTimeJDBCConverter(int fieldID, String fieldName, FieldReader reader, List<JdbcWriterField> fields) {
            super(fieldID, fieldName, reader);
            this.holder = new NullableTimeHolder();
            fields.add(new JdbcWriterField(fieldName, TypeProtos.MinorType.TIME, TypeProtos.DataMode.OPTIONAL));
        }

        public void writeField() {
            if (!this.reader.isSet()) {
                JdbcRecordWriter.this.rowList.add("null");
                return;
            }
            this.reader.read(this.holder);
            JdbcRecordWriter.this.rowList.add(this.holder.value);
        }
    }

    public class DateJDBCConverter
    extends EventBasedRecordWriter.FieldConverter {
        private final DateHolder holder;

        public DateJDBCConverter(int fieldID, String fieldName, FieldReader reader, List<JdbcWriterField> fields) {
            super(fieldID, fieldName, reader);
            this.holder = new DateHolder();
            fields.add(new JdbcWriterField(fieldName, TypeProtos.MinorType.DATE, TypeProtos.DataMode.REQUIRED));
        }

        public void writeField() {
            this.reader.read(this.holder);
            JdbcRecordWriter.this.rowList.add(this.holder.value);
        }
    }

    public class NullableDateJDBCConverter
    extends EventBasedRecordWriter.FieldConverter {
        private final NullableDateHolder holder;

        public NullableDateJDBCConverter(int fieldID, String fieldName, FieldReader reader, List<JdbcWriterField> fields) {
            super(fieldID, fieldName, reader);
            this.holder = new NullableDateHolder();
            fields.add(new JdbcWriterField(fieldName, TypeProtos.MinorType.DATE, TypeProtos.DataMode.OPTIONAL));
        }

        public void writeField() {
            if (!this.reader.isSet()) {
                JdbcRecordWriter.this.rowList.add("null");
                return;
            }
            this.reader.read(this.holder);
            JdbcRecordWriter.this.rowList.add(this.holder.value);
        }
    }

    public class VarCharJDBCConverter
    extends EventBasedRecordWriter.FieldConverter {
        private final VarCharHolder holder;

        public VarCharJDBCConverter(int fieldID, String fieldName, FieldReader reader, List<JdbcWriterField> fields) {
            super(fieldID, fieldName, reader);
            this.holder = new VarCharHolder();
            fields.add(new JdbcWriterField(fieldName, TypeProtos.MinorType.VARCHAR, TypeProtos.DataMode.REQUIRED));
        }

        public void writeField() {
            this.reader.read(this.holder);
            if (this.reader.isSet()) {
                byte[] bytes = new byte[this.holder.end - this.holder.start];
                this.holder.buffer.getBytes(this.holder.start, bytes);
                JdbcRecordWriter.this.rowList.add(this.holder);
            }
        }
    }

    public class NullableVarCharJDBCConverter
    extends EventBasedRecordWriter.FieldConverter {
        private final NullableVarCharHolder holder;

        public NullableVarCharJDBCConverter(int fieldID, String fieldName, FieldReader reader, List<JdbcWriterField> fields) {
            super(fieldID, fieldName, reader);
            this.holder = new NullableVarCharHolder();
            fields.add(new JdbcWriterField(fieldName, TypeProtos.MinorType.VARCHAR, TypeProtos.DataMode.OPTIONAL));
        }

        public void writeField() {
            this.reader.read(this.holder);
            if (this.reader.isSet()) {
                byte[] bytes = new byte[this.holder.end - this.holder.start];
                this.holder.buffer.getBytes(this.holder.start, bytes);
            }
            JdbcRecordWriter.this.rowList.add(this.holder);
        }
    }

    public class VardecimalJDBCConverter
    extends EventBasedRecordWriter.FieldConverter {
        private final VarDecimalHolder holder;

        public VardecimalJDBCConverter(int fieldID, String fieldName, FieldReader reader, List<JdbcWriterField> fields) {
            super(fieldID, fieldName, reader);
            this.holder = new VarDecimalHolder();
            fields.add(new JdbcWriterField(fieldName, TypeProtos.MinorType.VARDECIMAL, TypeProtos.DataMode.REQUIRED));
        }

        public void writeField() {
            this.reader.read(this.holder);
            BigDecimal value = DecimalUtility.getBigDecimalFromDrillBuf((DrillBuf)this.holder.buffer, (int)this.holder.start, (int)(this.holder.end - this.holder.start), (int)this.holder.scale);
            JdbcRecordWriter.this.rowList.add(value);
        }
    }

    public class NullableVardecimalJDBCConverter
    extends EventBasedRecordWriter.FieldConverter {
        private final NullableVarDecimalHolder holder;

        public NullableVardecimalJDBCConverter(int fieldID, String fieldName, FieldReader reader, List<JdbcWriterField> fields) {
            super(fieldID, fieldName, reader);
            this.holder = new NullableVarDecimalHolder();
            fields.add(new JdbcWriterField(fieldName, TypeProtos.MinorType.VARDECIMAL, TypeProtos.DataMode.OPTIONAL));
        }

        public void writeField() {
            if (!this.reader.isSet()) {
                JdbcRecordWriter.this.rowList.add("null");
                return;
            }
            this.reader.read(this.holder);
            BigDecimal value = DecimalUtility.getBigDecimalFromDrillBuf((DrillBuf)this.holder.buffer, (int)this.holder.start, (int)(this.holder.end - this.holder.start), (int)this.holder.scale);
            JdbcRecordWriter.this.rowList.add(value);
        }
    }

    public class Float8JDBCConverter
    extends EventBasedRecordWriter.FieldConverter {
        private final Float8Holder holder;

        public Float8JDBCConverter(int fieldID, String fieldName, FieldReader reader, List<JdbcWriterField> fields) {
            super(fieldID, fieldName, reader);
            this.holder = new Float8Holder();
            fields.add(new JdbcWriterField(fieldName, TypeProtos.MinorType.FLOAT8, TypeProtos.DataMode.REQUIRED));
        }

        public void writeField() {
            this.reader.read(this.holder);
            JdbcRecordWriter.this.rowList.add(this.holder.value);
        }
    }

    public class NullableFloat8JDBCConverter
    extends EventBasedRecordWriter.FieldConverter {
        private final NullableFloat8Holder holder;

        public NullableFloat8JDBCConverter(int fieldID, String fieldName, FieldReader reader, List<JdbcWriterField> fields) {
            super(fieldID, fieldName, reader);
            this.holder = new NullableFloat8Holder();
            fields.add(new JdbcWriterField(fieldName, TypeProtos.MinorType.FLOAT8, TypeProtos.DataMode.OPTIONAL));
        }

        public void writeField() {
            if (!this.reader.isSet()) {
                JdbcRecordWriter.this.rowList.add("null");
                return;
            }
            this.reader.read(this.holder);
            JdbcRecordWriter.this.rowList.add(this.holder.value);
        }
    }

    public class Float4JDBCConverter
    extends EventBasedRecordWriter.FieldConverter {
        private final Float4Holder holder;

        public Float4JDBCConverter(int fieldID, String fieldName, FieldReader reader, List<JdbcWriterField> fields) {
            super(fieldID, fieldName, reader);
            this.holder = new Float4Holder();
            fields.add(new JdbcWriterField(fieldName, TypeProtos.MinorType.FLOAT4, TypeProtos.DataMode.REQUIRED));
        }

        public void writeField() {
            this.reader.read(this.holder);
            JdbcRecordWriter.this.rowList.add(Float.valueOf(this.holder.value));
        }
    }

    public class NullableFloat4JDBCConverter
    extends EventBasedRecordWriter.FieldConverter {
        private final NullableFloat4Holder holder;

        public NullableFloat4JDBCConverter(int fieldID, String fieldName, FieldReader reader, List<JdbcWriterField> fields) {
            super(fieldID, fieldName, reader);
            this.holder = new NullableFloat4Holder();
            fields.add(new JdbcWriterField(fieldName, TypeProtos.MinorType.FLOAT4, TypeProtos.DataMode.OPTIONAL));
        }

        public void writeField() {
            if (!this.reader.isSet()) {
                JdbcRecordWriter.this.rowList.add("null");
                return;
            }
            this.reader.read(this.holder);
            JdbcRecordWriter.this.rowList.add(Float.valueOf(this.holder.value));
        }
    }

    public class TinyIntJDBCConverter
    extends EventBasedRecordWriter.FieldConverter {
        private final TinyIntHolder holder;

        public TinyIntJDBCConverter(int fieldID, String fieldName, FieldReader reader, List<JdbcWriterField> fields) {
            super(fieldID, fieldName, reader);
            this.holder = new TinyIntHolder();
            fields.add(new JdbcWriterField(fieldName, TypeProtos.MinorType.TINYINT, TypeProtos.DataMode.REQUIRED));
        }

        public void writeField() {
            this.reader.read(this.holder);
            JdbcRecordWriter.this.rowList.add(this.holder.value);
        }
    }

    public class NullableTinyIntJDBCConverter
    extends EventBasedRecordWriter.FieldConverter {
        private final NullableTinyIntHolder holder;

        public NullableTinyIntJDBCConverter(int fieldID, String fieldName, FieldReader reader, List<JdbcWriterField> fields) {
            super(fieldID, fieldName, reader);
            this.holder = new NullableTinyIntHolder();
            fields.add(new JdbcWriterField(fieldName, TypeProtos.MinorType.TINYINT, TypeProtos.DataMode.OPTIONAL));
        }

        public void writeField() {
            if (!this.reader.isSet()) {
                JdbcRecordWriter.this.rowList.add("null");
                return;
            }
            this.reader.read(this.holder);
            JdbcRecordWriter.this.rowList.add(this.holder.value);
        }
    }

    public class SmallIntJDBCConverter
    extends EventBasedRecordWriter.FieldConverter {
        private final SmallIntHolder holder;

        public SmallIntJDBCConverter(int fieldID, String fieldName, FieldReader reader, List<JdbcWriterField> fields) {
            super(fieldID, fieldName, reader);
            this.holder = new SmallIntHolder();
            fields.add(new JdbcWriterField(fieldName, TypeProtos.MinorType.SMALLINT, TypeProtos.DataMode.REQUIRED));
        }

        public void writeField() {
            this.reader.read(this.holder);
            JdbcRecordWriter.this.rowList.add(this.holder.value);
        }
    }

    public class NullableSmallIntJDBCConverter
    extends EventBasedRecordWriter.FieldConverter {
        private final NullableSmallIntHolder holder;

        public NullableSmallIntJDBCConverter(int fieldID, String fieldName, FieldReader reader, List<JdbcWriterField> fields) {
            super(fieldID, fieldName, reader);
            this.holder = new NullableSmallIntHolder();
            fields.add(new JdbcWriterField(fieldName, TypeProtos.MinorType.SMALLINT, TypeProtos.DataMode.OPTIONAL));
        }

        public void writeField() {
            if (!this.reader.isSet()) {
                JdbcRecordWriter.this.rowList.add("null");
                return;
            }
            this.reader.read(this.holder);
            JdbcRecordWriter.this.rowList.add(this.holder.value);
        }
    }

    public class BigIntJDBCConverter
    extends EventBasedRecordWriter.FieldConverter {
        private final BigIntHolder holder;

        public BigIntJDBCConverter(int fieldID, String fieldName, FieldReader reader, List<JdbcWriterField> fields) {
            super(fieldID, fieldName, reader);
            this.holder = new BigIntHolder();
            fields.add(new JdbcWriterField(fieldName, TypeProtos.MinorType.BIGINT, TypeProtos.DataMode.REQUIRED));
        }

        public void writeField() {
            if (!this.reader.isSet()) {
                JdbcRecordWriter.this.rowList.add("null");
                return;
            }
            this.reader.read(this.holder);
            JdbcRecordWriter.this.rowList.add(this.holder.value);
        }
    }

    public class NullableBigIntJDBCConverter
    extends EventBasedRecordWriter.FieldConverter {
        private final NullableBigIntHolder holder;

        public NullableBigIntJDBCConverter(int fieldID, String fieldName, FieldReader reader, List<JdbcWriterField> fields) {
            super(fieldID, fieldName, reader);
            this.holder = new NullableBigIntHolder();
            fields.add(new JdbcWriterField(fieldName, TypeProtos.MinorType.BIGINT, TypeProtos.DataMode.OPTIONAL));
        }

        public void writeField() {
            if (!this.reader.isSet()) {
                JdbcRecordWriter.this.rowList.add("null");
                return;
            }
            this.reader.read(this.holder);
            JdbcRecordWriter.this.rowList.add(this.holder.value);
        }
    }

    public class IntJDBCConverter
    extends EventBasedRecordWriter.FieldConverter {
        private final IntHolder holder;

        public IntJDBCConverter(int fieldID, String fieldName, FieldReader reader, List<JdbcWriterField> fields) {
            super(fieldID, fieldName, reader);
            this.holder = new IntHolder();
            fields.add(new JdbcWriterField(fieldName, TypeProtos.MinorType.INT, TypeProtos.DataMode.REQUIRED));
        }

        public void writeField() {
            this.reader.read(this.holder);
            JdbcRecordWriter.this.rowList.add(this.holder.value);
        }
    }

    public class NullableIntJDBCConverter
    extends EventBasedRecordWriter.FieldConverter {
        private final NullableIntHolder holder;

        public NullableIntJDBCConverter(int fieldID, String fieldName, FieldReader reader, List<JdbcWriterField> fields) {
            super(fieldID, fieldName, reader);
            this.holder = new NullableIntHolder();
            fields.add(new JdbcWriterField(fieldName, TypeProtos.MinorType.INT, TypeProtos.DataMode.OPTIONAL));
        }

        public void writeField() {
            if (!this.reader.isSet()) {
                JdbcRecordWriter.this.rowList.add("null");
                return;
            }
            this.reader.read(this.holder);
            JdbcRecordWriter.this.rowList.add(this.holder.value);
        }
    }
}

