/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.store.jdbc;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeName;
import org.apache.drill.common.logical.StoragePluginConfig;

@JsonTypeName(value="jdbc")
@JsonFilter(value="passwordFilter")
public class JdbcStorageConfig
extends StoragePluginConfig {
    public static final String NAME = "jdbc";
    private final String driver;
    private final String url;
    private final String username;
    private final String password;
    private final boolean caseInsensitiveTableNames;

    @JsonCreator
    public JdbcStorageConfig(@JsonProperty(value="driver") String driver, @JsonProperty(value="url") String url, @JsonProperty(value="username") String username, @JsonProperty(value="password") String password, @JsonProperty(value="caseInsensitiveTableNames") boolean caseInsensitiveTableNames) {
        this.driver = driver;
        this.url = url;
        this.username = username;
        this.password = password;
        this.caseInsensitiveTableNames = caseInsensitiveTableNames;
    }

    public String getDriver() {
        return this.driver;
    }

    public String getUrl() {
        return this.url;
    }

    public String getUsername() {
        return this.username;
    }

    public String getPassword() {
        return this.password;
    }

    @JsonProperty(value="caseInsensitiveTableNames")
    public boolean areTableNamesCaseInsensitive() {
        return this.caseInsensitiveTableNames;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.driver == null ? 0 : this.driver.hashCode());
        result = 31 * result + (this.password == null ? 0 : this.password.hashCode());
        result = 31 * result + (this.url == null ? 0 : this.url.hashCode());
        result = 31 * result + (this.username == null ? 0 : this.username.hashCode());
        result = 31 * result + (this.caseInsensitiveTableNames ? 1231 : 1237);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (((Object)((Object)this)).getClass() != obj.getClass()) {
            return false;
        }
        JdbcStorageConfig other = (JdbcStorageConfig)((Object)obj);
        if (this.caseInsensitiveTableNames != other.caseInsensitiveTableNames) {
            return false;
        }
        if (this.driver == null ? other.driver != null : !this.driver.equals(other.driver)) {
            return false;
        }
        if (this.password == null ? other.password != null : !this.password.equals(other.password)) {
            return false;
        }
        if (this.url == null ? other.url != null : !this.url.equals(other.url)) {
            return false;
        }
        return !(this.username == null ? other.username != null : !this.username.equals(other.username));
    }
}

