/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.store.jdbc;

import java.util.Collections;
import java.util.List;
import org.apache.drill.common.exceptions.ExecutionSetupException;
import org.apache.drill.exec.ops.ExecutorFragmentContext;
import org.apache.drill.exec.ops.FragmentContext;
import org.apache.drill.exec.physical.base.PhysicalOperator;
import org.apache.drill.exec.physical.impl.BatchCreator;
import org.apache.drill.exec.physical.impl.ScanBatch;
import org.apache.drill.exec.record.RecordBatch;
import org.apache.drill.exec.store.jdbc.JdbcRecordReader;
import org.apache.drill.exec.store.jdbc.JdbcStoragePlugin;
import org.apache.drill.exec.store.jdbc.JdbcSubScan;
import org.apache.drill.shaded.guava.com.google.common.base.Preconditions;

public class JdbcBatchCreator
implements BatchCreator<JdbcSubScan> {
    public ScanBatch getBatch(ExecutorFragmentContext context, JdbcSubScan config, List<RecordBatch> children) throws ExecutionSetupException {
        Preconditions.checkArgument((boolean)children.isEmpty());
        JdbcStoragePlugin plugin = config.getPlugin();
        JdbcRecordReader reader = new JdbcRecordReader(plugin.getSource(), config.getSql(), plugin.getName(), config.getColumns());
        return new ScanBatch((PhysicalOperator)config, (FragmentContext)context, Collections.singletonList(reader));
    }
}

