/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.store.iceberg;

import java.io.IOException;
import java.math.BigDecimal;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.nio.file.Paths;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.ZoneId;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import org.apache.drill.common.exceptions.UserRemoteException;
import org.apache.drill.common.logical.StoragePluginConfig;
import org.apache.drill.common.logical.security.PlainCredentialsProvider;
import org.apache.drill.exec.physical.rowSet.DirectRowSet;
import org.apache.drill.exec.physical.rowSet.RowSetReader;
import org.apache.drill.exec.store.StoragePluginRegistry;
import org.apache.drill.exec.store.dfs.FileSystemConfig;
import org.apache.drill.exec.store.iceberg.format.IcebergFormatPluginConfig;
import org.apache.drill.exec.util.JsonStringHashMap;
import org.apache.drill.exec.util.Text;
import org.apache.drill.test.BaseDirTestWatcher;
import org.apache.drill.test.ClusterFixture;
import org.apache.drill.test.ClusterFixtureBuilder;
import org.apache.drill.test.ClusterTest;
import org.apache.drill.test.TestBuilder;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.iceberg.DataFile;
import org.apache.iceberg.DataFiles;
import org.apache.iceberg.FileFormat;
import org.apache.iceberg.HistoryEntry;
import org.apache.iceberg.PartitionSpec;
import org.apache.iceberg.Schema;
import org.apache.iceberg.Snapshot;
import org.apache.iceberg.Table;
import org.apache.iceberg.Transaction;
import org.apache.iceberg.data.GenericAppenderFactory;
import org.apache.iceberg.data.GenericRecord;
import org.apache.iceberg.data.Record;
import org.apache.iceberg.hadoop.HadoopTables;
import org.apache.iceberg.io.FileAppender;
import org.apache.iceberg.io.OutputFile;
import org.apache.iceberg.types.Type;
import org.apache.iceberg.types.Types;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;

public class IcebergQueriesTest
extends ClusterTest {
    private static Table table;

    @BeforeClass
    public static void setUpBeforeClass() throws Exception {
        IcebergQueriesTest.startCluster((ClusterFixtureBuilder)ClusterFixture.builder((BaseDirTestWatcher)dirTestWatcher));
        StoragePluginRegistry pluginRegistry = cluster.drillbit().getContext().getStorage();
        FileSystemConfig pluginConfig = (FileSystemConfig)pluginRegistry.getPlugin("dfs").getConfig();
        HashMap<String, IcebergFormatPluginConfig> formats = new HashMap<String, IcebergFormatPluginConfig>(pluginConfig.getFormats());
        formats.put("iceberg", IcebergFormatPluginConfig.builder().build());
        FileSystemConfig newPluginConfig = new FileSystemConfig(pluginConfig.getConnection(), pluginConfig.getConfig(), pluginConfig.getWorkspaces(), formats, null, PlainCredentialsProvider.EMPTY_CREDENTIALS_PROVIDER);
        newPluginConfig.setEnabled(Boolean.valueOf(pluginConfig.isEnabled()));
        pluginRegistry.put("dfs", (StoragePluginConfig)newPluginConfig);
        FileSystemConfig anotherFileSystemConfig = pluginConfig.copyWithFormats(formats);
        pluginRegistry.put("dfs2", (StoragePluginConfig)anotherFileSystemConfig);
        Configuration config = new Configuration();
        config.set("fs.defaultFS", "file:///");
        HadoopTables tables = new HadoopTables(config);
        Schema structSchema = new Schema(new Types.NestedField[]{Types.NestedField.optional((int)13, (String)"struct_int_field", (Type)Types.IntegerType.get()), Types.NestedField.optional((int)14, (String)"struct_string_field", (Type)Types.StringType.get())});
        Types.ListType repeatedStructType = Types.ListType.ofOptional((int)16, (Type)Types.StructType.of((Types.NestedField[])new Types.NestedField[]{Types.NestedField.optional((int)17, (String)"struct_int_field", (Type)Types.IntegerType.get()), Types.NestedField.optional((int)18, (String)"struct_string_field", (Type)Types.StringType.get())}));
        Schema schema = new Schema(new Types.NestedField[]{Types.NestedField.optional((int)1, (String)"int_field", (Type)Types.IntegerType.get()), Types.NestedField.optional((int)2, (String)"long_field", (Type)Types.LongType.get()), Types.NestedField.optional((int)3, (String)"float_field", (Type)Types.FloatType.get()), Types.NestedField.optional((int)4, (String)"double_field", (Type)Types.DoubleType.get()), Types.NestedField.optional((int)5, (String)"string_field", (Type)Types.StringType.get()), Types.NestedField.optional((int)6, (String)"boolean_field", (Type)Types.BooleanType.get()), Types.NestedField.optional((int)26, (String)"time_field", (Type)Types.TimeType.get()), Types.NestedField.optional((int)27, (String)"timestamp_field", (Type)Types.TimestampType.withoutZone()), Types.NestedField.optional((int)28, (String)"date_field", (Type)Types.DateType.get()), Types.NestedField.optional((int)29, (String)"decimal_field", (Type)Types.DecimalType.of((int)4, (int)2)), Types.NestedField.optional((int)30, (String)"uuid_field", (Type)Types.UUIDType.get()), Types.NestedField.optional((int)31, (String)"fixed_field", (Type)Types.FixedType.ofLength((int)10)), Types.NestedField.optional((int)32, (String)"binary_field", (Type)Types.BinaryType.get()), Types.NestedField.optional((int)7, (String)"list_field", (Type)Types.ListType.ofOptional((int)10, (Type)Types.StringType.get())), Types.NestedField.optional((int)8, (String)"map_field", (Type)Types.MapType.ofOptional((int)11, (int)12, (Type)Types.StringType.get(), (Type)Types.FloatType.get())), Types.NestedField.required((int)9, (String)"struct_field", (Type)structSchema.asStruct()), Types.NestedField.required((int)15, (String)"repeated_struct_field", (Type)repeatedStructType), Types.NestedField.required((int)19, (String)"repeated_list_field", (Type)Types.ListType.ofOptional((int)20, (Type)Types.ListType.ofOptional((int)21, (Type)Types.StringType.get()))), Types.NestedField.optional((int)22, (String)"repeated_map_field", (Type)Types.ListType.ofOptional((int)23, (Type)Types.MapType.ofOptional((int)24, (int)25, (Type)Types.StringType.get(), (Type)Types.FloatType.get())))});
        List<String> listValue = Arrays.asList("a", "b", "c");
        HashMap<String, Float> mapValue = new HashMap<String, Float>();
        mapValue.put("a", Float.valueOf(0.1f));
        mapValue.put("b", Float.valueOf(0.2f));
        HashMap<String, Float> secondMapValue = new HashMap<String, Float>();
        secondMapValue.put("true", Float.valueOf(1.0f));
        secondMapValue.put("false", Float.valueOf(0.0f));
        GenericRecord structValue = GenericRecord.create((Schema)structSchema);
        structValue.setField("struct_int_field", (Object)123);
        structValue.setField("struct_string_field", (Object)"abc");
        GenericRecord secondStructValue = GenericRecord.create((Schema)structSchema);
        secondStructValue.setField("struct_int_field", (Object)321);
        secondStructValue.setField("struct_string_field", (Object)"def");
        GenericRecord record = GenericRecord.create((Schema)schema);
        record.setField("int_field", (Object)1);
        record.setField("long_field", (Object)100L);
        record.setField("float_field", (Object)Float.valueOf(0.5f));
        record.setField("double_field", (Object)1.5);
        record.setField("string_field", (Object)"abc");
        record.setField("boolean_field", (Object)true);
        record.setField("time_field", (Object)LocalTime.of(2, 42, 42));
        record.setField("timestamp_field", (Object)LocalDateTime.of(1994, 4, 18, 11, 0, 0));
        record.setField("date_field", (Object)LocalDate.of(1994, 4, 18));
        record.setField("decimal_field", (Object)new BigDecimal("12.34"));
        record.setField("uuid_field", (Object)new byte[16]);
        record.setField("fixed_field", (Object)new byte[10]);
        record.setField("binary_field", (Object)ByteBuffer.wrap("hello".getBytes(StandardCharsets.UTF_8)));
        record.setField("list_field", listValue);
        record.setField("map_field", mapValue);
        record.setField("struct_field", (Object)structValue);
        record.setField("repeated_struct_field", Arrays.asList(structValue, structValue));
        record.setField("repeated_list_field", Arrays.asList(listValue, listValue));
        record.setField("repeated_map_field", Arrays.asList(mapValue, mapValue));
        GenericRecord nullsRecord = GenericRecord.create((Schema)schema);
        nullsRecord.setField("int_field", null);
        nullsRecord.setField("long_field", null);
        nullsRecord.setField("float_field", null);
        nullsRecord.setField("double_field", null);
        nullsRecord.setField("string_field", null);
        nullsRecord.setField("boolean_field", null);
        nullsRecord.setField("time_field", null);
        nullsRecord.setField("timestamp_field", null);
        nullsRecord.setField("date_field", null);
        nullsRecord.setField("decimal_field", null);
        nullsRecord.setField("uuid_field", null);
        nullsRecord.setField("fixed_field", null);
        nullsRecord.setField("binary_field", null);
        nullsRecord.setField("list_field", null);
        nullsRecord.setField("map_field", null);
        nullsRecord.setField("struct_field", (Object)GenericRecord.create((Schema)structSchema));
        nullsRecord.setField("repeated_struct_field", Collections.emptyList());
        nullsRecord.setField("repeated_list_field", Collections.emptyList());
        nullsRecord.setField("repeated_map_field", Collections.emptyList());
        GenericRecord secondRecord = GenericRecord.create((Schema)schema);
        secondRecord.setField("int_field", (Object)988);
        secondRecord.setField("long_field", (Object)543L);
        secondRecord.setField("float_field", (Object)Float.valueOf(Float.NaN));
        secondRecord.setField("double_field", (Object)Double.MAX_VALUE);
        secondRecord.setField("string_field", (Object)"def");
        secondRecord.setField("boolean_field", (Object)false);
        secondRecord.setField("time_field", (Object)LocalTime.of(3, 41, 53));
        secondRecord.setField("timestamp_field", (Object)LocalDateTime.of(1995, 9, 10, 9, 0, 0));
        secondRecord.setField("date_field", (Object)LocalDate.of(1995, 9, 10));
        secondRecord.setField("decimal_field", (Object)new BigDecimal("99.99"));
        secondRecord.setField("uuid_field", (Object)new byte[16]);
        secondRecord.setField("fixed_field", (Object)new byte[10]);
        secondRecord.setField("binary_field", (Object)ByteBuffer.wrap("world".getBytes(StandardCharsets.UTF_8)));
        secondRecord.setField("list_field", Arrays.asList("y", "n"));
        secondRecord.setField("map_field", secondMapValue);
        secondRecord.setField("struct_field", (Object)secondStructValue);
        secondRecord.setField("repeated_struct_field", Arrays.asList(structValue, secondStructValue));
        secondRecord.setField("repeated_list_field", Arrays.asList(listValue, Arrays.asList("y", "n")));
        secondRecord.setField("repeated_map_field", Arrays.asList(mapValue, secondMapValue));
        String location = Paths.get(dirTestWatcher.getDfsTestTmpDir().toURI().getPath(), "testAllTypes").toUri().getPath();
        table = tables.create(schema, location);
        IcebergQueriesTest.writeParquetAndCommitDataFile(table, "allTypes", Arrays.asList(record, nullsRecord));
        IcebergQueriesTest.writeParquetAndCommitDataFile(table, "allTypes_1", Collections.singleton(secondRecord));
        String avroLocation = Paths.get(dirTestWatcher.getDfsTestTmpDir().toURI().getPath(), "testAllTypesAvro").toUri().getPath();
        IcebergQueriesTest.writeAndCommitDataFile(tables.create(structSchema, avroLocation), "allTypes", FileFormat.AVRO, Arrays.asList(structValue, GenericRecord.create((Schema)structSchema), secondStructValue));
        String orcLocation = Paths.get(dirTestWatcher.getDfsTestTmpDir().toURI().getPath(), "testAllTypesOrc").toUri().getPath();
        IcebergQueriesTest.writeAndCommitDataFile(tables.create(structSchema, orcLocation), "allTypes", FileFormat.ORC, Arrays.asList(structValue, GenericRecord.create((Schema)structSchema), secondStructValue));
        String emptyTableLocation = Paths.get(dirTestWatcher.getDfsTestTmpDir().toURI().getPath(), "testAllTypesEmpty").toUri().getPath();
        tables.create(structSchema, emptyTableLocation);
    }

    private static void writeParquetAndCommitDataFile(Table table, String name, Iterable<Record> records) throws IOException {
        IcebergQueriesTest.writeAndCommitDataFile(table, name, FileFormat.PARQUET, records);
    }

    private static void writeAndCommitDataFile(Table table, String name, FileFormat fileFormat, Iterable<Record> records) throws IOException {
        OutputFile outputFile = table.io().newOutputFile(new Path(table.location(), fileFormat.addExtension(name)).toUri().getPath());
        FileAppender fileAppender = new GenericAppenderFactory(table.schema()).newAppender(outputFile, fileFormat);
        fileAppender.addAll(records);
        fileAppender.close();
        DataFile dataFile = DataFiles.builder((PartitionSpec)table.spec()).withInputFile(outputFile.toInputFile()).withMetrics(fileAppender.metrics()).build();
        Transaction transaction = table.newTransaction();
        transaction.newAppend().appendFile(dataFile).commit();
        transaction.commitTransaction();
    }

    @Test
    public void testSerDe() throws Exception {
        String plan = this.queryBuilder().sql("select * from dfs.tmp.testAllTypes").explainJson();
        long count = this.queryBuilder().physical(plan).run().recordCount();
        Assert.assertEquals((long)3L, (long)count);
    }

    @Test
    public void testSelectWithSnapshotId() throws Exception {
        String snapshotQuery = "select snapshot_id from dfs.tmp.`testAllTypes#snapshots` order by committed_at limit 1";
        String query = "select * from table(dfs.tmp.testAllTypes(type => 'iceberg', snapshotId => %s))";
        long snapshotId = this.queryBuilder().sql(snapshotQuery).singletonLong();
        String plan = this.queryBuilder().sql(query, new Object[]{snapshotId}).explainJson();
        long count = this.queryBuilder().physical(plan).run().recordCount();
        Assert.assertEquals((long)2L, (long)count);
    }

    @Test
    public void testSelectWithSnapshotAsOfTime() throws Exception {
        String snapshotQuery = "select committed_at from dfs.tmp.`testAllTypes#snapshots` order by committed_at limit 1";
        String query = "select * from table(dfs.tmp.testAllTypes(type => 'iceberg', snapshotAsOfTime => %s))";
        long snapshotId = this.queryBuilder().sql(snapshotQuery).singletonLong();
        String plan = this.queryBuilder().sql(query, new Object[]{snapshotId}).explainJson();
        long count = this.queryBuilder().physical(plan).run().recordCount();
        Assert.assertEquals((long)2L, (long)count);
    }

    @Test
    public void testSelectFromSnapshotId() throws Exception {
        String snapshotQuery = "select snapshot_id from dfs.tmp.`testAllTypes#snapshots` order by committed_at limit 1";
        String query = "select * from table(dfs.tmp.testAllTypes(type => 'iceberg', fromSnapshotId => %s))";
        long snapshotId = this.queryBuilder().sql(snapshotQuery).singletonLong();
        String plan = this.queryBuilder().sql(query, new Object[]{snapshotId}).explainJson();
        long count = this.queryBuilder().physical(plan).run().recordCount();
        Assert.assertEquals((long)1L, (long)count);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testSelectFromSnapshotIdAndToSnapshotId() throws Exception {
        String snapshotQuery = "select snapshot_id from dfs.tmp.`testAllTypes#snapshots` order by committed_at";
        String query = "select * from table(dfs.tmp.testAllTypes(type => 'iceberg', fromSnapshotId => %s, toSnapshotId => %s))";
        DirectRowSet rowSet = this.queryBuilder().sql(snapshotQuery).rowSet();
        try {
            RowSetReader reader = rowSet.reader();
            Assert.assertTrue((boolean)reader.next());
            Long fromSnapshotId = (Long)reader.column(0).reader().getObject();
            Assert.assertTrue((boolean)reader.next());
            Long toSnapshotId = (Long)reader.column(0).reader().getObject();
            String plan = this.queryBuilder().sql(query, new Object[]{fromSnapshotId, toSnapshotId}).explainJson();
            long count = this.queryBuilder().physical(plan).run().recordCount();
            Assert.assertEquals((long)1L, (long)count);
        }
        finally {
            rowSet.clear();
        }
    }

    @Test
    public void testSelectWithSnapshotIdAndSnapshotAsOfTime() throws Exception {
        String query = "select * from table(dfs.tmp.testAllTypes(type => 'iceberg', snapshotId => %s, snapshotAsOfTime => %s))";
        try {
            this.queryBuilder().sql(query, new Object[]{123, 456}).run();
            Assert.fail();
        }
        catch (UserRemoteException e) {
            MatcherAssert.assertThat((Object)e.getVerboseMessage(), (Matcher)CoreMatchers.containsString((String)"Both 'snapshotId' and 'snapshotAsOfTime' cannot be specified"));
        }
    }

    @Test
    public void testAllTypes() throws Exception {
        this.testBuilder().sqlQuery("select * from dfs.tmp.testAllTypes").unOrdered().baselineColumns(new String[]{"int_field", "long_field", "float_field", "double_field", "string_field", "boolean_field", "time_field", "timestamp_field", "date_field", "decimal_field", "uuid_field", "fixed_field", "binary_field", "list_field", "map_field", "struct_field", "repeated_struct_field", "repeated_list_field", "repeated_map_field"}).baselineValues(new Object[]{1, 100L, Float.valueOf(0.5f), 1.5, "abc", true, LocalTime.of(2, 42, 42), LocalDateTime.of(1994, 4, 18, 11, 0, 0), LocalDate.of(1994, 4, 18), new BigDecimal("12.34"), new byte[16], new byte[10], "hello".getBytes(StandardCharsets.UTF_8), TestBuilder.listOf((Object[])new Object[]{"a", "b", "c"}), TestBuilder.mapOfObject((Object[])new Object[]{new Text("a"), Float.valueOf(0.1f), new Text("b"), Float.valueOf(0.2f)}), TestBuilder.mapOf((Object[])new Object[]{"struct_int_field", 123, "struct_string_field", "abc"}), TestBuilder.listOf((Object[])new Object[]{TestBuilder.mapOf((Object[])new Object[]{"struct_int_field", 123, "struct_string_field", "abc"}), TestBuilder.mapOf((Object[])new Object[]{"struct_int_field", 123, "struct_string_field", "abc"})}), TestBuilder.listOf((Object[])new Object[]{TestBuilder.listOf((Object[])new Object[]{"a", "b", "c"}), TestBuilder.listOf((Object[])new Object[]{"a", "b", "c"})}), TestBuilder.listOf((Object[])new Object[]{TestBuilder.mapOfObject((Object[])new Object[]{new Text("a"), Float.valueOf(0.1f), new Text("b"), Float.valueOf(0.2f)}), TestBuilder.mapOfObject((Object[])new Object[]{new Text("a"), Float.valueOf(0.1f), new Text("b"), Float.valueOf(0.2f)})})}).baselineValues(new Object[]{null, null, null, null, null, null, null, null, null, null, null, null, null, TestBuilder.listOf((Object[])new Object[0]), TestBuilder.mapOfObject((Object[])new Object[0]), TestBuilder.mapOf((Object[])new Object[0]), TestBuilder.listOf((Object[])new Object[0]), TestBuilder.listOf((Object[])new Object[0]), TestBuilder.listOf((Object[])new Object[0])}).baselineValues(new Object[]{988, 543L, Float.valueOf(Float.NaN), Double.MAX_VALUE, "def", false, LocalTime.of(3, 41, 53), LocalDateTime.of(1995, 9, 10, 9, 0, 0), LocalDate.of(1995, 9, 10), new BigDecimal("99.99"), new byte[16], new byte[10], "world".getBytes(StandardCharsets.UTF_8), TestBuilder.listOf((Object[])new Object[]{"y", "n"}), TestBuilder.mapOfObject((Object[])new Object[]{new Text("true"), Float.valueOf(1.0f), new Text("false"), Float.valueOf(0.0f)}), TestBuilder.mapOf((Object[])new Object[]{"struct_int_field", 321, "struct_string_field", "def"}), TestBuilder.listOf((Object[])new Object[]{TestBuilder.mapOf((Object[])new Object[]{"struct_int_field", 123, "struct_string_field", "abc"}), TestBuilder.mapOf((Object[])new Object[]{"struct_int_field", 321, "struct_string_field", "def"})}), TestBuilder.listOf((Object[])new Object[]{TestBuilder.listOf((Object[])new Object[]{"a", "b", "c"}), TestBuilder.listOf((Object[])new Object[]{"y", "n"})}), TestBuilder.listOf((Object[])new Object[]{TestBuilder.mapOfObject((Object[])new Object[]{new Text("a"), Float.valueOf(0.1f), new Text("b"), Float.valueOf(0.2f)}), TestBuilder.mapOfObject((Object[])new Object[]{new Text("true"), Float.valueOf(1.0f), new Text("false"), Float.valueOf(0.0f)})})}).go();
    }

    @Test
    public void testProjectingColumns() throws Exception {
        String query = "select int_field, string_field from dfs.tmp.testAllTypes";
        this.queryBuilder().sql(query).planMatcher().include(new String[]{"projection\\=struct<1: int_field: optional int, 5: string_field: optional string>"}).match();
        this.testBuilder().sqlQuery(query).unOrdered().baselineColumns(new String[]{"int_field", "string_field"}).baselineValues(new Object[]{1, "abc"}).baselineValues(new Object[]{null, null}).baselineValues(new Object[]{988, "def"}).go();
    }

    @Test
    public void testProjectNestedColumn() throws Exception {
        String query = "select t.struct_field.struct_int_field as i, list_field[1] as l,t.repeated_struct_field[0].struct_string_field s from dfs.tmp.testAllTypes t";
        this.queryBuilder().sql(query).planMatcher().include(new String[]{"projection\\=struct<14: list_field: optional list<string>, 16: struct_field: required struct<23: struct_int_field: optional int>, 17: repeated_struct_field: required list<struct<27: struct_string_field: optional string>>"}).match();
        this.testBuilder().sqlQuery(query).unOrdered().baselineColumns(new String[]{"i", "l", "s"}).baselineValues(new Object[]{123, "b", "abc"}).baselineValues(new Object[]{null, null, null}).baselineValues(new Object[]{321, "n", "abc"}).go();
    }

    @Test
    public void testFilterPushdown() throws Exception {
        String query = "select int_field, string_field from dfs.tmp.testAllTypes where long_field = 100";
        this.queryBuilder().sql(query).planMatcher().include(new String[]{"filter\\=ref\\(name\\=\"long_field\"\\) \\=\\= 100"}).include(new String[]{"projection\\=struct<1: int_field: optional int, 2: long_field: optional long, 5: string_field: optional string>"}).match();
        this.testBuilder().sqlQuery(query).ordered().baselineColumns(new String[]{"int_field", "string_field"}).baselineValues(new Object[]{1, "abc"}).go();
    }

    @Test
    public void testEmptyResults() throws Exception {
        String query = "select int_field, string_field from dfs.tmp.testAllTypes where long_field = 101";
        this.queryBuilder().sql(query).planMatcher().include(new String[]{"filter\\=ref\\(name\\=\"long_field\"\\) \\=\\= 101"}).include(new String[]{"projection\\=struct<1: int_field: optional int, 2: long_field: optional long, 5: string_field: optional string>"}).match();
        this.testBuilder().sqlQuery(query).ordered().expectsEmptyResultSet().go();
    }

    @Test
    public void testFilterWithDifferentTypes() throws Exception {
        String query = "select int_field, string_field from dfs.tmp.testAllTypes where long_field = '100'";
        this.testBuilder().sqlQuery(query).ordered().baselineColumns(new String[]{"int_field", "string_field"}).baselineValues(new Object[]{1, "abc"}).go();
    }

    @Test
    public void testSelectEntriesMetadata() throws Exception {
        String query = "select * from dfs.tmp.`testAllTypes#entries`";
        long count = this.queryBuilder().sql(query).run().recordCount();
        Assert.assertEquals((long)2L, (long)count);
    }

    @Test
    public void testSelectFilesMetadata() throws Exception {
        String query = "select * from dfs.tmp.`testAllTypes#files`";
        long count = this.queryBuilder().sql(query).run().recordCount();
        Assert.assertEquals((long)2L, (long)count);
    }

    @Test
    public void testSelectHistoryMetadata() throws Exception {
        String query = "select * from dfs.tmp.`testAllTypes#history`";
        List entries = table.history();
        this.testBuilder().sqlQuery(query).unOrdered().baselineColumns(new String[]{"made_current_at", "snapshot_id", "parent_id", "is_current_ancestor"}).baselineValues(new Object[]{LocalDateTime.ofInstant(Instant.ofEpochMilli(((HistoryEntry)entries.get(0)).timestampMillis()), ZoneId.of("UTC")), ((HistoryEntry)entries.get(0)).snapshotId(), null, true}).baselineValues(new Object[]{LocalDateTime.ofInstant(Instant.ofEpochMilli(((HistoryEntry)entries.get(1)).timestampMillis()), ZoneId.of("UTC")), ((HistoryEntry)entries.get(1)).snapshotId(), ((HistoryEntry)entries.get(0)).snapshotId(), true}).go();
    }

    @Test
    public void testSelectSnapshotsMetadata() throws Exception {
        String query = "select * from dfs.tmp.`testAllTypes#snapshots`";
        ArrayList snapshots = new ArrayList();
        table.snapshots().forEach(snapshots::add);
        JsonStringHashMap summaryMap = new JsonStringHashMap();
        ((Snapshot)snapshots.get(0)).summary().forEach((k, v) -> summaryMap.put((Object)new Text(k.getBytes(StandardCharsets.UTF_8)), (Object)new Text(v.getBytes(StandardCharsets.UTF_8))));
        JsonStringHashMap secondSummaryMap = new JsonStringHashMap();
        ((Snapshot)snapshots.get(1)).summary().forEach((k, v) -> secondSummaryMap.put((Object)new Text(k.getBytes(StandardCharsets.UTF_8)), (Object)new Text(v.getBytes(StandardCharsets.UTF_8))));
        this.testBuilder().sqlQuery(query).unOrdered().baselineColumns(new String[]{"committed_at", "snapshot_id", "parent_id", "operation", "manifest_list", "summary"}).baselineValues(new Object[]{LocalDateTime.ofInstant(Instant.ofEpochMilli(((Snapshot)snapshots.get(0)).timestampMillis()), ZoneId.of("UTC")), ((Snapshot)snapshots.get(0)).snapshotId(), ((Snapshot)snapshots.get(0)).parentId(), ((Snapshot)snapshots.get(0)).operation(), ((Snapshot)snapshots.get(0)).manifestListLocation(), summaryMap}).baselineValues(new Object[]{LocalDateTime.ofInstant(Instant.ofEpochMilli(((Snapshot)snapshots.get(1)).timestampMillis()), ZoneId.of("UTC")), ((Snapshot)snapshots.get(1)).snapshotId(), ((Snapshot)snapshots.get(1)).parentId(), ((Snapshot)snapshots.get(1)).operation(), ((Snapshot)snapshots.get(1)).manifestListLocation(), secondSummaryMap}).go();
    }

    @Test
    public void testSelectManifestsMetadata() throws Exception {
        String query = "select * from dfs.tmp.`testAllTypes#manifests`";
        long count = this.queryBuilder().sql(query).run().recordCount();
        Assert.assertEquals((long)2L, (long)count);
    }

    @Test
    public void testSelectPartitionsMetadata() throws Exception {
        String query = "select * from dfs.tmp.`testAllTypes#partitions`";
        this.testBuilder().sqlQuery(query).unOrdered().baselineColumns(new String[]{"record_count", "file_count"}).baselineValues(new Object[]{3L, 2}).go();
    }

    @Test
    public void testSchemaProvisioning() throws Exception {
        String query = "select int_field, string_field from table(dfs.tmp.testAllTypes(schema => 'inline=(int_field varchar not null default `error`)'))";
        this.queryBuilder().sql(query).planMatcher().include(new String[]{"projection\\=struct<1: int_field: optional int, 5: string_field: optional string>"}).match();
        this.testBuilder().sqlQuery(query).unOrdered().baselineColumns(new String[]{"int_field", "string_field"}).baselineValues(new Object[]{"1", "abc"}).baselineValues(new Object[]{"error", null}).baselineValues(new Object[]{"988", "def"}).go();
    }

    @Test
    public void testSelectAvroFormat() throws Exception {
        this.testBuilder().sqlQuery("select * from dfs.tmp.testAllTypesAvro").unOrdered().baselineColumns(new String[]{"struct_int_field", "struct_string_field"}).baselineValues(new Object[]{123, "abc"}).baselineValues(new Object[]{null, null}).baselineValues(new Object[]{321, "def"}).go();
    }

    @Test
    public void testSelectOrcFormat() throws Exception {
        this.testBuilder().sqlQuery("select * from dfs.tmp.testAllTypesOrc").unOrdered().baselineColumns(new String[]{"struct_int_field", "struct_string_field"}).baselineValues(new Object[]{123, "abc"}).baselineValues(new Object[]{null, null}).baselineValues(new Object[]{321, "def"}).go();
    }

    @Test
    public void testSelectEmptyTable() throws Exception {
        this.testBuilder().sqlQuery("select * from dfs.tmp.testAllTypesEmpty").unOrdered().expectsEmptyResultSet().go();
    }

    @Test
    public void testLimit() throws Exception {
        String query = "select int_field, string_field from dfs.tmp.testAllTypes limit 1";
        this.queryBuilder().sql(query).planMatcher().include(new String[]{"Limit\\(fetch\\=\\[1\\]\\)"}).include(new String[]{"maxRecords\\=1"}).match();
        long count = this.queryBuilder().sql(query).run().recordCount();
        Assert.assertEquals((long)1L, (long)count);
    }

    @Test
    public void testLimitWithFilter() throws Exception {
        String query = "select int_field, string_field from dfs.tmp.testAllTypes where int_field = 1 limit 1";
        this.queryBuilder().sql(query).planMatcher().include(new String[]{"Limit\\(fetch\\=\\[1\\]\\)"}).include(new String[]{"maxRecords\\=1"}).include(new String[]{"filter\\=ref\\(name=\"int_field\"\\) \\=\\= 1"}).match();
        this.testBuilder().sqlQuery(query).unOrdered().baselineColumns(new String[]{"int_field", "string_field"}).baselineValues(new Object[]{1, "abc"}).go();
    }

    @Test
    public void testNoLimitWithSort() throws Exception {
        String query = "select int_field, string_field from dfs.tmp.testAllTypes order by int_field limit 1";
        this.queryBuilder().sql(query).planMatcher().include(new String[]{"Limit\\(fetch\\=\\[1\\]\\)"}).include(new String[]{"maxRecords\\=-1"}).match();
        this.testBuilder().sqlQuery(query).unOrdered().baselineColumns(new String[]{"int_field", "string_field"}).baselineValues(new Object[]{1, "abc"}).go();
    }

    @Test
    public void testLateralSql() throws Exception {
        String sql = "SELECT t.c_name, t2.ord.o_shop AS o_shop\nFROM cp.`lateraljoin/nested-customer.json` t,\nunnest(t.orders) t2(ord)\nLIMIT 1";
        this.testBuilder().sqlQuery(sql).unOrdered().baselineColumns(new String[]{"c_name", "o_shop"}).baselineValues(new Object[]{"customer1", "Meno Park 1st"}).go();
    }

    @Test
    public void testLateralSqlIceberg() throws Exception {
        String sql = "SELECT t.int_field, t2.ord.struct_string_field struct_string_field\nFROM dfs.tmp.testAllTypes t,\nunnest(t.repeated_struct_field) t2(ord)\nORDER BY t.int_field\nLIMIT 1";
        this.testBuilder().sqlQuery(sql).unOrdered().baselineColumns(new String[]{"int_field", "struct_string_field"}).baselineValues(new Object[]{1, "abc"}).go();
    }

    @Test
    public void testFilterPushCorrelate() throws Exception {
        String sql = "SELECT t.c_name, t2.ord.o_shop AS o_shop\nFROM cp.`lateraljoin/nested-customer.json` t,\nunnest(t.orders) t2(ord)\nWHERE t.c_name='customer1' AND t2.ord.o_shop='Meno Park 1st'";
        this.testBuilder().unOrdered().sqlQuery(sql).baselineColumns(new String[]{"c_name", "o_shop"}).baselineValues(new Object[]{"customer1", "Meno Park 1st"}).go();
    }
}

