/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.store.iceberg.read;

import java.util.HashMap;
import java.util.Map;
import org.apache.drill.exec.physical.impl.scan.v3.FixedReceiver;
import org.apache.drill.exec.record.ColumnConverter;
import org.apache.drill.exec.record.ColumnConverterFactory;
import org.apache.drill.exec.record.metadata.ColumnMetadata;
import org.apache.drill.exec.record.metadata.TupleMetadata;
import org.apache.drill.exec.record.metadata.TupleSchema;
import org.apache.drill.exec.store.iceberg.read.IcebergColumnConverterFactory;
import org.apache.drill.exec.vector.accessor.TupleWriter;
import org.apache.iceberg.data.Record;

public class MapColumnConverter
implements ColumnConverter {
    private final ColumnConverterFactory factory;
    private final TupleMetadata providedSchema;
    private final TupleWriter tupleWriter;
    private final Map<String, ColumnConverter> converters;

    public MapColumnConverter(ColumnConverterFactory factory, TupleMetadata providedSchema, TupleWriter tupleWriter, Map<String, ColumnConverter> converters) {
        this.factory = factory;
        this.providedSchema = providedSchema;
        this.tupleWriter = tupleWriter;
        this.converters = new HashMap<String, ColumnConverter>(converters);
    }

    public void convert(Object value) {
        if (value == null) {
            return;
        }
        Record record = (Record)value;
        if (this.converters.isEmpty()) {
            this.buildMapMembers(record, this.providedSchema, this.tupleWriter, this.converters);
        }
        record.struct().fields().forEach(field -> this.processValue(field.name(), record.getField(field.name())));
    }

    private void processValue(String name, Object columnValue) {
        ColumnConverter columnConverter = this.converters.get(name);
        if (columnConverter != null) {
            columnConverter.convert(columnValue);
        }
    }

    public void buildMapMembers(Record record, TupleMetadata providedSchema, TupleWriter tupleWriter, Map<String, ColumnConverter> converters) {
        TupleSchema readerSchema = IcebergColumnConverterFactory.convertSchema(record.struct());
        TupleMetadata tableSchema = FixedReceiver.Builder.mergeSchemas((TupleMetadata)providedSchema, (TupleMetadata)readerSchema);
        tableSchema.toMetadataList().forEach(arg_0 -> ((TupleWriter)tupleWriter).addColumn(arg_0));
        for (ColumnMetadata columnMetadata : tableSchema) {
            String name = columnMetadata.name();
            converters.put(name, this.factory.getConverter(providedSchema, readerSchema.metadata(name), tupleWriter.column(name)));
        }
    }
}

