/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.store.iceberg;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.google.common.base.Preconditions;
import com.google.common.collect.ListMultimap;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.drill.common.PlanStringBuilder;
import org.apache.drill.common.exceptions.DrillRuntimeException;
import org.apache.drill.common.expression.LogicalExpression;
import org.apache.drill.common.expression.PathSegment;
import org.apache.drill.common.expression.SchemaPath;
import org.apache.drill.common.logical.FormatPluginConfig;
import org.apache.drill.common.logical.StoragePluginConfig;
import org.apache.drill.exec.physical.EndpointAffinity;
import org.apache.drill.exec.physical.base.AbstractGroupScan;
import org.apache.drill.exec.physical.base.PhysicalOperator;
import org.apache.drill.exec.physical.base.ScanStats;
import org.apache.drill.exec.proto.CoordinationProtos;
import org.apache.drill.exec.record.metadata.TupleMetadata;
import org.apache.drill.exec.store.StoragePluginRegistry;
import org.apache.drill.exec.store.dfs.DrillFileSystem;
import org.apache.drill.exec.store.iceberg.IcebergBlockMapBuilder;
import org.apache.drill.exec.store.iceberg.IcebergCompleteWork;
import org.apache.drill.exec.store.iceberg.IcebergSubScan;
import org.apache.drill.exec.store.iceberg.IcebergWork;
import org.apache.drill.exec.store.iceberg.format.IcebergFormatPlugin;
import org.apache.drill.exec.store.iceberg.plan.DrillExprToIcebergTranslator;
import org.apache.drill.exec.store.iceberg.snapshot.Snapshot;
import org.apache.drill.exec.store.schedule.AffinityCreator;
import org.apache.drill.exec.store.schedule.AssignmentCreator;
import org.apache.drill.exec.util.ImpersonationUtil;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.iceberg.CombinedScanTask;
import org.apache.iceberg.TableScan;
import org.apache.iceberg.expressions.Expression;
import org.apache.iceberg.hadoop.HadoopTables;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@JsonTypeName(value="iceberg-scan")
public class IcebergGroupScan
extends AbstractGroupScan {
    private static final Logger logger = LoggerFactory.getLogger(IcebergGroupScan.class);
    private final IcebergFormatPlugin formatPlugin;
    private final String path;
    private final TupleMetadata schema;
    private final LogicalExpression condition;
    private final DrillFileSystem fs;
    private final List<SchemaPath> columns;
    private int maxRecords;
    private List<IcebergCompleteWork> chunks;
    private TableScan tableScan;
    private List<EndpointAffinity> endpointAffinities;
    private ListMultimap<Integer, IcebergCompleteWork> mappings;

    @JsonCreator
    public IcebergGroupScan(@JsonProperty(value="userName") String userName, @JsonProperty(value="storage") StoragePluginConfig storageConfig, @JsonProperty(value="format") FormatPluginConfig formatConfig, @JsonProperty(value="columns") List<SchemaPath> columns, @JsonProperty(value="schema") TupleMetadata schema, @JsonProperty(value="path") String path, @JsonProperty(value="condition") LogicalExpression condition, @JsonProperty(value="maxRecords") Integer maxRecords, @JacksonInject StoragePluginRegistry pluginRegistry) throws IOException {
        this(IcebergGroupScan.builder().userName(userName).formatPlugin((IcebergFormatPlugin)pluginRegistry.resolveFormat(storageConfig, formatConfig, IcebergFormatPlugin.class)).schema(schema).path(path).condition(condition).columns(columns).maxRecords(maxRecords));
    }

    private IcebergGroupScan(IcebergGroupScanBuilder builder) throws IOException {
        super(builder.userName);
        this.formatPlugin = builder.formatPlugin;
        this.columns = builder.columns;
        this.path = builder.path;
        this.schema = builder.schema;
        this.condition = builder.condition;
        this.maxRecords = builder.maxRecords;
        this.fs = ImpersonationUtil.createFileSystem((String)ImpersonationUtil.resolveUserName((String)this.userName), (Configuration)this.formatPlugin.getFsConf());
        this.tableScan = IcebergGroupScan.initTableScan(this.formatPlugin, this.path, this.condition);
        this.init();
    }

    public static TableScan initTableScan(IcebergFormatPlugin formatPlugin, String path, LogicalExpression condition) {
        Boolean ignoreResiduals;
        Boolean includeColumnStats;
        Boolean caseSensitive;
        Snapshot snapshot;
        TableScan tableScan = new HadoopTables(formatPlugin.getFsConf()).load(path).newScan();
        Map<String, String> properties = formatPlugin.getConfig().getProperties();
        if (properties != null) {
            for (Map.Entry<String, String> entry : properties.entrySet()) {
                tableScan = tableScan.option(entry.getKey(), entry.getValue());
            }
        }
        if (condition != null) {
            Expression expression = (Expression)condition.accept(DrillExprToIcebergTranslator.INSTANCE, null);
            tableScan = tableScan.filter(expression);
        }
        if ((snapshot = formatPlugin.getConfig().getSnapshot()) != null) {
            tableScan = snapshot.apply(tableScan);
        }
        if ((caseSensitive = formatPlugin.getConfig().getCaseSensitive()) != null) {
            tableScan = tableScan.caseSensitive(caseSensitive.booleanValue());
        }
        if ((includeColumnStats = formatPlugin.getConfig().getIncludeColumnStats()) != null && includeColumnStats.booleanValue()) {
            tableScan = tableScan.includeColumnStats();
        }
        if ((ignoreResiduals = formatPlugin.getConfig().getIgnoreResiduals()) != null && ignoreResiduals.booleanValue()) {
            tableScan = tableScan.ignoreResiduals();
        }
        return tableScan;
    }

    private IcebergGroupScan(IcebergGroupScan that) {
        super((AbstractGroupScan)that);
        this.columns = that.columns;
        this.formatPlugin = that.formatPlugin;
        this.path = that.path;
        this.condition = that.condition;
        this.schema = that.schema;
        this.mappings = that.mappings;
        this.fs = that.fs;
        this.maxRecords = that.maxRecords;
        this.chunks = that.chunks;
        this.tableScan = that.tableScan;
        this.endpointAffinities = that.endpointAffinities;
    }

    public static IcebergGroupScanBuilder builder() {
        return new IcebergGroupScanBuilder();
    }

    public IcebergGroupScan clone(List<SchemaPath> columns) {
        try {
            return this.toBuilder().columns(columns).build();
        }
        catch (IOException e) {
            throw new DrillRuntimeException((Throwable)e);
        }
    }

    public IcebergGroupScan applyLimit(int maxRecords) {
        IcebergGroupScan clone = new IcebergGroupScan(this);
        clone.maxRecords = maxRecords;
        return clone;
    }

    public void applyAssignments(List<CoordinationProtos.DrillbitEndpoint> endpoints) {
        this.mappings = AssignmentCreator.getMappings(endpoints, this.chunks);
    }

    private void createMappings(List<EndpointAffinity> affinities) {
        List<CoordinationProtos.DrillbitEndpoint> endpoints = affinities.stream().map(EndpointAffinity::getEndpoint).collect(Collectors.toList());
        this.applyAssignments(endpoints);
    }

    public IcebergSubScan getSpecificScan(int minorFragmentId) {
        if (this.mappings == null) {
            this.createMappings(this.endpointAffinities);
        }
        assert (minorFragmentId < this.mappings.size()) : String.format("Mappings length [%d] should be longer than minor fragment id [%d] but it isn't.", this.mappings.size(), minorFragmentId);
        List workList = this.mappings.get((Object)minorFragmentId);
        Preconditions.checkArgument((!workList.isEmpty() ? 1 : 0) != 0, (Object)String.format("MinorFragmentId %d has no read entries assigned", minorFragmentId));
        IcebergSubScan subScan = IcebergSubScan.builder().userName(this.userName).formatPlugin(this.formatPlugin).columns(this.columns).condition(this.condition).schema(this.schema).workList(this.convertWorkList(workList)).tableScan(this.tableScan).path(this.path).maxRecords(this.maxRecords).build();
        subScan.setOperatorId(this.getOperatorId());
        return subScan;
    }

    private List<IcebergWork> convertWorkList(List<IcebergCompleteWork> workList) {
        return workList.stream().map(IcebergCompleteWork::getScanTask).map(IcebergWork::new).collect(Collectors.toList());
    }

    @JsonIgnore
    public TableScan getTableScan() {
        return this.tableScan;
    }

    @JsonProperty(value="maxRecords")
    public int getMaxRecords() {
        return this.maxRecords;
    }

    public int getMaxParallelizationWidth() {
        return this.chunks.size();
    }

    public String getDigest() {
        return this.toString();
    }

    public ScanStats getScanStats() {
        int expectedRecordsPerChunk = 1000000;
        if (this.maxRecords >= 0) {
            expectedRecordsPerChunk = Math.max(this.maxRecords, 1);
        }
        int estimatedRecords = this.chunks.size() * expectedRecordsPerChunk;
        return new ScanStats(ScanStats.GroupScanProperty.NO_EXACT_ROW_COUNT, (double)estimatedRecords, 1.0, 0.0);
    }

    public PhysicalOperator getNewWithChildren(List<PhysicalOperator> children) {
        Preconditions.checkArgument((boolean)children.isEmpty());
        return new IcebergGroupScan(this);
    }

    private void init() throws IOException {
        this.tableScan = IcebergGroupScan.projectColumns(this.tableScan, this.columns);
        this.chunks = new IcebergBlockMapBuilder((FileSystem)this.fs, this.formatPlugin.getContext().getBits()).generateFileWork((Iterable<CombinedScanTask>)this.tableScan.planTasks());
        this.endpointAffinities = AffinityCreator.getAffinityMap(this.chunks);
    }

    public static TableScan projectColumns(TableScan tableScan, List<SchemaPath> columns) {
        boolean hasStar = columns.stream().anyMatch(SchemaPath::isDynamicStar);
        if (!hasStar) {
            List projectColumns = columns.stream().map(IcebergGroupScan::getPath).collect(Collectors.toList());
            return tableScan.select(projectColumns);
        }
        return tableScan;
    }

    public static String getPath(SchemaPath schemaPath) {
        StringBuilder sb = new StringBuilder();
        PathSegment.NameSegment segment = schemaPath.getRootSegment();
        sb.append(segment.getNameSegment().getPath());
        while ((segment = segment.getChild()) != null) {
            sb.append('.').append(segment.isNamed() ? segment.getNameSegment().getPath() : "element");
        }
        return sb.toString();
    }

    public List<EndpointAffinity> getOperatorAffinity() {
        if (this.endpointAffinities == null) {
            logger.debug("Chunks size: {}", (Object)this.chunks.size());
            this.endpointAffinities = AffinityCreator.getAffinityMap(this.chunks);
        }
        return this.endpointAffinities;
    }

    public boolean supportsLimitPushdown() {
        return false;
    }

    @JsonProperty(value="columns")
    public List<SchemaPath> getColumns() {
        return this.columns;
    }

    @JsonProperty(value="schema")
    public TupleMetadata getSchema() {
        return this.schema;
    }

    @JsonProperty(value="storage")
    public StoragePluginConfig getStorageConfig() {
        return this.formatPlugin.getStorageConfig();
    }

    @JsonProperty(value="format")
    public FormatPluginConfig getFormatConfig() {
        return this.formatPlugin.getConfig();
    }

    @JsonProperty(value="path")
    public String getPath() {
        return this.path;
    }

    @JsonProperty(value="condition")
    public LogicalExpression getCondition() {
        return this.condition;
    }

    @JsonIgnore
    public IcebergFormatPlugin getFormatPlugin() {
        return this.formatPlugin;
    }

    public String toString() {
        return new PlanStringBuilder((Object)this).field("path", this.path).field("schema", (Object)this.schema).field("columns", this.columns).field("tableScan", (Object)this.tableScan).field("maxRecords", this.maxRecords).toString();
    }

    public IcebergGroupScanBuilder toBuilder() {
        return new IcebergGroupScanBuilder().userName(this.userName).formatPlugin(this.formatPlugin).schema(this.schema).path(this.path).condition(this.condition).columns(this.columns).maxRecords(this.maxRecords);
    }

    public static class IcebergGroupScanBuilder {
        private String userName;
        private IcebergFormatPlugin formatPlugin;
        private TupleMetadata schema;
        private String path;
        private LogicalExpression condition;
        private List<SchemaPath> columns;
        private int maxRecords;

        public IcebergGroupScanBuilder userName(String userName) {
            this.userName = userName;
            return this;
        }

        public IcebergGroupScanBuilder formatPlugin(IcebergFormatPlugin formatPlugin) {
            this.formatPlugin = formatPlugin;
            return this;
        }

        public IcebergGroupScanBuilder schema(TupleMetadata schema) {
            this.schema = schema;
            return this;
        }

        public IcebergGroupScanBuilder path(String path) {
            this.path = path;
            return this;
        }

        public IcebergGroupScanBuilder condition(LogicalExpression condition) {
            this.condition = condition;
            return this;
        }

        public IcebergGroupScanBuilder columns(List<SchemaPath> columns) {
            this.columns = columns;
            return this;
        }

        public IcebergGroupScanBuilder maxRecords(int maxRecords) {
            this.maxRecords = maxRecords;
            return this;
        }

        public IcebergGroupScan build() throws IOException {
            return new IcebergGroupScan(this);
        }
    }
}

