/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.store.iceberg;

import org.apache.drill.exec.store.schedule.CompleteWork;
import org.apache.drill.exec.store.schedule.EndpointByteMap;
import org.apache.iceberg.CombinedScanTask;
import org.apache.iceberg.FileScanTask;

public class IcebergCompleteWork
implements CompleteWork {
    private final EndpointByteMap byteMap;
    private final CombinedScanTask scanTask;
    private final long totalBytes;

    public IcebergCompleteWork(EndpointByteMap byteMap, CombinedScanTask scanTask) {
        this.byteMap = byteMap;
        this.scanTask = scanTask;
        this.totalBytes = scanTask.files().stream().mapToLong(FileScanTask::length).sum();
    }

    public CombinedScanTask getScanTask() {
        return this.scanTask;
    }

    public long getTotalBytes() {
        return this.totalBytes;
    }

    public EndpointByteMap getByteMap() {
        return this.byteMap;
    }

    public int compareTo(CompleteWork o) {
        return 0;
    }
}

