/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.zookeeper;

import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.Abortable;
import org.apache.hadoop.hbase.HBaseConfiguration;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.Stoppable;
import org.apache.hadoop.hbase.testclassification.MediumTests;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.zookeeper.ZKLeaderManager;
import org.apache.hadoop.hbase.zookeeper.ZKUtil;
import org.apache.hadoop.hbase.zookeeper.ZooKeeperWatcher;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={MediumTests.class})
public class TestZKLeaderManager {
    private static final Log LOG = LogFactory.getLog(TestZKLeaderManager.class);
    private static final String LEADER_ZNODE = "/test/" + TestZKLeaderManager.class.getSimpleName();
    private static HBaseTestingUtility TEST_UTIL;
    private static MockLeader[] CANDIDATES;

    @BeforeClass
    public static void setupBeforeClass() throws Exception {
        TEST_UTIL = new HBaseTestingUtility();
        TEST_UTIL.startMiniZKCluster();
        Configuration conf = TEST_UTIL.getConfiguration();
        MockAbortable abortable = new MockAbortable();
        CANDIDATES = new MockLeader[3];
        for (int i = 0; i < 3; ++i) {
            ZooKeeperWatcher watcher = TestZKLeaderManager.newZK(conf, "server" + i, abortable);
            TestZKLeaderManager.CANDIDATES[i] = new MockLeader(watcher, i);
            CANDIDATES[i].start();
        }
    }

    @AfterClass
    public static void tearDownAfterClass() throws Exception {
        TEST_UTIL.shutdownMiniZKCluster();
    }

    @Test
    public void testLeaderSelection() throws Exception {
        MockLeader currentLeader = this.getCurrentLeader();
        Assert.assertNotNull((String)"Leader should exist", (Object)currentLeader);
        LOG.debug((Object)("Current leader index is " + currentLeader.getIndex()));
        byte[] znodeData = ZKUtil.getData(currentLeader.getWatcher(), LEADER_ZNODE);
        Assert.assertNotNull((String)"Leader znode should contain leader index", (Object)znodeData);
        Assert.assertTrue((String)"Leader znode should not be empty", (znodeData.length > 0 ? 1 : 0) != 0);
        int storedIndex = Bytes.toInt(znodeData);
        LOG.debug((Object)("Stored leader index in ZK is " + storedIndex));
        Assert.assertEquals((String)"Leader znode should match leader index", (long)currentLeader.getIndex(), (long)storedIndex);
        currentLeader.abdicate();
        Assert.assertFalse((boolean)currentLeader.isMaster());
        currentLeader = this.getCurrentLeader();
        Assert.assertNotNull((String)"New leader should exist after abdication", (Object)currentLeader);
        LOG.debug((Object)("New leader index is " + currentLeader.getIndex()));
        znodeData = ZKUtil.getData(currentLeader.getWatcher(), LEADER_ZNODE);
        Assert.assertNotNull((String)"Leader znode should contain leader index", (Object)znodeData);
        Assert.assertTrue((String)"Leader znode should not be empty", (znodeData.length > 0 ? 1 : 0) != 0);
        storedIndex = Bytes.toInt(znodeData);
        LOG.debug((Object)("Stored leader index in ZK is " + storedIndex));
        Assert.assertEquals((String)"Leader znode should match leader index", (long)currentLeader.getIndex(), (long)storedIndex);
        currentLeader.stop("Stopping for test");
        Assert.assertFalse((boolean)currentLeader.isMaster());
        currentLeader = this.getCurrentLeader();
        Assert.assertNotNull((String)"New leader should exist after stop", (Object)currentLeader);
        LOG.debug((Object)("New leader index is " + currentLeader.getIndex()));
        znodeData = ZKUtil.getData(currentLeader.getWatcher(), LEADER_ZNODE);
        Assert.assertNotNull((String)"Leader znode should contain leader index", (Object)znodeData);
        Assert.assertTrue((String)"Leader znode should not be empty", (znodeData.length > 0 ? 1 : 0) != 0);
        storedIndex = Bytes.toInt(znodeData);
        LOG.debug((Object)("Stored leader index in ZK is " + storedIndex));
        Assert.assertEquals((String)"Leader znode should match leader index", (long)currentLeader.getIndex(), (long)storedIndex);
        currentLeader.stop("Stopping for test");
        Assert.assertFalse((boolean)currentLeader.isMaster());
        currentLeader = this.getCurrentLeader();
        Assert.assertNotNull((String)"New leader should exist", (Object)currentLeader);
    }

    private MockLeader getCurrentLeader() throws Exception {
        MockLeader currentLeader = null;
        for (int i = 0; i < 1000; ++i) {
            for (int j = 0; j < CANDIDATES.length; ++j) {
                if (!CANDIDATES[j].isMaster()) continue;
                if (currentLeader != null) {
                    Assert.fail((String)("Both candidate " + currentLeader.getIndex() + " and " + j + " claim to be leader!"));
                }
                currentLeader = CANDIDATES[j];
            }
            if (currentLeader != null) break;
            Thread.sleep(10L);
        }
        return currentLeader;
    }

    private static ZooKeeperWatcher newZK(Configuration conf, String name, Abortable abort) throws Exception {
        Configuration copy = HBaseConfiguration.create(conf);
        ZooKeeperWatcher zk = new ZooKeeperWatcher(copy, name, abort);
        return zk;
    }

    private static class MockLeader
    extends Thread
    implements Stoppable {
        private boolean stopped;
        private ZooKeeperWatcher watcher;
        private ZKLeaderManager zkLeader;
        private AtomicBoolean master = new AtomicBoolean(false);
        private int index;

        public MockLeader(ZooKeeperWatcher watcher, int index) {
            this.setDaemon(true);
            this.setName("TestZKLeaderManager-leader-" + index);
            this.index = index;
            this.watcher = watcher;
            this.zkLeader = new ZKLeaderManager(watcher, LEADER_ZNODE, Bytes.toBytes(index), this);
        }

        public boolean isMaster() {
            return this.master.get();
        }

        public int getIndex() {
            return this.index;
        }

        public ZooKeeperWatcher getWatcher() {
            return this.watcher;
        }

        @Override
        public void run() {
            while (!this.stopped) {
                this.zkLeader.start();
                this.zkLeader.waitToBecomeLeader();
                this.master.set(true);
                while (this.master.get() && !this.stopped) {
                    try {
                        Thread.sleep(10L);
                    }
                    catch (InterruptedException interruptedException) {}
                }
            }
        }

        public void abdicate() {
            this.zkLeader.stepDownAsLeader();
            this.master.set(false);
        }

        @Override
        public void stop(String why) {
            this.stopped = true;
            this.abdicate();
            this.watcher.close();
        }

        @Override
        public boolean isStopped() {
            return this.stopped;
        }
    }

    private static class MockAbortable
    implements Abortable {
        private boolean aborted;

        private MockAbortable() {
        }

        @Override
        public void abort(String why, Throwable e) {
            this.aborted = true;
            LOG.fatal((Object)("Aborting during test: " + why), e);
            Assert.fail((String)("Aborted during test: " + why));
        }

        @Override
        public boolean isAborted() {
            return this.aborted;
        }
    }
}

