/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.wal;

import java.io.IOException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.Get;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.client.Table;
import org.apache.hadoop.hbase.testclassification.MediumTests;
import org.apache.hadoop.hbase.testclassification.RegionServerTests;
import org.apache.hadoop.hbase.util.Bytes;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Rule;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.rules.TestName;

@Category(value={RegionServerTests.class, MediumTests.class})
public class TestDisabledWAL {
    @Rule
    public TestName name = new TestName();
    private static final Log LOG = LogFactory.getLog(TestDisabledWAL.class);
    static final HBaseTestingUtility TEST_UTIL = new HBaseTestingUtility();
    private Table table;
    private TableName tableName;
    private byte[] fam = Bytes.toBytes("f1");

    @BeforeClass
    public static void beforeClass() throws Exception {
        Configuration conf = TEST_UTIL.getConfiguration();
        conf.setBoolean("hbase.regionserver.hlog.enabled", false);
        try {
            TEST_UTIL.startMiniCluster();
        }
        catch (IOException | RuntimeException e) {
            LOG.error((Object)"Master failed to start.", (Throwable)e);
            Assert.fail((String)("Failed to start cluster. Reason being: " + e.getCause().getMessage()));
        }
    }

    @AfterClass
    public static void afterClass() throws Exception {
        TEST_UTIL.shutdownMiniCluster();
    }

    @Before
    public void setup() throws Exception {
        this.tableName = TableName.valueOf(this.name.getMethodName().replaceAll("[^a-zA-Z0-9]", "_"));
        LOG.info((Object)("Creating table " + this.tableName));
        this.table = TEST_UTIL.createTable(this.tableName, this.fam);
    }

    @After
    public void cleanup() throws Exception {
        LOG.info((Object)("Deleting table " + this.tableName));
        TEST_UTIL.deleteTable(this.tableName);
    }

    @Test
    public void testDisabledWAL() throws Exception {
        LOG.info((Object)("Writing data to table " + this.tableName));
        Put p = new Put(Bytes.toBytes("row"));
        p.addColumn(this.fam, Bytes.toBytes("qual"), Bytes.toBytes("val"));
        this.table.put(p);
        LOG.info((Object)("Flushing table " + this.tableName));
        TEST_UTIL.flush(this.tableName);
        LOG.info((Object)("Getting data from table " + this.tableName));
        Get get = new Get(Bytes.toBytes("row"));
        Result result = this.table.get(get);
        Assert.assertNotNull((Object)result.getValue(this.fam, Bytes.toBytes("qual")));
    }
}

