/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.util.hbck;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.NavigableMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.HColumnDescriptor;
import org.apache.hadoop.hbase.HRegionInfo;
import org.apache.hadoop.hbase.HTableDescriptor;
import org.apache.hadoop.hbase.MetaTableAccessor;
import org.apache.hadoop.hbase.NamespaceDescriptor;
import org.apache.hadoop.hbase.ServerName;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.Admin;
import org.apache.hadoop.hbase.client.Connection;
import org.apache.hadoop.hbase.client.ConnectionFactory;
import org.apache.hadoop.hbase.client.Delete;
import org.apache.hadoop.hbase.client.HBaseAdmin;
import org.apache.hadoop.hbase.client.HTable;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.client.ResultScanner;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.client.Table;
import org.apache.hadoop.hbase.testclassification.LargeTests;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.FSUtils;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.experimental.categories.Category;

@Category(value={LargeTests.class})
public class OfflineMetaRebuildTestCore {
    private static final Log LOG = LogFactory.getLog(OfflineMetaRebuildTestCore.class);
    protected HBaseTestingUtility TEST_UTIL;
    protected Configuration conf;
    private static final byte[] FAM = Bytes.toBytes("fam");
    protected Table htbl;
    protected static final byte[][] splits = new byte[][]{Bytes.toBytes("A"), Bytes.toBytes("B"), Bytes.toBytes("C")};
    private static final String TABLE_BASE = "tableMetaRebuild";
    private static int tableIdx = 0;
    protected TableName table = TableName.valueOf("tableMetaRebuild");
    protected Connection connection;

    @Before
    public void setUpBefore() throws Exception {
        this.TEST_UTIL = new HBaseTestingUtility();
        this.TEST_UTIL.getConfiguration().setInt("dfs.datanode.max.xceivers", 9192);
        this.TEST_UTIL.startMiniCluster(3);
        this.conf = this.TEST_UTIL.getConfiguration();
        this.connection = ConnectionFactory.createConnection(this.conf);
        Assert.assertEquals((long)0L, (long)this.TEST_UTIL.getHBaseAdmin().listTables().length);
        this.table = TableName.valueOf("tableMetaRebuild-" + tableIdx);
        ++tableIdx;
        this.htbl = this.setupTable(this.table);
        this.populateTable(this.htbl);
        Assert.assertEquals((long)5L, (long)this.scanMeta());
        LOG.info((Object)("Table " + this.table + " has " + this.tableRowCount(this.conf, this.table) + " entries."));
        Assert.assertEquals((long)16L, (long)this.tableRowCount(this.conf, this.table));
        this.TEST_UTIL.getHBaseAdmin().disableTable(this.table);
        Assert.assertEquals((long)1L, (long)this.TEST_UTIL.getHBaseAdmin().listTables().length);
    }

    @After
    public void tearDownAfter() throws Exception {
        if (this.htbl != null) {
            this.htbl.close();
            this.htbl = null;
        }
        this.connection.close();
        this.TEST_UTIL.shutdownMiniCluster();
    }

    private Table setupTable(TableName tablename) throws Exception {
        HTableDescriptor desc = new HTableDescriptor(tablename);
        HColumnDescriptor hcd = new HColumnDescriptor(Bytes.toString(FAM));
        desc.addFamily(hcd);
        this.TEST_UTIL.getHBaseAdmin().createTable(desc, splits);
        return this.connection.getTable(tablename);
    }

    private void dumpMeta(HTableDescriptor htd) throws IOException {
        List<byte[]> metaRows = this.TEST_UTIL.getMetaTableRows(htd.getTableName());
        for (byte[] row : metaRows) {
            LOG.info((Object)Bytes.toString(row));
        }
    }

    private void populateTable(Table tbl) throws IOException {
        byte[] values = new byte[]{65, 66, 67, 68};
        ArrayList<Put> puts = new ArrayList<Put>();
        for (int i = 0; i < values.length; ++i) {
            for (int j = 0; j < values.length; ++j) {
                Put put = new Put(new byte[]{values[i], values[j]});
                put.add(Bytes.toBytes("fam"), new byte[0], new byte[]{values[i], values[j]});
                puts.add(put);
            }
        }
        tbl.put(puts);
    }

    void deleteTable(HBaseAdmin admin, String tablename) throws IOException {
        try {
            byte[] tbytes = Bytes.toBytes(tablename);
            admin.disableTable(tbytes);
            admin.deleteTable(tbytes);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    protected void deleteRegion(Configuration conf, Table tbl, byte[] startKey, byte[] endKey) throws IOException {
        LOG.info((Object)"Before delete:");
        HTableDescriptor htd = tbl.getTableDescriptor();
        this.dumpMeta(htd);
        NavigableMap<HRegionInfo, ServerName> hris = ((HTable)tbl).getRegionLocations();
        for (Map.Entry e : hris.entrySet()) {
            HRegionInfo hri = (HRegionInfo)e.getKey();
            ServerName hsa = (ServerName)e.getValue();
            if (Bytes.compareTo(hri.getStartKey(), startKey) == 0 && Bytes.compareTo(hri.getEndKey(), endKey) == 0) {
                LOG.info((Object)("RegionName: " + hri.getRegionNameAsString()));
                byte[] deleteRow = hri.getRegionName();
                this.TEST_UTIL.getHBaseAdmin().unassign(deleteRow, true);
                LOG.info((Object)("deleting hdfs data: " + hri.toString() + hsa.toString()));
                Path rootDir = FSUtils.getRootDir(conf);
                FileSystem fs = rootDir.getFileSystem(conf);
                Path p = new Path(FSUtils.getTableDir(rootDir, htd.getTableName()), hri.getEncodedName());
                fs.delete(p, true);
                try (Table meta = this.connection.getTable(TableName.META_TABLE_NAME);){
                    Delete delete = new Delete(deleteRow);
                    meta.delete(delete);
                }
            }
            LOG.info((Object)(hri.toString() + hsa.toString()));
        }
        this.TEST_UTIL.getMetaTableRows(htd.getTableName());
        LOG.info((Object)"After delete:");
        this.dumpMeta(htd);
    }

    protected HRegionInfo createRegion(Configuration conf, Table htbl, byte[] startKey, byte[] endKey) throws IOException {
        HTable meta = new HTable(conf, TableName.META_TABLE_NAME);
        HTableDescriptor htd = htbl.getTableDescriptor();
        HRegionInfo hri = new HRegionInfo(htbl.getName(), startKey, endKey);
        LOG.info((Object)("manually adding regioninfo and hdfs data: " + hri.toString()));
        Path rootDir = FSUtils.getRootDir(conf);
        FileSystem fs = rootDir.getFileSystem(conf);
        Path p = new Path(FSUtils.getTableDir(rootDir, htbl.getName()), hri.getEncodedName());
        fs.mkdirs(p);
        Path riPath = new Path(p, ".regioninfo");
        FSDataOutputStream out = fs.create(riPath);
        out.write(hri.toDelimitedByteArray());
        out.close();
        MetaTableAccessor.addRegionToMeta(meta, hri);
        meta.close();
        return hri;
    }

    protected void wipeOutMeta() throws IOException {
        HBaseAdmin admin = this.TEST_UTIL.getHBaseAdmin();
        Scan s = new Scan();
        HTable meta = new HTable(this.conf, TableName.META_TABLE_NAME);
        ResultScanner scanner = meta.getScanner(s);
        ArrayList<Delete> dels = new ArrayList<Delete>();
        for (Result r : scanner) {
            HRegionInfo info = HRegionInfo.getHRegionInfo(r);
            if (info == null || info.getTable().getNamespaceAsString().equals(NamespaceDescriptor.SYSTEM_NAMESPACE_NAME_STR)) continue;
            Delete d = new Delete(r.getRow());
            dels.add(d);
            admin.unassign(r.getRow(), true);
        }
        meta.delete(dels);
        scanner.close();
        meta.close();
    }

    protected int tableRowCount(Configuration conf, TableName table) throws IOException {
        HTable t = new HTable(conf, table);
        Scan st = new Scan();
        ResultScanner rst = t.getScanner(st);
        int count = 0;
        for (Result rt : rst) {
            ++count;
        }
        t.close();
        return count;
    }

    protected int scanMeta() throws IOException {
        int count = 0;
        HTable meta = new HTable(this.conf, TableName.META_TABLE_NAME);
        ResultScanner scanner = meta.getScanner(new Scan());
        LOG.info((Object)("Table: " + Bytes.toString(meta.getTableName())));
        for (Result res : scanner) {
            LOG.info((Object)Bytes.toString(res.getRow()));
            ++count;
        }
        meta.close();
        return count;
    }

    protected HTableDescriptor[] getTables(Configuration configuration) throws IOException {
        HTableDescriptor[] htbls = null;
        try (Connection connection = ConnectionFactory.createConnection(configuration);
             Admin admin = connection.getAdmin();){
            htbls = admin.listTables();
        }
        return htbls;
    }
}

