/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.util;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Random;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.CellScanner;
import org.apache.hadoop.hbase.KeyValue;
import org.apache.hadoop.hbase.Tag;
import org.apache.hadoop.hbase.classification.InterfaceAudience;
import org.apache.hadoop.hbase.client.Mutation;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.util.LoadTestTool;
import org.apache.hadoop.hbase.util.MultiThreadedAction;

@InterfaceAudience.Private
public class LoadTestDataGeneratorWithTags
extends MultiThreadedAction.DefaultDataGenerator {
    private int minNumTags;
    private int maxNumTags;
    private int minTagLength;
    private int maxTagLength;
    private Random random = new Random();

    public LoadTestDataGeneratorWithTags(int minValueSize, int maxValueSize, int minColumnsPerKey, int maxColumnsPerKey, byte[] ... columnFamilies) {
        super(minValueSize, maxValueSize, minColumnsPerKey, maxColumnsPerKey, columnFamilies);
    }

    @Override
    public void initialize(String[] args) {
        super.initialize(args);
        if (args.length != 4) {
            throw new IllegalArgumentException("LoadTestDataGeneratorWithTags must have 4 initialization arguments. ie. minNumTags:maxNumTags:minTagLength:maxTagLength");
        }
        this.minNumTags = Integer.parseInt(args[0]);
        this.maxNumTags = Integer.parseInt(args[1]);
        this.minTagLength = Integer.parseInt(args[2]);
        this.maxTagLength = Integer.parseInt(args[3]);
    }

    @Override
    public Mutation beforeMutate(long rowkeyBase, Mutation m) throws IOException {
        if (m instanceof Put) {
            ArrayList<KeyValue> updatedCells = new ArrayList<KeyValue>();
            int numTags = this.minNumTags == this.maxNumTags ? this.minNumTags : this.minNumTags + this.random.nextInt(this.maxNumTags - this.minNumTags);
            CellScanner cellScanner = m.cellScanner();
            while (cellScanner.advance()) {
                Cell cell = cellScanner.current();
                byte[] tag = LoadTestTool.generateData(this.random, this.minTagLength + this.random.nextInt(this.maxTagLength - this.minTagLength));
                ArrayList<Tag> tags = new ArrayList<Tag>();
                for (int n = 0; n < numTags; ++n) {
                    tags.add(new Tag(127, tag));
                }
                KeyValue updatedCell = new KeyValue(cell.getRowArray(), cell.getRowOffset(), cell.getRowLength(), cell.getFamilyArray(), cell.getFamilyOffset(), cell.getFamilyLength(), cell.getQualifierArray(), cell.getQualifierOffset(), cell.getQualifierLength(), cell.getTimestamp(), KeyValue.Type.codeToType(cell.getTypeByte()), cell.getValueArray(), cell.getValueOffset(), cell.getValueLength(), tags);
                updatedCells.add(updatedCell);
            }
            m.getFamilyCellMap().clear();
            for (Cell cell : updatedCells) {
                ((Put)m).add(cell);
            }
        }
        return m;
    }
}

