/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.security.visibility;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.KeyValue;
import org.apache.hadoop.hbase.Tag;
import org.apache.hadoop.hbase.classification.InterfaceAudience;
import org.apache.hadoop.hbase.regionserver.DeleteTracker;
import org.apache.hadoop.hbase.regionserver.querymatcher.ScanDeleteTracker;
import org.apache.hadoop.hbase.security.visibility.VisibilityLabelServiceManager;
import org.apache.hadoop.hbase.security.visibility.VisibilityUtils;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.Pair;
import org.apache.hadoop.hbase.util.Triple;

@InterfaceAudience.Private
public class VisibilityScanDeleteTracker
extends ScanDeleteTracker {
    private static final Log LOG = LogFactory.getLog(VisibilityScanDeleteTracker.class);
    private static final List<Tag> EMPTY_TAG = Collections.EMPTY_LIST;
    private List<Triple<List<Tag>, Byte, Long>> visibilityTagsDeleteFamily = new ArrayList<Triple<List<Tag>, Byte, Long>>();
    private List<Triple<List<Tag>, Byte, Long>> visibilityTagsDeleteFamilyVersion = new ArrayList<Triple<List<Tag>, Byte, Long>>();
    private List<Pair<List<Tag>, Byte>> visibilityTagsDeleteColumns;
    private List<Pair<List<Tag>, Byte>> visiblityTagsDeleteColumnVersion = new ArrayList<Pair<List<Tag>, Byte>>();

    @Override
    public void add(Cell delCell) {
        long timestamp = delCell.getTimestamp();
        int qualifierOffset = delCell.getQualifierOffset();
        int qualifierLength = delCell.getQualifierLength();
        byte type = delCell.getTypeByte();
        if (type == KeyValue.Type.DeleteFamily.getCode()) {
            this.hasFamilyStamp = true;
            boolean hasVisTag = this.extractDeleteCellVisTags(delCell, KeyValue.Type.DeleteFamily);
            if (!hasVisTag && timestamp > this.familyStamp) {
                this.familyStamp = timestamp;
            }
            return;
        }
        if (type == KeyValue.Type.DeleteFamilyVersion.getCode()) {
            this.familyVersionStamps.add(timestamp);
            this.extractDeleteCellVisTags(delCell, KeyValue.Type.DeleteFamilyVersion);
            return;
        }
        if (this.deleteBuffer != null) {
            if (Bytes.compareTo(this.deleteBuffer, this.deleteOffset, this.deleteLength, delCell.getQualifierArray(), qualifierOffset, qualifierLength) != 0) {
                this.visibilityTagsDeleteColumns = null;
                this.visiblityTagsDeleteColumnVersion = null;
            } else if (type == KeyValue.Type.Delete.getCode() && this.deleteTimestamp != timestamp) {
                this.visiblityTagsDeleteColumnVersion = null;
            }
        }
        this.deleteBuffer = delCell.getQualifierArray();
        this.deleteOffset = qualifierOffset;
        this.deleteLength = qualifierLength;
        this.deleteType = type;
        this.deleteTimestamp = timestamp;
        this.extractDeleteCellVisTags(delCell, KeyValue.Type.codeToType(type));
    }

    private boolean extractDeleteCellVisTags(Cell delCell, KeyValue.Type type) {
        boolean hasVisTag = false;
        Byte deleteCellVisTagsFormat = null;
        switch (type) {
            case DeleteFamily: {
                ArrayList<Tag> delTags = new ArrayList<Tag>();
                if (this.visibilityTagsDeleteFamily == null) {
                    this.visibilityTagsDeleteFamily = new ArrayList<Triple<List<Tag>, Byte, Long>>();
                }
                deleteCellVisTagsFormat = VisibilityUtils.extractVisibilityTags(delCell, delTags);
                if (!delTags.isEmpty()) {
                    this.visibilityTagsDeleteFamily.add(new Triple<ArrayList<Tag>, Byte, Long>(delTags, deleteCellVisTagsFormat, delCell.getTimestamp()));
                    hasVisTag = true;
                    break;
                }
                this.visibilityTagsDeleteFamily.add(new Triple<List<Tag>, Byte, Long>(EMPTY_TAG, deleteCellVisTagsFormat, delCell.getTimestamp()));
                break;
            }
            case DeleteFamilyVersion: {
                if (this.visibilityTagsDeleteFamilyVersion == null) {
                    this.visibilityTagsDeleteFamilyVersion = new ArrayList<Triple<List<Tag>, Byte, Long>>();
                }
                ArrayList<Tag> delTags = new ArrayList<Tag>();
                deleteCellVisTagsFormat = VisibilityUtils.extractVisibilityTags(delCell, delTags);
                if (!delTags.isEmpty()) {
                    this.visibilityTagsDeleteFamilyVersion.add(new Triple<ArrayList<Tag>, Byte, Long>(delTags, deleteCellVisTagsFormat, delCell.getTimestamp()));
                    hasVisTag = true;
                    break;
                }
                this.visibilityTagsDeleteFamilyVersion.add(new Triple<List<Tag>, Byte, Long>(EMPTY_TAG, deleteCellVisTagsFormat, delCell.getTimestamp()));
                break;
            }
            case DeleteColumn: {
                if (this.visibilityTagsDeleteColumns == null) {
                    this.visibilityTagsDeleteColumns = new ArrayList<Pair<List<Tag>, Byte>>();
                }
                ArrayList<Tag> delTags = new ArrayList<Tag>();
                deleteCellVisTagsFormat = VisibilityUtils.extractVisibilityTags(delCell, delTags);
                if (!delTags.isEmpty()) {
                    this.visibilityTagsDeleteColumns.add(new Pair<ArrayList<Tag>, Byte>(delTags, deleteCellVisTagsFormat));
                    hasVisTag = true;
                    break;
                }
                this.visibilityTagsDeleteColumns.add(new Pair<List<Tag>, Byte>(EMPTY_TAG, deleteCellVisTagsFormat));
                break;
            }
            case Delete: {
                if (this.visiblityTagsDeleteColumnVersion == null) {
                    this.visiblityTagsDeleteColumnVersion = new ArrayList<Pair<List<Tag>, Byte>>();
                }
                ArrayList<Tag> delTags = new ArrayList<Tag>();
                deleteCellVisTagsFormat = VisibilityUtils.extractVisibilityTags(delCell, delTags);
                if (!delTags.isEmpty()) {
                    this.visiblityTagsDeleteColumnVersion.add(new Pair<ArrayList<Tag>, Byte>(delTags, deleteCellVisTagsFormat));
                    hasVisTag = true;
                    break;
                }
                this.visiblityTagsDeleteColumnVersion.add(new Pair<List<Tag>, Byte>(EMPTY_TAG, deleteCellVisTagsFormat));
                break;
            }
            default: {
                throw new IllegalArgumentException("Invalid delete type");
            }
        }
        return hasVisTag;
    }

    @Override
    public DeleteTracker.DeleteResult isDeleted(Cell cell) {
        block36: {
            long timestamp = cell.getTimestamp();
            int qualifierOffset = cell.getQualifierOffset();
            int qualifierLength = cell.getQualifierLength();
            try {
                boolean matchFound;
                Byte putCellVisTagsFormat;
                ArrayList<Tag> putVisTags;
                Triple<List<Tag>, Byte, Long> triple;
                int i;
                if (this.hasFamilyStamp) {
                    if (this.visibilityTagsDeleteFamily != null) {
                        if (!this.visibilityTagsDeleteFamily.isEmpty()) {
                            for (i = 0; i < this.visibilityTagsDeleteFamily.size(); ++i) {
                                triple = this.visibilityTagsDeleteFamily.get(i);
                                if (timestamp > triple.getThird()) continue;
                                putVisTags = new ArrayList<Tag>();
                                putCellVisTagsFormat = VisibilityUtils.extractVisibilityTags(cell, putVisTags);
                                matchFound = VisibilityLabelServiceManager.getInstance().getVisibilityLabelService().matchVisibility(putVisTags, putCellVisTagsFormat, triple.getFirst(), triple.getSecond());
                                if (!matchFound) continue;
                                return DeleteTracker.DeleteResult.FAMILY_VERSION_DELETED;
                            }
                        } else if (!VisibilityUtils.isVisibilityTagsPresent(cell) && timestamp <= this.familyStamp) {
                            return DeleteTracker.DeleteResult.FAMILY_VERSION_DELETED;
                        }
                    } else if (!VisibilityUtils.isVisibilityTagsPresent(cell) && timestamp <= this.familyStamp) {
                        return DeleteTracker.DeleteResult.FAMILY_VERSION_DELETED;
                    }
                }
                if (this.familyVersionStamps.contains(timestamp)) {
                    if (this.visibilityTagsDeleteFamilyVersion != null) {
                        if (!this.visibilityTagsDeleteFamilyVersion.isEmpty()) {
                            for (i = 0; i < this.visibilityTagsDeleteFamilyVersion.size(); ++i) {
                                triple = this.visibilityTagsDeleteFamilyVersion.get(i);
                                if (timestamp != triple.getThird()) continue;
                                putVisTags = new ArrayList();
                                putCellVisTagsFormat = VisibilityUtils.extractVisibilityTags(cell, putVisTags);
                                matchFound = VisibilityLabelServiceManager.getInstance().getVisibilityLabelService().matchVisibility(putVisTags, putCellVisTagsFormat, triple.getFirst(), triple.getSecond());
                                if (!matchFound) continue;
                                return DeleteTracker.DeleteResult.FAMILY_VERSION_DELETED;
                            }
                        } else if (!VisibilityUtils.isVisibilityTagsPresent(cell)) {
                            return DeleteTracker.DeleteResult.FAMILY_VERSION_DELETED;
                        }
                    } else if (!VisibilityUtils.isVisibilityTagsPresent(cell)) {
                        return DeleteTracker.DeleteResult.FAMILY_VERSION_DELETED;
                    }
                }
                if (this.deleteBuffer == null) break block36;
                int ret = Bytes.compareTo(this.deleteBuffer, this.deleteOffset, this.deleteLength, cell.getQualifierArray(), qualifierOffset, qualifierLength);
                if (ret == 0) {
                    boolean matchFound2;
                    ArrayList<Tag> putVisTags2;
                    if (this.deleteType == KeyValue.Type.DeleteColumn.getCode()) {
                        if (this.visibilityTagsDeleteColumns != null) {
                            if (!this.visibilityTagsDeleteColumns.isEmpty()) {
                                for (Pair<List<Tag>, Byte> tags : this.visibilityTagsDeleteColumns) {
                                    putVisTags2 = new ArrayList<Tag>();
                                    Byte putCellVisTagsFormat2 = VisibilityUtils.extractVisibilityTags(cell, putVisTags2);
                                    matchFound2 = VisibilityLabelServiceManager.getInstance().getVisibilityLabelService().matchVisibility(putVisTags2, putCellVisTagsFormat2, tags.getFirst(), tags.getSecond());
                                    if (!matchFound2) continue;
                                    return DeleteTracker.DeleteResult.VERSION_DELETED;
                                }
                            } else if (!VisibilityUtils.isVisibilityTagsPresent(cell)) {
                                return DeleteTracker.DeleteResult.VERSION_DELETED;
                            }
                        } else if (!VisibilityUtils.isVisibilityTagsPresent(cell)) {
                            return DeleteTracker.DeleteResult.VERSION_DELETED;
                        }
                    }
                    if (timestamp == this.deleteTimestamp) {
                        if (this.visiblityTagsDeleteColumnVersion != null) {
                            if (!this.visiblityTagsDeleteColumnVersion.isEmpty()) {
                                for (Pair<List<Tag>, Byte> tags : this.visiblityTagsDeleteColumnVersion) {
                                    putVisTags2 = new ArrayList();
                                    Byte putCellVisTagsFormat3 = VisibilityUtils.extractVisibilityTags(cell, putVisTags2);
                                    matchFound2 = VisibilityLabelServiceManager.getInstance().getVisibilityLabelService().matchVisibility(putVisTags2, putCellVisTagsFormat3, tags.getFirst(), tags.getSecond());
                                    if (!matchFound2) continue;
                                    return DeleteTracker.DeleteResult.VERSION_DELETED;
                                }
                            } else if (!VisibilityUtils.isVisibilityTagsPresent(cell)) {
                                return DeleteTracker.DeleteResult.VERSION_DELETED;
                            }
                        } else if (!VisibilityUtils.isVisibilityTagsPresent(cell)) {
                            return DeleteTracker.DeleteResult.VERSION_DELETED;
                        }
                    }
                    break block36;
                }
                if (ret < 0) {
                    this.deleteBuffer = null;
                    this.visibilityTagsDeleteColumns = null;
                    this.visiblityTagsDeleteColumnVersion = null;
                    break block36;
                }
                throw new IllegalStateException("isDeleted failed: deleteBuffer=" + Bytes.toStringBinary(this.deleteBuffer, this.deleteOffset, this.deleteLength) + ", qualifier=" + Bytes.toStringBinary(cell.getQualifierArray(), qualifierOffset, qualifierLength) + ", timestamp=" + timestamp + ", comparison result: " + ret);
            }
            catch (IOException e) {
                LOG.error((Object)"Error in isDeleted() check! Will treat cell as not deleted", (Throwable)e);
            }
        }
        return DeleteTracker.DeleteResult.NOT_DELETED;
    }

    @Override
    public void reset() {
        super.reset();
        this.visibilityTagsDeleteColumns = null;
        this.visibilityTagsDeleteFamily = null;
        this.visibilityTagsDeleteFamilyVersion = null;
        this.visiblityTagsDeleteColumnVersion = null;
    }
}

