/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.security.access;

import java.util.ArrayList;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.Abortable;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.Waiter;
import org.apache.hadoop.hbase.security.User;
import org.apache.hadoop.hbase.security.access.Permission;
import org.apache.hadoop.hbase.security.access.SecureTestUtil;
import org.apache.hadoop.hbase.security.access.TableAuthManager;
import org.apache.hadoop.hbase.security.access.TablePermission;
import org.apache.hadoop.hbase.testclassification.LargeTests;
import org.apache.hadoop.hbase.zookeeper.ZooKeeperWatcher;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={LargeTests.class})
public class TestZKPermissionsWatcher {
    private static final Log LOG = LogFactory.getLog(TestZKPermissionsWatcher.class);
    private static final HBaseTestingUtility UTIL = new HBaseTestingUtility();
    private static TableAuthManager AUTH_A;
    private static TableAuthManager AUTH_B;
    private static final Abortable ABORTABLE;
    private static TableName TEST_TABLE;

    @BeforeClass
    public static void beforeClass() throws Exception {
        Configuration conf = UTIL.getConfiguration();
        SecureTestUtil.enableSecurity(conf);
        UTIL.startMiniCluster();
        AUTH_A = TableAuthManager.getOrCreate(new ZooKeeperWatcher(conf, "TestZKPermissionsWatcher_1", ABORTABLE), conf);
        AUTH_B = TableAuthManager.getOrCreate(new ZooKeeperWatcher(conf, "TestZKPermissionsWatcher_2", ABORTABLE), conf);
    }

    @AfterClass
    public static void afterClass() throws Exception {
        UTIL.shutdownMiniCluster();
    }

    @Test
    public void testPermissionsWatcher() throws Exception {
        Configuration conf = UTIL.getConfiguration();
        User george = User.createUserForTesting(conf, "george", new String[0]);
        User hubert = User.createUserForTesting(conf, "hubert", new String[0]);
        Assert.assertFalse((boolean)AUTH_A.authorizeUser(george, TEST_TABLE, null, Permission.Action.READ));
        Assert.assertFalse((boolean)AUTH_A.authorizeUser(george, TEST_TABLE, null, Permission.Action.WRITE));
        Assert.assertFalse((boolean)AUTH_A.authorizeUser(hubert, TEST_TABLE, null, Permission.Action.READ));
        Assert.assertFalse((boolean)AUTH_A.authorizeUser(hubert, TEST_TABLE, null, Permission.Action.WRITE));
        Assert.assertFalse((boolean)AUTH_B.authorizeUser(george, TEST_TABLE, null, Permission.Action.READ));
        Assert.assertFalse((boolean)AUTH_B.authorizeUser(george, TEST_TABLE, null, Permission.Action.WRITE));
        Assert.assertFalse((boolean)AUTH_B.authorizeUser(hubert, TEST_TABLE, null, Permission.Action.READ));
        Assert.assertFalse((boolean)AUTH_B.authorizeUser(hubert, TEST_TABLE, null, Permission.Action.WRITE));
        ArrayList<TablePermission> acl = new ArrayList<TablePermission>();
        acl.add(new TablePermission(TEST_TABLE, null, Permission.Action.READ, Permission.Action.WRITE));
        final long mtimeB = AUTH_B.getMTime();
        AUTH_A.setTableUserPermissions(george.getShortName(), TEST_TABLE, acl);
        UTIL.waitFor(10000L, 100L, new Waiter.Predicate<Exception>(){

            @Override
            public boolean evaluate() throws Exception {
                return AUTH_B.getMTime() > mtimeB;
            }
        });
        Thread.sleep(1000L);
        Assert.assertTrue((boolean)AUTH_A.authorizeUser(george, TEST_TABLE, null, Permission.Action.READ));
        Assert.assertTrue((boolean)AUTH_A.authorizeUser(george, TEST_TABLE, null, Permission.Action.WRITE));
        Assert.assertTrue((boolean)AUTH_B.authorizeUser(george, TEST_TABLE, null, Permission.Action.READ));
        Assert.assertTrue((boolean)AUTH_B.authorizeUser(george, TEST_TABLE, null, Permission.Action.WRITE));
        Assert.assertFalse((boolean)AUTH_A.authorizeUser(hubert, TEST_TABLE, null, Permission.Action.READ));
        Assert.assertFalse((boolean)AUTH_A.authorizeUser(hubert, TEST_TABLE, null, Permission.Action.WRITE));
        Assert.assertFalse((boolean)AUTH_B.authorizeUser(hubert, TEST_TABLE, null, Permission.Action.READ));
        Assert.assertFalse((boolean)AUTH_B.authorizeUser(hubert, TEST_TABLE, null, Permission.Action.WRITE));
        acl = new ArrayList();
        acl.add(new TablePermission(TEST_TABLE, null, Permission.Action.READ));
        final long mtimeA = AUTH_A.getMTime();
        AUTH_B.setTableUserPermissions("hubert", TEST_TABLE, acl);
        UTIL.waitFor(10000L, 100L, new Waiter.Predicate<Exception>(){

            @Override
            public boolean evaluate() throws Exception {
                return AUTH_A.getMTime() > mtimeA;
            }
        });
        Thread.sleep(1000L);
        Assert.assertTrue((boolean)AUTH_A.authorizeUser(george, TEST_TABLE, null, Permission.Action.READ));
        Assert.assertTrue((boolean)AUTH_A.authorizeUser(george, TEST_TABLE, null, Permission.Action.WRITE));
        Assert.assertTrue((boolean)AUTH_B.authorizeUser(george, TEST_TABLE, null, Permission.Action.READ));
        Assert.assertTrue((boolean)AUTH_B.authorizeUser(george, TEST_TABLE, null, Permission.Action.WRITE));
        Assert.assertTrue((boolean)AUTH_A.authorizeUser(hubert, TEST_TABLE, null, Permission.Action.READ));
        Assert.assertFalse((boolean)AUTH_A.authorizeUser(hubert, TEST_TABLE, null, Permission.Action.WRITE));
        Assert.assertTrue((boolean)AUTH_B.authorizeUser(hubert, TEST_TABLE, null, Permission.Action.READ));
        Assert.assertFalse((boolean)AUTH_B.authorizeUser(hubert, TEST_TABLE, null, Permission.Action.WRITE));
    }

    static {
        ABORTABLE = new Abortable(){
            private final AtomicBoolean abort = new AtomicBoolean(false);

            @Override
            public void abort(String why, Throwable e) {
                LOG.info((Object)why, e);
                this.abort.set(true);
            }

            @Override
            public boolean isAborted() {
                return this.abort.get();
            }
        };
        TEST_TABLE = TableName.valueOf("perms_test");
    }
}

