/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.security.access;

import drill.shaded.hbase.guava.com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.AuthUtil;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.Coprocessor;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.HColumnDescriptor;
import org.apache.hadoop.hbase.HTableDescriptor;
import org.apache.hadoop.hbase.TableNotFoundException;
import org.apache.hadoop.hbase.client.Connection;
import org.apache.hadoop.hbase.client.ConnectionFactory;
import org.apache.hadoop.hbase.client.Delete;
import org.apache.hadoop.hbase.client.Get;
import org.apache.hadoop.hbase.client.HBaseAdmin;
import org.apache.hadoop.hbase.client.HTable;
import org.apache.hadoop.hbase.client.Increment;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.client.ResultScanner;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.client.Table;
import org.apache.hadoop.hbase.master.MasterCoprocessorHost;
import org.apache.hadoop.hbase.regionserver.RegionServerCoprocessorHost;
import org.apache.hadoop.hbase.security.User;
import org.apache.hadoop.hbase.security.access.AccessControlFilter;
import org.apache.hadoop.hbase.security.access.AccessControlLists;
import org.apache.hadoop.hbase.security.access.AccessController;
import org.apache.hadoop.hbase.security.access.Permission;
import org.apache.hadoop.hbase.security.access.SecureTestUtil;
import org.apache.hadoop.hbase.security.access.TableAuthManager;
import org.apache.hadoop.hbase.testclassification.LargeTests;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.TestTableName;
import org.apache.hadoop.hbase.util.Threads;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Rule;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={LargeTests.class})
public class TestCellACLs
extends SecureTestUtil {
    private static final Log LOG = LogFactory.getLog(TestCellACLs.class);
    @Rule
    public TestTableName TEST_TABLE = new TestTableName();
    private static final HBaseTestingUtility TEST_UTIL;
    private static final byte[] TEST_FAMILY;
    private static final byte[] TEST_ROW;
    private static final byte[] TEST_Q1;
    private static final byte[] TEST_Q2;
    private static final byte[] TEST_Q3;
    private static final byte[] TEST_Q4;
    private static final byte[] ZERO;
    private static final byte[] ONE;
    private static Configuration conf;
    private static final String GROUP = "group";
    private static User GROUP_USER;
    private static User USER_OWNER;
    private static User USER_OTHER;
    private static String[] usersAndGroups;

    @BeforeClass
    public static void setupBeforeClass() throws Exception {
        conf = TEST_UTIL.getConfiguration();
        conf.setInt("hbase.regionserver.metahandler.count", 10);
        TestCellACLs.enableSecurity(conf);
        TestCellACLs.verifyConfiguration(conf);
        conf.setBoolean("hbase.security.access.early_out", false);
        TEST_UTIL.startMiniCluster();
        MasterCoprocessorHost cpHost = TEST_UTIL.getMiniHBaseCluster().getMaster().getMasterCoprocessorHost();
        cpHost.load(AccessController.class, 0, conf);
        AccessController ac = (AccessController)cpHost.findCoprocessor(AccessController.class.getName());
        cpHost.createEnvironment((Class)AccessController.class, (Coprocessor)ac, 0, 1, conf);
        RegionServerCoprocessorHost rsHost = TEST_UTIL.getMiniHBaseCluster().getRegionServer(0).getRegionServerCoprocessorHost();
        rsHost.createEnvironment((Class)AccessController.class, (Coprocessor)ac, 0, 1, conf);
        TEST_UTIL.waitTableEnabled(AccessControlLists.ACL_TABLE_NAME);
        USER_OWNER = User.createUserForTesting(conf, "owner", new String[0]);
        USER_OTHER = User.createUserForTesting(conf, "other", new String[0]);
        GROUP_USER = User.createUserForTesting(conf, "group_user", new String[]{GROUP});
        usersAndGroups = new String[]{USER_OTHER.getShortName(), AuthUtil.toGroupEntry(GROUP)};
    }

    @AfterClass
    public static void tearDownAfterClass() throws Exception {
        TEST_UTIL.shutdownMiniCluster();
    }

    @Before
    public void setUp() throws Exception {
        HBaseAdmin admin = TEST_UTIL.getHBaseAdmin();
        HTableDescriptor htd = new HTableDescriptor(this.TEST_TABLE.getTableName());
        HColumnDescriptor hcd = new HColumnDescriptor(TEST_FAMILY);
        hcd.setMaxVersions(4);
        htd.setOwner(USER_OWNER);
        htd.addFamily(hcd);
        admin.createTable(htd, new byte[][]{Bytes.toBytes("s")});
        TEST_UTIL.waitTableEnabled(this.TEST_TABLE.getTableName());
        LOG.info((Object)"Sleeping a second because of HBASE-12581");
        Threads.sleep(1000L);
    }

    @Test(timeout=120000L)
    public void testCellPermissions() throws Exception {
        TestCellACLs.verifyAllowed(new SecureTestUtil.AccessTestAction(){

            @Override
            public Object run() throws Exception {
                try (HTable t = new HTable(TEST_UTIL.getConfiguration(), TestCellACLs.this.TEST_TABLE.getTableName());){
                    Put p = new Put(TEST_ROW).add(TEST_FAMILY, TEST_Q1, ZERO);
                    p.setACL(TestCellACLs.this.prepareCellPermissions(usersAndGroups, new Permission.Action[]{Permission.Action.READ}));
                    t.put(p);
                    p = new Put(TEST_ROW).add(TEST_FAMILY, TEST_Q2, ZERO);
                    p.setACL(TestCellACLs.this.prepareCellPermissions(usersAndGroups, new Permission.Action[]{Permission.Action.READ, Permission.Action.WRITE}));
                    t.put(p);
                    p = new Put(TEST_ROW).add(TEST_FAMILY, TEST_Q3, ZERO).add(TEST_FAMILY, TEST_Q4, ZERO);
                    t.put(p);
                }
                return null;
            }
        }, USER_OWNER);
        SecureTestUtil.AccessTestAction getQ1 = new SecureTestUtil.AccessTestAction(){

            @Override
            public Object run() throws Exception {
                Get get = new Get(TEST_ROW).addColumn(TEST_FAMILY, TEST_Q1);
                try (HTable t = new HTable(TEST_UTIL.getConfiguration(), TestCellACLs.this.TEST_TABLE.getTableName());){
                    List<Cell> list = t.get(get).listCells();
                    return list;
                }
            }
        };
        SecureTestUtil.AccessTestAction getQ2 = new SecureTestUtil.AccessTestAction(){

            @Override
            public Object run() throws Exception {
                Get get = new Get(TEST_ROW).addColumn(TEST_FAMILY, TEST_Q2);
                try (HTable t = new HTable(TEST_UTIL.getConfiguration(), TestCellACLs.this.TEST_TABLE.getTableName());){
                    List<Cell> list = t.get(get).listCells();
                    return list;
                }
            }
        };
        SecureTestUtil.AccessTestAction getQ3 = new SecureTestUtil.AccessTestAction(){

            @Override
            public Object run() throws Exception {
                Get get = new Get(TEST_ROW).addColumn(TEST_FAMILY, TEST_Q3);
                try (HTable t = new HTable(TEST_UTIL.getConfiguration(), TestCellACLs.this.TEST_TABLE.getTableName());){
                    List<Cell> list = t.get(get).listCells();
                    return list;
                }
            }
        };
        SecureTestUtil.AccessTestAction getQ4 = new SecureTestUtil.AccessTestAction(){

            @Override
            public Object run() throws Exception {
                Get get = new Get(TEST_ROW).addColumn(TEST_FAMILY, TEST_Q4);
                try (HTable t = new HTable(TEST_UTIL.getConfiguration(), TestCellACLs.this.TEST_TABLE.getTableName());){
                    List<Cell> list = t.get(get).listCells();
                    return list;
                }
            }
        };
        TestCellACLs.verifyAllowed(getQ1, USER_OTHER, GROUP_USER);
        TestCellACLs.verifyAllowed(getQ2, USER_OTHER, GROUP_USER);
        TestCellACLs.verifyIfNull(getQ3, USER_OTHER, GROUP_USER);
        TestCellACLs.verifyIfNull(getQ4, USER_OTHER, GROUP_USER);
        final ArrayList scanResults = Lists.newArrayList();
        SecureTestUtil.AccessTestAction scanAction = new SecureTestUtil.AccessTestAction(){

            @Override
            public List<Cell> run() throws Exception {
                Scan scan = new Scan();
                scan.setStartRow(TEST_ROW);
                scan.setStopRow(Bytes.add(TEST_ROW, new byte[]{0}));
                scan.addFamily(TEST_FAMILY);
                try (HTable t = new HTable(TEST_UTIL.getConfiguration(), TestCellACLs.this.TEST_TABLE.getTableName());){
                    ResultScanner scanner = t.getScanner(scan);
                    Result result = null;
                    do {
                        if ((result = scanner.next()) == null) continue;
                        scanResults.addAll(result.listCells());
                    } while (result != null);
                }
                return scanResults;
            }
        };
        scanResults.clear();
        TestCellACLs.verifyAllowed(scanAction, USER_OWNER);
        Assert.assertEquals((long)4L, (long)scanResults.size());
        scanResults.clear();
        TestCellACLs.verifyAllowed(scanAction, USER_OTHER);
        Assert.assertEquals((long)2L, (long)scanResults.size());
        scanResults.clear();
        TestCellACLs.verifyAllowed(scanAction, GROUP_USER);
        Assert.assertEquals((long)2L, (long)scanResults.size());
        SecureTestUtil.AccessTestAction incrementQ1 = new SecureTestUtil.AccessTestAction(){

            @Override
            public Object run() throws Exception {
                Increment i = new Increment(TEST_ROW).addColumn(TEST_FAMILY, TEST_Q1, 1L);
                try (HTable t = new HTable(TEST_UTIL.getConfiguration(), TestCellACLs.this.TEST_TABLE.getTableName());){
                    t.increment(i);
                }
                return null;
            }
        };
        SecureTestUtil.AccessTestAction incrementQ2 = new SecureTestUtil.AccessTestAction(){

            @Override
            public Object run() throws Exception {
                Increment i = new Increment(TEST_ROW).addColumn(TEST_FAMILY, TEST_Q2, 1L);
                try (HTable t = new HTable(TEST_UTIL.getConfiguration(), TestCellACLs.this.TEST_TABLE.getTableName());){
                    t.increment(i);
                }
                return null;
            }
        };
        SecureTestUtil.AccessTestAction incrementQ2newDenyACL = new SecureTestUtil.AccessTestAction(){

            @Override
            public Object run() throws Exception {
                Increment i = new Increment(TEST_ROW).addColumn(TEST_FAMILY, TEST_Q2, 1L);
                i.setACL(USER_OTHER.getShortName(), new Permission(Permission.Action.READ));
                try (HTable t = new HTable(TEST_UTIL.getConfiguration(), TestCellACLs.this.TEST_TABLE.getTableName());){
                    t.increment(i);
                }
                return null;
            }
        };
        SecureTestUtil.AccessTestAction incrementQ3 = new SecureTestUtil.AccessTestAction(){

            @Override
            public Object run() throws Exception {
                Increment i = new Increment(TEST_ROW).addColumn(TEST_FAMILY, TEST_Q3, 1L);
                try (HTable t = new HTable(TEST_UTIL.getConfiguration(), TestCellACLs.this.TEST_TABLE.getTableName());){
                    t.increment(i);
                }
                return null;
            }
        };
        TestCellACLs.verifyDenied(incrementQ1, USER_OTHER, GROUP_USER);
        TestCellACLs.verifyDenied(incrementQ3, USER_OTHER, GROUP_USER);
        TestCellACLs.verifyAllowed(incrementQ2, USER_OTHER, GROUP_USER);
        TestCellACLs.verifyAllowed(incrementQ2newDenyACL, USER_OTHER);
        TestCellACLs.verifyDenied(incrementQ2, USER_OTHER, GROUP_USER);
        SecureTestUtil.AccessTestAction deleteFamily = new SecureTestUtil.AccessTestAction(){

            @Override
            public Object run() throws Exception {
                Delete delete = new Delete(TEST_ROW).addFamily(TEST_FAMILY);
                try (HTable t = new HTable(TEST_UTIL.getConfiguration(), TestCellACLs.this.TEST_TABLE.getTableName());){
                    t.delete(delete);
                }
                return null;
            }
        };
        SecureTestUtil.AccessTestAction deleteQ1 = new SecureTestUtil.AccessTestAction(){

            @Override
            public Object run() throws Exception {
                Delete delete = new Delete(TEST_ROW).addColumn(TEST_FAMILY, TEST_Q1);
                try (HTable t = new HTable(TEST_UTIL.getConfiguration(), TestCellACLs.this.TEST_TABLE.getTableName());){
                    t.delete(delete);
                }
                return null;
            }
        };
        TestCellACLs.verifyDenied(deleteFamily, USER_OTHER, GROUP_USER);
        TestCellACLs.verifyDenied(deleteQ1, USER_OTHER, GROUP_USER);
        TestCellACLs.verifyAllowed(deleteQ1, USER_OWNER);
    }

    @Test(timeout=120000L)
    public void testCoveringCheck() throws Exception {
        TestCellACLs.grantOnTable(TEST_UTIL, USER_OTHER.getShortName(), this.TEST_TABLE.getTableName(), TEST_FAMILY, null, Permission.Action.READ);
        TestCellACLs.grantOnTable(TEST_UTIL, AuthUtil.toGroupEntry(GROUP), this.TEST_TABLE.getTableName(), TEST_FAMILY, null, Permission.Action.READ);
        this.verfifyUserDeniedForWrite(USER_OTHER, ZERO);
        this.verfifyUserDeniedForWrite(GROUP_USER, ZERO);
        TestCellACLs.verifyAllowed(new SecureTestUtil.AccessTestAction(){

            @Override
            public Object run() throws Exception {
                try (HTable t = new HTable(TEST_UTIL.getConfiguration(), TestCellACLs.this.TEST_TABLE.getTableName());){
                    Put p = new Put(TEST_ROW).add(TEST_FAMILY, TEST_Q1, ZERO);
                    t.put(p);
                }
                return null;
            }
        }, USER_OWNER);
        this.verfifyUserDeniedForWrite(USER_OTHER, ONE);
        this.verfifyUserDeniedForWrite(GROUP_USER, ONE);
        this.verifyUserAllowedForRead(USER_OTHER);
        this.verifyUserAllowedForRead(GROUP_USER);
    }

    private void verfifyUserDeniedForWrite(User user, final byte[] value) throws Exception {
        TestCellACLs.verifyDenied(new SecureTestUtil.AccessTestAction(){

            @Override
            public Object run() throws Exception {
                try (Connection connection = ConnectionFactory.createConnection(conf);
                     Table t = connection.getTable(TestCellACLs.this.TEST_TABLE.getTableName());){
                    Put p = new Put(TEST_ROW).addColumn(TEST_FAMILY, TEST_Q1, value);
                    t.put(p);
                }
                return null;
            }
        }, user);
    }

    private void verifyUserAllowedForRead(User user) throws Exception {
        TestCellACLs.verifyAllowed(new SecureTestUtil.AccessTestAction(){

            /*
             * Exception decompiling
             */
            @Override
            public Object run() throws Exception {
                /*
                 * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
                 * 
                 * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
                 *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
                 *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
                 *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
                 *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
                 *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
                 *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
                 *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
                 *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
                 *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
                 *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
                 *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
                 *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
                 *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
                 *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
                 *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
                 *     at org.benf.cfr.reader.Main.main(Main.java:54)
                 */
                throw new IllegalStateException("Decompilation failed");
            }
        }, user);
    }

    private Map<String, Permission> prepareCellPermissions(String[] users, Permission.Action ... action) {
        HashMap<String, Permission> perms = new HashMap<String, Permission>(2);
        for (String user : users) {
            perms.put(user, new Permission(action));
        }
        return perms;
    }

    @After
    public void tearDown() throws Exception {
        try {
            TEST_UTIL.deleteTable(this.TEST_TABLE.getTableName());
        }
        catch (TableNotFoundException ex) {
            LOG.info((Object)("Test deleted table " + this.TEST_TABLE.getTableName()));
        }
        Assert.assertEquals((long)0L, (long)AccessControlLists.getTablePermissions(conf, this.TEST_TABLE.getTableName()).size());
    }

    static {
        Logger.getLogger(AccessController.class).setLevel(Level.TRACE);
        Logger.getLogger(AccessControlFilter.class).setLevel(Level.TRACE);
        Logger.getLogger(TableAuthManager.class).setLevel(Level.TRACE);
        TEST_UTIL = new HBaseTestingUtility();
        TEST_FAMILY = Bytes.toBytes("f1");
        TEST_ROW = Bytes.toBytes("cellpermtest");
        TEST_Q1 = Bytes.toBytes("q1");
        TEST_Q2 = Bytes.toBytes("q2");
        TEST_Q3 = Bytes.toBytes("q3");
        TEST_Q4 = Bytes.toBytes("q4");
        ZERO = Bytes.toBytes(0L);
        ONE = Bytes.toBytes(1L);
    }
}

