/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.security;

import drill.shaded.hbase.guava.com.google.common.collect.ImmutableSet;
import java.io.IOException;
import java.security.PrivilegedAction;
import java.security.PrivilegedExceptionAction;
import org.apache.commons.lang.SystemUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.HBaseConfiguration;
import org.apache.hadoop.hbase.security.User;
import org.apache.hadoop.hbase.security.UserProvider;
import org.apache.hadoop.hbase.testclassification.SmallTests;
import org.apache.hadoop.security.UserGroupInformation;
import org.junit.Assert;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={SmallTests.class})
public class TestUser {
    private static final Log LOG = LogFactory.getLog(TestUser.class);

    @Test
    public void testCreateUserForTestingGroupCache() throws Exception {
        Configuration conf = HBaseConfiguration.create();
        User uCreated = User.createUserForTesting(conf, "group_user", new String[]{"MYGROUP"});
        UserProvider up = UserProvider.instantiate(conf);
        User uProvided = up.create(UserGroupInformation.createRemoteUser((String)"group_user"));
        Assert.assertArrayEquals((Object[])uCreated.getGroupNames(), (Object[])uProvided.getGroupNames());
    }

    @Test
    public void testCacheGetGroups() throws Exception {
        Configuration conf = HBaseConfiguration.create();
        UserProvider up = UserProvider.instantiate(conf);
        String nonUser = "kklvfnvhdhcenfnniilggljhdecjhidkle";
        UserGroupInformation ugiOne = UserGroupInformation.createRemoteUser((String)nonUser);
        UserGroupInformation ugiTwo = UserGroupInformation.createRemoteUser((String)nonUser);
        User uOne = up.create(ugiOne);
        User uTwo = up.create(ugiTwo);
        Assert.assertArrayEquals((Object[])uOne.getGroupNames(), (Object[])uTwo.getGroupNames());
        Assert.assertTrue((uOne.getGroupNames() == uTwo.getGroupNames() ? 1 : 0) != 0);
        Assert.assertEquals((long)0L, (long)ugiOne.getGroupNames().length);
    }

    @Test
    public void testCacheGetGroupsRoot() throws Exception {
        if (!SystemUtils.IS_OS_WINDOWS) {
            Configuration conf = HBaseConfiguration.create();
            UserProvider up = UserProvider.instantiate(conf);
            String rootUserName = "root";
            UserGroupInformation ugiOne = UserGroupInformation.createRemoteUser((String)rootUserName);
            UserGroupInformation ugiTwo = UserGroupInformation.createRemoteUser((String)rootUserName);
            User uOne = up.create(ugiOne);
            User uTwo = up.create(ugiTwo);
            Assert.assertArrayEquals((Object[])uOne.getGroupNames(), (Object[])uTwo.getGroupNames());
            String[] groupNames = ugiOne.getGroupNames();
            Assert.assertTrue((groupNames.length > 0 ? 1 : 0) != 0);
        }
    }

    @Test
    public void testBasicAttributes() throws Exception {
        Configuration conf = HBaseConfiguration.create();
        User user = User.createUserForTesting(conf, "simple", new String[]{"foo"});
        Assert.assertEquals((String)"Username should match", (Object)"simple", (Object)user.getName());
        Assert.assertEquals((String)"Short username should match", (Object)"simple", (Object)user.getShortName());
    }

    @Test
    public void testRunAs() throws Exception {
        Configuration conf = HBaseConfiguration.create();
        final User user = User.createUserForTesting(conf, "testuser", new String[]{"foo"});
        final PrivilegedExceptionAction<String> action = new PrivilegedExceptionAction<String>(){

            @Override
            public String run() throws IOException {
                User u = User.getCurrent();
                return u.getName();
            }
        };
        String username = user.runAs(action);
        Assert.assertEquals((String)"Current user within runAs() should match", (Object)"testuser", (Object)username);
        User user2 = User.createUserForTesting(conf, "testuser2", new String[]{"foo"});
        String username2 = user2.runAs(action);
        Assert.assertEquals((String)"Second username should match second user", (Object)"testuser2", (Object)username2);
        username = user.runAs(new PrivilegedExceptionAction<String>(){

            @Override
            public String run() throws Exception {
                return User.getCurrent().getName();
            }
        });
        Assert.assertEquals((String)"User name in runAs() should match", (Object)"testuser", (Object)username);
        user2.runAs(new PrivilegedExceptionAction<Object>(){

            @Override
            public Object run() throws IOException, InterruptedException {
                String nestedName = (String)user.runAs(action);
                Assert.assertEquals((String)"Nest name should match nested user", (Object)"testuser", (Object)nestedName);
                Assert.assertEquals((String)"Current name should match current user", (Object)"testuser2", (Object)User.getCurrent().getName());
                return null;
            }
        });
        username = user.runAs(new PrivilegedAction<String>(){
            String result = null;

            @Override
            public String run() {
                try {
                    return User.getCurrent().getName();
                }
                catch (IOException e) {
                    this.result = "empty";
                    return this.result;
                }
            }
        });
        Assert.assertEquals((String)"Current user within runAs() should match", (Object)"testuser", (Object)username);
    }

    @Test
    public void testGetCurrent() throws Exception {
        User user1 = User.getCurrent();
        Assert.assertNotNull((Object)user1.ugi);
        LOG.debug((Object)("User1 is " + user1.getName()));
        for (int i = 0; i < 100; ++i) {
            User u = User.getCurrent();
            Assert.assertNotNull((Object)u);
            Assert.assertEquals((Object)user1.getName(), (Object)u.getName());
            Assert.assertEquals((Object)user1, (Object)u);
            Assert.assertEquals((long)user1.hashCode(), (long)u.hashCode());
        }
    }

    @Test
    public void testUserGroupNames() throws Exception {
        String username = "testuser";
        ImmutableSet<String> singleGroups = ImmutableSet.of("group");
        Configuration conf = HBaseConfiguration.create();
        User user = User.createUserForTesting(conf, "testuser", singleGroups.toArray(new String[singleGroups.size()]));
        this.assertUserGroup(user, singleGroups);
        ImmutableSet<String> multiGroups = ImmutableSet.of("group", "group1", "group2");
        user = User.createUserForTesting(conf, "testuser", multiGroups.toArray(new String[multiGroups.size()]));
        this.assertUserGroup(user, multiGroups);
    }

    private void assertUserGroup(User user, ImmutableSet<String> groups) {
        Assert.assertNotNull((String)"GroupNames should be not null", (Object)user.getGroupNames());
        Assert.assertTrue((String)("UserGroupNames length should be == " + groups.size()), (user.getGroupNames().length == groups.size() ? 1 : 0) != 0);
        for (String group : user.getGroupNames()) {
            Assert.assertTrue((String)"groupName should be in set ", (boolean)groups.contains(group));
        }
    }

    @Test
    public void testSecurityForNonSecureHadoop() {
        Assert.assertFalse((String)"Security should be disable in non-secure Hadoop", (boolean)User.isSecurityEnabled());
        Configuration conf = HBaseConfiguration.create();
        conf.set("hadoop.security.authentication", "kerberos");
        conf.set("hbase.security.authentication", "kerberos");
        Assert.assertTrue((String)"Security should be enabled", (boolean)User.isHBaseSecurityEnabled(conf));
        conf = HBaseConfiguration.create();
        conf.set("hadoop.security.authentication", "kerberos");
        Assert.assertFalse((String)"HBase security should not be enabled if hbase.security.authentication is not set accordingly", (boolean)User.isHBaseSecurityEnabled(conf));
        conf = HBaseConfiguration.create();
        conf.set("hbase.security.authentication", "kerberos");
        Assert.assertTrue((String)"HBase security should be enabled regardless of underlying HDFS settings", (boolean)User.isHBaseSecurityEnabled(conf));
    }
}

