/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.replication;

import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.hbase.ClusterStatus;
import org.apache.hadoop.hbase.ServerLoad;
import org.apache.hadoop.hbase.ServerName;
import org.apache.hadoop.hbase.client.Admin;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.replication.ReplicationLoadSink;
import org.apache.hadoop.hbase.replication.ReplicationLoadSource;
import org.apache.hadoop.hbase.replication.TestReplicationBase;
import org.apache.hadoop.hbase.testclassification.MediumTests;
import org.apache.hadoop.hbase.util.Bytes;
import org.junit.Assert;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={MediumTests.class})
public class TestReplicationStatus
extends TestReplicationBase {
    private static final Log LOG = LogFactory.getLog(TestReplicationStatus.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=300000L)
    public void testReplicationStatus() throws Exception {
        LOG.info((Object)"testReplicationStatus");
        try (Admin hbaseAdmin = utility1.getConnection().getAdmin();){
            admin.disablePeer("2");
            byte[] qualName = Bytes.toBytes("q");
            for (int i = 0; i < 100; ++i) {
                Put p = new Put(Bytes.toBytes("row" + i));
                p.add(famName, qualName, Bytes.toBytes("val" + i));
                htable1.put(p);
            }
            ClusterStatus status = hbaseAdmin.getClusterStatus();
            for (ServerName server : status.getServers()) {
                ServerLoad sl = status.getLoad(server);
                List<ReplicationLoadSource> rLoadSourceList = sl.getReplicationLoadSourceList();
                ReplicationLoadSink rLoadSink = sl.getReplicationLoadSink();
                Assert.assertTrue((String)"failed to get ReplicationLoadSourceList", (rLoadSourceList.size() == 1 ? 1 : 0) != 0);
                Assert.assertEquals((Object)"2", (Object)rLoadSourceList.get(0).getPeerID());
                Assert.assertTrue((String)"failed to get ReplicationLoadSink.AgeOfLastShippedOp ", (rLoadSink.getAgeOfLastAppliedOp() >= 0L ? 1 : 0) != 0);
                Assert.assertTrue((String)"failed to get ReplicationLoadSink.TimeStampsOfLastAppliedOp ", (rLoadSink.getTimeStampsOfLastAppliedOp() >= 0L ? 1 : 0) != 0);
            }
            utility1.getHBaseCluster().getRegionServer(1).stop("Stop RegionServer");
            Thread.sleep(10000L);
            status = hbaseAdmin.getClusterStatus();
            ServerName server = utility1.getHBaseCluster().getRegionServer(0).getServerName();
            ServerLoad sl = status.getLoad(server);
            List<ReplicationLoadSource> rLoadSourceList = sl.getReplicationLoadSourceList();
            Assert.assertTrue((String)"failed to get ReplicationLoadSourceList", (rLoadSourceList.size() == 1 ? 1 : 0) != 0);
            Assert.assertEquals((Object)"2", (Object)rLoadSourceList.get(0).getPeerID());
        }
        finally {
            admin.enablePeer("2");
            utility1.getHBaseCluster().getRegionServer(1).start();
        }
    }
}

