/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.replication;

import com.google.protobuf.ByteString;
import com.google.protobuf.Message;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.classification.InterfaceAudience;
import org.apache.hadoop.hbase.classification.InterfaceStability;
import org.apache.hadoop.hbase.exceptions.DeserializationException;
import org.apache.hadoop.hbase.protobuf.ProtobufUtil;
import org.apache.hadoop.hbase.protobuf.generated.HBaseProtos;
import org.apache.hadoop.hbase.protobuf.generated.ZooKeeperProtos;
import org.apache.hadoop.hbase.replication.ReplicationPeerConfig;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.Strings;

@InterfaceAudience.Private
@InterfaceStability.Stable
public final class ReplicationSerDeHelper {
    private static final Log LOG = LogFactory.getLog(ReplicationSerDeHelper.class);

    private ReplicationSerDeHelper() {
    }

    public static ZooKeeperProtos.TableCF[] convert(Map<TableName, ? extends Collection<String>> tableCfs) {
        if (tableCfs == null) {
            return null;
        }
        ArrayList<ZooKeeperProtos.TableCF> tableCFList = new ArrayList<ZooKeeperProtos.TableCF>();
        ZooKeeperProtos.TableCF.Builder tableCFBuilder = ZooKeeperProtos.TableCF.newBuilder();
        for (Map.Entry<TableName, ? extends Collection<String>> entry : tableCfs.entrySet()) {
            tableCFBuilder.clear();
            tableCFBuilder.setTableName(ProtobufUtil.toProtoTableName(entry.getKey()));
            Collection<String> v = entry.getValue();
            if (v != null && !v.isEmpty()) {
                for (String value : entry.getValue()) {
                    tableCFBuilder.addFamilies(ByteString.copyFromUtf8((String)value));
                }
            }
            tableCFList.add(tableCFBuilder.build());
        }
        return tableCFList.toArray(new ZooKeeperProtos.TableCF[tableCFList.size()]);
    }

    public static String convertToString(Map<TableName, ? extends Collection<String>> tableCfs) {
        if (tableCfs == null) {
            return null;
        }
        return ReplicationSerDeHelper.convert(ReplicationSerDeHelper.convert(tableCfs));
    }

    public static ZooKeeperProtos.TableCF[] convert(String tableCFsConfig) {
        String[] tables;
        if (tableCFsConfig == null || tableCFsConfig.trim().length() == 0) {
            return null;
        }
        ArrayList<ZooKeeperProtos.TableCF> tableCFList = new ArrayList<ZooKeeperProtos.TableCF>();
        ZooKeeperProtos.TableCF.Builder tableCFBuilder = ZooKeeperProtos.TableCF.newBuilder();
        for (String tab : tables = tableCFsConfig.split(";")) {
            if ((tab = tab.trim()).length() == 0) continue;
            String[] pair = tab.split(":");
            String tabName = pair[0].trim();
            if (pair.length > 2 || tabName.length() == 0) {
                LOG.info((Object)("incorrect format:" + tableCFsConfig));
                continue;
            }
            tableCFBuilder.clear();
            String ns = "default";
            String tName = tabName;
            String[] dbs = tabName.split("\\.");
            if (dbs != null && dbs.length == 2) {
                ns = dbs[0];
                tName = dbs[1];
            }
            tableCFBuilder.setTableName(ProtobufUtil.toProtoTableName(TableName.valueOf(ns, tName)));
            if (pair.length == 2) {
                String[] cfsList;
                for (String cf : cfsList = pair[1].split(",")) {
                    String cfName = cf.trim();
                    if (cfName.length() <= 0) continue;
                    tableCFBuilder.addFamilies(ByteString.copyFromUtf8((String)cfName));
                }
            }
            tableCFList.add(tableCFBuilder.build());
        }
        return tableCFList.toArray(new ZooKeeperProtos.TableCF[tableCFList.size()]);
    }

    public static String convert(ZooKeeperProtos.TableCF[] tableCFs) {
        StringBuilder sb = new StringBuilder();
        for (ZooKeeperProtos.TableCF tableCF : tableCFs) {
            String namespace = tableCF.getTableName().getNamespace().toStringUtf8();
            if (!Strings.isEmpty(namespace)) {
                sb.append(namespace).append(".").append(tableCF.getTableName().getQualifier().toStringUtf8()).append(":");
            } else {
                sb.append(tableCF.getTableName().toString()).append(":");
            }
            for (int j = 0; j < tableCF.getFamiliesCount(); ++j) {
                sb.append(tableCF.getFamilies(j).toStringUtf8()).append(",");
            }
            sb.deleteCharAt(sb.length() - 1).append(";");
        }
        if (sb.length() > 0) {
            sb.deleteCharAt(sb.length() - 1);
        }
        return sb.toString();
    }

    public static ZooKeeperProtos.TableCF getTableCF(ZooKeeperProtos.TableCF[] tableCFs, String table) {
        for (ZooKeeperProtos.TableCF tableCF : tableCFs) {
            if (!tableCF.getTableName().getQualifier().toStringUtf8().equals(table)) continue;
            return tableCF;
        }
        return null;
    }

    public static ZooKeeperProtos.TableCF[] parseTableCFs(byte[] bytes) throws IOException {
        if (bytes == null) {
            return null;
        }
        return ReplicationSerDeHelper.convert(Bytes.toString(bytes));
    }

    public static Map<TableName, List<String>> parseTableCFsFromConfig(String tableCFsConfig) {
        ZooKeeperProtos.TableCF[] tableCFs = ReplicationSerDeHelper.convert(tableCFsConfig);
        return ReplicationSerDeHelper.convert2Map(tableCFs);
    }

    public static Map<TableName, List<String>> convert2Map(ZooKeeperProtos.TableCF[] tableCFs) {
        if (tableCFs == null || tableCFs.length == 0) {
            return null;
        }
        HashMap<TableName, List<String>> tableCFsMap = new HashMap<TableName, List<String>>();
        for (ZooKeeperProtos.TableCF tableCF : tableCFs) {
            ArrayList<String> families = new ArrayList<String>();
            int m = tableCF.getFamiliesCount();
            for (int j = 0; j < m; ++j) {
                families.add(tableCF.getFamilies(j).toStringUtf8());
            }
            if (families.size() > 0) {
                tableCFsMap.put(ProtobufUtil.toTableName(tableCF.getTableName()), families);
                continue;
            }
            tableCFsMap.put(ProtobufUtil.toTableName(tableCF.getTableName()), null);
        }
        return tableCFsMap;
    }

    public static ReplicationPeerConfig parsePeerFrom(byte[] bytes) throws DeserializationException {
        if (ProtobufUtil.isPBMagicPrefix(bytes)) {
            ZooKeeperProtos.ReplicationPeer peer;
            int pblen = ProtobufUtil.lengthOfPBMagic();
            ZooKeeperProtos.ReplicationPeer.Builder builder = ZooKeeperProtos.ReplicationPeer.newBuilder();
            try {
                ProtobufUtil.mergeFrom((Message.Builder)builder, bytes, pblen, bytes.length - pblen);
                peer = builder.build();
            }
            catch (IOException e) {
                throw new DeserializationException(e);
            }
            return ReplicationSerDeHelper.convert(peer);
        }
        if (bytes.length > 0) {
            return new ReplicationPeerConfig().setClusterKey(Bytes.toString(bytes));
        }
        return new ReplicationPeerConfig().setClusterKey("");
    }

    private static ReplicationPeerConfig convert(ZooKeeperProtos.ReplicationPeer peer) {
        ReplicationPeerConfig peerConfig = new ReplicationPeerConfig();
        if (peer.hasClusterkey()) {
            peerConfig.setClusterKey(peer.getClusterkey());
        }
        if (peer.hasReplicationEndpointImpl()) {
            peerConfig.setReplicationEndpointImpl(peer.getReplicationEndpointImpl());
        }
        for (HBaseProtos.BytesBytesPair bytesBytesPair : peer.getDataList()) {
            peerConfig.getPeerData().put(bytesBytesPair.getFirst().toByteArray(), bytesBytesPair.getSecond().toByteArray());
        }
        for (HBaseProtos.NameStringPair nameStringPair : peer.getConfigurationList()) {
            peerConfig.getConfiguration().put(nameStringPair.getName(), nameStringPair.getValue());
        }
        Map<TableName, List<String>> tableCFsMap = ReplicationSerDeHelper.convert2Map(peer.getTableCfsList().toArray(new ZooKeeperProtos.TableCF[peer.getTableCfsCount()]));
        if (tableCFsMap != null) {
            peerConfig.setTableCFsMap(tableCFsMap);
        }
        if (peer.hasBandwidth()) {
            peerConfig.setBandwidth(peer.getBandwidth());
        }
        return peerConfig;
    }

    public static byte[] toByteArray(ReplicationPeerConfig peerConfig) {
        byte[] bytes = ReplicationSerDeHelper.convert(peerConfig).toByteArray();
        return ProtobufUtil.prependPBMagic(bytes);
    }

    /*
     * WARNING - void declaration
     */
    private static ZooKeeperProtos.ReplicationPeer convert(ReplicationPeerConfig peerConfig) {
        ZooKeeperProtos.ReplicationPeer.Builder builder = ZooKeeperProtos.ReplicationPeer.newBuilder();
        if (peerConfig.getClusterKey() != null) {
            builder.setClusterkey(peerConfig.getClusterKey());
        }
        if (peerConfig.getReplicationEndpointImpl() != null) {
            builder.setReplicationEndpointImpl(peerConfig.getReplicationEndpointImpl());
        }
        for (Map.Entry<byte[], byte[]> entry : peerConfig.getPeerData().entrySet()) {
            builder.addData(HBaseProtos.BytesBytesPair.newBuilder().setFirst(ByteString.copyFrom((byte[])entry.getKey())).setSecond(ByteString.copyFrom((byte[])entry.getValue())).build());
        }
        for (Map.Entry<Object, Object> entry : peerConfig.getConfiguration().entrySet()) {
            builder.addConfiguration(HBaseProtos.NameStringPair.newBuilder().setName((String)entry.getKey()).setValue((String)entry.getValue()).build());
        }
        ZooKeeperProtos.TableCF[] tableCFs = ReplicationSerDeHelper.convert(peerConfig.getTableCFsMap());
        if (tableCFs != null) {
            void var3_7;
            boolean bl = false;
            while (var3_7 < tableCFs.length) {
                builder.addTableCfs(tableCFs[var3_7]);
                ++var3_7;
            }
        }
        builder.setBandwidth(peerConfig.getBandwidth());
        return builder.build();
    }
}

