/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.regionserver.wal;

import java.io.IOException;
import java.util.LinkedList;
import java.util.Queue;
import org.apache.hadoop.hbase.regionserver.wal.HLogKey;
import org.apache.hadoop.hbase.regionserver.wal.SequenceFileLogReader;
import org.apache.hadoop.hbase.regionserver.wal.WALEdit;
import org.apache.hadoop.hbase.wal.WAL;

public class FaultySequenceFileLogReader
extends SequenceFileLogReader {
    Queue<WAL.Entry> nextQueue = new LinkedList<WAL.Entry>();
    int numberOfFileEntries = 0;

    FailureType getFailureType() {
        return FailureType.valueOf(this.conf.get("faultysequencefilelogreader.failuretype", "NONE"));
    }

    @Override
    public WAL.Entry next(WAL.Entry reuse) throws IOException {
        WAL.Entry e;
        this.entryStart = this.getPosition();
        boolean b = true;
        if (this.nextQueue.isEmpty()) {
            while (b) {
                e = new WAL.Entry(new HLogKey(), new WALEdit());
                if (this.compressionContext != null) {
                    e.setCompressionContext(this.compressionContext);
                }
                b = this.readNext(e);
                this.nextQueue.offer(e);
                ++this.numberOfFileEntries;
            }
        }
        if (this.nextQueue.size() == this.numberOfFileEntries && this.getFailureType() == FailureType.BEGINNING) {
            throw this.addFileInfoToException(new IOException("fake Exception"));
        }
        if (this.nextQueue.size() == this.numberOfFileEntries / 2 && this.getFailureType() == FailureType.MIDDLE) {
            throw this.addFileInfoToException(new IOException("fake Exception"));
        }
        if (this.nextQueue.size() == 1 && this.getFailureType() == FailureType.END) {
            throw this.addFileInfoToException(new IOException("fake Exception"));
        }
        if (this.nextQueue.peek() != null) {
            ++this.edit;
        }
        if ((e = this.nextQueue.poll()).getEdit().isEmpty()) {
            return null;
        }
        return e;
    }

    public static enum FailureType {
        BEGINNING,
        MIDDLE,
        END,
        NONE;

    }
}

