/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.regionserver.querymatcher;

import java.io.IOException;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.KeyValue;
import org.apache.hadoop.hbase.KeyValueUtil;
import org.apache.hadoop.hbase.classification.InterfaceAudience;
import org.apache.hadoop.hbase.filter.Filter;
import org.apache.hadoop.hbase.regionserver.DeleteTracker;
import org.apache.hadoop.hbase.regionserver.HStore;
import org.apache.hadoop.hbase.regionserver.RegionCoprocessorHost;
import org.apache.hadoop.hbase.regionserver.ScanInfo;
import org.apache.hadoop.hbase.regionserver.querymatcher.ColumnCount;
import org.apache.hadoop.hbase.regionserver.querymatcher.ColumnTracker;
import org.apache.hadoop.hbase.regionserver.querymatcher.ScanDeleteTracker;

@InterfaceAudience.Private
public abstract class ScanQueryMatcher {
    protected final KeyValue.KVComparator rowComparator;
    protected final Cell startKey;
    protected final ColumnTracker columns;
    protected final long oldestUnexpiredTS;
    protected final long now;
    protected Cell currentRow;

    protected ScanQueryMatcher(Cell startKey, ScanInfo scanInfo, ColumnTracker columns, long oldestUnexpiredTS, long now) {
        this.rowComparator = scanInfo.getComparator();
        this.startKey = startKey;
        this.oldestUnexpiredTS = oldestUnexpiredTS;
        this.now = now;
        this.columns = columns;
    }

    protected static Cell createStartKeyFromRow(byte[] startRow, ScanInfo scanInfo) {
        return KeyValueUtil.createFirstDeleteFamilyOnRow(startRow, scanInfo.getFamily());
    }

    protected final MatchCode preCheck(Cell cell) {
        if (this.currentRow == null) {
            return MatchCode.DONE;
        }
        if (this.rowComparator.compareRows(this.currentRow, cell) != 0) {
            return MatchCode.DONE;
        }
        if (this.columns.done()) {
            return MatchCode.SEEK_NEXT_ROW;
        }
        long timestamp = cell.getTimestamp();
        if (timestamp == Long.MIN_VALUE || this.columns.isDone(timestamp)) {
            return this.columns.getNextRowOrNextColumn(cell.getQualifierArray(), cell.getQualifierOffset(), cell.getQualifierLength());
        }
        if (HStore.isCellTTLExpired(cell, this.oldestUnexpiredTS, this.now)) {
            return MatchCode.SKIP;
        }
        return null;
    }

    protected final MatchCode checkDeleted(DeleteTracker deletes, Cell cell) {
        if (deletes.isEmpty()) {
            return null;
        }
        DeleteTracker.DeleteResult deleteResult = deletes.isDeleted(cell);
        switch (deleteResult) {
            case FAMILY_DELETED: 
            case COLUMN_DELETED: {
                return this.columns.getNextRowOrNextColumn(cell.getQualifierArray(), cell.getQualifierOffset(), cell.getQualifierLength());
            }
            case VERSION_DELETED: 
            case FAMILY_VERSION_DELETED: {
                return MatchCode.SKIP;
            }
            case NOT_DELETED: {
                return null;
            }
        }
        throw new RuntimeException("Unexpected delete result: " + (Object)((Object)deleteResult));
    }

    public abstract MatchCode match(Cell var1) throws IOException;

    public Cell getStartKey() {
        return this.startKey;
    }

    public abstract boolean hasNullColumnInQuery();

    public Cell currentRow() {
        return this.currentRow;
    }

    public void clearCurrentRow() {
        this.currentRow = null;
    }

    protected abstract void reset();

    public void setToNewRow(Cell currentRow) {
        this.currentRow = currentRow;
        this.columns.reset();
        this.reset();
    }

    public abstract boolean isUserScan();

    public abstract boolean moreRowsMayExistAfter(Cell var1);

    public Cell getKeyForNextColumn(Cell cell) {
        Cell nextKey;
        if (cell.getQualifierLength() == 0 && (nextKey = ScanQueryMatcher.createNextOnRowCol(cell)) != cell) {
            return nextKey;
        }
        ColumnCount nextColumn = this.columns.getColumnHint();
        if (nextColumn == null) {
            return KeyValueUtil.createLastOnRow(cell.getRowArray(), cell.getRowOffset(), cell.getRowLength(), cell.getFamilyArray(), cell.getFamilyOffset(), cell.getFamilyLength(), cell.getQualifierArray(), cell.getQualifierOffset(), cell.getQualifierLength());
        }
        return KeyValueUtil.createFirstOnRow(cell.getRowArray(), cell.getRowOffset(), cell.getRowLength(), cell.getFamilyArray(), cell.getFamilyOffset(), cell.getFamilyLength(), nextColumn.getBuffer(), nextColumn.getOffset(), nextColumn.getLength());
    }

    public int compareKeyForNextRow(Cell nextIndexed, Cell currentCell) {
        return this.rowComparator.compareKey(nextIndexed, currentCell.getRowArray(), currentCell.getRowOffset(), currentCell.getRowLength(), null, 0, 0, null, 0, 0, Long.MIN_VALUE, KeyValue.Type.Minimum.getCode());
    }

    public int compareKeyForNextColumn(Cell nextIndexed, Cell currentCell) {
        ColumnCount nextColumn = this.columns.getColumnHint();
        if (nextColumn == null) {
            return this.rowComparator.compareKey(nextIndexed, currentCell.getRowArray(), currentCell.getRowOffset(), currentCell.getRowLength(), currentCell.getFamilyArray(), currentCell.getFamilyOffset(), currentCell.getFamilyLength(), currentCell.getQualifierArray(), currentCell.getQualifierOffset(), currentCell.getQualifierLength(), Long.MIN_VALUE, KeyValue.Type.Minimum.getCode());
        }
        return this.rowComparator.compareKey(nextIndexed, currentCell.getRowArray(), currentCell.getRowOffset(), currentCell.getRowLength(), currentCell.getFamilyArray(), currentCell.getFamilyOffset(), currentCell.getFamilyLength(), nextColumn.getBuffer(), nextColumn.getOffset(), nextColumn.getLength(), Long.MAX_VALUE, KeyValue.Type.Maximum.getCode());
    }

    public abstract Filter getFilter();

    public abstract Cell getNextKeyHint(Cell var1) throws IOException;

    protected static DeleteTracker instantiateDeleteTracker(RegionCoprocessorHost host) throws IOException {
        DeleteTracker tracker = new ScanDeleteTracker();
        if (host != null) {
            tracker = host.postInstantiateDeleteTracker(tracker);
        }
        return tracker;
    }

    static MatchCode checkColumn(ColumnTracker columnTracker, byte[] bytes, int offset, int length, long ttl, byte type, boolean ignoreCount) throws IOException {
        MatchCode matchCode = columnTracker.checkColumn(bytes, offset, length, type);
        if (matchCode == MatchCode.INCLUDE) {
            return columnTracker.checkVersions(bytes, offset, length, ttl, type, ignoreCount);
        }
        return matchCode;
    }

    private static Cell createNextOnRowCol(Cell cell) {
        long ts = cell.getTimestamp();
        byte type = cell.getTypeByte();
        if (type != KeyValue.Type.Minimum.getCode()) {
            type = KeyValue.Type.values()[KeyValue.Type.codeToType(type).ordinal() - 1].getCode();
        } else if (ts != Long.MIN_VALUE) {
            --ts;
            type = KeyValue.Type.Maximum.getCode();
        } else {
            return cell;
        }
        return ScanQueryMatcher.createNextOnRowCol(cell, ts, type);
    }

    private static Cell createNextOnRowCol(final Cell cell, final long ts, final byte type) {
        return new Cell(){

            @Override
            public byte[] getRowArray() {
                return cell.getRowArray();
            }

            @Override
            public int getRowOffset() {
                return cell.getRowOffset();
            }

            @Override
            public short getRowLength() {
                return cell.getRowLength();
            }

            @Override
            public byte[] getFamilyArray() {
                return cell.getFamilyArray();
            }

            @Override
            public int getFamilyOffset() {
                return cell.getFamilyOffset();
            }

            @Override
            public byte getFamilyLength() {
                return cell.getFamilyLength();
            }

            @Override
            public byte[] getQualifierArray() {
                return cell.getQualifierArray();
            }

            @Override
            public int getQualifierOffset() {
                return cell.getQualifierOffset();
            }

            @Override
            public int getQualifierLength() {
                return cell.getQualifierLength();
            }

            @Override
            public long getTimestamp() {
                return ts;
            }

            @Override
            public byte getTypeByte() {
                return type;
            }

            @Override
            public long getMvccVersion() {
                return cell.getMvccVersion();
            }

            @Override
            public long getSequenceId() {
                return cell.getSequenceId();
            }

            @Override
            public byte[] getValueArray() {
                return cell.getValueArray();
            }

            @Override
            public int getValueOffset() {
                return cell.getValueOffset();
            }

            @Override
            public int getValueLength() {
                return cell.getValueLength();
            }

            @Override
            public byte[] getTagsArray() {
                return cell.getTagsArray();
            }

            @Override
            public int getTagsOffset() {
                return cell.getTagsOffset();
            }

            @Override
            public int getTagsLength() {
                return cell.getTagsLength();
            }

            @Override
            public byte[] getValue() {
                return cell.getValue();
            }

            @Override
            public byte[] getFamily() {
                return cell.getFamily();
            }

            @Override
            public byte[] getQualifier() {
                return cell.getQualifier();
            }

            @Override
            public byte[] getRow() {
                return cell.getRow();
            }
        };
    }

    public static enum MatchCode {
        INCLUDE,
        SKIP,
        NEXT,
        DONE,
        SEEK_NEXT_ROW,
        SEEK_NEXT_COL,
        DONE_SCAN,
        SEEK_NEXT_USING_HINT,
        INCLUDE_AND_SEEK_NEXT_COL,
        INCLUDE_AND_SEEK_NEXT_ROW;

    }
}

