/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.regionserver.querymatcher;

import java.io.IOException;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.CellUtil;
import org.apache.hadoop.hbase.classification.InterfaceAudience;
import org.apache.hadoop.hbase.regionserver.DeleteTracker;
import org.apache.hadoop.hbase.regionserver.ScanInfo;
import org.apache.hadoop.hbase.regionserver.querymatcher.CompactionScanQueryMatcher;
import org.apache.hadoop.hbase.regionserver.querymatcher.ScanQueryMatcher;

@InterfaceAudience.Private
public class MinorCompactionScanQueryMatcher
extends CompactionScanQueryMatcher {
    public MinorCompactionScanQueryMatcher(ScanInfo scanInfo, DeleteTracker deletes, long readPointToUse, long oldestUnexpiredTS, long now) {
        super(scanInfo, deletes, readPointToUse, oldestUnexpiredTS, now);
    }

    @Override
    public ScanQueryMatcher.MatchCode match(Cell cell) throws IOException {
        ScanQueryMatcher.MatchCode returnCode = this.preCheck(cell);
        if (returnCode != null) {
            return returnCode;
        }
        long mvccVersion = cell.getSequenceId();
        byte typeByte = cell.getTypeByte();
        if (CellUtil.isDelete(typeByte)) {
            if (mvccVersion > this.maxReadPointToTrackVersions) {
                return ScanQueryMatcher.MatchCode.INCLUDE;
            }
            this.trackDelete(cell);
            return ScanQueryMatcher.MatchCode.INCLUDE;
        }
        returnCode = this.checkDeleted(this.deletes, cell);
        if (returnCode != null) {
            return returnCode;
        }
        return this.columns.checkVersions(cell.getQualifierArray(), cell.getQualifierOffset(), cell.getQualifierLength(), cell.getTimestamp(), typeByte, mvccVersion > this.maxReadPointToTrackVersions);
    }
}

