/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.regionserver;

import org.apache.hadoop.hbase.CompatibilitySingletonFactory;
import org.apache.hadoop.hbase.regionserver.MetricsRegionServerSourceFactory;
import org.apache.hadoop.hbase.regionserver.MetricsTableSource;
import org.apache.hadoop.hbase.regionserver.MetricsTableSourceImpl;
import org.apache.hadoop.hbase.regionserver.MetricsTableWrapperAggregate;
import org.apache.hadoop.hbase.testclassification.MetricsTests;
import org.apache.hadoop.hbase.testclassification.SmallTests;
import org.junit.Assert;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={MetricsTests.class, SmallTests.class})
public class TestMetricsTableSourceImpl {
    @Test
    public void testCompareToHashCode() throws Exception {
        MetricsRegionServerSourceFactory metricsFact = CompatibilitySingletonFactory.getInstance(MetricsRegionServerSourceFactory.class);
        MetricsTableSource one = metricsFact.createTable("ONETABLE", new TableWrapperStub("ONETABLE"));
        MetricsTableSource oneClone = metricsFact.createTable("ONETABLE", new TableWrapperStub("ONETABLE"));
        MetricsTableSource two = metricsFact.createTable("TWOTABLE", new TableWrapperStub("TWOTABLE"));
        Assert.assertEquals((long)0L, (long)one.compareTo(oneClone));
        Assert.assertEquals((long)one.hashCode(), (long)oneClone.hashCode());
        Assert.assertNotEquals((Object)one, (Object)two);
        Assert.assertTrue((one.compareTo(two) != 0 ? 1 : 0) != 0);
        Assert.assertTrue((two.compareTo(one) != 0 ? 1 : 0) != 0);
        Assert.assertTrue((two.compareTo(one) != one.compareTo(two) ? 1 : 0) != 0);
        Assert.assertTrue((two.compareTo(two) == 0 ? 1 : 0) != 0);
    }

    @Test(expected=RuntimeException.class)
    public void testNoGetTableMetricsSourceImpl() throws Exception {
        CompatibilitySingletonFactory.getInstance(MetricsTableSourceImpl.class);
    }

    @Test
    public void testGetTableMetrics() throws Exception {
        MetricsTableSource oneTbl = CompatibilitySingletonFactory.getInstance(MetricsRegionServerSourceFactory.class).createTable("ONETABLE", new TableWrapperStub("ONETABLE"));
        Assert.assertEquals((Object)"ONETABLE", (Object)oneTbl.getTableName());
    }

    static class TableWrapperStub
    implements MetricsTableWrapperAggregate {
        private String tableName;

        public TableWrapperStub(String tableName) {
            this.tableName = tableName;
        }

        @Override
        public long getReadRequestsCount(String table) {
            return 10L;
        }

        @Override
        public long getWriteRequestsCount(String table) {
            return 20L;
        }

        @Override
        public long getTotalRequestsCount(String table) {
            return 30L;
        }

        @Override
        public long getMemstoresSize(String table) {
            return 1000L;
        }

        @Override
        public long getStoreFilesSize(String table) {
            return 2000L;
        }

        @Override
        public long getTableSize(String table) {
            return 3000L;
        }

        public String getTableName() {
            return this.tableName;
        }
    }
}

