/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.regionserver;

import java.util.ArrayList;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.HTableDescriptor;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.Delete;
import org.apache.hadoop.hbase.client.HTable;
import org.apache.hadoop.hbase.client.Mutation;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.filter.BinaryComparator;
import org.apache.hadoop.hbase.filter.CompareFilter;
import org.apache.hadoop.hbase.filter.SingleColumnValueFilter;
import org.apache.hadoop.hbase.regionserver.BloomType;
import org.apache.hadoop.hbase.testclassification.FilterTests;
import org.apache.hadoop.hbase.testclassification.MediumTests;
import org.apache.hadoop.hbase.testclassification.RegionServerTests;
import org.apache.hadoop.hbase.util.Bytes;
import org.junit.AfterClass;
import org.junit.BeforeClass;
import org.junit.Rule;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.rules.TestName;

@Category(value={RegionServerTests.class, FilterTests.class, MediumTests.class})
public class TestIsDeleteFailure {
    private static final HBaseTestingUtility TEST_UTIL = new HBaseTestingUtility();
    @Rule
    public TestName name = new TestName();

    @BeforeClass
    public static void setUpBeforeClass() throws Exception {
        TEST_UTIL.getConfiguration().setInt("hbase.regionserver.msginterval", 100);
        TEST_UTIL.getConfiguration().setInt("hbase.client.pause", 250);
        TEST_UTIL.getConfiguration().setInt("hbase.client.retries.number", 2);
        TEST_UTIL.getConfiguration().setBoolean("hbase.master.enabletable.roundrobin", true);
        TEST_UTIL.startMiniCluster(1);
    }

    @AfterClass
    public static void tearDownAfterClass() throws Exception {
        TEST_UTIL.shutdownMiniCluster();
    }

    @Test
    public void testIsDeleteFailure() throws Exception {
        Delete del;
        Put put;
        byte[] row;
        int i;
        HTableDescriptor table = new HTableDescriptor(TableName.valueOf(this.name.getMethodName()));
        byte[] family = Bytes.toBytes("0");
        byte[] c1 = Bytes.toBytes("C01");
        byte[] c2 = Bytes.toBytes("C02");
        byte[] c3 = Bytes.toBytes("C03");
        byte[] c4 = Bytes.toBytes("C04");
        byte[] c5 = Bytes.toBytes("C05");
        byte[] c6 = Bytes.toBytes("C07");
        byte[] c7 = Bytes.toBytes("C07");
        byte[] c8 = Bytes.toBytes("C08");
        byte[] c9 = Bytes.toBytes("C09");
        byte[] c10 = Bytes.toBytes("C10");
        byte[] c11 = Bytes.toBytes("C11");
        byte[] c12 = Bytes.toBytes("C12");
        byte[] c13 = Bytes.toBytes("C13");
        byte[] c14 = Bytes.toBytes("C14");
        byte[] c15 = Bytes.toBytes("C15");
        byte[] val = Bytes.toBytes("foo");
        ArrayList<byte[]> fams = new ArrayList<byte[]>(1);
        fams.add(family);
        HTable ht = TEST_UTIL.createTable(table, (byte[][])fams.toArray((T[])new byte[0][]), null, BloomType.ROWCOL, 10000, new Configuration(TEST_UTIL.getConfiguration()));
        ArrayList<Mutation> pending = new ArrayList<Mutation>();
        for (i = 0; i < 1000; ++i) {
            row = Bytes.toBytes("key" + Integer.toString(i));
            put = new Put(row);
            put.addColumn(family, c3, val);
            put.addColumn(family, c4, val);
            put.addColumn(family, c5, val);
            put.addColumn(family, c6, val);
            put.addColumn(family, c7, val);
            put.addColumn(family, c8, val);
            put.addColumn(family, c12, val);
            put.addColumn(family, c13, val);
            put.addColumn(family, c15, val);
            pending.add(put);
            del = new Delete(row);
            del.addColumns(family, c2);
            del.addColumns(family, c9);
            del.addColumns(family, c10);
            del.addColumns(family, c14);
            pending.add(del);
        }
        ht.batch(pending, new Object[pending.size()]);
        TEST_UTIL.flush();
        TEST_UTIL.compact(true);
        for (i = 20; i < 300; ++i) {
            row = Bytes.toBytes("key" + Integer.toString(i));
            put = new Put(row);
            put.addColumn(family, c3, val);
            put.addColumn(family, c4, val);
            put.addColumn(family, c5, val);
            put.addColumn(family, c6, val);
            put.addColumn(family, c7, val);
            put.addColumn(family, c8, val);
            put.addColumn(family, c12, val);
            put.addColumn(family, c13, val);
            put.addColumn(family, c15, val);
            pending.add(put);
            del = new Delete(row);
            del.addColumns(family, c2);
            del.addColumns(family, c9);
            del.addColumns(family, c10);
            del.addColumns(family, c14);
            pending.add(del);
        }
        ht.batch(pending, new Object[pending.size()]);
        TEST_UTIL.flush();
        Scan scan = new Scan();
        scan.addColumn(family, c9);
        scan.addColumn(family, c15);
        SingleColumnValueFilter filter = new SingleColumnValueFilter(family, c15, CompareFilter.CompareOp.EQUAL, new BinaryComparator(c15));
        scan.setFilter(filter);
        for (Result result : ht.getScanner(scan)) {
            result.advance();
        }
        ht.close();
    }
}

