/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.protobuf;

import com.google.protobuf.ByteString;
import java.io.IOException;
import org.apache.hadoop.hbase.client.Append;
import org.apache.hadoop.hbase.client.Delete;
import org.apache.hadoop.hbase.client.Get;
import org.apache.hadoop.hbase.client.Increment;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.protobuf.ProtobufUtil;
import org.apache.hadoop.hbase.protobuf.generated.ClientProtos;
import org.apache.hadoop.hbase.protobuf.generated.HBaseProtos;
import org.apache.hadoop.hbase.testclassification.SmallTests;
import org.apache.hadoop.hbase.util.ByteStringer;
import org.apache.hadoop.hbase.util.Bytes;
import org.junit.Assert;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={SmallTests.class})
public class TestProtobufUtil {
    @Test
    public void testException() throws IOException {
        HBaseProtos.NameBytesPair.Builder builder = HBaseProtos.NameBytesPair.newBuilder();
        String omg = "OMG!!!";
        builder.setName("java.io.IOException");
        builder.setValue(ByteStringer.wrap(Bytes.toBytes("OMG!!!")));
        Throwable t = ProtobufUtil.toException(builder.build());
        Assert.assertEquals((Object)"OMG!!!", (Object)t.getMessage());
        builder.clear();
        builder.setName("org.apache.hadoop.ipc.RemoteException");
        builder.setValue(ByteStringer.wrap(Bytes.toBytes("OMG!!!")));
        t = ProtobufUtil.toException(builder.build());
        Assert.assertEquals((Object)"OMG!!!", (Object)t.getMessage());
    }

    @Test
    public void testGet() throws IOException {
        ClientProtos.Get.Builder getBuilder = ClientProtos.Get.newBuilder();
        getBuilder.setRow(ByteString.copyFromUtf8((String)"row"));
        ClientProtos.Column.Builder columnBuilder = ClientProtos.Column.newBuilder();
        columnBuilder.setFamily(ByteString.copyFromUtf8((String)"f1"));
        columnBuilder.addQualifier(ByteString.copyFromUtf8((String)"c1"));
        columnBuilder.addQualifier(ByteString.copyFromUtf8((String)"c2"));
        getBuilder.addColumn(columnBuilder.build());
        columnBuilder.clear();
        columnBuilder.setFamily(ByteString.copyFromUtf8((String)"f2"));
        getBuilder.addColumn(columnBuilder.build());
        getBuilder.setLoadColumnFamiliesOnDemand(true);
        ClientProtos.Get proto = getBuilder.build();
        Assert.assertEquals((long)1L, (long)proto.getMaxVersions());
        Assert.assertEquals((Object)true, (Object)proto.getCacheBlocks());
        getBuilder = ClientProtos.Get.newBuilder(proto);
        getBuilder.setMaxVersions(1);
        getBuilder.setCacheBlocks(true);
        Get get = ProtobufUtil.toGet(proto);
        Assert.assertEquals((Object)getBuilder.build(), (Object)ProtobufUtil.toGet(get));
    }

    @Test
    public void testAppend() throws IOException {
        long timeStamp = 111111L;
        ClientProtos.MutationProto.Builder mutateBuilder = ClientProtos.MutationProto.newBuilder();
        mutateBuilder.setRow(ByteString.copyFromUtf8((String)"row"));
        mutateBuilder.setMutateType(ClientProtos.MutationProto.MutationType.APPEND);
        mutateBuilder.setTimestamp(timeStamp);
        ClientProtos.MutationProto.ColumnValue.Builder valueBuilder = ClientProtos.MutationProto.ColumnValue.newBuilder();
        valueBuilder.setFamily(ByteString.copyFromUtf8((String)"f1"));
        ClientProtos.MutationProto.ColumnValue.QualifierValue.Builder qualifierBuilder = ClientProtos.MutationProto.ColumnValue.QualifierValue.newBuilder();
        qualifierBuilder.setQualifier(ByteString.copyFromUtf8((String)"c1"));
        qualifierBuilder.setValue(ByteString.copyFromUtf8((String)"v1"));
        qualifierBuilder.setTimestamp(timeStamp);
        valueBuilder.addQualifierValue(qualifierBuilder.build());
        qualifierBuilder.setQualifier(ByteString.copyFromUtf8((String)"c2"));
        qualifierBuilder.setValue(ByteString.copyFromUtf8((String)"v2"));
        valueBuilder.addQualifierValue(qualifierBuilder.build());
        qualifierBuilder.setTimestamp(timeStamp);
        mutateBuilder.addColumnValue(valueBuilder.build());
        ClientProtos.MutationProto proto = mutateBuilder.build();
        Assert.assertEquals((Object)((Object)ClientProtos.MutationProto.Durability.USE_DEFAULT), (Object)((Object)proto.getDurability()));
        mutateBuilder = ClientProtos.MutationProto.newBuilder(proto);
        mutateBuilder.setDurability(ClientProtos.MutationProto.Durability.USE_DEFAULT);
        Append append = ProtobufUtil.toAppend(proto, null);
        mutateBuilder.setTimestamp(append.getTimeStamp());
        Assert.assertEquals((Object)mutateBuilder.build(), (Object)ProtobufUtil.toMutation(ClientProtos.MutationProto.MutationType.APPEND, append));
    }

    @Test
    public void testDelete() throws IOException {
        ClientProtos.MutationProto.Builder mutateBuilder = ClientProtos.MutationProto.newBuilder();
        mutateBuilder.setRow(ByteString.copyFromUtf8((String)"row"));
        mutateBuilder.setMutateType(ClientProtos.MutationProto.MutationType.DELETE);
        mutateBuilder.setTimestamp(111111L);
        ClientProtos.MutationProto.ColumnValue.Builder valueBuilder = ClientProtos.MutationProto.ColumnValue.newBuilder();
        valueBuilder.setFamily(ByteString.copyFromUtf8((String)"f1"));
        ClientProtos.MutationProto.ColumnValue.QualifierValue.Builder qualifierBuilder = ClientProtos.MutationProto.ColumnValue.QualifierValue.newBuilder();
        qualifierBuilder.setQualifier(ByteString.copyFromUtf8((String)"c1"));
        qualifierBuilder.setDeleteType(ClientProtos.MutationProto.DeleteType.DELETE_ONE_VERSION);
        qualifierBuilder.setTimestamp(111222L);
        valueBuilder.addQualifierValue(qualifierBuilder.build());
        qualifierBuilder.setQualifier(ByteString.copyFromUtf8((String)"c2"));
        qualifierBuilder.setDeleteType(ClientProtos.MutationProto.DeleteType.DELETE_MULTIPLE_VERSIONS);
        qualifierBuilder.setTimestamp(111333L);
        valueBuilder.addQualifierValue(qualifierBuilder.build());
        mutateBuilder.addColumnValue(valueBuilder.build());
        ClientProtos.MutationProto proto = mutateBuilder.build();
        Assert.assertEquals((Object)((Object)ClientProtos.MutationProto.Durability.USE_DEFAULT), (Object)((Object)proto.getDurability()));
        mutateBuilder = ClientProtos.MutationProto.newBuilder(proto);
        mutateBuilder.setDurability(ClientProtos.MutationProto.Durability.USE_DEFAULT);
        Delete delete = ProtobufUtil.toDelete(proto);
        for (ClientProtos.MutationProto.ColumnValue.Builder column : mutateBuilder.getColumnValueBuilderList()) {
            for (ClientProtos.MutationProto.ColumnValue.QualifierValue.Builder qualifier : column.getQualifierValueBuilderList()) {
                qualifier.setValue(ByteString.EMPTY);
            }
        }
        Assert.assertEquals((Object)mutateBuilder.build(), (Object)ProtobufUtil.toMutation(ClientProtos.MutationProto.MutationType.DELETE, delete));
    }

    @Test
    public void testIncrement() throws IOException {
        ClientProtos.MutationProto.Builder mutateBuilder = ClientProtos.MutationProto.newBuilder();
        mutateBuilder.setRow(ByteString.copyFromUtf8((String)"row"));
        mutateBuilder.setMutateType(ClientProtos.MutationProto.MutationType.INCREMENT);
        ClientProtos.MutationProto.ColumnValue.Builder valueBuilder = ClientProtos.MutationProto.ColumnValue.newBuilder();
        valueBuilder.setFamily(ByteString.copyFromUtf8((String)"f1"));
        ClientProtos.MutationProto.ColumnValue.QualifierValue.Builder qualifierBuilder = ClientProtos.MutationProto.ColumnValue.QualifierValue.newBuilder();
        qualifierBuilder.setQualifier(ByteString.copyFromUtf8((String)"c1"));
        qualifierBuilder.setValue(ByteStringer.wrap(Bytes.toBytes(11L)));
        valueBuilder.addQualifierValue(qualifierBuilder.build());
        qualifierBuilder.setQualifier(ByteString.copyFromUtf8((String)"c2"));
        qualifierBuilder.setValue(ByteStringer.wrap(Bytes.toBytes(22L)));
        valueBuilder.addQualifierValue(qualifierBuilder.build());
        mutateBuilder.addColumnValue(valueBuilder.build());
        ClientProtos.MutationProto proto = mutateBuilder.build();
        Assert.assertEquals((Object)((Object)ClientProtos.MutationProto.Durability.USE_DEFAULT), (Object)((Object)proto.getDurability()));
        mutateBuilder = ClientProtos.MutationProto.newBuilder(proto);
        mutateBuilder.setDurability(ClientProtos.MutationProto.Durability.USE_DEFAULT);
        Increment increment = ProtobufUtil.toIncrement(proto, null);
        Assert.assertEquals((Object)mutateBuilder.build(), (Object)ProtobufUtil.toMutation(increment, ClientProtos.MutationProto.newBuilder(), 0L));
    }

    @Test
    public void testPut() throws IOException {
        ClientProtos.MutationProto.Builder mutateBuilder = ClientProtos.MutationProto.newBuilder();
        mutateBuilder.setRow(ByteString.copyFromUtf8((String)"row"));
        mutateBuilder.setMutateType(ClientProtos.MutationProto.MutationType.PUT);
        mutateBuilder.setTimestamp(111111L);
        ClientProtos.MutationProto.ColumnValue.Builder valueBuilder = ClientProtos.MutationProto.ColumnValue.newBuilder();
        valueBuilder.setFamily(ByteString.copyFromUtf8((String)"f1"));
        ClientProtos.MutationProto.ColumnValue.QualifierValue.Builder qualifierBuilder = ClientProtos.MutationProto.ColumnValue.QualifierValue.newBuilder();
        qualifierBuilder.setQualifier(ByteString.copyFromUtf8((String)"c1"));
        qualifierBuilder.setValue(ByteString.copyFromUtf8((String)"v1"));
        valueBuilder.addQualifierValue(qualifierBuilder.build());
        qualifierBuilder.setQualifier(ByteString.copyFromUtf8((String)"c2"));
        qualifierBuilder.setValue(ByteString.copyFromUtf8((String)"v2"));
        qualifierBuilder.setTimestamp(222222L);
        valueBuilder.addQualifierValue(qualifierBuilder.build());
        mutateBuilder.addColumnValue(valueBuilder.build());
        ClientProtos.MutationProto proto = mutateBuilder.build();
        Assert.assertEquals((Object)((Object)ClientProtos.MutationProto.Durability.USE_DEFAULT), (Object)((Object)proto.getDurability()));
        mutateBuilder = ClientProtos.MutationProto.newBuilder(proto);
        mutateBuilder.setDurability(ClientProtos.MutationProto.Durability.USE_DEFAULT);
        Put put = ProtobufUtil.toPut(proto);
        long timestamp = put.getTimeStamp();
        for (ClientProtos.MutationProto.ColumnValue.Builder column : mutateBuilder.getColumnValueBuilderList()) {
            for (ClientProtos.MutationProto.ColumnValue.QualifierValue.Builder qualifier : column.getQualifierValueBuilderList()) {
                if (qualifier.hasTimestamp()) continue;
                qualifier.setTimestamp(timestamp);
            }
        }
        Assert.assertEquals((Object)mutateBuilder.build(), (Object)ProtobufUtil.toMutation(ClientProtos.MutationProto.MutationType.PUT, put));
    }

    @Test
    public void testScan() throws IOException {
        ClientProtos.Scan.Builder scanBuilder = ClientProtos.Scan.newBuilder();
        scanBuilder.setStartRow(ByteString.copyFromUtf8((String)"row1"));
        scanBuilder.setStopRow(ByteString.copyFromUtf8((String)"row2"));
        ClientProtos.Column.Builder columnBuilder = ClientProtos.Column.newBuilder();
        columnBuilder.setFamily(ByteString.copyFromUtf8((String)"f1"));
        columnBuilder.addQualifier(ByteString.copyFromUtf8((String)"c1"));
        columnBuilder.addQualifier(ByteString.copyFromUtf8((String)"c2"));
        scanBuilder.addColumn(columnBuilder.build());
        columnBuilder.clear();
        columnBuilder.setFamily(ByteString.copyFromUtf8((String)"f2"));
        scanBuilder.addColumn(columnBuilder.build());
        ClientProtos.Scan proto = scanBuilder.build();
        Assert.assertEquals((long)1L, (long)proto.getMaxVersions());
        Assert.assertEquals((Object)true, (Object)proto.getCacheBlocks());
        scanBuilder = ClientProtos.Scan.newBuilder(proto);
        scanBuilder.setMaxVersions(2);
        scanBuilder.setCacheBlocks(false);
        scanBuilder.setCaching(1024);
        scanBuilder.setIncludeStopRow(false);
        ClientProtos.Scan expectedProto = scanBuilder.build();
        ClientProtos.Scan actualProto = ProtobufUtil.toScan(ProtobufUtil.toScan(expectedProto));
        Assert.assertEquals((Object)expectedProto, (Object)actualProto);
    }
}

