/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.mapreduce;

import java.io.ByteArrayOutputStream;
import java.io.PrintStream;
import java.util.ArrayList;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.CellUtil;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.KeyValue;
import org.apache.hadoop.hbase.MiniHBaseCluster;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.Delete;
import org.apache.hadoop.hbase.client.Get;
import org.apache.hadoop.hbase.client.HTable;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.io.ImmutableBytesWritable;
import org.apache.hadoop.hbase.mapreduce.WALPlayer;
import org.apache.hadoop.hbase.regionserver.wal.WALEdit;
import org.apache.hadoop.hbase.testclassification.LargeTests;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.FSUtils;
import org.apache.hadoop.hbase.util.LauncherSecurityManager;
import org.apache.hadoop.hbase.wal.WAL;
import org.apache.hadoop.hbase.wal.WALKey;
import org.apache.hadoop.mapreduce.Mapper;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.mockito.Matchers;
import org.mockito.Mockito;
import org.mockito.invocation.InvocationOnMock;
import org.mockito.stubbing.Answer;

@Category(value={LargeTests.class})
public class TestWALPlayer {
    private static final HBaseTestingUtility TEST_UTIL = new HBaseTestingUtility();
    private static MiniHBaseCluster cluster;
    private static Path rootDir;
    private static Path walRootDir;
    private static FileSystem fs;
    private static FileSystem walFs;
    private static Configuration conf;

    @BeforeClass
    public static void beforeClass() throws Exception {
        TEST_UTIL.setJobWithoutMRCluster();
        conf = TEST_UTIL.getConfiguration();
        rootDir = TEST_UTIL.createRootDir();
        walRootDir = TEST_UTIL.createWALRootDir();
        fs = FSUtils.getRootDirFileSystem(conf);
        walFs = FSUtils.getWALFileSystem(conf);
        cluster = TEST_UTIL.startMiniCluster();
    }

    @AfterClass
    public static void afterClass() throws Exception {
        TEST_UTIL.shutdownMiniCluster();
        fs.delete(rootDir, true);
        walFs.delete(walRootDir, true);
    }

    @Test
    public void testWALPlayer() throws Exception {
        TableName TABLENAME1 = TableName.valueOf("testWALPlayer1");
        TableName TABLENAME2 = TableName.valueOf("testWALPlayer2");
        byte[] FAMILY = Bytes.toBytes("family");
        byte[] COLUMN1 = Bytes.toBytes("c1");
        byte[] COLUMN2 = Bytes.toBytes("c2");
        byte[] ROW = Bytes.toBytes("row");
        HTable t1 = TEST_UTIL.createTable(TABLENAME1, FAMILY);
        HTable t2 = TEST_UTIL.createTable(TABLENAME2, FAMILY);
        Put p = new Put(ROW);
        p.add(FAMILY, COLUMN1, COLUMN1);
        p.add(FAMILY, COLUMN2, COLUMN2);
        t1.put(p);
        Delete d = new Delete(ROW);
        d.deleteColumns(FAMILY, COLUMN1);
        t1.delete(d);
        WAL log = cluster.getRegionServer(0).getWAL(null);
        log.rollWriter();
        String walInputDir = new Path(cluster.getMaster().getMasterFileSystem().getWALRootDir(), "WALs").toString();
        Configuration configuration = TEST_UTIL.getConfiguration();
        WALPlayer player = new WALPlayer(configuration);
        String optionName = "_test_.name";
        configuration.set(optionName, "1000");
        player.setupTime(configuration, optionName);
        Assert.assertEquals((long)1000L, (long)configuration.getLong(optionName, 0L));
        Assert.assertEquals((long)0L, (long)player.run(new String[]{walInputDir, TABLENAME1.getNameAsString(), TABLENAME2.getNameAsString()}));
        Get g = new Get(ROW);
        Result r = t2.get(g);
        Assert.assertEquals((long)1L, (long)r.size());
        Assert.assertTrue((boolean)CellUtil.matchingQualifier(r.rawCells()[0], COLUMN2));
    }

    @Test
    public void testWALKeyValueMapper() throws Exception {
        this.testWALKeyValueMapper("wal.input.tables");
    }

    @Test
    public void testWALKeyValueMapperWithDeprecatedConfig() throws Exception {
        this.testWALKeyValueMapper("hlog.input.tables");
    }

    private void testWALKeyValueMapper(String tableConfigKey) throws Exception {
        Configuration configuration = new Configuration();
        configuration.set(tableConfigKey, "table");
        WALPlayer.WALKeyValueMapper mapper = new WALPlayer.WALKeyValueMapper();
        WALKey key = (WALKey)Mockito.mock(WALKey.class);
        Mockito.when((Object)key.getTablename()).thenReturn((Object)TableName.valueOf("table"));
        Mapper.Context context = (Mapper.Context)Mockito.mock(Mapper.Context.class);
        Mockito.when((Object)context.getConfiguration()).thenReturn((Object)configuration);
        WALEdit value = (WALEdit)Mockito.mock(WALEdit.class);
        ArrayList<KeyValue> values = new ArrayList<KeyValue>();
        KeyValue kv1 = new KeyValue(Bytes.toBytes("row"), Bytes.toBytes("family"), Bytes.toBytes("q"));
        values.add(kv1);
        Mockito.when(value.getCells()).thenReturn(values);
        mapper.setup(context);
        ((Mapper.Context)Mockito.doAnswer((Answer)new Answer<Void>(){

            public Void answer(InvocationOnMock invocation) throws Throwable {
                ImmutableBytesWritable writer = (ImmutableBytesWritable)invocation.getArguments()[0];
                KeyValue key = (KeyValue)invocation.getArguments()[1];
                Assert.assertEquals((Object)"row", (Object)Bytes.toString(writer.get()));
                Assert.assertEquals((Object)"row", (Object)Bytes.toString(key.getRow()));
                return null;
            }
        }).when((Object)context)).write(Matchers.any(ImmutableBytesWritable.class), Matchers.any(KeyValue.class));
        mapper.map(key, value, context);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testMainMethod() throws Exception {
        PrintStream oldPrintStream = System.err;
        SecurityManager SECURITY_MANAGER = System.getSecurityManager();
        LauncherSecurityManager newSecurityManager = new LauncherSecurityManager();
        System.setSecurityManager(newSecurityManager);
        ByteArrayOutputStream data = new ByteArrayOutputStream();
        String[] args = new String[]{};
        System.setErr(new PrintStream(data));
        try {
            System.setErr(new PrintStream(data));
            try {
                WALPlayer.main(args);
                Assert.fail((String)"should be SecurityException");
            }
            catch (SecurityException e) {
                Assert.assertEquals((long)-1L, (long)newSecurityManager.getExitCode());
                Assert.assertTrue((boolean)data.toString().contains("ERROR: Wrong number of arguments:"));
                Assert.assertTrue((boolean)data.toString().contains("Usage: WALPlayer [options] <wal inputdir> <tables> [<tableMappings>]"));
                Assert.assertTrue((boolean)data.toString().contains("-Dwal.bulk.output=/path/for/output"));
            }
        }
        finally {
            System.setErr(oldPrintStream);
            System.setSecurityManager(SECURITY_MANAGER);
        }
    }
}

