/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.mapreduce;

import drill.shaded.hbase.guava.com.google.common.collect.Lists;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.CategoryBasedTimeout;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.HConstants;
import org.apache.hadoop.hbase.HDFSBlocksDistribution;
import org.apache.hadoop.hbase.HRegionInfo;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.HBaseAdmin;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.client.Table;
import org.apache.hadoop.hbase.io.ImmutableBytesWritable;
import org.apache.hadoop.hbase.mapreduce.TableMapReduceUtil;
import org.apache.hadoop.hbase.mapreduce.TableMapper;
import org.apache.hadoop.hbase.mapreduce.TableSnapshotInputFormat;
import org.apache.hadoop.hbase.mapreduce.TableSnapshotInputFormatImpl;
import org.apache.hadoop.hbase.mapreduce.TableSnapshotInputFormatTestBase;
import org.apache.hadoop.hbase.snapshot.SnapshotTestingUtils;
import org.apache.hadoop.hbase.testclassification.LargeTests;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.FSUtils;
import org.apache.hadoop.hbase.util.RegionSplitter;
import org.apache.hadoop.io.NullWritable;
import org.apache.hadoop.mapreduce.InputSplit;
import org.apache.hadoop.mapreduce.Job;
import org.apache.hadoop.mapreduce.JobContext;
import org.apache.hadoop.mapreduce.Mapper;
import org.apache.hadoop.mapreduce.RecordReader;
import org.apache.hadoop.mapreduce.Reducer;
import org.apache.hadoop.mapreduce.TaskAttemptContext;
import org.apache.hadoop.mapreduce.lib.output.NullOutputFormat;
import org.junit.After;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.rules.TestRule;
import org.mockito.Mockito;

@Category(value={LargeTests.class})
public class TestTableSnapshotInputFormat
extends TableSnapshotInputFormatTestBase {
    private static final Log LOG = LogFactory.getLog(TestTableSnapshotInputFormat.class);
    @Rule
    public final TestRule timeout = CategoryBasedTimeout.builder().withTimeout(this.getClass()).withLookingForStuckThread(true).build();
    private static final byte[] bbb = Bytes.toBytes("bbb");
    private static final byte[] yyy = Bytes.toBytes("yyy");
    private static final byte[] bbc = Bytes.toBytes("bbc");
    private static final byte[] yya = Bytes.toBytes("yya");

    @Override
    protected byte[] getStartRow() {
        return bbb;
    }

    @Override
    protected byte[] getEndRow() {
        return yyy;
    }

    @After
    public void tearDown() throws Exception {
    }

    @Test
    public void testGetBestLocations() throws IOException {
        Configuration conf = this.UTIL.getConfiguration();
        HDFSBlocksDistribution blockDistribution = new HDFSBlocksDistribution();
        Assert.assertEquals(Lists.newArrayList(), TableSnapshotInputFormatImpl.getBestLocations(conf, blockDistribution));
        blockDistribution.addHostsAndBlockWeight(new String[]{"h1"}, 1L);
        Assert.assertEquals(Lists.newArrayList("h1"), TableSnapshotInputFormatImpl.getBestLocations(conf, blockDistribution));
        blockDistribution.addHostsAndBlockWeight(new String[]{"h1"}, 1L);
        Assert.assertEquals(Lists.newArrayList("h1"), TableSnapshotInputFormatImpl.getBestLocations(conf, blockDistribution));
        blockDistribution.addHostsAndBlockWeight(new String[]{"h2"}, 1L);
        Assert.assertEquals(Lists.newArrayList("h1"), TableSnapshotInputFormatImpl.getBestLocations(conf, blockDistribution));
        blockDistribution = new HDFSBlocksDistribution();
        blockDistribution.addHostsAndBlockWeight(new String[]{"h1"}, 10L);
        blockDistribution.addHostsAndBlockWeight(new String[]{"h2"}, 7L);
        blockDistribution.addHostsAndBlockWeight(new String[]{"h3"}, 5L);
        blockDistribution.addHostsAndBlockWeight(new String[]{"h4"}, 1L);
        Assert.assertEquals(Lists.newArrayList("h1"), TableSnapshotInputFormatImpl.getBestLocations(conf, blockDistribution));
        blockDistribution.addHostsAndBlockWeight(new String[]{"h2"}, 2L);
        Assert.assertEquals(Lists.newArrayList("h1", "h2"), TableSnapshotInputFormatImpl.getBestLocations(conf, blockDistribution));
        blockDistribution.addHostsAndBlockWeight(new String[]{"h2"}, 3L);
        Assert.assertEquals(Lists.newArrayList("h2", "h1"), TableSnapshotInputFormatImpl.getBestLocations(conf, blockDistribution));
        blockDistribution.addHostsAndBlockWeight(new String[]{"h3"}, 6L);
        blockDistribution.addHostsAndBlockWeight(new String[]{"h4"}, 9L);
        Assert.assertEquals(Lists.newArrayList("h2", "h3", "h4", "h1"), TableSnapshotInputFormatImpl.getBestLocations(conf, blockDistribution));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testInitTableSnapshotMapperJobConfig() throws Exception {
        this.setupCluster();
        TableName tableName = TableName.valueOf("testInitTableSnapshotMapperJobConfig");
        String snapshotName = "foo";
        try {
            TestTableSnapshotInputFormat.createTableAndSnapshot(this.UTIL, tableName, snapshotName, this.getStartRow(), this.getEndRow(), 1);
            Job job = new Job(this.UTIL.getConfiguration());
            Path tmpTableDir = this.UTIL.getRandomDir();
            TableMapReduceUtil.initTableSnapshotMapperJob(snapshotName, new Scan(), TestTableSnapshotMapper.class, ImmutableBytesWritable.class, NullWritable.class, job, false, tmpTableDir);
            Assert.assertEquals((String)"Snapshot job should be configured for default LruBlockCache.", (double)0.4f, (double)job.getConfiguration().getFloat("hfile.block.cache.size", -1.0f), (double)0.01);
            Assert.assertEquals((String)"Snapshot job should not use BucketCache.", (double)0.0, (double)job.getConfiguration().getFloat("hbase.bucketcache.size", -1.0f), (double)0.01);
        }
        finally {
            this.UTIL.getHBaseAdmin().deleteSnapshot(snapshotName);
            this.UTIL.deleteTable(tableName);
            this.tearDownCluster();
        }
    }

    @Override
    public void testRestoreSnapshotDoesNotCreateBackRefLinksInit(TableName tableName, String snapshotName, Path tmpTableDir) throws Exception {
        Job job = new Job(this.UTIL.getConfiguration());
        TableMapReduceUtil.initTableSnapshotMapperJob(snapshotName, new Scan(), TestTableSnapshotMapper.class, ImmutableBytesWritable.class, NullWritable.class, job, false, tmpTableDir);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void testWithMockedMapReduce(HBaseTestingUtility util, String snapshotName, int numRegions, int numSplitsPerRegion, int expectedNumSplits) throws Exception {
        this.setupCluster();
        TableName tableName = TableName.valueOf("testWithMockedMapReduce");
        try {
            TestTableSnapshotInputFormat.createTableAndSnapshot(util, tableName, snapshotName, this.getStartRow(), this.getEndRow(), numRegions);
            Job job = new Job(util.getConfiguration());
            Path tmpTableDir = util.getRandomDir();
            Scan scan = new Scan(this.getStartRow(), this.getEndRow());
            if (numSplitsPerRegion > 1) {
                TableMapReduceUtil.initTableSnapshotMapperJob(snapshotName, scan, TestTableSnapshotMapper.class, ImmutableBytesWritable.class, NullWritable.class, job, false, tmpTableDir, new RegionSplitter.UniformSplit(), numSplitsPerRegion);
            } else {
                TableMapReduceUtil.initTableSnapshotMapperJob(snapshotName, scan, TestTableSnapshotMapper.class, ImmutableBytesWritable.class, NullWritable.class, job, false, tmpTableDir);
            }
            this.verifyWithMockedMapReduce(job, numRegions, expectedNumSplits, this.getStartRow(), this.getEndRow());
        }
        finally {
            util.getHBaseAdmin().deleteSnapshot(snapshotName);
            util.deleteTable(tableName);
            this.tearDownCluster();
        }
    }

    public static void blockUntilSplitFinished(HBaseTestingUtility util, TableName tableName, int expectedRegionSize) throws Exception {
        List<HRegionInfo> hRegionInfoList;
        for (int i = 0; i < 100 && (hRegionInfoList = util.getHBaseAdmin().getTableRegions(tableName)).size() < expectedRegionSize; ++i) {
            Thread.sleep(1000L);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testWithMockedMapReduceWithSplitsPerRegion() throws Exception {
        this.setupCluster();
        String snapshotName = "testWithMockedMapReduceWithSplitsPerRegion";
        TableName tableName = TableName.valueOf(snapshotName);
        try {
            TestTableSnapshotInputFormat.createTableAndSnapshot(this.UTIL, tableName, snapshotName, this.getStartRow(), this.getEndRow(), 10);
            Configuration conf = this.UTIL.getConfiguration();
            Job job = new Job(conf);
            Path tmpTableDir = this.UTIL.getDataTestDirOnTestFS(snapshotName);
            Scan scan = new Scan(bbc, yya);
            TableMapReduceUtil.initTableSnapshotMapperJob(snapshotName, scan, TestTableSnapshotMapper.class, ImmutableBytesWritable.class, NullWritable.class, job, false, tmpTableDir, new RegionSplitter.UniformSplit(), 5);
            this.verifyWithMockedMapReduce(job, 10, 40, bbc, yya);
        }
        finally {
            this.UTIL.getHBaseAdmin().deleteSnapshot(snapshotName);
            this.UTIL.deleteTable(tableName);
            this.tearDownCluster();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testWithMockedMapReduceWithNoStartRowStopRow() throws Exception {
        this.setupCluster();
        String snapshotName = "testWithMockedMapReduceWithNoStartRowStopRow";
        TableName tableName = TableName.valueOf(snapshotName);
        try {
            TestTableSnapshotInputFormat.createTableAndSnapshot(this.UTIL, tableName, snapshotName, this.getStartRow(), this.getEndRow(), 10);
            Configuration conf = this.UTIL.getConfiguration();
            Job job = new Job(conf);
            Path tmpTableDir = this.UTIL.getDataTestDirOnTestFS(snapshotName);
            Scan scan2 = new Scan();
            TableMapReduceUtil.initTableSnapshotMapperJob(snapshotName, scan2, TestTableSnapshotMapper.class, ImmutableBytesWritable.class, NullWritable.class, job, false, tmpTableDir, new RegionSplitter.UniformSplit(), 5);
            this.verifyWithMockedMapReduce(job, 10, 50, HConstants.EMPTY_START_ROW, HConstants.EMPTY_START_ROW);
        }
        finally {
            this.UTIL.getHBaseAdmin().deleteSnapshot(snapshotName);
            this.UTIL.deleteTable(tableName);
            this.tearDownCluster();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testNoDuplicateResultsWhenSplitting() throws Exception {
        this.setupCluster();
        TableName tableName = TableName.valueOf("testNoDuplicateResultsWhenSplitting");
        String snapshotName = "testSnapshotBug";
        try {
            if (this.UTIL.getHBaseAdmin().tableExists(tableName)) {
                this.UTIL.deleteTable(tableName);
            }
            this.UTIL.createTable(tableName, FAMILIES);
            HBaseAdmin admin = this.UTIL.getHBaseAdmin();
            Table table = this.UTIL.getConnection().getTable(tableName);
            this.UTIL.loadTable(table, FAMILIES);
            admin.split(tableName, Bytes.toBytes("eee"));
            TestTableSnapshotInputFormat.blockUntilSplitFinished(this.UTIL, tableName, 2);
            Path rootDir = FSUtils.getRootDir(this.UTIL.getConfiguration());
            FileSystem fs = rootDir.getFileSystem(this.UTIL.getConfiguration());
            SnapshotTestingUtils.createSnapshotAndValidate(admin, tableName, Arrays.asList(FAMILIES), null, snapshotName, rootDir, fs, true);
            byte[] value = Bytes.toBytes("after_snapshot_value");
            this.UTIL.loadTable(table, FAMILIES, value);
            admin.flush(tableName);
            table.close();
            Job job = new Job(this.UTIL.getConfiguration());
            Path tmpTableDir = this.UTIL.getDataTestDirOnTestFS(snapshotName);
            Scan scan = new Scan().withStartRow(this.getStartRow()).withStopRow(this.getEndRow());
            TableMapReduceUtil.initTableSnapshotMapperJob(snapshotName, scan, TestTableSnapshotMapper.class, ImmutableBytesWritable.class, NullWritable.class, job, false, tmpTableDir);
            this.verifyWithMockedMapReduce(job, 2, 2, this.getStartRow(), this.getEndRow());
        }
        finally {
            this.UTIL.getHBaseAdmin().deleteSnapshot(snapshotName);
            this.UTIL.deleteTable(tableName);
            this.tearDownCluster();
        }
    }

    private void verifyWithMockedMapReduce(Job job, int numRegions, int expectedNumSplits, byte[] startRow, byte[] stopRow) throws IOException, InterruptedException {
        TableSnapshotInputFormat tsif = new TableSnapshotInputFormat();
        List<InputSplit> splits = tsif.getSplits((JobContext)job);
        Assert.assertEquals((long)expectedNumSplits, (long)splits.size());
        HBaseTestingUtility.SeenRowTracker rowTracker = new HBaseTestingUtility.SeenRowTracker(startRow, stopRow.length > 0 ? stopRow : Bytes.toBytes("\uffff"));
        for (int i = 0; i < splits.size(); ++i) {
            InputSplit split = splits.get(i);
            Assert.assertTrue((boolean)(split instanceof TableSnapshotInputFormat.TableSnapshotRegionSplit));
            TableSnapshotInputFormat.TableSnapshotRegionSplit snapshotRegionSplit = (TableSnapshotInputFormat.TableSnapshotRegionSplit)split;
            Scan scan = TableMapReduceUtil.convertStringToScan(snapshotRegionSplit.getDelegate().getScan());
            if (startRow.length > 0) {
                Assert.assertTrue((String)(Bytes.toStringBinary(startRow) + " should <= " + Bytes.toStringBinary(scan.getStartRow())), (Bytes.compareTo(startRow, scan.getStartRow()) <= 0 ? 1 : 0) != 0);
            }
            if (stopRow.length > 0) {
                Assert.assertTrue((String)(Bytes.toStringBinary(stopRow) + " should >= " + Bytes.toStringBinary(scan.getStopRow())), (Bytes.compareTo(stopRow, scan.getStopRow()) >= 0 ? 1 : 0) != 0);
            }
            Assert.assertTrue((String)"startRow should < stopRow", (Bytes.compareTo(scan.getStartRow(), scan.getStopRow()) < 0 ? 1 : 0) != 0);
            TaskAttemptContext taskAttemptContext = (TaskAttemptContext)Mockito.mock(TaskAttemptContext.class);
            Mockito.when((Object)taskAttemptContext.getConfiguration()).thenReturn((Object)job.getConfiguration());
            RecordReader<ImmutableBytesWritable, Result> rr = tsif.createRecordReader(split, taskAttemptContext);
            rr.initialize(split, taskAttemptContext);
            while (rr.nextKeyValue()) {
                byte[] row = ((ImmutableBytesWritable)rr.getCurrentKey()).get();
                TestTableSnapshotInputFormat.verifyRowFromMap((ImmutableBytesWritable)rr.getCurrentKey(), (Result)rr.getCurrentValue());
                rowTracker.addRow(row);
            }
            rr.close();
        }
        rowTracker.validate();
    }

    @Override
    protected void testWithMapReduceImpl(HBaseTestingUtility util, TableName tableName, String snapshotName, Path tableDir, int numRegions, int numSplitsPerRegion, int expectedNumSplits, boolean shutdownCluster) throws Exception {
        TestTableSnapshotInputFormat.doTestWithMapReduce(util, tableName, snapshotName, this.getStartRow(), this.getEndRow(), tableDir, numRegions, numSplitsPerRegion, expectedNumSplits, shutdownCluster);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void doTestWithMapReduce(HBaseTestingUtility util, TableName tableName, String snapshotName, byte[] startRow, byte[] endRow, Path tableDir, int numRegions, int numSplitsPerRegion, int expectedNumSplits, boolean shutdownCluster) throws Exception {
        LOG.info((Object)"testing with MapReduce");
        LOG.info((Object)"create the table and snapshot");
        TestTableSnapshotInputFormat.createTableAndSnapshot(util, tableName, snapshotName, startRow, endRow, numRegions);
        if (shutdownCluster) {
            LOG.info((Object)"shutting down hbase cluster.");
            util.shutdownMiniHBaseCluster();
        }
        try {
            Job job = new Job(util.getConfiguration());
            Scan scan = new Scan(startRow, endRow);
            job.setJarByClass(util.getClass());
            TableMapReduceUtil.addDependencyJarsForClasses(job.getConfiguration(), TestTableSnapshotInputFormat.class);
            if (numSplitsPerRegion > 1) {
                TableMapReduceUtil.initTableSnapshotMapperJob(snapshotName, scan, TestTableSnapshotMapper.class, ImmutableBytesWritable.class, NullWritable.class, job, true, tableDir, new RegionSplitter.UniformSplit(), numSplitsPerRegion);
            } else {
                TableMapReduceUtil.initTableSnapshotMapperJob(snapshotName, scan, TestTableSnapshotMapper.class, ImmutableBytesWritable.class, NullWritable.class, job, true, tableDir);
            }
            job.setReducerClass(TestTableSnapshotReducer.class);
            job.setNumReduceTasks(1);
            job.setOutputFormatClass(NullOutputFormat.class);
            Assert.assertTrue((boolean)job.waitForCompletion(true));
        }
        finally {
            if (!shutdownCluster) {
                util.getHBaseAdmin().deleteSnapshot(snapshotName);
                util.deleteTable(tableName);
            }
        }
    }

    static /* synthetic */ byte[] access$000() {
        return bbb;
    }

    static /* synthetic */ byte[] access$100() {
        return yyy;
    }

    public static class TestTableSnapshotReducer
    extends Reducer<ImmutableBytesWritable, NullWritable, NullWritable, NullWritable> {
        HBaseTestingUtility.SeenRowTracker rowTracker = new HBaseTestingUtility.SeenRowTracker(TestTableSnapshotInputFormat.access$000(), TestTableSnapshotInputFormat.access$100());

        protected void reduce(ImmutableBytesWritable key, Iterable<NullWritable> values, Reducer.Context context) throws IOException, InterruptedException {
            this.rowTracker.addRow(key.get());
        }

        protected void cleanup(Reducer.Context context) throws IOException, InterruptedException {
            this.rowTracker.validate();
        }
    }

    public static class TestTableSnapshotMapper
    extends TableMapper<ImmutableBytesWritable, NullWritable> {
        protected void map(ImmutableBytesWritable key, Result value, Mapper.Context context) throws IOException, InterruptedException {
            TableSnapshotInputFormatTestBase.verifyRowFromMap(key, value);
            context.write((Object)key, (Object)NullWritable.get());
        }
    }

    public static enum TestTableSnapshotCounters {
        VALIDATION_ERROR;

    }
}

