/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.mapreduce;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.HTestConst;
import org.apache.hadoop.hbase.KeyValue;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.Connection;
import org.apache.hadoop.hbase.client.ConnectionFactory;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.client.Table;
import org.apache.hadoop.hbase.mapreduce.TableRecordReaderImpl;
import org.apache.hadoop.hbase.testclassification.MediumTests;
import org.apache.hadoop.hbase.util.Bytes;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={MediumTests.class})
public class TestTableRecordReader {
    private static final HBaseTestingUtility TEST_UTIL = new HBaseTestingUtility();
    private static TableName TABLE_NAME = TableName.valueOf("TestTableRecordReader");
    private static int NUM_ROWS = 5;
    private static byte[] ROW = Bytes.toBytes("testRow");
    private static byte[][] ROWS = HTestConst.makeNAscii(ROW, NUM_ROWS);
    private static int NUM_FAMILIES = 2;
    private static byte[] FAMILY = Bytes.toBytes("testFamily");
    private static byte[][] FAMILIES = HTestConst.makeNAscii(FAMILY, NUM_FAMILIES);
    private static int NUM_QUALIFIERS = 2;
    private static byte[] QUALIFIER = Bytes.toBytes("testQualifier");
    private static byte[][] QUALIFIERS = HTestConst.makeNAscii(QUALIFIER, NUM_QUALIFIERS);
    private static int VALUE_SIZE = 10;
    private static byte[] VALUE = Bytes.createMaxByteArray(VALUE_SIZE);
    private static final int TIMEOUT = 4000;

    @BeforeClass
    public static void setUpBeforeClass() throws Exception {
        Configuration conf = TEST_UTIL.getConfiguration();
        conf.setInt("hbase.client.scanner.timeout.period", 4000);
        conf.setInt("hbase.rpc.timeout", 4000);
        conf.setLong("hbase.cells.scanned.per.heartbeat.check", 1L);
        TEST_UTIL.startMiniCluster(1);
        TestTableRecordReader.createTestTable(TABLE_NAME, ROWS, FAMILIES, QUALIFIERS, VALUE);
    }

    private static void createTestTable(TableName name, byte[][] rows, byte[][] families, byte[][] qualifiers, byte[] cellValue) throws IOException {
        TEST_UTIL.createTable(name, families).put(TestTableRecordReader.createPuts(rows, families, qualifiers, cellValue));
    }

    private static List<Put> createPuts(byte[][] rows, byte[][] families, byte[][] qualifiers, byte[] value) throws IOException {
        ArrayList<Put> puts = new ArrayList<Put>();
        for (int row = 0; row < rows.length; ++row) {
            Put put = new Put(rows[row]);
            for (int fam = 0; fam < families.length; ++fam) {
                for (int qual = 0; qual < qualifiers.length; ++qual) {
                    KeyValue kv = new KeyValue(rows[row], families[fam], qualifiers[qual], (long)qual, value);
                    put.add(kv);
                }
            }
            puts.add(put);
        }
        return puts;
    }

    @AfterClass
    public static void tearDownAfterClass() throws Exception {
        TEST_UTIL.shutdownMiniCluster();
    }

    @Test
    public void test() throws Exception {
        try (Connection conn = ConnectionFactory.createConnection(TEST_UTIL.getConfiguration());
             Table table = conn.getTable(TABLE_NAME);){
            TableRecordReaderImpl trr = new TableRecordReaderImpl();
            Scan scan = new Scan().setMaxResultSize(1L).setCaching(Integer.MAX_VALUE).setNeedCursorResult(true);
            trr.setScan(scan);
            trr.setHTable(table);
            trr.initialize(null, null);
            int num = 0;
            while (trr.nextKeyValue()) {
                ++num;
            }
            Assert.assertEquals((long)(NUM_ROWS * NUM_FAMILIES * NUM_QUALIFIERS), (long)num);
        }
    }
}

