/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.mapreduce;

import drill.shaded.hbase.guava.com.google.common.base.Throwables;
import java.util.Arrays;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.CategoryBasedTimeout;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.CellUtil;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.HTable;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.client.ResultScanner;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.client.Table;
import org.apache.hadoop.hbase.mapreduce.HashTable;
import org.apache.hadoop.hbase.mapreduce.SyncTable;
import org.apache.hadoop.hbase.testclassification.LargeTests;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.mapreduce.Counters;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Rule;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.rules.TestRule;

@Category(value={LargeTests.class})
public class TestSyncTable {
    @Rule
    public final TestRule timeout = CategoryBasedTimeout.builder().withTimeout(this.getClass()).withLookingForStuckThread(true).build();
    private static final Log LOG = LogFactory.getLog(TestSyncTable.class);
    private static final HBaseTestingUtility TEST_UTIL = new HBaseTestingUtility();

    @BeforeClass
    public static void beforeClass() throws Exception {
        TEST_UTIL.setJobWithoutMRCluster();
        TEST_UTIL.startMiniCluster(3);
    }

    @AfterClass
    public static void afterClass() throws Exception {
        TEST_UTIL.cleanupDataTestDirOnTestFS();
        TEST_UTIL.shutdownMiniCluster();
    }

    private static byte[][] generateSplits(int numRows, int numRegions) {
        byte[][] splitRows = new byte[numRegions - 1][];
        for (int i = 1; i < numRegions; ++i) {
            splitRows[i - 1] = Bytes.toBytes(numRows * i / numRegions);
        }
        return splitRows;
    }

    @Test
    public void testSyncTable() throws Exception {
        TableName sourceTableName = TableName.valueOf("testSourceTable");
        TableName targetTableName = TableName.valueOf("testTargetTable");
        Path testDir = TEST_UTIL.getDataTestDirOnTestFS("testSyncTable");
        this.writeTestData(sourceTableName, targetTableName, new long[0]);
        this.hashSourceTable(sourceTableName, testDir, new String[0]);
        Counters syncCounters = this.syncTables(sourceTableName, targetTableName, testDir, new String[0]);
        this.assertEqualTables(90, sourceTableName, targetTableName, false);
        Assert.assertEquals((long)60L, (long)syncCounters.findCounter((Enum)SyncTable.SyncMapper.Counter.ROWSWITHDIFFS).getValue());
        Assert.assertEquals((long)10L, (long)syncCounters.findCounter((Enum)SyncTable.SyncMapper.Counter.SOURCEMISSINGROWS).getValue());
        Assert.assertEquals((long)10L, (long)syncCounters.findCounter((Enum)SyncTable.SyncMapper.Counter.TARGETMISSINGROWS).getValue());
        Assert.assertEquals((long)50L, (long)syncCounters.findCounter((Enum)SyncTable.SyncMapper.Counter.SOURCEMISSINGCELLS).getValue());
        Assert.assertEquals((long)50L, (long)syncCounters.findCounter((Enum)SyncTable.SyncMapper.Counter.TARGETMISSINGCELLS).getValue());
        Assert.assertEquals((long)20L, (long)syncCounters.findCounter((Enum)SyncTable.SyncMapper.Counter.DIFFERENTCELLVALUES).getValue());
        TEST_UTIL.deleteTable(sourceTableName);
        TEST_UTIL.deleteTable(targetTableName);
    }

    @Test
    public void testSyncTableDoDeletesFalse() throws Exception {
        TableName sourceTableName = TableName.valueOf("testSyncTableDoDeletesFalse_source");
        TableName targetTableName = TableName.valueOf("testSyncTableDoDeletesFalse_target");
        Path testDir = TEST_UTIL.getDataTestDirOnTestFS("testSyncTableDoDeletesFalse");
        this.writeTestData(sourceTableName, targetTableName, new long[0]);
        this.hashSourceTable(sourceTableName, testDir, new String[0]);
        Counters syncCounters = this.syncTables(sourceTableName, targetTableName, testDir, "--doDeletes=false");
        this.assertTargetDoDeletesFalse(100, sourceTableName, targetTableName);
        Assert.assertEquals((long)60L, (long)syncCounters.findCounter((Enum)SyncTable.SyncMapper.Counter.ROWSWITHDIFFS).getValue());
        Assert.assertEquals((long)10L, (long)syncCounters.findCounter((Enum)SyncTable.SyncMapper.Counter.SOURCEMISSINGROWS).getValue());
        Assert.assertEquals((long)10L, (long)syncCounters.findCounter((Enum)SyncTable.SyncMapper.Counter.TARGETMISSINGROWS).getValue());
        Assert.assertEquals((long)50L, (long)syncCounters.findCounter((Enum)SyncTable.SyncMapper.Counter.SOURCEMISSINGCELLS).getValue());
        Assert.assertEquals((long)50L, (long)syncCounters.findCounter((Enum)SyncTable.SyncMapper.Counter.TARGETMISSINGCELLS).getValue());
        Assert.assertEquals((long)20L, (long)syncCounters.findCounter((Enum)SyncTable.SyncMapper.Counter.DIFFERENTCELLVALUES).getValue());
        TEST_UTIL.deleteTable(sourceTableName);
        TEST_UTIL.deleteTable(targetTableName);
    }

    @Test
    public void testSyncTableDoPutsFalse() throws Exception {
        TableName sourceTableName = TableName.valueOf("testSyncTableDoPutsFalse_source");
        TableName targetTableName = TableName.valueOf("testSyncTableDoPutsFalse_target");
        Path testDir = TEST_UTIL.getDataTestDirOnTestFS("testSyncTableDoPutsFalse");
        this.writeTestData(sourceTableName, targetTableName, new long[0]);
        this.hashSourceTable(sourceTableName, testDir, new String[0]);
        Counters syncCounters = this.syncTables(sourceTableName, targetTableName, testDir, "--doPuts=false");
        this.assertTargetDoPutsFalse(70, sourceTableName, targetTableName);
        Assert.assertEquals((long)60L, (long)syncCounters.findCounter((Enum)SyncTable.SyncMapper.Counter.ROWSWITHDIFFS).getValue());
        Assert.assertEquals((long)10L, (long)syncCounters.findCounter((Enum)SyncTable.SyncMapper.Counter.SOURCEMISSINGROWS).getValue());
        Assert.assertEquals((long)10L, (long)syncCounters.findCounter((Enum)SyncTable.SyncMapper.Counter.TARGETMISSINGROWS).getValue());
        Assert.assertEquals((long)50L, (long)syncCounters.findCounter((Enum)SyncTable.SyncMapper.Counter.SOURCEMISSINGCELLS).getValue());
        Assert.assertEquals((long)50L, (long)syncCounters.findCounter((Enum)SyncTable.SyncMapper.Counter.TARGETMISSINGCELLS).getValue());
        Assert.assertEquals((long)20L, (long)syncCounters.findCounter((Enum)SyncTable.SyncMapper.Counter.DIFFERENTCELLVALUES).getValue());
        TEST_UTIL.deleteTable(sourceTableName);
        TEST_UTIL.deleteTable(targetTableName);
    }

    @Test
    public void testSyncTableIgnoreTimestampsTrue() throws Exception {
        TableName sourceTableName = TableName.valueOf("testSyncTableIgnoreTimestampsTrue_source");
        TableName targetTableName = TableName.valueOf("testSyncTableIgnoreTimestampsTrue_target");
        Path testDir = TEST_UTIL.getDataTestDirOnTestFS("testSyncTableIgnoreTimestampsTrue");
        long current = System.currentTimeMillis();
        this.writeTestData(sourceTableName, targetTableName, current - 1000L, current);
        this.hashSourceTable(sourceTableName, testDir, "--ignoreTimestamps=true");
        Counters syncCounters = this.syncTables(sourceTableName, targetTableName, testDir, "--ignoreTimestamps=true");
        this.assertEqualTables(90, sourceTableName, targetTableName, true);
        Assert.assertEquals((long)50L, (long)syncCounters.findCounter((Enum)SyncTable.SyncMapper.Counter.ROWSWITHDIFFS).getValue());
        Assert.assertEquals((long)10L, (long)syncCounters.findCounter((Enum)SyncTable.SyncMapper.Counter.SOURCEMISSINGROWS).getValue());
        Assert.assertEquals((long)10L, (long)syncCounters.findCounter((Enum)SyncTable.SyncMapper.Counter.TARGETMISSINGROWS).getValue());
        Assert.assertEquals((long)30L, (long)syncCounters.findCounter((Enum)SyncTable.SyncMapper.Counter.SOURCEMISSINGCELLS).getValue());
        Assert.assertEquals((long)30L, (long)syncCounters.findCounter((Enum)SyncTable.SyncMapper.Counter.TARGETMISSINGCELLS).getValue());
        Assert.assertEquals((long)20L, (long)syncCounters.findCounter((Enum)SyncTable.SyncMapper.Counter.DIFFERENTCELLVALUES).getValue());
        TEST_UTIL.deleteTable(sourceTableName);
        TEST_UTIL.deleteTable(targetTableName);
    }

    private void assertEqualTables(int expectedRows, TableName sourceTableName, TableName targetTableName, boolean ignoreTimestamps) throws Exception {
        Result targetRow;
        Table sourceTable = TEST_UTIL.getConnection().getTable(sourceTableName);
        Table targetTable = TEST_UTIL.getConnection().getTable(targetTableName);
        ResultScanner sourceScanner = sourceTable.getScanner(new Scan());
        ResultScanner targetScanner = targetTable.getScanner(new Scan());
        for (int i = 0; i < expectedRows; ++i) {
            Object[] targetCells;
            Object[] sourceCells;
            Result sourceRow = sourceScanner.next();
            Result targetRow2 = targetScanner.next();
            LOG.debug((Object)("SOURCE row: " + (sourceRow == null ? "null" : Integer.valueOf(Bytes.toInt(sourceRow.getRow()))) + " cells:" + sourceRow));
            LOG.debug((Object)("TARGET row: " + (targetRow2 == null ? "null" : Integer.valueOf(Bytes.toInt(targetRow2.getRow()))) + " cells:" + targetRow2));
            if (sourceRow == null) {
                Assert.fail((String)("Expected " + expectedRows + " source rows but only found " + i));
            }
            if (targetRow2 == null) {
                Assert.fail((String)("Expected " + expectedRows + " target rows but only found " + i));
            }
            if ((sourceCells = sourceRow.rawCells()).length != (targetCells = targetRow2.rawCells()).length) {
                LOG.debug((Object)("Source cells: " + Arrays.toString(sourceCells)));
                LOG.debug((Object)("Target cells: " + Arrays.toString(targetCells)));
                Assert.fail((String)("Row " + Bytes.toInt(sourceRow.getRow()) + " has " + sourceCells.length + " cells in source table but " + targetCells.length + " cells in target table"));
            }
            for (int j = 0; j < sourceCells.length; ++j) {
                Object sourceCell = sourceCells[j];
                Cell targetCell = targetCells[j];
                try {
                    if (!CellUtil.matchingRow((Cell)sourceCell, targetCell)) {
                        Assert.fail((String)"Rows don't match");
                    }
                    if (!CellUtil.matchingFamily((Cell)sourceCell, targetCell)) {
                        Assert.fail((String)"Families don't match");
                    }
                    if (!CellUtil.matchingQualifier((Cell)sourceCell, targetCell)) {
                        Assert.fail((String)"Qualifiers don't match");
                    }
                    if (!ignoreTimestamps && !CellUtil.matchingTimestamp((Cell)sourceCell, targetCell)) {
                        Assert.fail((String)"Timestamps don't match");
                    }
                    if (CellUtil.matchingValue((Cell)sourceCell, targetCell)) continue;
                    Assert.fail((String)"Values don't match");
                    continue;
                }
                catch (Throwable t) {
                    LOG.debug((Object)("Source cell: " + sourceCell + " target cell: " + targetCell));
                    Throwables.propagate(t);
                }
            }
        }
        Result sourceRow = sourceScanner.next();
        if (sourceRow != null) {
            Assert.fail((String)("Source table has more than " + expectedRows + " rows.  Next row: " + Bytes.toInt(sourceRow.getRow())));
        }
        if ((targetRow = targetScanner.next()) != null) {
            Assert.fail((String)("Target table has more than " + expectedRows + " rows.  Next row: " + Bytes.toInt(targetRow.getRow())));
        }
        sourceScanner.close();
        targetScanner.close();
        sourceTable.close();
        targetTable.close();
    }

    private void assertTargetDoDeletesFalse(int expectedRows, TableName sourceTableName, TableName targetTableName) throws Exception {
        Table sourceTable = TEST_UTIL.getConnection().getTable(sourceTableName);
        Table targetTable = TEST_UTIL.getConnection().getTable(targetTableName);
        ResultScanner sourceScanner = sourceTable.getScanner(new Scan());
        ResultScanner targetScanner = targetTable.getScanner(new Scan());
        Result targetRow = targetScanner.next();
        Result sourceRow = sourceScanner.next();
        int rowsCount = 0;
        while (targetRow != null) {
            ++rowsCount;
            if (Bytes.toInt(sourceRow.getRow()) != Bytes.toInt(targetRow.getRow())) {
                targetRow = targetScanner.next();
                continue;
            }
            LOG.debug((Object)("SOURCE row: " + (sourceRow == null ? "null" : Integer.valueOf(Bytes.toInt(sourceRow.getRow()))) + " cells:" + sourceRow));
            LOG.debug((Object)("TARGET row: " + (targetRow == null ? "null" : Integer.valueOf(Bytes.toInt(targetRow.getRow()))) + " cells:" + targetRow));
            Object[] sourceCells = sourceRow.rawCells();
            Object[] targetCells = targetRow.rawCells();
            int targetRowKey = Bytes.toInt(targetRow.getRow());
            if (targetRowKey >= 70 && targetRowKey < 80) {
                if (sourceCells.length == targetCells.length) {
                    LOG.debug((Object)("Source cells: " + Arrays.toString(sourceCells)));
                    LOG.debug((Object)("Target cells: " + Arrays.toString(targetCells)));
                    Assert.fail((String)("Row " + targetRowKey + " should have more cells in target than in source"));
                }
            } else if (sourceCells.length != targetCells.length) {
                LOG.debug((Object)("Source cells: " + Arrays.toString(sourceCells)));
                LOG.debug((Object)("Target cells: " + Arrays.toString(targetCells)));
                Assert.fail((String)("Row " + Bytes.toInt(sourceRow.getRow()) + " has " + sourceCells.length + " cells in source table but " + targetCells.length + " cells in target table"));
            }
            for (int j = 0; j < sourceCells.length; ++j) {
                Object sourceCell = sourceCells[j];
                Cell targetCell = targetCells[j];
                try {
                    if (!CellUtil.matchingRow((Cell)sourceCell, targetCell)) {
                        Assert.fail((String)"Rows don't match");
                    }
                    if (!CellUtil.matchingFamily((Cell)sourceCell, targetCell)) {
                        Assert.fail((String)"Families don't match");
                    }
                    if (!CellUtil.matchingQualifier((Cell)sourceCell, targetCell)) {
                        Assert.fail((String)"Qualifiers don't match");
                    }
                    if (targetRowKey < 80 && targetRowKey >= 90 && !CellUtil.matchingTimestamp((Cell)sourceCell, targetCell)) {
                        Assert.fail((String)"Timestamps don't match");
                    }
                    if (CellUtil.matchingValue((Cell)sourceCell, targetCell)) continue;
                    Assert.fail((String)"Values don't match");
                    continue;
                }
                catch (Throwable t) {
                    LOG.debug((Object)("Source cell: " + sourceCell + " target cell: " + targetCell));
                    Throwables.propagate(t);
                }
            }
            targetRow = targetScanner.next();
            sourceRow = sourceScanner.next();
        }
        Assert.assertEquals((String)"Target expected rows does not match.", (long)expectedRows, (long)rowsCount);
        sourceScanner.close();
        targetScanner.close();
        sourceTable.close();
        targetTable.close();
    }

    private void assertTargetDoPutsFalse(int expectedRows, TableName sourceTableName, TableName targetTableName) throws Exception {
        Table sourceTable = TEST_UTIL.getConnection().getTable(sourceTableName);
        Table targetTable = TEST_UTIL.getConnection().getTable(targetTableName);
        ResultScanner sourceScanner = sourceTable.getScanner(new Scan());
        ResultScanner targetScanner = targetTable.getScanner(new Scan());
        Result targetRow = targetScanner.next();
        Result sourceRow = sourceScanner.next();
        int rowsCount = 0;
        while (targetRow != null) {
            Object targetCell;
            Object sourceCell;
            int j;
            if (Bytes.toInt(sourceRow.getRow()) != Bytes.toInt(targetRow.getRow())) {
                sourceRow = sourceScanner.next();
                continue;
            }
            LOG.debug((Object)("SOURCE row: " + (sourceRow == null ? "null" : Integer.valueOf(Bytes.toInt(sourceRow.getRow()))) + " cells:" + sourceRow));
            LOG.debug((Object)("TARGET row: " + (targetRow == null ? "null" : Integer.valueOf(Bytes.toInt(targetRow.getRow()))) + " cells:" + targetRow));
            LOG.debug((Object)("rowsCount: " + rowsCount));
            Object[] sourceCells = sourceRow.rawCells();
            Object[] targetCells = targetRow.rawCells();
            int targetRowKey = Bytes.toInt(targetRow.getRow());
            if (targetRowKey >= 40 && targetRowKey < 60) {
                LOG.debug((Object)("Source cells: " + Arrays.toString(sourceCells)));
                LOG.debug((Object)("Target cells: " + Arrays.toString(targetCells)));
                Assert.fail((String)"There shouldn't exist any rows between 40 and 60, since Puts are disabled and Deletes are enabled.");
            } else if (targetRowKey >= 60 && targetRowKey < 70) {
                if (sourceCells.length == targetCells.length) {
                    LOG.debug((Object)("Source cells: " + Arrays.toString(sourceCells)));
                    LOG.debug((Object)("Target cells: " + Arrays.toString(targetCells)));
                    Assert.fail((String)("Row " + Bytes.toInt(sourceRow.getRow()) + " shouldn't have same number of cells."));
                }
            } else if (targetRowKey >= 80 && targetRowKey < 90) {
                LOG.debug((Object)("Source cells: " + Arrays.toString(sourceCells)));
                LOG.debug((Object)("Target cells: " + Arrays.toString(targetCells)));
                Assert.fail((String)"There should be no rows between 80 and 90 on target, as these had different timestamps and should had been deleted.");
            } else if (targetRowKey >= 90 && targetRowKey < 100) {
                for (j = 0; j < sourceCells.length; ++j) {
                    sourceCell = sourceCells[j];
                    targetCell = targetCells[j];
                    if (!CellUtil.matchingValue((Cell)sourceCell, (Cell)targetCell)) continue;
                    Assert.fail((String)("Cells values should not match for rows between 90 and 100. Target row id: " + Bytes.toInt(targetRow.getRow())));
                }
            } else {
                for (j = 0; j < sourceCells.length; ++j) {
                    sourceCell = sourceCells[j];
                    targetCell = targetCells[j];
                    try {
                        if (!CellUtil.matchingRow((Cell)sourceCell, (Cell)targetCell)) {
                            Assert.fail((String)"Rows don't match");
                        }
                        if (!CellUtil.matchingFamily((Cell)sourceCell, (Cell)targetCell)) {
                            Assert.fail((String)"Families don't match");
                        }
                        if (!CellUtil.matchingQualifier((Cell)sourceCell, (Cell)targetCell)) {
                            Assert.fail((String)"Qualifiers don't match");
                        }
                        if (!CellUtil.matchingTimestamp((Cell)sourceCell, (Cell)targetCell)) {
                            Assert.fail((String)"Timestamps don't match");
                        }
                        if (CellUtil.matchingValue((Cell)sourceCell, (Cell)targetCell)) continue;
                        Assert.fail((String)"Values don't match");
                        continue;
                    }
                    catch (Throwable t) {
                        LOG.debug((Object)("Source cell: " + sourceCell + " target cell: " + targetCell));
                        Throwables.propagate(t);
                    }
                }
            }
            ++rowsCount;
            targetRow = targetScanner.next();
            sourceRow = sourceScanner.next();
        }
        Assert.assertEquals((String)"Target expected rows does not match.", (long)expectedRows, (long)rowsCount);
        sourceScanner.close();
        targetScanner.close();
        sourceTable.close();
        targetTable.close();
    }

    private Counters syncTables(TableName sourceTableName, TableName targetTableName, Path testDir, String ... options) throws Exception {
        SyncTable syncTable = new SyncTable(TEST_UTIL.getConfiguration());
        String[] args = Arrays.copyOf(options, options.length + 3);
        args[options.length] = testDir.toString();
        args[options.length + 1] = sourceTableName.getNameAsString();
        args[options.length + 2] = targetTableName.getNameAsString();
        int code = syncTable.run(args);
        Assert.assertEquals((String)"sync table job failed", (long)0L, (long)code);
        LOG.info((Object)"Sync tables completed");
        return syncTable.counters;
    }

    private void hashSourceTable(TableName sourceTableName, Path testDir, String ... options) throws Exception {
        int numHashFiles = 3;
        long batchSize = 100L;
        int scanBatch = 1;
        HashTable hashTable = new HashTable(TEST_UTIL.getConfiguration());
        String[] args = Arrays.copyOf(options, options.length + 5);
        args[options.length] = "--batchsize=" + batchSize;
        args[options.length + 1] = "--numhashfiles=" + numHashFiles;
        args[options.length + 2] = "--scanbatch=" + scanBatch;
        args[options.length + 3] = sourceTableName.getNameAsString();
        args[options.length + 4] = testDir.toString();
        int code = hashTable.run(args);
        Assert.assertEquals((String)"hash table job failed", (long)0L, (long)code);
        FileSystem fs = TEST_UTIL.getTestFileSystem();
        HashTable.TableHash tableHash = HashTable.TableHash.read(fs.getConf(), testDir);
        Assert.assertEquals((Object)sourceTableName.getNameAsString(), (Object)tableHash.tableName);
        Assert.assertEquals((long)batchSize, (long)tableHash.batchSize);
        Assert.assertEquals((long)numHashFiles, (long)tableHash.numHashFiles);
        Assert.assertEquals((long)(numHashFiles - 1), (long)tableHash.partitions.size());
        LOG.info((Object)"Hash table completed");
    }

    private void writeTestData(TableName sourceTableName, TableName targetTableName, long ... timestamps) throws Exception {
        Put put;
        Put targetPut;
        Put sourcePut;
        int rowIndex;
        byte[] family = Bytes.toBytes("family");
        byte[] column1 = Bytes.toBytes("c1");
        byte[] column2 = Bytes.toBytes("c2");
        byte[] value1 = Bytes.toBytes("val1");
        byte[] value2 = Bytes.toBytes("val2");
        byte[] value3 = Bytes.toBytes("val3");
        int numRows = 100;
        int sourceRegions = 10;
        int targetRegions = 6;
        if (ArrayUtils.isEmpty((long[])timestamps)) {
            long current = System.currentTimeMillis();
            timestamps = new long[]{current, current};
        }
        HTable sourceTable = TEST_UTIL.createTable(sourceTableName, family, TestSyncTable.generateSplits(numRows, sourceRegions));
        HTable targetTable = TEST_UTIL.createTable(targetTableName, family, TestSyncTable.generateSplits(numRows, targetRegions));
        for (rowIndex = 0; rowIndex < 40; ++rowIndex) {
            sourcePut = new Put(Bytes.toBytes(rowIndex));
            sourcePut.addColumn(family, column1, timestamps[0], value1);
            sourcePut.addColumn(family, column2, timestamps[0], value2);
            sourceTable.put(sourcePut);
            targetPut = new Put(Bytes.toBytes(rowIndex));
            targetPut.addColumn(family, column1, timestamps[1], value1);
            targetPut.addColumn(family, column2, timestamps[1], value2);
            targetTable.put(targetPut);
        }
        while (rowIndex < 50) {
            put = new Put(Bytes.toBytes(rowIndex));
            put.addColumn(family, column1, timestamps[0], value1);
            put.addColumn(family, column2, timestamps[0], value2);
            sourceTable.put(put);
            ++rowIndex;
        }
        while (rowIndex < 60) {
            put = new Put(Bytes.toBytes(rowIndex));
            put.addColumn(family, column1, timestamps[1], value1);
            put.addColumn(family, column2, timestamps[1], value2);
            targetTable.put(put);
            ++rowIndex;
        }
        while (rowIndex < 70) {
            sourcePut = new Put(Bytes.toBytes(rowIndex));
            sourcePut.addColumn(family, column1, timestamps[0], value1);
            sourcePut.addColumn(family, column2, timestamps[0], value2);
            sourceTable.put(sourcePut);
            targetPut = new Put(Bytes.toBytes(rowIndex));
            targetPut.addColumn(family, column1, timestamps[1], value1);
            targetTable.put(targetPut);
            ++rowIndex;
        }
        while (rowIndex < 80) {
            sourcePut = new Put(Bytes.toBytes(rowIndex));
            sourcePut.addColumn(family, column1, timestamps[0], value1);
            sourceTable.put(sourcePut);
            targetPut = new Put(Bytes.toBytes(rowIndex));
            targetPut.addColumn(family, column1, timestamps[1], value1);
            targetPut.addColumn(family, column2, timestamps[1], value2);
            targetTable.put(targetPut);
            ++rowIndex;
        }
        while (rowIndex < 90) {
            sourcePut = new Put(Bytes.toBytes(rowIndex));
            sourcePut.addColumn(family, column1, timestamps[0], column1);
            sourcePut.addColumn(family, column2, timestamps[0], value2);
            sourceTable.put(sourcePut);
            targetPut = new Put(Bytes.toBytes(rowIndex));
            targetPut.addColumn(family, column1, timestamps[1] + 1L, column1);
            targetPut.addColumn(family, column2, timestamps[1] - 1L, value2);
            targetTable.put(targetPut);
            ++rowIndex;
        }
        while (rowIndex < numRows) {
            sourcePut = new Put(Bytes.toBytes(rowIndex));
            sourcePut.addColumn(family, column1, timestamps[0], value1);
            sourcePut.addColumn(family, column2, timestamps[0], value2);
            sourceTable.put(sourcePut);
            targetPut = new Put(Bytes.toBytes(rowIndex));
            targetPut.addColumn(family, column1, timestamps[1], value3);
            targetPut.addColumn(family, column2, timestamps[1], value3);
            targetTable.put(targetPut);
            ++rowIndex;
        }
        sourceTable.close();
        targetTable.close();
    }
}

