/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.ipc;

import com.google.protobuf.ServiceException;
import drill.shaded.hbase.guava.com.google.common.collect.Lists;
import java.io.IOException;
import java.net.InetSocketAddress;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.HBaseConfiguration;
import org.apache.hadoop.hbase.ipc.FifoRpcScheduler;
import org.apache.hadoop.hbase.ipc.RpcClient;
import org.apache.hadoop.hbase.ipc.RpcClientFactory;
import org.apache.hadoop.hbase.ipc.RpcServer;
import org.apache.hadoop.hbase.ipc.RpcServerInterface;
import org.apache.hadoop.hbase.ipc.TestProtobufRpcServiceImpl;
import org.apache.hadoop.hbase.ipc.protobuf.generated.TestProtos;
import org.apache.hadoop.hbase.ipc.protobuf.generated.TestRpcServiceProtos;
import org.apache.hadoop.hbase.testclassification.MediumTests;
import org.apache.hadoop.hbase.testclassification.RPCTests;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={RPCTests.class, MediumTests.class})
public class TestProtoBufRpc {
    public static final String ADDRESS = "localhost";
    public static int PORT = 0;
    private InetSocketAddress isa;
    private Configuration conf;
    private RpcServerInterface server;

    @Before
    public void setUp() throws IOException {
        this.conf = HBaseConfiguration.create();
        Logger log = Logger.getLogger((String)"org.apache.hadoop.ipc.HBaseServer");
        log.setLevel(Level.DEBUG);
        log = Logger.getLogger((String)"org.apache.hadoop.ipc.HBaseServer.trace");
        log.setLevel(Level.TRACE);
        this.server = new RpcServer(null, "testrpc", Lists.newArrayList(new RpcServer.BlockingServiceAndInterface(TestProtobufRpcServiceImpl.SERVICE, null)), new InetSocketAddress(ADDRESS, PORT), this.conf, new FifoRpcScheduler(this.conf, 10));
        InetSocketAddress address = this.server.getListenerAddress();
        if (address == null) {
            throw new IOException("Listener channel is closed");
        }
        this.isa = address;
        this.server.start();
    }

    @After
    public void tearDown() throws Exception {
        this.server.stop();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(expected=ServiceException.class)
    public void testProtoBufRpc() throws Exception {
        try (RpcClient rpcClient = RpcClientFactory.createClient(this.conf, "default-cluster");){
            TestRpcServiceProtos.TestProtobufRpcProto.BlockingInterface stub = TestProtobufRpcServiceImpl.newBlockingStub(rpcClient, this.isa);
            TestProtos.EmptyRequestProto emptyRequest = TestProtos.EmptyRequestProto.newBuilder().build();
            stub.ping(null, emptyRequest);
            TestProtos.EchoRequestProto echoRequest = TestProtos.EchoRequestProto.newBuilder().setMessage("hello").build();
            TestProtos.EchoResponseProto echoResponse = stub.echo(null, echoRequest);
            Assert.assertEquals((Object)echoResponse.getMessage(), (Object)"hello");
            stub.error(null, emptyRequest);
            Assert.fail((String)"Expected exception is not thrown");
        }
    }
}

