/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.io.hfile;

import java.util.ArrayList;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.CellUtil;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.io.hfile.CacheConfig;
import org.apache.hadoop.hbase.io.hfile.HFile;
import org.apache.hadoop.hbase.io.hfile.HFileContext;
import org.apache.hadoop.hbase.io.hfile.HFileContextBuilder;
import org.apache.hadoop.hbase.io.hfile.HFileReaderV2;
import org.apache.hadoop.hbase.io.hfile.HFileScanner;
import org.apache.hadoop.hbase.io.hfile.HFileWriterV2;
import org.apache.hadoop.hbase.testclassification.SmallTests;
import org.apache.hadoop.hbase.util.Bytes;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={SmallTests.class})
public class TestHFileInlineToRootChunkConversion {
    private final HBaseTestingUtility testUtil = new HBaseTestingUtility();
    private final Configuration conf = this.testUtil.getConfiguration();

    @Test
    public void testWriteHFile() throws Exception {
        Path hfPath = new Path(this.testUtil.getDataTestDir(), TestHFileInlineToRootChunkConversion.class.getSimpleName() + ".hfile");
        int maxChunkSize = 1024;
        FileSystem fs = FileSystem.get((Configuration)this.conf);
        CacheConfig cacheConf = new CacheConfig(this.conf);
        this.conf.setInt("hfile.index.block.max.size", maxChunkSize);
        HFileContext context = new HFileContextBuilder().withBlockSize(16).build();
        HFileWriterV2 hfw = (HFileWriterV2)new HFileWriterV2.WriterFactoryV2(this.conf, cacheConf).withFileContext(context).withPath(fs, hfPath).create();
        ArrayList<byte[]> keys = new ArrayList<byte[]>();
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < 4; ++i) {
            sb.append("key" + String.format("%05d", i));
            sb.append("_");
            for (int j = 0; j < 100; ++j) {
                sb.append(48 + j);
            }
            String keyStr = sb.toString();
            sb.setLength(0);
            byte[] k = Bytes.toBytes(keyStr);
            keys.add(k);
            byte[] v = Bytes.toBytes("value" + i);
            hfw.append(CellUtil.createCell(k, v));
        }
        hfw.close();
        HFileReaderV2 reader = (HFileReaderV2)HFile.createReader(fs, hfPath, cacheConf, this.conf);
        HFileScanner scanner = reader.getScanner(true, true);
        for (int i = 0; i < keys.size(); ++i) {
            scanner.seekTo(CellUtil.createCell((byte[])keys.get(i)));
        }
        reader.close();
    }
}

