/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.io.hfile;

import java.util.Random;
import org.apache.hadoop.hbase.io.hfile.RandomDistribution;
import org.apache.hadoop.io.BytesWritable;

class KeySampler {
    Random random;
    int min;
    int max;
    RandomDistribution.DiscreteRNG keyLenRNG;
    private static final int MIN_KEY_LEN = 4;

    public KeySampler(Random random, byte[] first, byte[] last, RandomDistribution.DiscreteRNG keyLenRNG) {
        this.random = random;
        int firstLen = this.keyPrefixToInt(first);
        int lastLen = this.keyPrefixToInt(last);
        this.min = Math.min(firstLen, lastLen);
        this.max = Math.max(firstLen, lastLen);
        System.out.println(this.min);
        System.out.println(this.max);
        this.keyLenRNG = keyLenRNG;
    }

    private int keyPrefixToInt(byte[] key) {
        byte[] b = key;
        int o = 0;
        return (b[o] & 0xFF) << 24 | (b[o + 1] & 0xFF) << 16 | (b[o + 2] & 0xFF) << 8 | b[o + 3] & 0xFF;
    }

    public void next(BytesWritable key) {
        key.setSize(Math.max(4, this.keyLenRNG.nextInt()));
        this.random.nextBytes(key.get());
        int rnd = 0;
        if (this.max != this.min) {
            rnd = this.random.nextInt(this.max - this.min);
        }
        int n = rnd + this.min;
        byte[] b = key.get();
        b[0] = (byte)(n >> 24);
        b[1] = (byte)(n >> 16);
        b[2] = (byte)(n >> 8);
        b[3] = (byte)n;
    }
}

