/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.io.crypto;

import java.io.File;
import java.io.FileOutputStream;
import java.net.URLEncoder;
import java.security.Key;
import java.security.KeyStore;
import java.security.MessageDigest;
import java.util.Properties;
import javax.crypto.spec.SecretKeySpec;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.hbase.HBaseCommonTestingUtility;
import org.apache.hadoop.hbase.io.crypto.KeyStoreKeyProvider;
import org.apache.hadoop.hbase.testclassification.SmallTests;
import org.apache.hadoop.hbase.util.Bytes;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={SmallTests.class})
public class TestKeyStoreKeyProvider {
    private static final Log LOG = LogFactory.getLog(TestKeyStoreKeyProvider.class);
    static final HBaseCommonTestingUtility TEST_UTIL = new HBaseCommonTestingUtility();
    static final String ALIAS = "test";
    static final String PASSWORD = "password";
    static byte[] KEY;
    static File storeFile;
    static File passwordFile;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @BeforeClass
    public static void setUp() throws Exception {
        KEY = MessageDigest.getInstance("SHA-256").digest(Bytes.toBytes(ALIAS));
        KeyStore store = KeyStore.getInstance("JCEKS");
        store.load(null, PASSWORD.toCharArray());
        store.setEntry(ALIAS, new KeyStore.SecretKeyEntry(new SecretKeySpec(KEY, "AES")), new KeyStore.PasswordProtection(PASSWORD.toCharArray()));
        String dataDir = TEST_UTIL.getDataTestDir().toString();
        new File(dataDir).mkdirs();
        storeFile = new File(dataDir, "keystore.jks");
        try (FileOutputStream os = new FileOutputStream(storeFile);){
            store.store(os, PASSWORD.toCharArray());
        }
        Properties p = new Properties();
        p.setProperty(ALIAS, PASSWORD);
        passwordFile = new File(dataDir, "keystore.pw");
        os = new FileOutputStream(passwordFile);
        try {
            p.store(os, "");
        }
        finally {
            os.close();
        }
    }

    @Test(timeout=30000L)
    public void testKeyStoreKeyProviderWithPassword() throws Exception {
        KeyStoreKeyProvider provider = new KeyStoreKeyProvider();
        provider.init("jceks://" + storeFile.toURI().getPath() + "?password=" + PASSWORD);
        Key key = provider.getKey(ALIAS);
        Assert.assertNotNull((Object)key);
        byte[] keyBytes = key.getEncoded();
        Assert.assertEquals((long)keyBytes.length, (long)KEY.length);
        for (int i = 0; i < KEY.length; ++i) {
            Assert.assertEquals((long)keyBytes[i], (long)KEY[i]);
        }
    }

    @Test(timeout=30000L)
    public void testKeyStoreKeyProviderWithPasswordFile() throws Exception {
        KeyStoreKeyProvider provider = new KeyStoreKeyProvider();
        provider.init("jceks://" + storeFile.toURI().getPath() + "?passwordFile=" + URLEncoder.encode(passwordFile.getAbsolutePath(), "UTF-8"));
        Key key = provider.getKey(ALIAS);
        Assert.assertNotNull((Object)key);
        byte[] keyBytes = key.getEncoded();
        Assert.assertEquals((long)keyBytes.length, (long)KEY.length);
        for (int i = 0; i < KEY.length; ++i) {
            Assert.assertEquals((long)keyBytes[i], (long)KEY[i]);
        }
    }
}

