/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.http;

import java.util.EnumSet;
import javax.servlet.DispatcherType;
import org.apache.commons.lang.StringUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.http.CustomHeadersFilter;
import org.eclipse.jetty.servlet.FilterHolder;
import org.eclipse.jetty.servlet.ServletContextHandler;

public class FiltersUtil {
    public static void addCustomHeadersFilterIfPresent(ServletContextHandler contextHandler, Configuration configuration) {
        String headersFileLocation = configuration.get("hbase.custom.headers.file");
        if (!StringUtils.isEmpty((String)headersFileLocation)) {
            contextHandler.addFilter(FiltersUtil.makeCustomHeadersFilter(headersFileLocation), "/*", EnumSet.allOf(DispatcherType.class));
        }
    }

    private static FilterHolder makeCustomHeadersFilter(String headersFileLocation) {
        FilterHolder customHeadersFilter = new FilterHolder(CustomHeadersFilter.class);
        customHeadersFilter.setInitParameter("hbase.custom.headers.file", headersFileLocation);
        return customHeadersFilter;
    }
}

