/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.filter;

import drill.shaded.hbase.guava.com.google.common.collect.Lists;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Objects;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.KeyValue;
import org.apache.hadoop.hbase.KeyValueUtil;
import org.apache.hadoop.hbase.exceptions.DeserializationException;
import org.apache.hadoop.hbase.filter.BinaryComparator;
import org.apache.hadoop.hbase.filter.ColumnPaginationFilter;
import org.apache.hadoop.hbase.filter.CompareFilter;
import org.apache.hadoop.hbase.filter.FamilyFilter;
import org.apache.hadoop.hbase.filter.Filter;
import org.apache.hadoop.hbase.filter.FilterBase;
import org.apache.hadoop.hbase.filter.FilterList;
import org.apache.hadoop.hbase.filter.FirstKeyOnlyFilter;
import org.apache.hadoop.hbase.filter.InclusiveStopFilter;
import org.apache.hadoop.hbase.filter.KeyOnlyFilter;
import org.apache.hadoop.hbase.filter.PageFilter;
import org.apache.hadoop.hbase.filter.PrefixFilter;
import org.apache.hadoop.hbase.filter.QualifierFilter;
import org.apache.hadoop.hbase.filter.SingleColumnValueFilter;
import org.apache.hadoop.hbase.filter.WhileMatchFilter;
import org.apache.hadoop.hbase.protobuf.ProtobufUtil;
import org.apache.hadoop.hbase.testclassification.FilterTests;
import org.apache.hadoop.hbase.testclassification.SmallTests;
import org.apache.hadoop.hbase.util.Bytes;
import org.junit.Assert;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.mockito.Mockito;

@Category(value={FilterTests.class, SmallTests.class})
public class TestFilterList {
    static final int MAX_PAGES = 2;

    @Test
    public void testAddFilter() throws Exception {
        FirstKeyOnlyFilter filter1 = new FirstKeyOnlyFilter();
        FirstKeyOnlyFilter filter2 = new FirstKeyOnlyFilter();
        FilterList filterList = new FilterList(filter1, filter2);
        filterList.addFilter(new FirstKeyOnlyFilter());
        filterList = new FilterList(Arrays.asList(filter1, filter2));
        filterList.addFilter(new FirstKeyOnlyFilter());
        filterList = new FilterList(FilterList.Operator.MUST_PASS_ALL, filter1, filter2);
        filterList.addFilter(new FirstKeyOnlyFilter());
        filterList = new FilterList(FilterList.Operator.MUST_PASS_ALL, Arrays.asList(filter1, filter2));
        filterList.addFilter(new FirstKeyOnlyFilter());
        filterList.setReversed(false);
        FirstKeyOnlyFilter f = new FirstKeyOnlyFilter();
        f.setReversed(true);
        try {
            filterList.addFilter(f);
            Assert.fail((String)"The IllegalArgumentException should be thrown because the added filter is reversed");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void testConstruction() {
        FilterList ff2;
        FirstKeyOnlyFilter f1 = new FirstKeyOnlyFilter();
        FirstKeyOnlyFilter f2 = new FirstKeyOnlyFilter();
        f1.setReversed(true);
        f2.setReversed(false);
        try {
            ff2 = new FilterList(f1, f2);
            Assert.fail((String)"The IllegalArgumentException should be thrown");
        }
        catch (IllegalArgumentException ff2) {
            // empty catch block
        }
        try {
            ff2 = new FilterList(Arrays.asList(f1, f2));
            Assert.fail((String)"The IllegalArgumentException should be thrown because the added filter is reversed");
        }
        catch (IllegalArgumentException ff3) {
            // empty catch block
        }
        try {
            ff2 = new FilterList(FilterList.Operator.MUST_PASS_ALL, Arrays.asList(f1, f2));
            Assert.fail((String)"The IllegalArgumentException should be thrown because the added filter is reversed");
        }
        catch (IllegalArgumentException ff4) {
            // empty catch block
        }
        try {
            ff2 = new FilterList(FilterList.Operator.MUST_PASS_ALL, f1, f2);
            Assert.fail((String)"The IllegalArgumentException should be thrown because the added filter is reversed");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void testMPONE() throws Exception {
        this.mpOneTest(this.getFilterMPONE());
    }

    private Filter getFilterMPONE() {
        ArrayList<Filter> filters = new ArrayList<Filter>();
        filters.add(new PageFilter(2L));
        filters.add(new WhileMatchFilter(new PrefixFilter(Bytes.toBytes("yyy"))));
        return new FilterList(FilterList.Operator.MUST_PASS_ONE, filters);
    }

    private void mpOneTest(Filter filterMPONE) throws Exception {
        filterMPONE.reset();
        Assert.assertFalse((boolean)filterMPONE.filterAllRemaining());
        byte[] rowkey = Bytes.toBytes("yyyyyyyyy");
        for (int i = 0; i < 1; ++i) {
            Assert.assertFalse((boolean)filterMPONE.filterRowKey(rowkey, 0, rowkey.length));
            KeyValue kv = new KeyValue(rowkey, rowkey, Bytes.toBytes(i), Bytes.toBytes(i));
            Assert.assertTrue((Filter.ReturnCode.INCLUDE == filterMPONE.filterKeyValue(kv) ? 1 : 0) != 0);
            Assert.assertFalse((boolean)filterMPONE.filterRow());
        }
        rowkey = Bytes.toBytes("z");
        Assert.assertFalse((boolean)filterMPONE.filterRowKey(rowkey, 0, rowkey.length));
        KeyValue kv = new KeyValue(rowkey, rowkey, Bytes.toBytes(0), Bytes.toBytes(0));
        Assert.assertTrue((Filter.ReturnCode.INCLUDE == filterMPONE.filterKeyValue(kv) ? 1 : 0) != 0);
        Assert.assertFalse((boolean)filterMPONE.filterRow());
        rowkey = Bytes.toBytes("yyy");
        Assert.assertTrue((boolean)filterMPONE.filterRowKey(rowkey, 0, rowkey.length));
        kv = new KeyValue(rowkey, rowkey, Bytes.toBytes(0), Bytes.toBytes(0));
        Assert.assertFalse((Filter.ReturnCode.INCLUDE == filterMPONE.filterKeyValue(kv) ? 1 : 0) != 0);
        Assert.assertFalse((boolean)filterMPONE.filterRow());
        rowkey = Bytes.toBytes("z");
        Assert.assertTrue((boolean)filterMPONE.filterRowKey(rowkey, 0, rowkey.length));
        Assert.assertTrue((boolean)filterMPONE.filterAllRemaining());
    }

    @Test
    public void testMPALL() throws Exception {
        this.mpAllTest(this.getMPALLFilter());
    }

    private Filter getMPALLFilter() {
        ArrayList<Filter> filters = new ArrayList<Filter>();
        filters.add(new PageFilter(2L));
        filters.add(new WhileMatchFilter(new PrefixFilter(Bytes.toBytes("yyy"))));
        FilterList filterMPALL = new FilterList(FilterList.Operator.MUST_PASS_ALL, filters);
        return filterMPALL;
    }

    private void mpAllTest(Filter filterMPALL) throws Exception {
        filterMPALL.reset();
        Assert.assertFalse((boolean)filterMPALL.filterAllRemaining());
        byte[] rowkey = Bytes.toBytes("yyyyyyyyy");
        for (int i = 0; i < 1; ++i) {
            Assert.assertFalse((boolean)filterMPALL.filterRowKey(rowkey, 0, rowkey.length));
            KeyValue kv = new KeyValue(rowkey, rowkey, Bytes.toBytes(i), Bytes.toBytes(i));
            Assert.assertTrue((Filter.ReturnCode.INCLUDE == filterMPALL.filterKeyValue(kv) ? 1 : 0) != 0);
        }
        filterMPALL.reset();
        rowkey = Bytes.toBytes("z");
        Assert.assertTrue((boolean)filterMPALL.filterRowKey(rowkey, 0, rowkey.length));
        KeyValue kv = new KeyValue(rowkey, rowkey, rowkey, rowkey);
        Assert.assertTrue((Filter.ReturnCode.NEXT_ROW == filterMPALL.filterKeyValue(kv) ? 1 : 0) != 0);
    }

    @Test
    public void testOrdering() throws Exception {
        this.orderingTest(this.getOrderingFilter());
    }

    public Filter getOrderingFilter() {
        ArrayList<Filter> filters = new ArrayList<Filter>();
        filters.add(new PrefixFilter(Bytes.toBytes("yyy")));
        filters.add(new PageFilter(2L));
        FilterList filterMPONE = new FilterList(FilterList.Operator.MUST_PASS_ONE, filters);
        return filterMPONE;
    }

    public void orderingTest(Filter filterMPONE) throws Exception {
        KeyValue kv;
        int i;
        filterMPONE.reset();
        Assert.assertFalse((boolean)filterMPONE.filterAllRemaining());
        byte[] rowkey = Bytes.toBytes("yyyyyyyy");
        for (i = 0; i < 2; ++i) {
            Assert.assertFalse((boolean)filterMPONE.filterRowKey(rowkey, 0, rowkey.length));
            kv = new KeyValue(rowkey, rowkey, Bytes.toBytes(i), Bytes.toBytes(i));
            Assert.assertTrue((Filter.ReturnCode.INCLUDE == filterMPONE.filterKeyValue(kv) ? 1 : 0) != 0);
            Assert.assertFalse((boolean)filterMPONE.filterRow());
        }
        rowkey = Bytes.toBytes("xxxxxxx");
        for (i = 0; i < 2; ++i) {
            Assert.assertFalse((boolean)filterMPONE.filterRowKey(rowkey, 0, rowkey.length));
            kv = new KeyValue(rowkey, rowkey, Bytes.toBytes(i), Bytes.toBytes(i));
            Assert.assertTrue((Filter.ReturnCode.INCLUDE == filterMPONE.filterKeyValue(kv) ? 1 : 0) != 0);
            Assert.assertFalse((boolean)filterMPONE.filterRow());
        }
        rowkey = Bytes.toBytes("yyy");
        for (i = 0; i < 2; ++i) {
            Assert.assertFalse((boolean)filterMPONE.filterRowKey(rowkey, 0, rowkey.length));
            kv = new KeyValue(rowkey, rowkey, Bytes.toBytes(i), Bytes.toBytes(i));
            Assert.assertTrue((Filter.ReturnCode.INCLUDE == filterMPONE.filterKeyValue(kv) ? 1 : 0) != 0);
            Assert.assertFalse((boolean)filterMPONE.filterRow());
        }
    }

    @Test
    public void testFilterListTwoFiltersMustPassOne() throws Exception {
        byte[] r1 = Bytes.toBytes("Row1");
        byte[] r11 = Bytes.toBytes("Row11");
        byte[] r2 = Bytes.toBytes("Row2");
        FilterList flist = new FilterList(FilterList.Operator.MUST_PASS_ONE);
        flist.addFilter(new PrefixFilter(r1));
        flist.filterRowKey(r1, 0, r1.length);
        Assert.assertEquals((Object)((Object)Filter.ReturnCode.INCLUDE), (Object)((Object)flist.filterKeyValue(new KeyValue(r1, r1, r1))));
        Assert.assertEquals((Object)((Object)Filter.ReturnCode.INCLUDE), (Object)((Object)flist.filterKeyValue(new KeyValue(r11, r11, r11))));
        flist.reset();
        flist.filterRowKey(r2, 0, r2.length);
        Assert.assertEquals((Object)((Object)Filter.ReturnCode.SKIP), (Object)((Object)flist.filterKeyValue(new KeyValue(r2, r2, r2))));
        flist = new FilterList(FilterList.Operator.MUST_PASS_ONE);
        flist.addFilter(new AlwaysNextColFilter());
        flist.addFilter(new PrefixFilter(r1));
        flist.filterRowKey(r1, 0, r1.length);
        Assert.assertEquals((Object)((Object)Filter.ReturnCode.INCLUDE), (Object)((Object)flist.filterKeyValue(new KeyValue(r1, r1, r1))));
        Assert.assertEquals((Object)((Object)Filter.ReturnCode.INCLUDE), (Object)((Object)flist.filterKeyValue(new KeyValue(r11, r11, r11))));
        flist.reset();
        flist.filterRowKey(r2, 0, r2.length);
        Assert.assertEquals((Object)((Object)Filter.ReturnCode.NEXT_COL), (Object)((Object)flist.filterKeyValue(new KeyValue(r2, r2, r2))));
    }

    @Test
    public void testFilterListWithInclusiveStopFilterMustPassOne() throws Exception {
        byte[] r1 = Bytes.toBytes("Row1");
        byte[] r11 = Bytes.toBytes("Row11");
        byte[] r2 = Bytes.toBytes("Row2");
        FilterList flist = new FilterList(FilterList.Operator.MUST_PASS_ONE);
        flist.addFilter(new AlwaysNextColFilter());
        flist.addFilter(new InclusiveStopFilter(r1));
        flist.filterRowKey(r1, 0, r1.length);
        Assert.assertEquals((Object)((Object)Filter.ReturnCode.INCLUDE), (Object)((Object)flist.filterKeyValue(new KeyValue(r1, r1, r1))));
        Assert.assertEquals((Object)((Object)Filter.ReturnCode.INCLUDE), (Object)((Object)flist.filterKeyValue(new KeyValue(r11, r11, r11))));
        flist.reset();
        flist.filterRowKey(r2, 0, r2.length);
        Assert.assertEquals((Object)((Object)Filter.ReturnCode.NEXT_COL), (Object)((Object)flist.filterKeyValue(new KeyValue(r2, r2, r2))));
    }

    @Test
    public void testSerialization() throws Exception {
        ArrayList<Filter> filters = new ArrayList<Filter>();
        filters.add(new PageFilter(2L));
        filters.add(new WhileMatchFilter(new PrefixFilter(Bytes.toBytes("yyy"))));
        FilterList filterMPALL = new FilterList(FilterList.Operator.MUST_PASS_ALL, filters);
        byte[] buffer = ((Filter)filterMPALL).toByteArray();
        FilterList.parseFrom(buffer);
        this.mpOneTest(ProtobufUtil.toFilter(ProtobufUtil.toFilter(this.getFilterMPONE())));
        this.mpAllTest(ProtobufUtil.toFilter(ProtobufUtil.toFilter(this.getMPALLFilter())));
        this.orderingTest(ProtobufUtil.toFilter(ProtobufUtil.toFilter(this.getOrderingFilter())));
    }

    @Test
    public void testFilterKeyValue() throws Exception {
        FilterBase includeFilter = new FilterBase(){

            @Override
            public Filter.ReturnCode filterKeyValue(Cell v) {
                return Filter.ReturnCode.INCLUDE;
            }
        };
        FilterBase alternateFilter = new FilterBase(){
            boolean returnInclude = true;

            @Override
            public Filter.ReturnCode filterKeyValue(Cell v) {
                Filter.ReturnCode returnCode = this.returnInclude ? Filter.ReturnCode.INCLUDE : Filter.ReturnCode.SKIP;
                this.returnInclude = !this.returnInclude;
                return returnCode;
            }
        };
        FilterBase alternateIncludeFilter = new FilterBase(){
            boolean returnIncludeOnly = false;

            @Override
            public Filter.ReturnCode filterKeyValue(Cell v) {
                Filter.ReturnCode returnCode = this.returnIncludeOnly ? Filter.ReturnCode.INCLUDE : Filter.ReturnCode.INCLUDE_AND_NEXT_COL;
                this.returnIncludeOnly = !this.returnIncludeOnly;
                return returnCode;
            }
        };
        FilterList mpOnefilterList = new FilterList(FilterList.Operator.MUST_PASS_ONE, Arrays.asList(includeFilter, alternateIncludeFilter, alternateFilter));
        Assert.assertEquals((Object)((Object)Filter.ReturnCode.INCLUDE), (Object)((Object)mpOnefilterList.filterKeyValue(null)));
        Assert.assertEquals((Object)((Object)Filter.ReturnCode.INCLUDE), (Object)((Object)mpOnefilterList.filterKeyValue(null)));
        FilterList mpAllfilterList = new FilterList(FilterList.Operator.MUST_PASS_ALL, Arrays.asList(includeFilter, alternateIncludeFilter, alternateFilter));
        Assert.assertEquals((Object)((Object)Filter.ReturnCode.INCLUDE_AND_NEXT_COL), (Object)((Object)mpAllfilterList.filterKeyValue(null)));
        Assert.assertEquals((Object)((Object)Filter.ReturnCode.SKIP), (Object)((Object)mpAllfilterList.filterKeyValue(null)));
    }

    @Test
    public void testHintPassThru() throws Exception {
        final KeyValue minKeyValue = new KeyValue(Bytes.toBytes(0L), null, null);
        KeyValue maxKeyValue = new KeyValue(Bytes.toBytes(Long.MAX_VALUE), null, null);
        FilterBase filterNoHint = new FilterBase(){

            @Override
            public byte[] toByteArray() {
                return null;
            }

            @Override
            public Filter.ReturnCode filterKeyValue(Cell ignored) throws IOException {
                return Filter.ReturnCode.INCLUDE;
            }
        };
        FilterBase filterMinHint = new FilterBase(){

            @Override
            public Filter.ReturnCode filterKeyValue(Cell ignored) {
                return Filter.ReturnCode.SEEK_NEXT_USING_HINT;
            }

            @Override
            public Cell getNextCellHint(Cell currentKV) {
                return minKeyValue;
            }

            @Override
            public byte[] toByteArray() {
                return null;
            }
        };
        FilterBase filterMaxHint = new FilterBase(){

            @Override
            public Filter.ReturnCode filterKeyValue(Cell ignored) {
                return Filter.ReturnCode.SEEK_NEXT_USING_HINT;
            }

            @Override
            public Cell getNextCellHint(Cell cell) {
                return new KeyValue(Bytes.toBytes(Long.MAX_VALUE), null, null);
            }

            @Override
            public byte[] toByteArray() {
                return null;
            }
        };
        FilterList filterList = new FilterList(FilterList.Operator.MUST_PASS_ONE, Arrays.asList(filterMinHint, filterMaxHint));
        Assert.assertEquals((long)0L, (long)KeyValue.COMPARATOR.compare(filterList.getNextCellHint(null), minKeyValue));
        filterList = new FilterList(FilterList.Operator.MUST_PASS_ONE, Arrays.asList(filterMinHint, filterMaxHint, filterNoHint));
        Assert.assertNull((Object)filterList.getNextCellHint(null));
        filterList = new FilterList(FilterList.Operator.MUST_PASS_ONE, Arrays.asList(filterNoHint, filterMaxHint));
        Assert.assertNull((Object)filterList.getNextCellHint(null));
        filterList = new FilterList(FilterList.Operator.MUST_PASS_ONE, Arrays.asList(filterMaxHint, filterMaxHint));
        Assert.assertEquals((long)0L, (long)KeyValue.COMPARATOR.compare(filterList.getNextCellHint(null), maxKeyValue));
        filterList = new FilterList(FilterList.Operator.MUST_PASS_ALL, Arrays.asList(filterMinHint, filterMaxHint));
        filterList.filterKeyValue(null);
        Assert.assertEquals((long)0L, (long)KeyValue.COMPARATOR.compare(filterList.getNextCellHint(null), minKeyValue));
        filterList = new FilterList(FilterList.Operator.MUST_PASS_ALL, Arrays.asList(filterMaxHint, filterMinHint));
        filterList.filterKeyValue(null);
        Assert.assertEquals((long)0L, (long)KeyValue.COMPARATOR.compare(filterList.getNextCellHint(null), maxKeyValue));
        filterList = new FilterList(FilterList.Operator.MUST_PASS_ALL, Arrays.asList(filterNoHint, filterMinHint, filterMaxHint));
        filterList.filterKeyValue(null);
        Assert.assertEquals((long)0L, (long)KeyValue.COMPARATOR.compare(filterList.getNextCellHint(null), minKeyValue));
        filterList = new FilterList(FilterList.Operator.MUST_PASS_ALL, Arrays.asList(filterNoHint, filterMaxHint));
        filterList.filterKeyValue(null);
        Assert.assertEquals((long)0L, (long)KeyValue.COMPARATOR.compare(filterList.getNextCellHint(null), maxKeyValue));
        filterList = new FilterList(FilterList.Operator.MUST_PASS_ALL, Arrays.asList(filterNoHint, filterMinHint));
        filterList.filterKeyValue(null);
        Assert.assertEquals((long)0L, (long)KeyValue.COMPARATOR.compare(filterList.getNextCellHint(null), minKeyValue));
    }

    @Test
    public void testTransformMPO() throws Exception {
        FilterList flist = new FilterList(FilterList.Operator.MUST_PASS_ONE, Lists.newArrayList(new FilterList(FilterList.Operator.MUST_PASS_ALL, Lists.newArrayList(new FamilyFilter(CompareFilter.CompareOp.EQUAL, new BinaryComparator(Bytes.toBytes("fam"))), new QualifierFilter(CompareFilter.CompareOp.EQUAL, new BinaryComparator(Bytes.toBytes("qual1"))), new KeyOnlyFilter())), new FilterList(FilterList.Operator.MUST_PASS_ALL, Lists.newArrayList(new FamilyFilter(CompareFilter.CompareOp.EQUAL, new BinaryComparator(Bytes.toBytes("fam"))), new QualifierFilter(CompareFilter.CompareOp.EQUAL, new BinaryComparator(Bytes.toBytes("qual2")))))));
        KeyValue kvQual1 = new KeyValue(Bytes.toBytes("row"), Bytes.toBytes("fam"), Bytes.toBytes("qual1"), Bytes.toBytes("value"));
        KeyValue kvQual2 = new KeyValue(Bytes.toBytes("row"), Bytes.toBytes("fam"), Bytes.toBytes("qual2"), Bytes.toBytes("value"));
        KeyValue kvQual3 = new KeyValue(Bytes.toBytes("row"), Bytes.toBytes("fam"), Bytes.toBytes("qual3"), Bytes.toBytes("value"));
        Assert.assertEquals((Object)((Object)Filter.ReturnCode.INCLUDE), (Object)((Object)flist.filterKeyValue(kvQual1)));
        KeyValue transformedQual1 = KeyValueUtil.ensureKeyValue(flist.transformCell(kvQual1));
        Assert.assertEquals((long)0L, (long)transformedQual1.getValueLength());
        Assert.assertEquals((Object)((Object)Filter.ReturnCode.INCLUDE), (Object)((Object)flist.filterKeyValue(kvQual2)));
        KeyValue transformedQual2 = KeyValueUtil.ensureKeyValue(flist.transformCell(kvQual2));
        Assert.assertEquals((Object)"value", (Object)Bytes.toString(transformedQual2.getValueArray(), transformedQual2.getValueOffset(), transformedQual2.getValueLength()));
        Assert.assertEquals((Object)((Object)Filter.ReturnCode.SKIP), (Object)((Object)flist.filterKeyValue(kvQual3)));
    }

    @Test
    public void testWithMultiVersionsInSameRow() throws Exception {
        FilterList filterList01 = new FilterList(FilterList.Operator.MUST_PASS_ONE, new ColumnPaginationFilter(1, 0));
        KeyValue kv1 = new KeyValue(Bytes.toBytes("row"), Bytes.toBytes("fam"), Bytes.toBytes("qual"), 1L, Bytes.toBytes("value"));
        KeyValue kv2 = new KeyValue(Bytes.toBytes("row"), Bytes.toBytes("fam"), Bytes.toBytes("qual"), 2L, Bytes.toBytes("value"));
        KeyValue kv3 = new KeyValue(Bytes.toBytes("row"), Bytes.toBytes("fam"), Bytes.toBytes("qual"), 3L, Bytes.toBytes("value"));
        Assert.assertEquals((Object)((Object)Filter.ReturnCode.INCLUDE_AND_NEXT_COL), (Object)((Object)filterList01.filterKeyValue(kv1)));
        Assert.assertEquals((Object)((Object)Filter.ReturnCode.NEXT_COL), (Object)((Object)filterList01.filterKeyValue(kv2)));
        Assert.assertEquals((Object)((Object)Filter.ReturnCode.NEXT_COL), (Object)((Object)filterList01.filterKeyValue(kv3)));
        FilterList filterList11 = new FilterList(FilterList.Operator.MUST_PASS_ONE, new ColumnPaginationFilter(1, 1));
        Assert.assertEquals((Object)((Object)Filter.ReturnCode.NEXT_COL), (Object)((Object)filterList11.filterKeyValue(kv1)));
        Assert.assertEquals((Object)((Object)Filter.ReturnCode.NEXT_COL), (Object)((Object)filterList11.filterKeyValue(kv2)));
        Assert.assertEquals((Object)((Object)Filter.ReturnCode.NEXT_COL), (Object)((Object)filterList11.filterKeyValue(kv3)));
    }

    @Test
    public void testMPONEWithSeekNextUsingHint() throws Exception {
        byte[] col = Bytes.toBytes("c");
        FilterList filterList = new FilterList(FilterList.Operator.MUST_PASS_ONE, new ColumnPaginationFilter(1, col));
        KeyValue kv1 = new KeyValue(Bytes.toBytes("row"), Bytes.toBytes("fam"), Bytes.toBytes("a"), 1L, Bytes.toBytes("value"));
        KeyValue kv2 = new KeyValue(Bytes.toBytes("row"), Bytes.toBytes("fam"), Bytes.toBytes("b"), 2L, Bytes.toBytes("value"));
        KeyValue kv3 = new KeyValue(Bytes.toBytes("row"), Bytes.toBytes("fam"), Bytes.toBytes("c"), 3L, Bytes.toBytes("value"));
        KeyValue kv4 = new KeyValue(Bytes.toBytes("row"), Bytes.toBytes("fam"), Bytes.toBytes("c"), 4L, Bytes.toBytes("value"));
        Assert.assertEquals((Object)((Object)Filter.ReturnCode.SEEK_NEXT_USING_HINT), (Object)((Object)filterList.filterKeyValue(kv1)));
        Assert.assertEquals((Object)((Object)Filter.ReturnCode.SEEK_NEXT_USING_HINT), (Object)((Object)filterList.filterKeyValue(kv2)));
        Assert.assertEquals((Object)((Object)Filter.ReturnCode.INCLUDE_AND_NEXT_COL), (Object)((Object)filterList.filterKeyValue(kv3)));
        Assert.assertEquals((Object)((Object)Filter.ReturnCode.NEXT_COL), (Object)((Object)filterList.filterKeyValue(kv4)));
    }

    @Test
    public void testShouldPassCurrentCellToFilter() throws IOException {
        KeyValue kv1 = new KeyValue(Bytes.toBytes("row"), Bytes.toBytes("fam"), Bytes.toBytes("a"), 1L, Bytes.toBytes("value"));
        KeyValue kv2 = new KeyValue(Bytes.toBytes("row"), Bytes.toBytes("fam"), Bytes.toBytes("a"), 2L, Bytes.toBytes("value"));
        KeyValue kv3 = new KeyValue(Bytes.toBytes("row"), Bytes.toBytes("fam"), Bytes.toBytes("b"), 3L, Bytes.toBytes("value"));
        KeyValue kv4 = new KeyValue(Bytes.toBytes("row1"), Bytes.toBytes("fam"), Bytes.toBytes("c"), 4L, Bytes.toBytes("value"));
        MockFilter mockFilter = new MockFilter(Filter.ReturnCode.NEXT_COL);
        FilterList filter = new FilterList(FilterList.Operator.MUST_PASS_ONE, mockFilter);
        filter.filterKeyValue(kv1);
        Assert.assertTrue((boolean)mockFilter.didCellPassToTheFilter);
        mockFilter.didCellPassToTheFilter = false;
        filter.filterKeyValue(kv2);
        Assert.assertFalse((boolean)mockFilter.didCellPassToTheFilter);
        mockFilter.didCellPassToTheFilter = false;
        filter.filterKeyValue(kv3);
        Assert.assertTrue((boolean)mockFilter.didCellPassToTheFilter);
        mockFilter = new MockFilter(Filter.ReturnCode.INCLUDE_AND_NEXT_COL);
        filter = new FilterList(FilterList.Operator.MUST_PASS_ONE, mockFilter);
        filter.filterKeyValue(kv1);
        Assert.assertTrue((boolean)mockFilter.didCellPassToTheFilter);
        mockFilter.didCellPassToTheFilter = false;
        filter.filterKeyValue(kv2);
        Assert.assertFalse((boolean)mockFilter.didCellPassToTheFilter);
        mockFilter.didCellPassToTheFilter = false;
        filter.filterKeyValue(kv3);
        Assert.assertTrue((boolean)mockFilter.didCellPassToTheFilter);
        mockFilter = new MockFilter(Filter.ReturnCode.NEXT_ROW);
        filter = new FilterList(FilterList.Operator.MUST_PASS_ONE, mockFilter);
        filter.filterKeyValue(kv1);
        Assert.assertTrue((boolean)mockFilter.didCellPassToTheFilter);
        mockFilter.didCellPassToTheFilter = false;
        filter.filterKeyValue(kv2);
        Assert.assertFalse((boolean)mockFilter.didCellPassToTheFilter);
        mockFilter.didCellPassToTheFilter = false;
        filter.filterKeyValue(kv3);
        Assert.assertFalse((boolean)mockFilter.didCellPassToTheFilter);
        filter.reset();
        mockFilter.didCellPassToTheFilter = false;
        filter.filterKeyValue(kv4);
        Assert.assertTrue((boolean)mockFilter.didCellPassToTheFilter);
        mockFilter = new MockFilter(Filter.ReturnCode.INCLUDE_AND_SEEK_NEXT_ROW);
        filter = new FilterList(FilterList.Operator.MUST_PASS_ONE, mockFilter);
        filter.filterKeyValue(kv1);
        Assert.assertTrue((boolean)mockFilter.didCellPassToTheFilter);
        mockFilter.didCellPassToTheFilter = false;
        filter.filterKeyValue(kv2);
        Assert.assertFalse((boolean)mockFilter.didCellPassToTheFilter);
        mockFilter.didCellPassToTheFilter = false;
        filter.filterKeyValue(kv3);
        Assert.assertFalse((boolean)mockFilter.didCellPassToTheFilter);
        filter.reset();
        mockFilter.didCellPassToTheFilter = false;
        filter.filterKeyValue(kv4);
        Assert.assertTrue((boolean)mockFilter.didCellPassToTheFilter);
    }

    @Test
    public void testTheMaximalRule() throws IOException {
        KeyValue kv1 = new KeyValue(Bytes.toBytes("row"), Bytes.toBytes("fam"), Bytes.toBytes("a"), 1L, Bytes.toBytes("value"));
        MockFilter filter1 = new MockFilter(Filter.ReturnCode.INCLUDE);
        MockFilter filter2 = new MockFilter(Filter.ReturnCode.INCLUDE_AND_NEXT_COL);
        MockFilter filter3 = new MockFilter(Filter.ReturnCode.INCLUDE_AND_SEEK_NEXT_ROW);
        MockFilter filter4 = new MockFilter(Filter.ReturnCode.NEXT_COL);
        MockFilter filter5 = new MockFilter(Filter.ReturnCode.SKIP);
        MockFilter filter6 = new MockFilter(Filter.ReturnCode.SEEK_NEXT_USING_HINT);
        MockFilter filter7 = new MockFilter(Filter.ReturnCode.NEXT_ROW);
        FilterList filterList = new FilterList(FilterList.Operator.MUST_PASS_ALL, filter1, filter2);
        Assert.assertEquals((Object)((Object)Filter.ReturnCode.INCLUDE_AND_NEXT_COL), (Object)((Object)filterList.filterKeyValue(kv1)));
        filterList = new FilterList(FilterList.Operator.MUST_PASS_ALL, filter2, filter3);
        Assert.assertEquals((Object)((Object)Filter.ReturnCode.INCLUDE_AND_SEEK_NEXT_ROW), (Object)((Object)filterList.filterKeyValue(kv1)));
        filterList = new FilterList(FilterList.Operator.MUST_PASS_ALL, filter4, filter5, filter6);
        Assert.assertEquals((Object)((Object)Filter.ReturnCode.NEXT_COL), (Object)((Object)filterList.filterKeyValue(kv1)));
        filterList = new FilterList(FilterList.Operator.MUST_PASS_ALL, filter4, filter6);
        Assert.assertEquals((Object)((Object)Filter.ReturnCode.NEXT_COL), (Object)((Object)filterList.filterKeyValue(kv1)));
        filterList = new FilterList(FilterList.Operator.MUST_PASS_ALL, filter3, filter1);
        Assert.assertEquals((Object)((Object)Filter.ReturnCode.INCLUDE_AND_SEEK_NEXT_ROW), (Object)((Object)filterList.filterKeyValue(kv1)));
        filterList = new FilterList(FilterList.Operator.MUST_PASS_ALL, filter3, filter2, filter1, filter5);
        Assert.assertEquals((Object)((Object)Filter.ReturnCode.NEXT_ROW), (Object)((Object)filterList.filterKeyValue(kv1)));
        filterList = new FilterList(FilterList.Operator.MUST_PASS_ALL, filter2, new FilterList(FilterList.Operator.MUST_PASS_ALL, filter3, filter4));
        Assert.assertEquals((Object)((Object)Filter.ReturnCode.NEXT_ROW), (Object)((Object)filterList.filterKeyValue(kv1)));
        filterList = new FilterList(FilterList.Operator.MUST_PASS_ALL, filter3, filter7);
        Assert.assertEquals((Object)((Object)Filter.ReturnCode.NEXT_ROW), (Object)((Object)filterList.filterKeyValue(kv1)));
    }

    @Test
    public void testTheMinimalRule() throws IOException {
        KeyValue kv1 = new KeyValue(Bytes.toBytes("row"), Bytes.toBytes("fam"), Bytes.toBytes("a"), 1L, Bytes.toBytes("value"));
        MockFilter filter1 = new MockFilter(Filter.ReturnCode.INCLUDE);
        MockFilter filter2 = new MockFilter(Filter.ReturnCode.INCLUDE_AND_NEXT_COL);
        MockFilter filter3 = new MockFilter(Filter.ReturnCode.INCLUDE_AND_SEEK_NEXT_ROW);
        MockFilter filter4 = new MockFilter(Filter.ReturnCode.NEXT_COL);
        MockFilter filter5 = new MockFilter(Filter.ReturnCode.SKIP);
        MockFilter filter6 = new MockFilter(Filter.ReturnCode.SEEK_NEXT_USING_HINT);
        FilterList filterList = new FilterList(FilterList.Operator.MUST_PASS_ONE, filter1, filter2);
        Assert.assertEquals((Object)((Object)filterList.filterKeyValue(kv1)), (Object)((Object)Filter.ReturnCode.INCLUDE));
        filterList = new FilterList(FilterList.Operator.MUST_PASS_ONE, filter2, filter3);
        Assert.assertEquals((Object)((Object)Filter.ReturnCode.INCLUDE_AND_NEXT_COL), (Object)((Object)filterList.filterKeyValue(kv1)));
        filterList = new FilterList(FilterList.Operator.MUST_PASS_ONE, filter4, filter5, filter6);
        Assert.assertEquals((Object)((Object)Filter.ReturnCode.SKIP), (Object)((Object)filterList.filterKeyValue(kv1)));
        filterList = new FilterList(FilterList.Operator.MUST_PASS_ONE, filter4, filter6);
        Assert.assertEquals((Object)((Object)Filter.ReturnCode.SKIP), (Object)((Object)filterList.filterKeyValue(kv1)));
        filterList = new FilterList(FilterList.Operator.MUST_PASS_ONE, filter3, filter1);
        Assert.assertEquals((Object)((Object)Filter.ReturnCode.INCLUDE), (Object)((Object)filterList.filterKeyValue(kv1)));
        filterList = new FilterList(FilterList.Operator.MUST_PASS_ONE, filter3, filter2, filter1, filter5);
        Assert.assertEquals((Object)((Object)Filter.ReturnCode.INCLUDE), (Object)((Object)filterList.filterKeyValue(kv1)));
        filterList = new FilterList(FilterList.Operator.MUST_PASS_ONE, filter2, new FilterList(FilterList.Operator.MUST_PASS_ONE, filter3, filter4));
        Assert.assertEquals((Object)((Object)Filter.ReturnCode.INCLUDE_AND_NEXT_COL), (Object)((Object)filterList.filterKeyValue(kv1)));
        filterList = new FilterList(FilterList.Operator.MUST_PASS_ONE, filter2, new FilterList(FilterList.Operator.MUST_PASS_ONE, filter3, filter4));
        Assert.assertEquals((Object)((Object)Filter.ReturnCode.INCLUDE_AND_NEXT_COL), (Object)((Object)filterList.filterKeyValue(kv1)));
        filterList = new FilterList(FilterList.Operator.MUST_PASS_ONE, filter6, filter6);
        Assert.assertEquals((Object)((Object)Filter.ReturnCode.SEEK_NEXT_USING_HINT), (Object)((Object)filterList.filterKeyValue(kv1)));
    }

    @Test
    public void testReversedFilterListWithMockSeekHintFilter() throws IOException {
        KeyValue kv1 = new KeyValue(Bytes.toBytes("row1"), Bytes.toBytes("fam"), Bytes.toBytes("a"), 1L, Bytes.toBytes("value"));
        KeyValue kv2 = new KeyValue(Bytes.toBytes("row2"), Bytes.toBytes("fam"), Bytes.toBytes("a"), 1L, Bytes.toBytes("value"));
        KeyValue kv3 = new KeyValue(Bytes.toBytes("row3"), Bytes.toBytes("fam"), Bytes.toBytes("a"), 1L, Bytes.toBytes("value"));
        MockSeekHintFilter filter1 = new MockSeekHintFilter(kv1);
        filter1.setReversed(true);
        MockSeekHintFilter filter2 = new MockSeekHintFilter(kv2);
        filter2.setReversed(true);
        MockSeekHintFilter filter3 = new MockSeekHintFilter(kv3);
        filter3.setReversed(true);
        FilterList filterList = new FilterList(FilterList.Operator.MUST_PASS_ONE);
        filterList.setReversed(true);
        filterList.addFilter(filter1);
        filterList.addFilter(filter2);
        filterList.addFilter(filter3);
        Assert.assertEquals((Object)((Object)Filter.ReturnCode.SEEK_NEXT_USING_HINT), (Object)((Object)filterList.filterKeyValue(kv1)));
        Assert.assertEquals((Object)kv3, (Object)filterList.getNextCellHint(kv1));
        filterList = new FilterList(FilterList.Operator.MUST_PASS_ALL);
        filterList.setReversed(true);
        filterList.addFilter(filter1);
        filterList.addFilter(filter2);
        filterList.addFilter(filter3);
        Assert.assertEquals((Object)((Object)Filter.ReturnCode.SEEK_NEXT_USING_HINT), (Object)((Object)filterList.filterKeyValue(kv1)));
        Assert.assertEquals((Object)kv1, (Object)filterList.getNextCellHint(kv1));
    }

    @Test
    public void testReversedFilterListWithOR() throws IOException {
        byte[] r22 = Bytes.toBytes("Row22");
        byte[] r2 = Bytes.toBytes("Row2");
        byte[] r1 = Bytes.toBytes("Row1");
        FilterList filterList = new FilterList(FilterList.Operator.MUST_PASS_ONE);
        filterList.setReversed(true);
        PrefixFilter prefixFilter = new PrefixFilter(r2);
        prefixFilter.setReversed(true);
        filterList.addFilter(prefixFilter);
        filterList.filterRowKey(r22, 0, r22.length);
        Assert.assertEquals((Object)((Object)Filter.ReturnCode.INCLUDE), (Object)((Object)filterList.filterKeyValue(new KeyValue(r22, r22, r22))));
        Assert.assertEquals((Object)((Object)Filter.ReturnCode.INCLUDE), (Object)((Object)filterList.filterKeyValue(new KeyValue(r2, r2, r2))));
        filterList.reset();
        filterList.filterRowKey(r1, 0, r1.length);
        Assert.assertEquals((Object)((Object)Filter.ReturnCode.SKIP), (Object)((Object)filterList.filterKeyValue(new KeyValue(r1, r1, r1))));
        filterList = new FilterList(FilterList.Operator.MUST_PASS_ONE);
        filterList.setReversed(true);
        AlwaysNextColFilter alwaysNextColFilter = new AlwaysNextColFilter();
        alwaysNextColFilter.setReversed(true);
        prefixFilter = new PrefixFilter(r2);
        prefixFilter.setReversed(true);
        filterList.addFilter(alwaysNextColFilter);
        filterList.addFilter(prefixFilter);
        filterList.filterRowKey(r22, 0, r22.length);
        Assert.assertEquals((Object)((Object)Filter.ReturnCode.INCLUDE), (Object)((Object)filterList.filterKeyValue(new KeyValue(r22, r22, r22))));
        Assert.assertEquals((Object)((Object)Filter.ReturnCode.INCLUDE), (Object)((Object)filterList.filterKeyValue(new KeyValue(r2, r2, r2))));
        filterList.reset();
        filterList.filterRowKey(r1, 0, r1.length);
        Assert.assertEquals((Object)((Object)Filter.ReturnCode.NEXT_COL), (Object)((Object)filterList.filterKeyValue(new KeyValue(r1, r1, r1))));
    }

    @Test
    public void testKeyOnlyFilterTransformCell() throws IOException {
        KeyValue kv1 = new KeyValue(Bytes.toBytes("row"), Bytes.toBytes("cf"), Bytes.toBytes("column1"), 1L, Bytes.toBytes("value1"));
        KeyValue kv2 = new KeyValue(Bytes.toBytes("row"), Bytes.toBytes("cf"), Bytes.toBytes("column1"), 2L, Bytes.toBytes("value2"));
        SingleColumnValueFilter filter1 = new SingleColumnValueFilter(Bytes.toBytes("cf"), Bytes.toBytes("column1"), CompareFilter.CompareOp.EQUAL, Bytes.toBytes("value1"));
        SingleColumnValueFilter filter2 = new SingleColumnValueFilter(Bytes.toBytes("cf"), Bytes.toBytes("column1"), CompareFilter.CompareOp.EQUAL, Bytes.toBytes("value2"));
        FilterList internalFilterList = new FilterList(FilterList.Operator.MUST_PASS_ONE, filter1, filter2);
        FilterList keyOnlyFilterFirst = new FilterList(FilterList.Operator.MUST_PASS_ALL, new KeyOnlyFilter(), internalFilterList);
        Assert.assertEquals((Object)((Object)Filter.ReturnCode.INCLUDE), (Object)((Object)keyOnlyFilterFirst.filterKeyValue(kv1)));
        Cell c = keyOnlyFilterFirst.transformCell(kv1);
        Assert.assertEquals((long)0L, (long)c.getValueLength());
        Assert.assertEquals((Object)((Object)Filter.ReturnCode.INCLUDE), (Object)((Object)keyOnlyFilterFirst.filterKeyValue(kv2)));
        c = keyOnlyFilterFirst.transformCell(kv2);
        Assert.assertEquals((long)0L, (long)c.getValueLength());
        internalFilterList.reset();
        FilterList keyOnlyFilterLast = new FilterList(FilterList.Operator.MUST_PASS_ALL, new KeyOnlyFilter(), internalFilterList);
        Assert.assertEquals((Object)((Object)Filter.ReturnCode.INCLUDE), (Object)((Object)keyOnlyFilterLast.filterKeyValue(kv1)));
        c = keyOnlyFilterLast.transformCell(kv1);
        Assert.assertEquals((long)0L, (long)c.getValueLength());
        Assert.assertEquals((Object)((Object)Filter.ReturnCode.INCLUDE), (Object)((Object)keyOnlyFilterLast.filterKeyValue(kv2)));
        c = keyOnlyFilterLast.transformCell(kv2);
        Assert.assertEquals((long)0L, (long)c.getValueLength());
    }

    @Test
    public void testEmptyFilterListTransformCell() throws IOException {
        KeyValue kv = new KeyValue(Bytes.toBytes("row"), Bytes.toBytes("cf"), Bytes.toBytes("column1"), 1L, Bytes.toBytes("value"));
        FilterList filterList = new FilterList(FilterList.Operator.MUST_PASS_ALL);
        Assert.assertEquals((Object)((Object)Filter.ReturnCode.INCLUDE), (Object)((Object)filterList.filterKeyValue(kv)));
        Assert.assertEquals((Object)kv, (Object)filterList.transformCell(kv));
        filterList = new FilterList(FilterList.Operator.MUST_PASS_ONE);
        Assert.assertEquals((Object)((Object)Filter.ReturnCode.INCLUDE), (Object)((Object)filterList.filterKeyValue(kv)));
        Assert.assertEquals((Object)kv, (Object)filterList.transformCell(kv));
    }

    @Test
    public void testRowCountFilter() throws IOException {
        KeyValue kv1 = new KeyValue(Bytes.toBytes("row"), Bytes.toBytes("fam1"), Bytes.toBytes("a"), 1L, Bytes.toBytes("value"));
        KeyValue kv2 = new KeyValue(Bytes.toBytes("row"), Bytes.toBytes("fam2"), Bytes.toBytes("a"), 2L, Bytes.toBytes("value"));
        MockNextRowFilter mockNextRowFilter = new MockNextRowFilter();
        FilterList filter = new FilterList(FilterList.Operator.MUST_PASS_ONE, mockNextRowFilter);
        filter.filterKeyValue(kv1);
        filter.filterKeyValue(kv2);
        Assert.assertEquals((long)2L, (long)mockNextRowFilter.getHitCount());
    }

    @Test
    public void testTransformCell() throws IOException {
        KeyValue kv = new KeyValue(Bytes.toBytes("row"), Bytes.toBytes("cf"), Bytes.toBytes("column1"), 1L, Bytes.toBytes("value"));
        TransformFilter filter1 = new TransformFilter(Filter.ReturnCode.INCLUDE);
        TransformFilter filter2 = new TransformFilter(Filter.ReturnCode.NEXT_ROW);
        TransformFilter filter3 = new TransformFilter(Filter.ReturnCode.SEEK_NEXT_USING_HINT);
        FilterList filterList = new FilterList(FilterList.Operator.MUST_PASS_ONE, filter1, filter2, filter3);
        Assert.assertEquals((Object)((Object)Filter.ReturnCode.INCLUDE), (Object)((Object)filterList.filterKeyValue(kv)));
        Assert.assertEquals((Object)kv, (Object)filterList.transformCell(kv));
        Assert.assertEquals((Object)true, (Object)filter1.getTransformed());
        Assert.assertEquals((Object)false, (Object)filter2.getTransformed());
        Assert.assertEquals((Object)false, (Object)filter3.getTransformed());
        filter1 = new TransformFilter(Filter.ReturnCode.INCLUDE);
        filter2 = new TransformFilter(Filter.ReturnCode.INCLUDE_AND_SEEK_NEXT_ROW);
        filter3 = new TransformFilter(Filter.ReturnCode.INCLUDE_AND_NEXT_COL);
        filterList = new FilterList(FilterList.Operator.MUST_PASS_ALL, filter1, filter2, filter3);
        Assert.assertEquals((Object)((Object)Filter.ReturnCode.INCLUDE_AND_SEEK_NEXT_ROW), (Object)((Object)filterList.filterKeyValue(kv)));
        Assert.assertEquals((Object)kv, (Object)filterList.transformCell(kv));
        Assert.assertEquals((Object)true, (Object)filter1.getTransformed());
        Assert.assertEquals((Object)true, (Object)filter2.getTransformed());
        Assert.assertEquals((Object)true, (Object)filter3.getTransformed());
    }

    @Test
    public void testFilterListWithORWhenPassingCellMismatchPreviousRC() throws IOException {
        KeyValue kv1 = new KeyValue(Bytes.toBytes("row1"), Bytes.toBytes("fam"), Bytes.toBytes("a"), 100L, Bytes.toBytes("value"));
        KeyValue kv2 = new KeyValue(Bytes.toBytes("row1"), Bytes.toBytes("fam"), Bytes.toBytes("a"), 99L, Bytes.toBytes("value"));
        KeyValue kv3 = new KeyValue(Bytes.toBytes("row1"), Bytes.toBytes("fam"), Bytes.toBytes("b"), 1L, Bytes.toBytes("value"));
        KeyValue kv4 = new KeyValue(Bytes.toBytes("row1"), Bytes.toBytes("fan"), Bytes.toBytes("a"), 1L, Bytes.toBytes("value"));
        Filter subFilter1 = (Filter)Mockito.mock(FilterBase.class);
        Mockito.when((Object)((Object)subFilter1.filterKeyValue(kv1))).thenReturn((Object)Filter.ReturnCode.INCLUDE_AND_NEXT_COL);
        Mockito.when((Object)((Object)subFilter1.filterKeyValue(kv2))).thenReturn((Object)Filter.ReturnCode.NEXT_COL);
        Mockito.when((Object)((Object)subFilter1.filterKeyValue(kv3))).thenReturn((Object)Filter.ReturnCode.INCLUDE_AND_NEXT_COL);
        Mockito.when((Object)((Object)subFilter1.filterKeyValue(kv4))).thenReturn((Object)Filter.ReturnCode.INCLUDE_AND_NEXT_COL);
        Filter subFilter2 = (Filter)Mockito.mock(FilterBase.class);
        Mockito.when((Object)((Object)subFilter2.filterKeyValue(kv1))).thenReturn((Object)Filter.ReturnCode.SKIP);
        Mockito.when((Object)((Object)subFilter2.filterKeyValue(kv2))).thenReturn((Object)Filter.ReturnCode.NEXT_ROW);
        Mockito.when((Object)((Object)subFilter2.filterKeyValue(kv3))).thenReturn((Object)Filter.ReturnCode.NEXT_ROW);
        Mockito.when((Object)((Object)subFilter2.filterKeyValue(kv4))).thenReturn((Object)Filter.ReturnCode.INCLUDE_AND_SEEK_NEXT_ROW);
        FilterList filterList = new FilterList(FilterList.Operator.MUST_PASS_ONE, subFilter1, subFilter2);
        Assert.assertEquals((Object)((Object)Filter.ReturnCode.INCLUDE), (Object)((Object)((Filter)filterList).filterKeyValue(kv1)));
        Assert.assertEquals((Object)((Object)Filter.ReturnCode.NEXT_COL), (Object)((Object)((Filter)filterList).filterKeyValue(kv2)));
        Assert.assertEquals((Object)((Object)Filter.ReturnCode.INCLUDE_AND_NEXT_COL), (Object)((Object)((Filter)filterList).filterKeyValue(kv3)));
        Assert.assertEquals((Object)((Object)Filter.ReturnCode.INCLUDE_AND_NEXT_COL), (Object)((Object)((Filter)filterList).filterKeyValue(kv4)));
        subFilter1 = (Filter)Mockito.mock(FilterBase.class);
        Mockito.when((Object)subFilter1.filterAllRemaining()).thenReturn((Object)true);
        Mockito.when((Object)((Object)subFilter1.filterKeyValue(kv1))).thenReturn((Object)Filter.ReturnCode.NEXT_ROW);
        subFilter2 = (Filter)Mockito.mock(FilterBase.class);
        Mockito.when((Object)((Object)subFilter2.filterKeyValue(kv1))).thenReturn((Object)Filter.ReturnCode.SEEK_NEXT_USING_HINT);
        filterList = new FilterList(FilterList.Operator.MUST_PASS_ONE, subFilter1, subFilter2);
        Assert.assertEquals((Object)((Object)Filter.ReturnCode.SEEK_NEXT_USING_HINT), (Object)((Object)((Filter)filterList).filterKeyValue(kv1)));
        subFilter1 = (Filter)Mockito.mock(FilterBase.class);
        Mockito.when((Object)((Object)subFilter1.filterKeyValue(kv1))).thenReturn((Object)Filter.ReturnCode.SEEK_NEXT_USING_HINT);
        subFilter2 = (Filter)Mockito.mock(FilterBase.class);
        Mockito.when((Object)((Object)subFilter2.filterKeyValue(kv1))).thenReturn((Object)Filter.ReturnCode.SEEK_NEXT_USING_HINT);
        filterList = new FilterList(FilterList.Operator.MUST_PASS_ONE, subFilter1, subFilter2);
        Assert.assertEquals((Object)((Object)Filter.ReturnCode.SEEK_NEXT_USING_HINT), (Object)((Object)((Filter)filterList).filterKeyValue(kv1)));
    }

    private static class TransformFilter
    extends FilterBase {
        private Filter.ReturnCode targetRetCode;
        private boolean transformed = false;

        public TransformFilter(Filter.ReturnCode targetRetCode) {
            this.targetRetCode = targetRetCode;
        }

        @Override
        public Filter.ReturnCode filterKeyValue(Cell v) throws IOException {
            return this.targetRetCode;
        }

        @Override
        public Cell transformCell(Cell c) throws IOException {
            this.transformed = true;
            return super.transformCell(c);
        }

        public boolean getTransformed() {
            return this.transformed;
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof TransformFilter)) {
                return false;
            }
            if (obj == this) {
                return true;
            }
            TransformFilter f = (TransformFilter)obj;
            return this.targetRetCode.equals((Object)f.targetRetCode);
        }

        public int hashCode() {
            return Objects.hash(new Object[]{this.targetRetCode});
        }
    }

    private static class MockNextRowFilter
    extends FilterBase {
        private int hitCount = 0;

        private MockNextRowFilter() {
        }

        @Override
        public Filter.ReturnCode filterKeyValue(Cell v) throws IOException {
            ++this.hitCount;
            return Filter.ReturnCode.NEXT_ROW;
        }

        public int getHitCount() {
            return this.hitCount;
        }
    }

    static class MockSeekHintFilter
    extends FilterBase {
        private Cell returnCell;

        public MockSeekHintFilter(Cell returnCell) {
            this.returnCell = returnCell;
        }

        @Override
        public Filter.ReturnCode filterKeyValue(Cell v) throws IOException {
            return Filter.ReturnCode.SEEK_NEXT_USING_HINT;
        }

        @Override
        public Cell getNextCellHint(Cell currentCell) throws IOException {
            return this.returnCell;
        }

        public boolean equals(Object obj) {
            if (obj == null || !(obj instanceof MockSeekHintFilter)) {
                return false;
            }
            if (obj == this) {
                return true;
            }
            MockSeekHintFilter f = (MockSeekHintFilter)obj;
            return this.returnCell.equals(f.returnCell);
        }

        public int hashCode() {
            return Objects.hash(this.returnCell);
        }
    }

    private static class MockFilter
    extends FilterBase {
        private Filter.ReturnCode targetRetCode;
        public boolean didCellPassToTheFilter = false;

        public MockFilter(Filter.ReturnCode targetRetCode) {
            this.targetRetCode = targetRetCode;
        }

        @Override
        public Filter.ReturnCode filterKeyValue(Cell v) throws IOException {
            this.didCellPassToTheFilter = true;
            return this.targetRetCode;
        }

        public boolean equals(Object obj) {
            if (obj == null || !(obj instanceof MockFilter)) {
                return false;
            }
            if (obj == this) {
                return true;
            }
            MockFilter f = (MockFilter)obj;
            return this.targetRetCode.equals((Object)f.targetRetCode);
        }

        public int hashCode() {
            return Objects.hash(new Object[]{this.targetRetCode});
        }
    }

    static class AlwaysNextColFilter
    extends FilterBase {
        @Override
        public Filter.ReturnCode filterKeyValue(Cell v) {
            return Filter.ReturnCode.NEXT_COL;
        }

        public static AlwaysNextColFilter parseFrom(byte[] pbBytes) throws DeserializationException {
            return new AlwaysNextColFilter();
        }
    }
}

