/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.coprocessor;

import java.io.IOException;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.Coprocessor;
import org.apache.hadoop.hbase.HBaseConfiguration;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.HColumnDescriptor;
import org.apache.hadoop.hbase.HTableDescriptor;
import org.apache.hadoop.hbase.MetaTableAccessor;
import org.apache.hadoop.hbase.MiniHBaseCluster;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.HBaseAdmin;
import org.apache.hadoop.hbase.client.Mutation;
import org.apache.hadoop.hbase.coprocessor.BaseRegionServerObserver;
import org.apache.hadoop.hbase.coprocessor.ObserverContext;
import org.apache.hadoop.hbase.coprocessor.RegionServerCoprocessorEnvironment;
import org.apache.hadoop.hbase.coprocessor.RegionServerObserver;
import org.apache.hadoop.hbase.regionserver.HRegion;
import org.apache.hadoop.hbase.regionserver.HRegionServer;
import org.apache.hadoop.hbase.regionserver.Region;
import org.apache.hadoop.hbase.regionserver.RegionMergeTransactionFactory;
import org.apache.hadoop.hbase.regionserver.RegionMergeTransactionImpl;
import org.apache.hadoop.hbase.regionserver.RegionServerCoprocessorHost;
import org.apache.hadoop.hbase.testclassification.MediumTests;
import org.apache.hadoop.hbase.util.Bytes;
import org.junit.Assert;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={MediumTests.class})
public class TestRegionServerObserver {
    private static final Log LOG = LogFactory.getLog(TestRegionServerObserver.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testCoprocessorHooksInRegionsMerge() throws Exception {
        boolean NUM_MASTERS = true;
        boolean NUM_RS = true;
        String TABLENAME = "testRegionServerObserver";
        String TABLENAME2 = "testRegionServerObserver_2";
        byte[] FAM = Bytes.toBytes("fam");
        Configuration conf = HBaseConfiguration.create();
        conf.setClass("hbase.coprocessor.regionserver.classes", CPRegionServerObserver.class, RegionServerObserver.class);
        HBaseTestingUtility TEST_UTIL = new HBaseTestingUtility(conf);
        TEST_UTIL.startMiniCluster(1, 1);
        HBaseAdmin admin = new HBaseAdmin(conf);
        try {
            MiniHBaseCluster cluster = TEST_UTIL.getHBaseCluster();
            HRegionServer regionServer = cluster.getRegionServer(0);
            RegionServerCoprocessorHost cpHost = regionServer.getRegionServerCoprocessorHost();
            Coprocessor coprocessor = cpHost.findCoprocessor(CPRegionServerObserver.class.getName());
            CPRegionServerObserver regionServerObserver = (CPRegionServerObserver)coprocessor;
            HTableDescriptor desc = new HTableDescriptor(TableName.valueOf("testRegionServerObserver"));
            desc.addFamily(new HColumnDescriptor(FAM));
            admin.createTable(desc, new byte[][]{Bytes.toBytes("row")});
            desc = new HTableDescriptor(TableName.valueOf("testRegionServerObserver_2"));
            desc.addFamily(new HColumnDescriptor(FAM));
            admin.createTable(desc, new byte[][]{Bytes.toBytes("row")});
            Assert.assertFalse((boolean)regionServerObserver.wasRegionMergeCalled());
            List<Region> regions = regionServer.getOnlineRegions(TableName.valueOf("testRegionServerObserver"));
            admin.mergeRegions(regions.get(0).getRegionInfo().getEncodedNameAsBytes(), regions.get(1).getRegionInfo().getEncodedNameAsBytes(), true);
            int regionsCount = regionServer.getOnlineRegions(TableName.valueOf("testRegionServerObserver")).size();
            while (regionsCount != 1) {
                regionsCount = regionServer.getOnlineRegions(TableName.valueOf("testRegionServerObserver")).size();
                Thread.sleep(1000L);
            }
            Assert.assertTrue((boolean)regionServerObserver.wasRegionMergeCalled());
            Assert.assertTrue((boolean)regionServerObserver.wasPreMergeCommit());
            Assert.assertTrue((boolean)regionServerObserver.wasPostMergeCommit());
            Assert.assertEquals((long)regionsCount, (long)1L);
            Assert.assertEquals((long)regionServer.getOnlineRegions(TableName.valueOf("testRegionServerObserver_2")).size(), (long)1L);
        }
        finally {
            if (admin != null) {
                admin.close();
            }
            TEST_UTIL.shutdownMiniCluster();
        }
    }

    public static class CPRegionServerObserver
    extends BaseRegionServerObserver {
        private RegionMergeTransactionImpl rmt = null;
        private HRegion mergedRegion = null;
        private boolean preMergeCalled;
        private boolean preMergeBeforePONRCalled;
        private boolean preMergeAfterPONRCalled;
        private boolean preRollBackMergeCalled;
        private boolean postRollBackMergeCalled;
        private boolean postMergeCalled;

        public void resetStates() {
            this.preMergeCalled = false;
            this.preMergeBeforePONRCalled = false;
            this.preMergeAfterPONRCalled = false;
            this.preRollBackMergeCalled = false;
            this.postRollBackMergeCalled = false;
            this.postMergeCalled = false;
        }

        @Override
        public void preMerge(ObserverContext<RegionServerCoprocessorEnvironment> ctx, Region regionA, Region regionB) throws IOException {
            this.preMergeCalled = true;
        }

        @Override
        public void preMergeCommit(ObserverContext<RegionServerCoprocessorEnvironment> ctx, Region regionA, Region regionB, List<Mutation> metaEntries) throws IOException {
            this.preMergeBeforePONRCalled = true;
            RegionServerCoprocessorEnvironment environment = ctx.getEnvironment();
            HRegionServer rs = (HRegionServer)environment.getRegionServerServices();
            List<Region> onlineRegions = rs.getOnlineRegions(TableName.valueOf("testRegionServerObserver_2"));
            this.rmt = new RegionMergeTransactionFactory(rs.getConfiguration()).create(onlineRegions.get(0), onlineRegions.get(1), true);
            if (!this.rmt.prepare(rs)) {
                LOG.error((Object)("Prepare for the region merge of table " + onlineRegions.get(0).getTableDesc().getNameAsString() + " failed. So returning null. "));
                ctx.bypass();
                return;
            }
            this.mergedRegion = this.rmt.stepsBeforePONR(rs, rs, false);
            this.rmt.prepareMutationsForMerge(this.mergedRegion.getRegionInfo(), regionA.getRegionInfo(), regionB.getRegionInfo(), rs.getServerName(), metaEntries, regionA.getTableDesc().getRegionReplication());
            MetaTableAccessor.mutateMetaTable(rs.getConnection(), metaEntries);
        }

        @Override
        public void postMergeCommit(ObserverContext<RegionServerCoprocessorEnvironment> ctx, Region regionA, Region regionB, Region mr) throws IOException {
            this.preMergeAfterPONRCalled = true;
            RegionServerCoprocessorEnvironment environment = ctx.getEnvironment();
            HRegionServer rs = (HRegionServer)environment.getRegionServerServices();
            this.rmt.stepsAfterPONR(rs, rs, this.mergedRegion, null);
        }

        @Override
        public void preRollBackMerge(ObserverContext<RegionServerCoprocessorEnvironment> ctx, Region regionA, Region regionB) throws IOException {
            this.preRollBackMergeCalled = true;
        }

        @Override
        public void postRollBackMerge(ObserverContext<RegionServerCoprocessorEnvironment> ctx, Region regionA, Region regionB) throws IOException {
            this.postRollBackMergeCalled = true;
        }

        @Override
        public void postMerge(ObserverContext<RegionServerCoprocessorEnvironment> c, Region regionA, Region regionB, Region mergedRegion) throws IOException {
            this.postMergeCalled = true;
        }

        public boolean wasPreMergeCalled() {
            return this.preMergeCalled;
        }

        public boolean wasPostMergeCalled() {
            return this.postMergeCalled;
        }

        public boolean wasPreMergeCommit() {
            return this.preMergeBeforePONRCalled;
        }

        public boolean wasPostMergeCommit() {
            return this.preMergeAfterPONRCalled;
        }

        public boolean wasPreRollBackMerge() {
            return this.preRollBackMergeCalled;
        }

        public boolean wasPostRollBackMerge() {
            return this.postRollBackMergeCalled;
        }

        public boolean wasRegionMergeCalled() {
            return this.preMergeCalled && this.postMergeCalled;
        }
    }
}

