/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.NavigableSet;
import java.util.Set;
import org.apache.hadoop.hbase.HColumnDescriptor;
import org.apache.hadoop.hbase.HConstants;
import org.apache.hadoop.hbase.HRegionInfo;
import org.apache.hadoop.hbase.HTableDescriptor;
import org.apache.hadoop.hbase.KeyValue;
import org.apache.hadoop.hbase.ServerName;
import org.apache.hadoop.hbase.SplitLogTask;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.Get;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.exceptions.DeserializationException;
import org.apache.hadoop.hbase.filter.BinaryComparator;
import org.apache.hadoop.hbase.filter.CompareFilter;
import org.apache.hadoop.hbase.filter.Filter;
import org.apache.hadoop.hbase.filter.PrefixFilter;
import org.apache.hadoop.hbase.filter.RowFilter;
import org.apache.hadoop.hbase.io.TimeRange;
import org.apache.hadoop.hbase.protobuf.ProtobufUtil;
import org.apache.hadoop.hbase.protobuf.generated.ClientProtos;
import org.apache.hadoop.hbase.protobuf.generated.ZooKeeperProtos;
import org.apache.hadoop.hbase.testclassification.SmallTests;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.Writables;
import org.apache.hadoop.io.DataInputBuffer;
import org.apache.hadoop.io.Writable;
import org.junit.Assert;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={SmallTests.class})
public class TestSerialization {
    protected static final int MAXVERSIONS = 3;
    protected static final byte[] fam1 = Bytes.toBytes("colfamily1");
    protected static final byte[] fam2 = Bytes.toBytes("colfamily2");
    protected static final byte[] fam3 = Bytes.toBytes("colfamily3");
    protected static final byte[][] COLUMNS = new byte[][]{fam1, fam2, fam3};

    @Test
    public void testKeyValue() throws Exception {
        String name = "testKeyValue2";
        byte[] row = "testKeyValue2".getBytes();
        byte[] fam = "fam".getBytes();
        byte[] qf = "qf".getBytes();
        long ts = System.currentTimeMillis();
        byte[] val = "val".getBytes();
        KeyValue kv = new KeyValue(row, fam, qf, ts, val);
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        DataOutputStream dos = new DataOutputStream(baos);
        long l = KeyValue.write(kv, dos);
        dos.close();
        byte[] mb = baos.toByteArray();
        ByteArrayInputStream bais = new ByteArrayInputStream(mb);
        DataInputStream dis = new DataInputStream(bais);
        KeyValue deserializedKv = KeyValue.create(dis);
        Assert.assertTrue((boolean)Bytes.equals(kv.getBuffer(), deserializedKv.getBuffer()));
        Assert.assertEquals((long)kv.getOffset(), (long)deserializedKv.getOffset());
        Assert.assertEquals((long)kv.getLength(), (long)deserializedKv.getLength());
    }

    @Test
    public void testCreateKeyValueInvalidNegativeLength() {
        KeyValue kv_0 = new KeyValue(Bytes.toBytes("myRow"), Bytes.toBytes("myCF"), Bytes.toBytes("myQualifier"), 12345L, Bytes.toBytes("my12345"));
        KeyValue kv_1 = new KeyValue(Bytes.toBytes("myRow"), Bytes.toBytes("myCF"), Bytes.toBytes("myQualifier"), 12345L, Bytes.toBytes("my123"));
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        DataOutputStream dos = new DataOutputStream(baos);
        long l = 0L;
        try {
            l = KeyValue.oswrite(kv_0, dos, false);
            Assert.assertEquals((long)100L, (long)(l += KeyValue.oswrite(kv_1, dos, false)));
        }
        catch (IOException e) {
            Assert.fail((String)("Unexpected IOException" + e.getMessage()));
        }
        ByteArrayInputStream bais = new ByteArrayInputStream(baos.toByteArray());
        DataInputStream dis = new DataInputStream(bais);
        try {
            KeyValue.create(dis);
            Assert.assertTrue((boolean)kv_0.equals(kv_1));
        }
        catch (Exception e) {
            Assert.fail((String)("Unexpected Exception" + e.getMessage()));
        }
        try {
            KeyValue.create(-1, dis);
            Assert.fail((String)"Expected corrupt stream");
        }
        catch (Exception e) {
            Assert.assertEquals((Object)"Failed read -1 bytes, stream corrupt?", (Object)e.getMessage());
        }
    }

    @Test
    public void testSplitLogTask() throws DeserializationException {
        SplitLogTask.Unassigned slt = new SplitLogTask.Unassigned(ServerName.valueOf("mgr,1,1"), ZooKeeperProtos.SplitLogTask.RecoveryMode.LOG_REPLAY);
        byte[] bytes = slt.toByteArray();
        SplitLogTask sltDeserialized = SplitLogTask.parseFrom(bytes);
        Assert.assertTrue((boolean)slt.equals(sltDeserialized));
    }

    @Test
    public void testCompareFilter() throws Exception {
        RowFilter f = new RowFilter(CompareFilter.CompareOp.EQUAL, new BinaryComparator(Bytes.toBytes("testRowOne-2")));
        byte[] bytes = ((Filter)f).toByteArray();
        RowFilter ff = RowFilter.parseFrom(bytes);
        Assert.assertNotNull((Object)ff);
    }

    @Test
    public void testTableDescriptor() throws Exception {
        String name = "testTableDescriptor";
        HTableDescriptor htd = this.createTableDescriptor("testTableDescriptor");
        byte[] mb = Writables.getBytes((Writable)htd);
        HTableDescriptor deserializedHtd = (HTableDescriptor)Writables.getWritable(mb, (Writable)new HTableDescriptor());
        Assert.assertEquals((Object)htd.getTableName(), (Object)deserializedHtd.getTableName());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testRegionInfo() throws Exception {
        HRegionInfo hri = this.createRandomRegion("testRegionInfo");
        byte[] hrib = hri.toByteArray();
        HRegionInfo deserializedHri = HRegionInfo.parseFrom(hrib);
        Assert.assertEquals((Object)hri.getEncodedName(), (Object)deserializedHri.getEncodedName());
        Assert.assertEquals((Object)hri, (Object)deserializedHri);
        hrib = hri.toDelimitedByteArray();
        try (DataInputBuffer buf = new DataInputBuffer();){
            buf.reset(hrib, hrib.length);
            deserializedHri = HRegionInfo.parseFrom((DataInputStream)buf);
            Assert.assertEquals((Object)hri.getEncodedName(), (Object)deserializedHri.getEncodedName());
            Assert.assertEquals((Object)hri, (Object)deserializedHri);
        }
    }

    @Test
    public void testRegionInfos() throws Exception {
        HRegionInfo hri = this.createRandomRegion("testRegionInfos");
        byte[] triple = HRegionInfo.toDelimitedByteArray(hri, hri, hri);
        List<HRegionInfo> regions = HRegionInfo.parseDelimitedFrom(triple, 0, triple.length);
        Assert.assertTrue((regions.size() == 3 ? 1 : 0) != 0);
        Assert.assertTrue((boolean)regions.get(0).equals(regions.get(1)));
        Assert.assertTrue((boolean)regions.get(0).equals(regions.get(2)));
    }

    private HRegionInfo createRandomRegion(String name) {
        HTableDescriptor htd = new HTableDescriptor(TableName.valueOf(name));
        String[] families = new String[]{"info", "anchor"};
        for (int i = 0; i < families.length; ++i) {
            htd.addFamily(new HColumnDescriptor(families[i]));
        }
        return new HRegionInfo(htd.getTableName(), HConstants.EMPTY_START_ROW, HConstants.EMPTY_END_ROW);
    }

    @Test
    public void testGet() throws Exception {
        byte[] row = "row".getBytes();
        byte[] fam = "fam".getBytes();
        byte[] qf1 = "qf1".getBytes();
        long ts = System.currentTimeMillis();
        int maxVersions = 2;
        Get get = new Get(row);
        get.addColumn(fam, qf1);
        get.setTimeRange(ts, ts + 1L);
        get.setMaxVersions(maxVersions);
        ClientProtos.Get getProto = ProtobufUtil.toGet(get);
        Get desGet = ProtobufUtil.toGet(getProto);
        Assert.assertTrue((boolean)Bytes.equals(get.getRow(), desGet.getRow()));
        Set set = null;
        Set desSet = null;
        for (Map.Entry<byte[], NavigableSet<byte[]>> entry : get.getFamilyMap().entrySet()) {
            Assert.assertTrue((boolean)desGet.getFamilyMap().containsKey(entry.getKey()));
            set = entry.getValue();
            desSet = desGet.getFamilyMap().get(entry.getKey());
            for (byte[] qualifier : set) {
                Assert.assertTrue((boolean)desSet.contains(qualifier));
            }
        }
        Assert.assertEquals((long)get.getMaxVersions(), (long)desGet.getMaxVersions());
        TimeRange tr = get.getTimeRange();
        TimeRange desTr = desGet.getTimeRange();
        Assert.assertEquals((long)tr.getMax(), (long)desTr.getMax());
        Assert.assertEquals((long)tr.getMin(), (long)desTr.getMin());
    }

    @Test
    public void testScan() throws Exception {
        byte[] startRow = "startRow".getBytes();
        byte[] stopRow = "stopRow".getBytes();
        byte[] fam = "fam".getBytes();
        byte[] qf1 = "qf1".getBytes();
        long ts = System.currentTimeMillis();
        int maxVersions = 2;
        Scan scan = new Scan(startRow, stopRow);
        scan.addColumn(fam, qf1);
        scan.setTimeRange(ts, ts + 1L);
        scan.setMaxVersions(maxVersions);
        ClientProtos.Scan scanProto = ProtobufUtil.toScan(scan);
        Scan desScan = ProtobufUtil.toScan(scanProto);
        Assert.assertTrue((boolean)Bytes.equals(scan.getStartRow(), desScan.getStartRow()));
        Assert.assertTrue((boolean)Bytes.equals(scan.getStopRow(), desScan.getStopRow()));
        Assert.assertEquals((Object)scan.getCacheBlocks(), (Object)desScan.getCacheBlocks());
        Set set = null;
        Set desSet = null;
        for (Map.Entry<byte[], NavigableSet<byte[]>> entry : scan.getFamilyMap().entrySet()) {
            Assert.assertTrue((boolean)desScan.getFamilyMap().containsKey(entry.getKey()));
            set = entry.getValue();
            desSet = desScan.getFamilyMap().get(entry.getKey());
            for (byte[] column : set) {
                Assert.assertTrue((boolean)desSet.contains(column));
            }
            scan = new Scan(startRow);
            String name = "testScan";
            byte[] prefix = Bytes.toBytes("testScan");
            scan.setFilter(new PrefixFilter(prefix));
            scanProto = ProtobufUtil.toScan(scan);
            desScan = ProtobufUtil.toScan(scanProto);
            Filter f = desScan.getFilter();
            Assert.assertTrue((boolean)(f instanceof PrefixFilter));
        }
        Assert.assertEquals((long)scan.getMaxVersions(), (long)desScan.getMaxVersions());
        TimeRange tr = scan.getTimeRange();
        TimeRange desTr = desScan.getTimeRange();
        Assert.assertEquals((long)tr.getMax(), (long)desTr.getMax());
        Assert.assertEquals((long)tr.getMin(), (long)desTr.getMin());
    }

    protected HTableDescriptor createTableDescriptor(String name) {
        return this.createTableDescriptor(name, 3);
    }

    protected HTableDescriptor createTableDescriptor(String name, int versions) {
        HTableDescriptor htd = new HTableDescriptor(TableName.valueOf(name));
        htd.addFamily(new HColumnDescriptor(fam1).setMaxVersions(versions).setBlockCacheEnabled(false));
        htd.addFamily(new HColumnDescriptor(fam2).setMaxVersions(versions).setBlockCacheEnabled(false));
        htd.addFamily(new HColumnDescriptor(fam3).setMaxVersions(versions).setBlockCacheEnabled(false));
        return htd;
    }
}

