/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase;

import java.io.IOException;
import java.security.SecureRandom;
import java.util.Random;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.commons.math.random.RandomData;
import org.apache.commons.math.random.RandomDataImpl;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.CellUtil;
import org.apache.hadoop.hbase.HConstants;
import org.apache.hadoop.hbase.KeyValue;
import org.apache.hadoop.hbase.PerformanceEvaluationCommons;
import org.apache.hadoop.hbase.classification.InterfaceAudience;
import org.apache.hadoop.hbase.io.ImmutableBytesWritable;
import org.apache.hadoop.hbase.io.crypto.Encryption;
import org.apache.hadoop.hbase.io.crypto.KeyProviderForTesting;
import org.apache.hadoop.hbase.io.hfile.AbstractHFileWriter;
import org.apache.hadoop.hbase.io.hfile.CacheConfig;
import org.apache.hadoop.hbase.io.hfile.HFile;
import org.apache.hadoop.hbase.io.hfile.HFileContext;
import org.apache.hadoop.hbase.io.hfile.HFileContextBuilder;
import org.apache.hadoop.hbase.io.hfile.HFileScanner;
import org.apache.hadoop.hbase.util.Bytes;

@InterfaceAudience.LimitedPrivate(value={"Tools"})
public class HFilePerformanceEvaluation {
    private static final int ROW_LENGTH = 10;
    private static final int ROW_COUNT = 1000000;
    private static final int RFILE_BLOCKSIZE = 8192;
    private static StringBuilder testSummary = new StringBuilder();
    private static final Log LOG;

    static byte[] format(int i) {
        String v = Integer.toString(i);
        return Bytes.toBytes("0000000000".substring(v.length()) + v);
    }

    static ImmutableBytesWritable format(int i, ImmutableBytesWritable w) {
        w.set(HFilePerformanceEvaluation.format(i));
        return w;
    }

    static Cell createCell(int i) {
        return HFilePerformanceEvaluation.createCell(i, HConstants.EMPTY_BYTE_ARRAY);
    }

    static Cell createCell(int i, byte[] value) {
        return HFilePerformanceEvaluation.createCell(HFilePerformanceEvaluation.format(i), value);
    }

    static Cell createCell(byte[] keyRow) {
        return CellUtil.createCell(keyRow);
    }

    static Cell createCell(byte[] keyRow, byte[] value) {
        return CellUtil.createCell(keyRow, value);
    }

    private void runBenchmarks() throws Exception {
        Configuration conf = new Configuration();
        FileSystem fs = FileSystem.get((Configuration)conf);
        Path mf = fs.makeQualified(new Path("performanceevaluation.mapfile"));
        this.runWriteBenchmark(conf, fs, mf, "none", "none");
        this.runReadBenchmark(conf, fs, mf, "none", "none");
        this.runWriteBenchmark(conf, fs, mf, "gz", "none");
        this.runReadBenchmark(conf, fs, mf, "gz", "none");
        Configuration aesconf = new Configuration();
        aesconf.set("hbase.crypto.keyprovider", KeyProviderForTesting.class.getName());
        aesconf.set("hbase.crypto.master.key.name", "hbase");
        aesconf.setInt("hfile.format.version", 3);
        FileSystem aesfs = FileSystem.get((Configuration)aesconf);
        Path aesmf = aesfs.makeQualified(new Path("performanceevaluation.aes.mapfile"));
        this.runWriteBenchmark(aesconf, aesfs, aesmf, "none", "aes");
        this.runReadBenchmark(aesconf, aesfs, aesmf, "none", "aes");
        this.runWriteBenchmark(aesconf, aesfs, aesmf, "gz", "aes");
        this.runReadBenchmark(aesconf, aesfs, aesmf, "gz", "aes");
        if (fs.exists(mf)) {
            fs.delete(mf, true);
        }
        if (aesfs.exists(aesmf)) {
            aesfs.delete(aesmf, true);
        }
        LOG.info((Object)"\n***************\nResult Summary\n***************\n");
        LOG.info((Object)testSummary.toString());
    }

    private void runWriteBenchmark(Configuration conf, FileSystem fs, Path mf, String codec, String cipher) throws Exception {
        if (fs.exists(mf)) {
            fs.delete(mf, true);
        }
        this.runBenchmark(new SequentialWriteBenchmark(conf, fs, mf, 1000000, codec, cipher), 1000000, codec, cipher);
    }

    private void runReadBenchmark(final Configuration conf, final FileSystem fs, final Path mf, final String codec, final String cipher) {
        PerformanceEvaluationCommons.concurrentReads(new Runnable(){

            @Override
            public void run() {
                try {
                    HFilePerformanceEvaluation.this.runBenchmark(new UniformRandomSmallScan(conf, fs, mf, 1000000), 1000000, codec, cipher);
                }
                catch (Exception e) {
                    testSummary.append("UniformRandomSmallScan failed " + e.getMessage());
                    e.printStackTrace();
                }
            }
        });
        PerformanceEvaluationCommons.concurrentReads(new Runnable(){

            @Override
            public void run() {
                try {
                    HFilePerformanceEvaluation.this.runBenchmark(new UniformRandomReadBenchmark(conf, fs, mf, 1000000), 1000000, codec, cipher);
                }
                catch (Exception e) {
                    testSummary.append("UniformRandomReadBenchmark failed " + e.getMessage());
                    e.printStackTrace();
                }
            }
        });
        PerformanceEvaluationCommons.concurrentReads(new Runnable(){

            @Override
            public void run() {
                try {
                    HFilePerformanceEvaluation.this.runBenchmark(new GaussianRandomReadBenchmark(conf, fs, mf, 1000000), 1000000, codec, cipher);
                }
                catch (Exception e) {
                    testSummary.append("GaussianRandomReadBenchmark failed " + e.getMessage());
                    e.printStackTrace();
                }
            }
        });
        PerformanceEvaluationCommons.concurrentReads(new Runnable(){

            @Override
            public void run() {
                try {
                    HFilePerformanceEvaluation.this.runBenchmark(new SequentialReadBenchmark(conf, fs, mf, 1000000), 1000000, codec, cipher);
                }
                catch (Exception e) {
                    testSummary.append("SequentialReadBenchmark failed " + e.getMessage());
                    e.printStackTrace();
                }
            }
        });
    }

    protected void runBenchmark(RowOrientedBenchmark benchmark, int rowCount, String codec, String cipher) throws Exception {
        LOG.info((Object)("Running " + benchmark.getClass().getSimpleName() + " with codec[" + codec + "] cipher[" + cipher + "] for " + rowCount + " rows."));
        long elapsedTime = benchmark.run();
        LOG.info((Object)("Running " + benchmark.getClass().getSimpleName() + " with codec[" + codec + "] cipher[" + cipher + "] for " + rowCount + " rows took " + elapsedTime + "ms."));
        testSummary.append("Running ").append(benchmark.getClass().getSimpleName()).append(" with codec[").append(codec).append("] cipher[").append(cipher).append("] for ").append(rowCount).append(" rows took ").append(elapsedTime).append("ms.").append("\n");
    }

    public static void main(String[] args) throws Exception {
        new HFilePerformanceEvaluation().runBenchmarks();
    }

    static {
        System.setProperty("org.apache.commons.logging.Log", "org.apache.commons.logging.impl.SimpleLog");
        System.setProperty("org.apache.commons.logging.simplelog.log.org.apache.hadoop.io.compress.CodecPool", "WARN");
        LOG = LogFactory.getLog((String)HFilePerformanceEvaluation.class.getName());
    }

    static class GaussianRandomReadBenchmark
    extends ReadBenchmark {
        private RandomData randomData = new RandomDataImpl();

        public GaussianRandomReadBenchmark(Configuration conf, FileSystem fs, Path mf, int totalRows) {
            super(conf, fs, mf, totalRows);
        }

        @Override
        void doRow(int i) throws Exception {
            HFileScanner scanner = this.reader.getScanner(false, true);
            byte[] gaussianRandomRowBytes = this.getGaussianRandomRowBytes();
            scanner.seekTo(HFilePerformanceEvaluation.createCell(gaussianRandomRowBytes));
            for (int ii = 0; ii < 30; ++ii) {
                if (!scanner.next()) {
                    LOG.info((Object)"NOTHING FOLLOWS");
                    return;
                }
                scanner.getKeyValue();
            }
        }

        private byte[] getGaussianRandomRowBytes() {
            int r = (int)this.randomData.nextGaussian((double)this.totalRows / 2.0, (double)this.totalRows / 10.0);
            return HFilePerformanceEvaluation.format(Math.min(this.totalRows, Math.max(r, 0)));
        }
    }

    static class UniformRandomSmallScan
    extends ReadBenchmark {
        private Random random = new Random();

        public UniformRandomSmallScan(Configuration conf, FileSystem fs, Path mf, int totalRows) {
            super(conf, fs, mf, totalRows / 10);
        }

        @Override
        void doRow(int i) throws Exception {
            byte[] b;
            Cell c;
            HFileScanner scanner = this.reader.getScanner(false, false);
            if (scanner.seekTo(c = HFilePerformanceEvaluation.createCell(b = this.getRandomRow())) != 0) {
                LOG.info((Object)("Nonexistent row: " + new String(b)));
                return;
            }
            c = scanner.getKeyValue();
            PerformanceEvaluationCommons.assertKey(b, c);
            for (int ii = 0; ii < 30; ++ii) {
                if (!scanner.next()) {
                    LOG.info((Object)"NOTHING FOLLOWS");
                    return;
                }
                c = scanner.getKeyValue();
                PerformanceEvaluationCommons.assertValueSize(c.getValueLength(), 10);
            }
        }

        private byte[] getRandomRow() {
            return HFilePerformanceEvaluation.format(this.random.nextInt(this.totalRows));
        }
    }

    static class UniformRandomReadBenchmark
    extends ReadBenchmark {
        private Random random = new Random();

        public UniformRandomReadBenchmark(Configuration conf, FileSystem fs, Path mf, int totalRows) {
            super(conf, fs, mf, totalRows);
        }

        @Override
        void doRow(int i) throws Exception {
            byte[] b;
            HFileScanner scanner = this.reader.getScanner(false, true);
            if (scanner.seekTo(HFilePerformanceEvaluation.createCell(b = this.getRandomRow())) < 0) {
                LOG.info((Object)("Not able to seekTo " + new String(b)));
                return;
            }
            Cell c = scanner.getKeyValue();
            PerformanceEvaluationCommons.assertKey(b, c);
            PerformanceEvaluationCommons.assertValueSize(c.getValueLength(), 10);
        }

        private byte[] getRandomRow() {
            return HFilePerformanceEvaluation.format(this.random.nextInt(this.totalRows));
        }
    }

    static class SequentialReadBenchmark
    extends ReadBenchmark {
        private HFileScanner scanner;

        public SequentialReadBenchmark(Configuration conf, FileSystem fs, Path mf, int totalRows) {
            super(conf, fs, mf, totalRows);
        }

        @Override
        void setUp() throws Exception {
            super.setUp();
            this.scanner = this.reader.getScanner(false, false);
            this.scanner.seekTo();
        }

        @Override
        void doRow(int i) throws Exception {
            if (this.scanner.next()) {
                Cell c = this.scanner.getKeyValue();
                PerformanceEvaluationCommons.assertKey(HFilePerformanceEvaluation.format(i + 1), c);
                PerformanceEvaluationCommons.assertValueSize(c.getValueLength(), 10);
            }
        }

        @Override
        protected int getReportingPeriod() {
            return this.totalRows;
        }
    }

    static abstract class ReadBenchmark
    extends RowOrientedBenchmark {
        protected HFile.Reader reader;

        public ReadBenchmark(Configuration conf, FileSystem fs, Path mf, int totalRows) {
            super(conf, fs, mf, totalRows);
        }

        @Override
        void setUp() throws Exception {
            this.reader = HFile.createReader(this.fs, this.mf, new CacheConfig(this.conf), this.conf);
            this.reader.loadFileInfo();
        }

        @Override
        void tearDown() throws Exception {
            this.reader.close();
        }
    }

    static class SequentialWriteBenchmark
    extends RowOrientedBenchmark {
        protected HFile.Writer writer;
        private Random random = new Random();
        private byte[] bytes = new byte[10];

        public SequentialWriteBenchmark(Configuration conf, FileSystem fs, Path mf, int totalRows, String codec, String cipher) {
            super(conf, fs, mf, totalRows, codec, cipher);
        }

        @Override
        void setUp() throws Exception {
            HFileContextBuilder builder = new HFileContextBuilder().withCompression(AbstractHFileWriter.compressionByName(this.codec)).withBlockSize(8192);
            if (this.cipher == "aes") {
                byte[] cipherKey = new byte[16];
                new SecureRandom().nextBytes(cipherKey);
                builder.withEncryptionContext(Encryption.newContext(this.conf).setCipher(Encryption.getCipher(this.conf, this.cipher)).setKey(cipherKey));
            } else if (!"none".equals(this.cipher)) {
                throw new IOException("Cipher " + this.cipher + " not supported.");
            }
            HFileContext hFileContext = builder.build();
            this.writer = HFile.getWriterFactoryNoCache(this.conf).withPath(this.fs, this.mf).withFileContext(hFileContext).withComparator(new KeyValue.RawBytesComparator()).create();
        }

        @Override
        void doRow(int i) throws Exception {
            this.writer.append(HFilePerformanceEvaluation.createCell(i, this.generateValue()));
        }

        private byte[] generateValue() {
            this.random.nextBytes(this.bytes);
            return this.bytes;
        }

        @Override
        protected int getReportingPeriod() {
            return this.totalRows;
        }

        @Override
        void tearDown() throws Exception {
            this.writer.close();
        }
    }

    static abstract class RowOrientedBenchmark {
        protected final Configuration conf;
        protected final FileSystem fs;
        protected final Path mf;
        protected final int totalRows;
        protected String codec = "none";
        protected String cipher = "none";

        public RowOrientedBenchmark(Configuration conf, FileSystem fs, Path mf, int totalRows, String codec, String cipher) {
            this.conf = conf;
            this.fs = fs;
            this.mf = mf;
            this.totalRows = totalRows;
            this.codec = codec;
            this.cipher = cipher;
        }

        public RowOrientedBenchmark(Configuration conf, FileSystem fs, Path mf, int totalRows) {
            this.conf = conf;
            this.fs = fs;
            this.mf = mf;
            this.totalRows = totalRows;
        }

        void setUp() throws Exception {
        }

        abstract void doRow(int var1) throws Exception;

        protected int getReportingPeriod() {
            return this.totalRows / 10;
        }

        void tearDown() throws Exception {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        long run() throws Exception {
            long elapsedTime;
            this.setUp();
            long startTime = System.currentTimeMillis();
            try {
                for (int i = 0; i < this.totalRows; ++i) {
                    if (i > 0 && i % this.getReportingPeriod() == 0) {
                        LOG.info((Object)("Processed " + i + " rows."));
                    }
                    this.doRow(i);
                }
                elapsedTime = System.currentTimeMillis() - startTime;
            }
            finally {
                this.tearDown();
            }
            return elapsedTime;
        }
    }
}

