/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase;

import drill.shaded.hbase.guava.com.google.common.primitives.Longs;
import edu.umd.cs.findbugs.annotations.SuppressWarnings;
import java.io.Serializable;
import java.util.Comparator;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.CellUtil;
import org.apache.hadoop.hbase.HConstants;
import org.apache.hadoop.hbase.KeyValue;
import org.apache.hadoop.hbase.classification.InterfaceAudience;
import org.apache.hadoop.hbase.classification.InterfaceStability;
import org.apache.hadoop.hbase.util.Bytes;

@InterfaceAudience.Private
@InterfaceStability.Evolving
@SuppressWarnings(value={"UNKNOWN"}, justification="Findbugs doesn't like the way we are negating the result of a compare in below")
public class CellComparator
implements Comparator<Cell>,
Serializable {
    private static final long serialVersionUID = -8760041766259623329L;

    @Override
    public int compare(Cell a, Cell b) {
        return CellComparator.compare(a, b, false);
    }

    public static int compare(Cell a, Cell b, boolean ignoreSequenceid) {
        int c = CellComparator.compareRows(a, b);
        if (c != 0) {
            return c;
        }
        c = CellComparator.compareWithoutRow(a, b);
        if (c != 0) {
            return c;
        }
        if (!ignoreSequenceid) {
            return Longs.compare(b.getMvccVersion(), a.getMvccVersion());
        }
        return c;
    }

    public static int findCommonPrefixInRowPart(Cell left, Cell right, int rowCommonPrefix) {
        return CellComparator.findCommonPrefix(left.getRowArray(), right.getRowArray(), left.getRowLength() - rowCommonPrefix, right.getRowLength() - rowCommonPrefix, left.getRowOffset() + rowCommonPrefix, right.getRowOffset() + rowCommonPrefix);
    }

    private static int findCommonPrefix(byte[] left, byte[] right, int leftLength, int rightLength, int leftOffset, int rightOffset) {
        int result;
        int length = Math.min(leftLength, rightLength);
        for (result = 0; result < length && left[leftOffset + result] == right[rightOffset + result]; ++result) {
        }
        return result;
    }

    public static int findCommonPrefixInFamilyPart(Cell left, Cell right, int familyCommonPrefix) {
        return CellComparator.findCommonPrefix(left.getFamilyArray(), right.getFamilyArray(), left.getFamilyLength() - familyCommonPrefix, right.getFamilyLength() - familyCommonPrefix, left.getFamilyOffset() + familyCommonPrefix, right.getFamilyOffset() + familyCommonPrefix);
    }

    public static int findCommonPrefixInQualifierPart(Cell left, Cell right, int qualifierCommonPrefix) {
        return CellComparator.findCommonPrefix(left.getQualifierArray(), right.getQualifierArray(), left.getQualifierLength() - qualifierCommonPrefix, right.getQualifierLength() - qualifierCommonPrefix, left.getQualifierOffset() + qualifierCommonPrefix, right.getQualifierOffset() + qualifierCommonPrefix);
    }

    public static boolean equals(Cell a, Cell b) {
        return CellComparator.equalsRow(a, b) && CellComparator.equalsFamily(a, b) && CellComparator.equalsQualifier(a, b) && CellComparator.equalsTimestamp(a, b) && CellComparator.equalsType(a, b);
    }

    public static boolean equalsRow(Cell a, Cell b) {
        return Bytes.equals(a.getRowArray(), a.getRowOffset(), a.getRowLength(), b.getRowArray(), b.getRowOffset(), b.getRowLength());
    }

    public static boolean equalsFamily(Cell a, Cell b) {
        return Bytes.equals(a.getFamilyArray(), a.getFamilyOffset(), a.getFamilyLength(), b.getFamilyArray(), b.getFamilyOffset(), b.getFamilyLength());
    }

    public static boolean equalsQualifier(Cell a, Cell b) {
        return Bytes.equals(a.getQualifierArray(), a.getQualifierOffset(), a.getQualifierLength(), b.getQualifierArray(), b.getQualifierOffset(), b.getQualifierLength());
    }

    public static boolean equalsTimestamp(Cell a, Cell b) {
        return a.getTimestamp() == b.getTimestamp();
    }

    public static boolean equalsType(Cell a, Cell b) {
        return a.getTypeByte() == b.getTypeByte();
    }

    public static int compareColumns(Cell left, Cell right) {
        int lfoffset = left.getFamilyOffset();
        int rfoffset = right.getFamilyOffset();
        int lclength = left.getQualifierLength();
        int rclength = right.getQualifierLength();
        byte lfamilylength = left.getFamilyLength();
        byte rfamilylength = right.getFamilyLength();
        int diff = CellComparator.compare(left.getFamilyArray(), lfoffset, lfamilylength, right.getFamilyArray(), rfoffset, rfamilylength);
        if (diff != 0) {
            return diff;
        }
        return CellComparator.compare(left.getQualifierArray(), left.getQualifierOffset(), lclength, right.getQualifierArray(), right.getQualifierOffset(), rclength);
    }

    public static int compareFamilies(Cell left, Cell right) {
        return Bytes.compareTo(left.getFamilyArray(), left.getFamilyOffset(), left.getFamilyLength(), right.getFamilyArray(), right.getFamilyOffset(), right.getFamilyLength());
    }

    public static int compareQualifiers(Cell left, Cell right) {
        return Bytes.compareTo(left.getQualifierArray(), left.getQualifierOffset(), left.getQualifierLength(), right.getQualifierArray(), right.getQualifierOffset(), right.getQualifierLength());
    }

    public int compareFlatKey(Cell left, Cell right) {
        int compare = CellComparator.compareRows(left, right);
        if (compare != 0) {
            return compare;
        }
        return CellComparator.compareWithoutRow(left, right);
    }

    public static int compareRows(Cell left, Cell right) {
        return Bytes.compareTo(left.getRowArray(), left.getRowOffset(), left.getRowLength(), right.getRowArray(), right.getRowOffset(), right.getRowLength());
    }

    public static int compareRows(byte[] left, int loffset, int llength, byte[] right, int roffset, int rlength) {
        return Bytes.compareTo(left, loffset, llength, right, roffset, rlength);
    }

    public static int compareWithoutRow(Cell leftCell, Cell rightCell) {
        boolean sameFamilySize;
        if (leftCell.getFamilyLength() + leftCell.getQualifierLength() == 0 && leftCell.getTypeByte() == KeyValue.Type.Minimum.getCode()) {
            return 1;
        }
        if (rightCell.getFamilyLength() + rightCell.getQualifierLength() == 0 && rightCell.getTypeByte() == KeyValue.Type.Minimum.getCode()) {
            return -1;
        }
        boolean bl = sameFamilySize = leftCell.getFamilyLength() == rightCell.getFamilyLength();
        if (!sameFamilySize) {
            return Bytes.compareTo(leftCell.getFamilyArray(), leftCell.getFamilyOffset(), leftCell.getFamilyLength(), rightCell.getFamilyArray(), rightCell.getFamilyOffset(), rightCell.getFamilyLength());
        }
        int diff = CellComparator.compareColumns(leftCell, rightCell);
        if (diff != 0) {
            return diff;
        }
        diff = CellComparator.compareTimestamps(leftCell, rightCell);
        if (diff != 0) {
            return diff;
        }
        return (0xFF & rightCell.getTypeByte()) - (0xFF & leftCell.getTypeByte());
    }

    public static int compareTimestamps(Cell left, Cell right) {
        return CellComparator.compareTimestamps(left.getTimestamp(), right.getTimestamp());
    }

    public static int hashCode(Cell cell) {
        if (cell == null) {
            return 0;
        }
        int hash = CellComparator.calculateHashForKeyValue(cell);
        hash = 31 * hash + (int)cell.getMvccVersion();
        return hash;
    }

    public static int hashCodeIgnoreMvcc(Cell cell) {
        if (cell == null) {
            return 0;
        }
        int hash = CellComparator.calculateHashForKeyValue(cell);
        return hash;
    }

    private static int calculateHashForKeyValue(Cell cell) {
        int rowHash = Bytes.hashCode(cell.getRowArray(), cell.getRowOffset(), cell.getRowLength());
        int familyHash = Bytes.hashCode(cell.getFamilyArray(), cell.getFamilyOffset(), cell.getFamilyLength());
        int qualifierHash = Bytes.hashCode(cell.getQualifierArray(), cell.getQualifierOffset(), cell.getQualifierLength());
        int hash = 31 * rowHash + familyHash;
        hash = 31 * hash + qualifierHash;
        hash = 31 * hash + (int)cell.getTimestamp();
        hash = 31 * hash + cell.getTypeByte();
        return hash;
    }

    public static boolean areKeyLengthsEqual(Cell a, Cell b) {
        return a.getRowLength() == b.getRowLength() && a.getFamilyLength() == b.getFamilyLength() && a.getQualifierLength() == b.getQualifierLength();
    }

    public static boolean areRowLengthsEqual(Cell a, Cell b) {
        return a.getRowLength() == b.getRowLength();
    }

    private static int compare(byte[] left, int leftOffset, int leftLength, byte[] right, int rightOffset, int rightLength) {
        return Bytes.compareTo(left, leftOffset, leftLength, right, rightOffset, rightLength);
    }

    public static int compareCommonRowPrefix(Cell left, Cell right, int rowCommonPrefix) {
        return CellComparator.compare(left.getRowArray(), left.getRowOffset() + rowCommonPrefix, left.getRowLength() - rowCommonPrefix, right.getRowArray(), right.getRowOffset() + rowCommonPrefix, right.getRowLength() - rowCommonPrefix);
    }

    public static int compareCommonFamilyPrefix(Cell left, Cell right, int familyCommonPrefix) {
        return CellComparator.compare(left.getFamilyArray(), left.getFamilyOffset() + familyCommonPrefix, left.getFamilyLength() - familyCommonPrefix, right.getFamilyArray(), right.getFamilyOffset() + familyCommonPrefix, right.getFamilyLength() - familyCommonPrefix);
    }

    public static int compareCommonQualifierPrefix(Cell left, Cell right, int qualCommonPrefix) {
        return CellComparator.compare(left.getQualifierArray(), left.getQualifierOffset() + qualCommonPrefix, left.getQualifierLength() - qualCommonPrefix, right.getQualifierArray(), right.getQualifierOffset() + qualCommonPrefix, right.getQualifierLength() - qualCommonPrefix);
    }

    public static boolean equalsIgnoreMvccVersion(Cell a, Cell b) {
        return 0 == CellComparator.compareStaticIgnoreMvccVersion(a, b);
    }

    private static int compareStaticIgnoreMvccVersion(Cell a, Cell b) {
        int c = CellComparator.compareRows(a, b);
        if (c != 0) {
            return c;
        }
        c = CellComparator.compareColumns(a, b);
        if (c != 0) {
            return c;
        }
        c = CellComparator.compareTimestamps(a, b);
        if (c != 0) {
            return c;
        }
        c = (0xFF & b.getTypeByte()) - (0xFF & a.getTypeByte());
        return c;
    }

    private static int compareTimestamps(long ltimestamp, long rtimestamp) {
        if (ltimestamp < rtimestamp) {
            return 1;
        }
        if (ltimestamp > rtimestamp) {
            return -1;
        }
        return 0;
    }

    public static Cell getMidpoint(KeyValue.KVComparator comparator, Cell left, Cell right) {
        if (right == null) {
            throw new IllegalArgumentException("right cell can not be null");
        }
        if (left == null) {
            return right;
        }
        if (comparator != null && comparator instanceof KeyValue.MetaComparator) {
            return right;
        }
        int diff = CellComparator.compareRows(left, right);
        if (diff > 0) {
            throw new IllegalArgumentException("Left row sorts after right row; left=" + CellUtil.getCellKeyAsString(left) + ", right=" + CellUtil.getCellKeyAsString(right));
        }
        if (diff < 0) {
            byte[] midRow = CellComparator.getMinimumMidpointArray(left.getRowArray(), left.getRowOffset(), left.getRowLength(), right.getRowArray(), right.getRowOffset(), right.getRowLength());
            if (midRow == null) {
                return right;
            }
            return CellUtil.createCell(midRow);
        }
        diff = CellComparator.compareFamilies(left, right);
        if (diff > 0) {
            throw new IllegalArgumentException("Left family sorts after right family; left=" + CellUtil.getCellKeyAsString(left) + ", right=" + CellUtil.getCellKeyAsString(right));
        }
        if (diff < 0) {
            byte[] midRow = CellComparator.getMinimumMidpointArray(left.getFamilyArray(), left.getFamilyOffset(), left.getFamilyLength(), right.getFamilyArray(), right.getFamilyOffset(), right.getFamilyLength());
            if (midRow == null) {
                return right;
            }
            return CellUtil.createCell(right.getRowArray(), right.getRowOffset(), right.getRowLength(), midRow, 0, midRow.length, HConstants.EMPTY_BYTE_ARRAY, 0, HConstants.EMPTY_BYTE_ARRAY.length);
        }
        diff = CellComparator.compareQualifiers(left, right);
        if (diff > 0) {
            throw new IllegalArgumentException("Left qualifier sorts after right qualifier; left=" + CellUtil.getCellKeyAsString(left) + ", right=" + CellUtil.getCellKeyAsString(right));
        }
        if (diff < 0) {
            byte[] midRow = CellComparator.getMinimumMidpointArray(left.getQualifierArray(), left.getQualifierOffset(), left.getQualifierLength(), right.getQualifierArray(), right.getQualifierOffset(), right.getQualifierLength());
            if (midRow == null) {
                return right;
            }
            return CellUtil.createCell(right.getRowArray(), right.getRowOffset(), right.getRowLength(), right.getFamilyArray(), right.getFamilyOffset(), right.getFamilyLength(), midRow, 0, midRow.length);
        }
        return right;
    }

    private static byte[] getMinimumMidpointArray(byte[] leftArray, int leftOffset, int leftLength, byte[] rightArray, int rightOffset, int rightLength) {
        int diffIdx;
        int minLength = leftLength < rightLength ? leftLength : rightLength;
        for (diffIdx = 0; diffIdx < minLength && leftArray[leftOffset + diffIdx] == rightArray[rightOffset + diffIdx]; ++diffIdx) {
        }
        byte[] minimumMidpointArray = null;
        if (diffIdx >= minLength) {
            minimumMidpointArray = new byte[diffIdx + 1];
            System.arraycopy(rightArray, rightOffset, minimumMidpointArray, 0, diffIdx + 1);
        } else {
            byte diffByte = leftArray[leftOffset + diffIdx];
            if ((0xFF & diffByte) < 255 && diffByte + 1 < (rightArray[rightOffset + diffIdx] & 0xFF)) {
                minimumMidpointArray = new byte[diffIdx + 1];
                System.arraycopy(leftArray, leftOffset, minimumMidpointArray, 0, diffIdx);
                minimumMidpointArray[diffIdx] = (byte)(diffByte + 1);
            } else {
                minimumMidpointArray = new byte[diffIdx + 1];
                System.arraycopy(rightArray, rightOffset, minimumMidpointArray, 0, diffIdx + 1);
            }
        }
        return minimumMidpointArray;
    }

    public static class RowComparator
    extends CellComparator {
        @Override
        public int compare(Cell a, Cell b) {
            return RowComparator.compareRows(a, b);
        }
    }
}

