/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.zookeeper;

import java.io.IOException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.hbase.Abortable;
import org.apache.hadoop.hbase.CoordinatedStateException;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.protobuf.generated.ZooKeeperProtos;
import org.apache.hadoop.hbase.testclassification.MediumTests;
import org.apache.hadoop.hbase.zookeeper.ZKTableStateManager;
import org.apache.hadoop.hbase.zookeeper.ZooKeeperWatcher;
import org.apache.zookeeper.KeeperException;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={MediumTests.class})
public class TestZKTableStateManager {
    private static final Log LOG = LogFactory.getLog(TestZKTableStateManager.class);
    private static final HBaseTestingUtility TEST_UTIL = new HBaseTestingUtility();

    @BeforeClass
    public static void setUpBeforeClass() throws Exception {
        TEST_UTIL.startMiniZKCluster();
    }

    @AfterClass
    public static void tearDownAfterClass() throws Exception {
        TEST_UTIL.shutdownMiniZKCluster();
    }

    @Test
    public void testTableStates() throws CoordinatedStateException, IOException, KeeperException, InterruptedException {
        TableName name = TableName.valueOf("testDisabled");
        Abortable abortable = new Abortable(){

            @Override
            public void abort(String why, Throwable e) {
                LOG.info((Object)why, e);
            }

            @Override
            public boolean isAborted() {
                return false;
            }
        };
        ZooKeeperWatcher zkw = new ZooKeeperWatcher(TEST_UTIL.getConfiguration(), name.getNameAsString(), abortable, true);
        ZKTableStateManager zkt = new ZKTableStateManager(zkw);
        Assert.assertFalse((boolean)zkt.isTableState(name, ZooKeeperProtos.Table.State.ENABLED));
        Assert.assertFalse((boolean)zkt.isTableState(name, ZooKeeperProtos.Table.State.DISABLING));
        Assert.assertFalse((boolean)zkt.isTableState(name, ZooKeeperProtos.Table.State.DISABLED));
        Assert.assertFalse((boolean)zkt.isTableState(name, ZooKeeperProtos.Table.State.ENABLING));
        Assert.assertFalse((boolean)zkt.isTableState(name, ZooKeeperProtos.Table.State.DISABLED, ZooKeeperProtos.Table.State.DISABLING));
        Assert.assertFalse((boolean)zkt.isTableState(name, ZooKeeperProtos.Table.State.DISABLED, ZooKeeperProtos.Table.State.ENABLING));
        Assert.assertFalse((boolean)zkt.isTablePresent(name));
        zkt.setTableState(name, ZooKeeperProtos.Table.State.DISABLING);
        Assert.assertTrue((boolean)zkt.isTableState(name, ZooKeeperProtos.Table.State.DISABLING));
        Assert.assertTrue((boolean)zkt.isTableState(name, ZooKeeperProtos.Table.State.DISABLED, ZooKeeperProtos.Table.State.DISABLING));
        Assert.assertFalse((boolean)zkt.getTablesInStates(ZooKeeperProtos.Table.State.DISABLED).contains(name));
        Assert.assertTrue((boolean)zkt.isTablePresent(name));
        zkt.setTableState(name, ZooKeeperProtos.Table.State.DISABLED);
        Assert.assertTrue((boolean)zkt.isTableState(name, ZooKeeperProtos.Table.State.DISABLED));
        Assert.assertTrue((boolean)zkt.isTableState(name, ZooKeeperProtos.Table.State.DISABLED, ZooKeeperProtos.Table.State.DISABLING));
        Assert.assertFalse((boolean)zkt.isTableState(name, ZooKeeperProtos.Table.State.DISABLING));
        Assert.assertTrue((boolean)zkt.getTablesInStates(ZooKeeperProtos.Table.State.DISABLED).contains(name));
        Assert.assertTrue((boolean)zkt.isTablePresent(name));
        zkt.setTableState(name, ZooKeeperProtos.Table.State.ENABLING);
        Assert.assertTrue((boolean)zkt.isTableState(name, ZooKeeperProtos.Table.State.ENABLING));
        Assert.assertTrue((boolean)zkt.isTableState(name, ZooKeeperProtos.Table.State.DISABLED, ZooKeeperProtos.Table.State.ENABLING));
        Assert.assertFalse((boolean)zkt.isTableState(name, ZooKeeperProtos.Table.State.DISABLED));
        Assert.assertFalse((boolean)zkt.getTablesInStates(ZooKeeperProtos.Table.State.DISABLED).contains(name));
        Assert.assertTrue((boolean)zkt.isTablePresent(name));
        zkt.setTableState(name, ZooKeeperProtos.Table.State.ENABLED);
        Assert.assertTrue((boolean)zkt.isTableState(name, ZooKeeperProtos.Table.State.ENABLED));
        Assert.assertFalse((boolean)zkt.isTableState(name, ZooKeeperProtos.Table.State.ENABLING));
        Assert.assertTrue((boolean)zkt.isTablePresent(name));
        zkt.setDeletedTable(name);
        Assert.assertFalse((boolean)zkt.isTableState(name, ZooKeeperProtos.Table.State.ENABLED));
        Assert.assertFalse((boolean)zkt.isTableState(name, ZooKeeperProtos.Table.State.DISABLING));
        Assert.assertFalse((boolean)zkt.isTableState(name, ZooKeeperProtos.Table.State.DISABLED));
        Assert.assertFalse((boolean)zkt.isTableState(name, ZooKeeperProtos.Table.State.ENABLING));
        Assert.assertFalse((boolean)zkt.isTableState(name, ZooKeeperProtos.Table.State.DISABLED, ZooKeeperProtos.Table.State.DISABLING));
        Assert.assertFalse((boolean)zkt.isTableState(name, ZooKeeperProtos.Table.State.DISABLED, ZooKeeperProtos.Table.State.ENABLING));
        Assert.assertFalse((boolean)zkt.isTablePresent(name));
    }
}

