/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.zookeeper;

import com.google.protobuf.Message;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.util.ArrayList;
import java.util.List;
import java.util.NavigableMap;
import java.util.TreeMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.hbase.Server;
import org.apache.hadoop.hbase.ServerName;
import org.apache.hadoop.hbase.classification.InterfaceAudience;
import org.apache.hadoop.hbase.master.ServerManager;
import org.apache.hadoop.hbase.protobuf.ProtobufUtil;
import org.apache.hadoop.hbase.protobuf.generated.HBaseProtos;
import org.apache.hadoop.hbase.zookeeper.ZKUtil;
import org.apache.hadoop.hbase.zookeeper.ZooKeeperListener;
import org.apache.hadoop.hbase.zookeeper.ZooKeeperWatcher;
import org.apache.zookeeper.KeeperException;

@InterfaceAudience.Private
public class RegionServerTracker
extends ZooKeeperListener {
    private static final Log LOG = LogFactory.getLog(RegionServerTracker.class);
    private NavigableMap<ServerName, HBaseProtos.RegionServerInfo> regionServers = new TreeMap<ServerName, HBaseProtos.RegionServerInfo>();
    private ServerManager serverManager;
    private Server server;

    public RegionServerTracker(ZooKeeperWatcher watcher, Server server, ServerManager serverManager) {
        super(watcher);
        this.server = server;
        this.serverManager = serverManager;
    }

    public void start() throws KeeperException, IOException {
        this.watcher.registerListener(this);
        List<String> servers = ZKUtil.listChildrenAndWatchThem(this.watcher, this.watcher.rsZNode);
        this.add(servers);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void add(List<String> servers) throws IOException {
        NavigableMap<ServerName, HBaseProtos.RegionServerInfo> navigableMap = this.regionServers;
        synchronized (navigableMap) {
            this.regionServers.clear();
            for (String n : servers) {
                ServerName sn = ServerName.parseServerName(ZKUtil.getNodeName(n));
                if (this.regionServers.get(sn) != null) continue;
                HBaseProtos.RegionServerInfo.Builder rsInfoBuilder = HBaseProtos.RegionServerInfo.newBuilder();
                try {
                    String nodePath = ZKUtil.joinZNode(this.watcher.rsZNode, n);
                    byte[] data = ZKUtil.getData(this.watcher, nodePath);
                    if (data != null && data.length > 0 && ProtobufUtil.isPBMagicPrefix(data)) {
                        int magicLen = ProtobufUtil.lengthOfPBMagic();
                        ProtobufUtil.mergeFrom((Message.Builder)rsInfoBuilder, data, magicLen, data.length - magicLen);
                    }
                    if (LOG.isDebugEnabled()) {
                        LOG.debug((Object)("Added tracking of RS " + nodePath));
                    }
                }
                catch (KeeperException e) {
                    LOG.warn((Object)"Get Rs info port from ephemeral node", (Throwable)e);
                }
                catch (IOException e) {
                    LOG.warn((Object)"Illegal data from ephemeral node", (Throwable)e);
                }
                catch (InterruptedException e) {
                    throw new InterruptedIOException();
                }
                this.regionServers.put(sn, rsInfoBuilder.build());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void remove(ServerName sn) {
        NavigableMap<ServerName, HBaseProtos.RegionServerInfo> navigableMap = this.regionServers;
        synchronized (navigableMap) {
            this.regionServers.remove(sn);
        }
    }

    @Override
    public void nodeDeleted(String path) {
        if (path.startsWith(this.watcher.rsZNode)) {
            String serverName = ZKUtil.getNodeName(path);
            LOG.info((Object)("RegionServer ephemeral node deleted, processing expiration [" + serverName + "]"));
            ServerName sn = ServerName.parseServerName(serverName);
            if (!this.serverManager.isServerOnline(sn)) {
                LOG.warn((Object)(serverName.toString() + " is not online or isn't known to the master.The latter could be caused by a DNS misconfiguration."));
                return;
            }
            this.remove(sn);
            this.serverManager.expireServer(sn);
        }
    }

    @Override
    public void nodeChildrenChanged(String path) {
        if (path.equals(this.watcher.rsZNode) && !this.server.isAborted() && !this.server.isStopped()) {
            try {
                List<String> servers = ZKUtil.listChildrenAndWatchThem(this.watcher, this.watcher.rsZNode);
                this.add(servers);
            }
            catch (IOException e) {
                this.server.abort("Unexpected zk exception getting RS nodes", e);
            }
            catch (KeeperException e) {
                this.server.abort("Unexpected zk exception getting RS nodes", e);
            }
        }
    }

    public HBaseProtos.RegionServerInfo getRegionServerInfo(ServerName sn) {
        return (HBaseProtos.RegionServerInfo)this.regionServers.get(sn);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<ServerName> getOnlineServers() {
        NavigableMap<ServerName, HBaseProtos.RegionServerInfo> navigableMap = this.regionServers;
        synchronized (navigableMap) {
            return new ArrayList<ServerName>(this.regionServers.keySet());
        }
    }
}

